/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.javatools.ui.internal.StripeProvider;

public class StripedScrollPane
extends JScrollPane {
    private final transient StripeProvider _stripeProvider;

    public StripedScrollPane(Component component, StripeProvider stripeProvider) {
        super(component);
        this._stripeProvider = stripeProvider;
    }

    protected JViewport createViewport() {
        return new StripedViewport();
    }

    static StripeProvider ra$_stripeProvider(StripedScrollPane stripedScrollPane) {
        return stripedScrollPane._stripeProvider;
    }

    private class StripedViewport
    extends JViewport {
        public StripedViewport() {
            this.setOpaque(false);
            this.setScrollMode(0);
        }

        public void paintComponent(Graphics g) {
            Component comp = StripedScrollPane.this.getViewport().getView();
            this.setBackground(comp.getBackground());
            int rowHeight = StripedScrollPane.ra$_stripeProvider(StripedScrollPane.this).getRowHeight();
            Rectangle clip = g.getClipBounds();
            int yOffset = this.getViewPosition().y % (rowHeight * 2);
            g.translate(0, -yOffset);
            int numberOfRows = this.getHeight() / rowHeight + 1;
            int i = 0;
            while (i <= numberOfRows) {
                g.setColor(StripedScrollPane.ra$_stripeProvider(StripedScrollPane.this).getBackgroundForRow(i, false));
                g.fillRect(clip.x, i * rowHeight, clip.width, rowHeight);
                ++i;
            }
            g.translate(0, yOffset);
            super.paintComponent(g);
        }
    }
}

