/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ColumnLayout;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.TransparentBorderComponent;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.TruncatingTreeCellRenderer;
import oracle.javatools.ui.border.ShadowBorder;
import oracle.javatools.ui.internal.SearchFieldHarness;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;

public class UICDemo {
    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        UIManager.put("Button.borderPaintsFocus", Boolean.FALSE);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new FlatTabbedPaneUI());
        tabbedPane.setTabPlacement(2);
        SearchFieldHarness sfh = new SearchFieldHarness();
        tabbedPane.addTab("Search", sfh);
        tabbedPane.addTab("Vertical Headers", OracleIcons.getIcon((String)"label.png"), UICDemo.createVertHeaderPanel());
        tabbedPane.addTab("Shadow Border", OracleIcons.getIcon((String)"label.png"), UICDemo.createShadowBorderPanel());
        tabbedPane.addTab("Truncating Tree", OracleIcons.getIcon((String)"structure.png"), UICDemo.createTruncatingTreeRenderer());
        tabbedPane.addTab("Headers", OracleIcons.getIcon((String)"listview.png"), UICDemo.createHeaders());
        tabbedPane.addTab("Create Dialogs", OracleIcons.getIcon((String)"new.png"), UICDemo.createCreateDialogs());
        tabbedPane.addTab("Rich Hint Label", OracleIcons.getIcon((String)"label.png"), UICDemo.createRichHintLabel());
        tabbedPane.addTab("Bug 5998458", OracleIcons.getIcon((String)"debug.png"), UICDemo.createBug5998458());
        tabbedPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        f.setContentPane(tabbedPane);
        f.pack();
        f.setVisible(true);
    }

    private static Component createBug5998458() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout());
        JTabbedPane pane = new JTabbedPane();
        pane.setUI(new FlatTabbedPaneUI());
        p.add((Component)pane, "Center");
        JButton b = new JButton("Rebuild tabs");
        p.add((Component)b, "South");
        int i = 0;
        while (i < 10) {
            pane.addTab("Tab " + i, new JPanel());
            ++i;
        }
        b.addActionListener(new 1(pane));
        return p;
    }

    private static Component createRichHintLabel() {
        TransparentPanel p = new TransparentPanel();
        JSplitPane split = new JSplitPane();
        split.setOrientation(0);
        split.setTopComponent(new JLabel("Hello"));
        RichHintLabel label = new RichHintLabel();
        label.setHtmlText("This is a <a href=\"http:test\">test</a> label with some long text to see how it deals with wrapping in a scroll pane.");
        JScrollPane pane = new JScrollPane(label);
        pane.setVerticalScrollBarPolicy(22);
        pane.setHorizontalScrollBarPolicy(31);
        split.setBottomComponent(pane);
        p.setLayout(new BorderLayout());
        p.add((Component)split, "Center");
        label.registerAction("test", new 2(p));
        return p;
    }

    private static Component createCreateDialogs() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BoxLayout(p, 1));
        JButton headerButton = new JButton("Good Header");
        headerButton.addActionListener(new 3(p));
        p.add(headerButton);
        headerButton = new JButton("Bad Header");
        headerButton.addActionListener(new 4(p));
        p.add(headerButton);
        return p;
    }

    private static Component createHeaders() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout());
        HeaderPanel<TransparentPanel> page = new HeaderPanel<TransparentPanel>();
        page.getHeader().setText("Tam O'Shanter");
        page.getHeader().setLevel(Header.Level.PAGE);
        page.getHeader().setExpanded(true);
        page.setStaticHelpText("This is some help text for the page level header.");
        p.add(page, "Center");
        TransparentPanel pagePanel = new TransparentPanel();
        pagePanel.setLayout(new VerticalFlowLayout());
        page.setHostedComponent(pagePanel);
        HeaderPanel<JLabel> sub1 = new HeaderPanel<JLabel>();
        sub1.getHeader().setName("TEST_HEADER_1");
        sub1.getHeader().setText("Warlocks and Witches in a Dance");
        sub1.setStaticHelpText("This is some help text for this header.");
        sub1.getHeader().setRollupStatusText("Nae cotillion, brent new frae France");
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"add.png")));
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"edit.png")));
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"delete.png")));
        sub1.getHeader().setExpanded(false);
        sub1.getHeader().setExpanded(true);
        sub1.setHostedComponent(new JLabel("Collapse me to see rollup text.", OracleIcons.getIcon((String)"info.png"), 2));
        sub1.getHeader().setLevel(Header.Level.SUB);
        pagePanel.add(sub1);
        HeaderPanel<TransparentPanel> sub2 = new HeaderPanel<TransparentPanel>();
        sub2.getHeader().setText("A Winnock Bunker in the East");
        sub2.getHeader().setLevel(Header.Level.SUB);
        sub2.getHeader().addActionControl(new 5("Foo"));
        TransparentPanel sub2Panel = new TransparentPanel();
        sub2Panel.setLayout(new VerticalFlowLayout());
        HeaderPanel<JLabel> subsub1 = new HeaderPanel<JLabel>();
        subsub1.getHeader().setLevel(Header.Level.SUBSUB);
        subsub1.getHeader().setText("A Tousie Tyke");
        subsub1.getHeader().setRollupStatusText("Black, grim, and large");
        subsub1.setHostedComponent(new JLabel("To gie them music was his charge"));
        sub2Panel.add(subsub1);
        HeaderPanel<JLabel> subsub2 = new HeaderPanel<JLabel>();
        subsub2.getHeader().setLevel(Header.Level.SUBSUB);
        subsub2.getHeader().setText("And by Some Devilish Cantraip Sleight");
        subsub2.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"add.png")));
        subsub2.getHeader().setRollupStatusText("Each in its cauld hand held a light");
        subsub2.setHostedComponent(new JLabel("Till roof and rafters a' did dirl"));
        sub2Panel.add(subsub2);
        sub2.setHostedComponent(sub2Panel);
        pagePanel.add(sub2);
        HeaderPanel<JLabel> dh = new HeaderPanel<JLabel>();
        dh.getHeader().setLevel(Header.Level.DIALOG);
        dh.getHeader().setText("A Dialog Style Header");
        dh.getHeader().setExpanded(false);
        dh.setHostedComponent(new JLabel("Boo.", OracleIcons.getIcon((String)"user.png"), 2));
        dh.setAnimationEnabled(false);
        pagePanel.add(dh);
        JScrollPane sp = new JScrollPane(p);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static Component createTruncatingTreeRenderer() {
        1Node n = new 1Node();
        n.text = "Root";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(n);
        n = new 1Node();
        n.text = "GetStockDailyValuesByValueXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 1Node();
        n.text = "GetStockDailyValuesByDateXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 1Node();
        n.text = "GetStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 1Node();
        n.text = "GetLatestStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 1Node();
        n.text = "GetStockDailyValue";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        DefaultMutableTreeNode sdv = new DefaultMutableTreeNode(n);
        root.add(sdv);
        n = new 1Node();
        n.text = "Method returns the value of the stock on the given date.";
        n.icon = OracleIcons.getIcon((String)"element.png");
        sdv.add(new DefaultMutableTreeNode(n));
        JTree tree = new JTree();
        tree.setModel(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new 6());
        JScrollPane sp = new JScrollPane(tree);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static Component createShadowBorderPanel() {
        JPanel parent = new JPanel();
        TransparentBorderComponent p = new TransparentBorderComponent();
        JLabel l = new JLabel();
        l.setText("Label with a drop shadow!");
        p.setBorder(new ShadowBorder());
        p.add(l);
        parent.add(p);
        return p;
    }

    private static Component createVertHeaderPanel() {
        TransparentPanel p = new TransparentPanel();
        p.setBackground(Color.WHITE);
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.setLayout(new ColumnLayout());
        JTree tree = new JTree();
        tree.setCellRenderer(new TruncatingTreeCellRenderer());
        tree.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Colors.FLAT_EDITOR_BORDER));
        HeaderPanel<JTree> hp = new HeaderPanel<JTree>(tree);
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_LEFT);
        hp.getHeader().setText("Messages");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        hp.getHeader().addActionControl(new 7("", OracleIcons.getIcon((String)"add.png")));
        hp.getHeader().addActionControl(new 8("", OracleIcons.getIcon((String)"delete.png")));
        p.add(hp);
        2Node n = new 2Node();
        n.text = "Root";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(n);
        n = new 2Node();
        n.text = "GetStockDailyValuesByValueXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 2Node();
        n.text = "GetStockDailyValuesByDateXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 2Node();
        n.text = "GetStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 2Node();
        n.text = "GetLatestStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new 2Node();
        n.text = "GetStockDailyValue";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        DefaultMutableTreeNode sdv = new DefaultMutableTreeNode(n);
        root.add(sdv);
        n = new 2Node();
        n.text = "Method returns the value of the stock on the given date.";
        n.icon = OracleIcons.getIcon((String)"element.png");
        sdv.add(new DefaultMutableTreeNode(n));
        tree = new JTree();
        tree.setModel(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new 9());
        hp = new HeaderPanel<JTree>(tree);
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_LEFT);
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().setText("Port Types");
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        hp.getHeader().addActionControl(new 10("", OracleIcons.getIcon((String)"add.png")));
        hp.getHeader().addActionControl(new 11("", OracleIcons.getIcon((String)"delete.png")));
        p.add(hp);
        hp = new HeaderPanel<JTree>(new JTree());
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_RIGHT);
        hp.getHeader().setText("Bindings");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().addActionControl(new 12("", OracleIcons.getIcon((String)"add.png")));
        hp.getHeader().addActionControl(new 13("", OracleIcons.getIcon((String)"delete.png")));
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        p.add(hp);
        hp = new HeaderPanel<JTree>(new JTree());
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_RIGHT);
        hp.getHeader().setText("Services");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().addActionControl(new 14("", OracleIcons.getIcon((String)"add.png")));
        hp.getHeader().addActionControl(new 15("", OracleIcons.getIcon((String)"delete.png")));
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        p.add(hp);
        JScrollPane sp = new JScrollPane(p);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    static final class 1
    implements ActionListener {
        private final /* synthetic */ JTabbedPane v$pane;

        public void actionPerformed(ActionEvent e) {
            this.v$pane.removeAll();
            this.v$pane.addTab("Single Tab", new JPanel());
        }

        public 1(JTabbedPane jTabbedPane) {
            this.v$pane = jTabbedPane;
        }
    }

    static final class 2
    extends AbstractAction {
        private final /* synthetic */ TransparentPanel v$p;

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showConfirmDialog(this.v$p, "Hello World!");
        }

        public 2(TransparentPanel transparentPanel) {
            this.v$p = transparentPanel;
        }
    }

    static final class 3
    implements ActionListener {
        private final /* synthetic */ TransparentPanel v$p;

        public void actionPerformed(ActionEvent ae) {
            JEWTDialog d = JEWTDialog.createDialog((Component)this.v$p, (String)"Create ESB Project", (int)7);
            DialogHeader h = new DialogHeader();
            h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/project.png")));
            h.setHeaderDescription("Enter the details of the empty Oracle Enterprise Service Bus project. An ESB project is a logical container for a set of files that define an ESB system or porition of an ESB system.");
            d.setDialogHeader((Component)h);
            d.runDialog();
        }

        public 3(TransparentPanel transparentPanel) {
            this.v$p = transparentPanel;
        }
    }

    static final class 4
    implements ActionListener {
        private final /* synthetic */ TransparentPanel v$p;

        public void actionPerformed(ActionEvent ae) {
            JEWTDialog d = JEWTDialog.createDialog((Component)this.v$p, (String)"New Java Class", (int)7);
            DialogHeader h = new DialogHeader();
            h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/java.png")));
            h.setHeaderDescription("Enter the details of your new class.");
            d.setDialogHeader((Component)h);
            d.runDialog();
        }

        public 4(TransparentPanel transparentPanel) {
            this.v$p = transparentPanel;
        }
    }

    static final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 5(String string) {
            super(string);
        }
    }

    static class 1Node {
        String text;
        Icon icon;

        1Node() {
        }
    }

    static final class 6
    extends TruncatingTreeCellRenderer {
        protected String getText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
            return ((1Node)value.getUserObject()).text;
        }

        protected Icon getIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
            return ((1Node)value.getUserObject()).icon;
        }
    }

    static final class 7
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 7(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 8(String string, Icon icon) {
            super(string, icon);
        }
    }

    static class 2Node {
        String text;
        Icon icon;

        2Node() {
        }
    }

    static final class 9
    extends TruncatingTreeCellRenderer {
        protected String getText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
            return ((2Node)value.getUserObject()).text;
        }

        protected Icon getIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
            return ((2Node)value.getUserObject()).icon;
        }
    }

    static final class 10
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 10(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 11
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 11(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 12
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 12(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 13
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 13(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 14
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 14(String string, Icon icon) {
            super(string, icon);
        }
    }

    static final class 15
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 15(String string, Icon icon) {
            super(string, icon);
        }
    }

    private static class NullAction
    extends AbstractAction {
        public NullAction(Icon icon) {
            super("", icon);
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }
}

