/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal.painters;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import oracle.javatools.ui.internal.painters.BufferedImagePainter;
import oracle.javatools.ui.internal.painters.PainterComponent;

public class BlurPainter
extends BufferedImagePainter {
    protected int blur;

    public BlurPainter() {
        this(3);
    }

    public BlurPainter(int blur) {
        this.setBlur(blur);
    }

    protected void createImage(Rectangle rect, PainterComponent paintingLayer) {
        int y = -rect.y;
        int x = -rect.x;
        rect.grow(this.blur, this.blur);
        this.image = new BufferedImage(rect.width, rect.height, 2);
        Graphics2D imageG = this.image.createGraphics();
        imageG.setColor(paintingLayer.getBackground());
        imageG.fillRect(0, 0, rect.width, rect.height);
        imageG.translate(this.blur + x, this.blur + y);
        paintingLayer.paint(imageG);
        imageG.dispose();
    }

    public void setBlur(int blur) {
        this.blur = blur;
        float f = 1.0f / (float)(blur * blur);
        float[] mat = new float[blur * blur];
        int i = 0;
        while (i < blur * blur) {
            mat[i] = f;
            ++i;
        }
        Kernel kernel = new Kernel(blur, blur, mat);
        this.op = new ConvolveOp(kernel, 1, null);
    }

    public int getBlur() {
        return this.blur;
    }
}

