/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal.painters;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.javatools.ui.internal.painters.Painter;
import oracle.javatools.ui.internal.painters.PainterComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmptyListPainter
implements Painter<JList> {
    private String emptyText;
    private static Font font = UIManager.getFont("Label.font").deriveFont(15.0f).deriveFont(1);
    private static Color color = UIManager.getColor("Label.disabledForeground");

    public EmptyListPainter(String emptyText) {
        this.emptyText = emptyText;
    }

    @Override
    public void paint(Graphics2D g, PainterComponent<JList> paintingLayer) {
        paintingLayer.paint(g);
        JList list = paintingLayer.getView();
        if (list.getModel().getSize() == 0) {
            g.setColor(color);
            g.setFont(font);
            int w = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.emptyText);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(this.emptyText, list.getVisibleRect().width / 2 - w / 2, (int)list.getVisibleRect().getHeight() / 3);
        }
    }
}

