/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal.painters;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.javatools.ui.internal.painters.DelegatingLayout;
import oracle.javatools.ui.internal.painters.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PainterComponent<V extends JComponent>
extends JComponent {
    private V view;
    private Painter<V> painter;
    private JPanel glassPane;
    private boolean painterPainting;

    private void $init$() {
        this.glassPane = new JPanel();
        this.painterPainting = false;
    }

    public PainterComponent() {
        this(null);
    }

    public PainterComponent(V view) {
        this(view, null);
    }

    public PainterComponent(V view, Painter<V> painter) {
        this.$init$();
        this.setOpaque(true);
        this.glassPane.setOpaque(false);
        this.setView(view);
        this.setPainter(painter);
    }

    public void setView(V view) {
        this.view = view;
        this.setLayout(new DelegatingLayout((JComponent)view, this.glassPane));
        this.removeAll();
        this.add((Component)view);
        this.add((Component)this.glassPane, 0);
    }

    public void setPainter(Painter<V> painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public V getView() {
        return this.view;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (g.getClipBounds() != null && !g.getClipBounds().getSize().equals(this.getVisibleRect().getSize())) {
            this.repaint();
            return;
        }
        if (this.painterPainting || this.painter == null) {
            ((JComponent)this.view).paint(g);
        } else {
            g.setColor(((Component)this.view).getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.painterPainting = true;
            this.painter.paint((Graphics2D)g, this);
            this.painterPainting = false;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return ((JComponent)this.view).getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return ((JComponent)this.view).getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return ((JComponent)this.view).getMaximumSize();
    }
}

