/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal.theme;

import com.jgoodies.looks.plastic.theme.SkyBluerTahoma;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;

public class SkyBluer
extends SkyBluerTahoma {
    protected FontUIResource controlTextFont;
    protected FontUIResource userTextFont;
    protected FontUIResource menuTextFont;
    protected FontUIResource systemTextFont;
    protected FontUIResource windowTitleFont;
    protected FontUIResource subTextFont;
    private static boolean _isWindowsRegistryFontSupported = false;

    public static void setWindowsRegistryFontSupported(boolean isSupported) {
        _isWindowsRegistryFontSupported = isSupported;
    }

    public String getName() {
        return "Sky Bluer";
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public FontUIResource getControlTextFont() {
        if (this.controlTextFont == null) {
            this.controlTextFont = this.getDefaultFont("swing.plaf.metal.controlFont", "Button.font", super.getControlTextFont());
        }
        return this.controlTextFont;
    }

    public FontUIResource getSystemTextFont() {
        if (this.systemTextFont == null) {
            this.systemTextFont = this.getDefaultFont("swing.plaf.metal.systemFont", "ToolTip.font", super.getSystemTextFont());
        }
        return this.systemTextFont;
    }

    public FontUIResource getUserTextFont() {
        if (this.userTextFont == null) {
            this.userTextFont = this.getDefaultFont("swing.plaf.metal.userFont", "TextField.font", super.getUserTextFont());
        }
        return this.userTextFont;
    }

    public FontUIResource getMenuTextFont() {
        if (this.menuTextFont == null) {
            this.menuTextFont = this.getDefaultFont("swing.plaf.metal.controlFont", "Menu.font", super.getMenuTextFont());
        }
        return this.menuTextFont;
    }

    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleFont == null) {
            this.windowTitleFont = this.getDefaultFont("swing.plaf.metal.controlFont", "InternalFrame.titleFont", super.getWindowTitleFont());
        }
        return this.windowTitleFont;
    }

    public FontUIResource getSubTextFont() {
        if (this.subTextFont == null) {
            Font font = Font.getFont("swing.plaf.metal.smallFont");
            if (font != null) {
                this.subTextFont = new FontUIResource(font);
            } else if (this.isWindows()) {
                font = this.getFont0();
                String name = font.getName();
                int style = font.getStyle();
                int size = Math.round(font.getSize2D() * 0.9f);
                this.subTextFont = new FontUIResource(name, style, size);
            } else {
                this.subTextFont = super.getSubTextFont();
            }
        }
        return this.subTextFont;
    }

    protected Font getFont0() {
        Toolkit toolkit;
        Object value;
        if (this.isWindows() && (value = (toolkit = Toolkit.getDefaultToolkit()).getDesktopProperty("win.defaultGUI.font")) instanceof Font) {
            Font font = (Font)value;
            int fontSize = font.getSize();
            return this.getFont0(fontSize);
        }
        return super.getFont0();
    }

    protected Font getFont0(int size) {
        return new Font("Dialog", 0, size);
    }

    protected FontUIResource getDefaultFont(String propertyKey, String uiDefaultsKey, FontUIResource defaultFont) {
        Font font = Font.getFont(propertyKey);
        if (font != null) {
            return new FontUIResource(font);
        }
        if (this.isWindows()) {
            FontUIResource ret;
            WindowsLookAndFeel winLaf = new WindowsLookAndFeel();
            UIDefaults winDefaults = winLaf.getDefaults();
            Object value = winDefaults.get(uiDefaultsKey);
            if (value instanceof FontUIResource) {
                ret = (FontUIResource)value;
            } else if (value instanceof Font) {
                ret = new FontUIResource((Font)value);
            } else {
                return defaultFont;
            }
            if (_isWindowsRegistryFontSupported) {
                return ret;
            }
            String fontName = ret.getFontName();
            if (!fontName.equalsIgnoreCase("tahoma")) {
                return ret;
            }
        }
        return defaultFont;
    }
}

