/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import oracle.bali.ewt.graphics.GraphicUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WordWrappingToolTipUI
extends BasicToolTipUI {
    private static final int MAX_CHARS_PER_LINE = 60;
    private static WordWrappingToolTipUI sharedInstance = new WordWrappingToolTipUI();
    private static final String CP_WRAP_DISABLED = "ttWrappingDisabled";

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public static void disableWordWrapping(JToolTip tip) {
        tip.putClientProperty(CP_WRAP_DISABLED, Boolean.TRUE);
    }

    private static boolean isWordWrappingDisabled(JComponent tip) {
        Boolean b = (Boolean)tip.getClientProperty(CP_WRAP_DISABLED);
        if (b == null) {
            return false;
        }
        return b;
    }

    private static List<String> breakTextIntoLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        BreakIterator lineIterator = BreakIterator.getLineInstance();
        lineIterator.setText(text);
        StringBuilder currentLine = new StringBuilder();
        boolean newline = false;
        int start = lineIterator.first();
        int end = lineIterator.next();
        while (end != -1) {
            if (newline) {
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                newline = false;
            }
            char lastChar = text.charAt(end - 1);
            int length = end - start;
            if (currentLine.length() + length >= 60 && lastChar != '.' && lastChar != ':') {
                newline = true;
            }
            currentLine.append(text.substring(start, end));
            start = end;
            end = lineIterator.next();
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (WordWrappingToolTipUI.isWordWrappingDisabled(c)) {
            return super.getPreferredSize(c);
        }
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            return super.getPreferredSize(c);
        }
        String text = ((JToolTip)c).getTipText();
        if (text == null) {
            text = "";
        }
        if (text.startsWith("<html>")) {
            return super.getPreferredSize(c);
        }
        Font font = c.getFont();
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        FontMetrics fm = c.getFontMetrics(font);
        List<String> wrapped = WordWrappingToolTipUI.breakTextIntoLines(text);
        prefSize.height += wrapped.size() * fm.getHeight();
        for (String s : wrapped) {
            prefSize.width = Math.max(prefSize.width, fm.stringWidth(s) + insets.left + insets.right + 6);
        }
        return prefSize;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        String text;
        if (WordWrappingToolTipUI.isWordWrappingDisabled(c)) {
            super.paint(g, c);
            return;
        }
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            super.paint(g, c);
        }
        if ((text = ((JToolTip)c).getTipText()) == null) {
            text = "";
        }
        if (text.startsWith("<html>")) {
            super.paint(g, c);
            return;
        }
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        g.setColor(c.getForeground());
        Font font = c.getFont();
        g.setFont(font);
        List<String> lines = WordWrappingToolTipUI.breakTextIntoLines(text);
        Insets insets = c.getInsets();
        FontMetrics metrics = c.getFontMetrics(font);
        int y = insets.top;
        for (String s : lines) {
            GraphicUtils.drawString((Graphics)g, (String)s, (int)(insets.left + 3), (int)(y + metrics.getAscent()));
            y += metrics.getHeight();
        }
    }
}

