/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticMenuUI;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public class ThemedMenuUI
extends PlasticMenuUI {
    private final Handler _handler;

    private void $init$() {
        this._handler = new Handler(null);
    }

    public static ComponentUI createUI(JComponent m) {
        return new ThemedMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (Themes.isThemed()) {
            c.addMouseListener(this._handler);
            c.addPropertyChangeListener(this._handler);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (Themes.isThemed()) {
            c.removeMouseListener(this._handler);
            c.removePropertyChangeListener(this._handler);
        }
    }

    private void setMenuStyle(JMenu menu, boolean mouseOver) {
        String state = mouseOver ? "mouseover" : "normal";
        Theme theme = Themes.getActiveTheme();
        if (menu.getFont() instanceof UIResource) {
            Font defaultFont = UIManager.getFont("Menu.font");
            menu.setFont(theme.getStateProperties("menubar", state).getFont(defaultFont, "label"));
        }
        if (menu.getForeground() instanceof UIResource) {
            menu.setForeground(theme.getStateProperties("menubar", state).getColor("label.foreground"));
        }
        if (menu.isShowing()) {
            menu.repaint();
        }
    }

    public ThemedMenuUI() {
        this.$init$();
    }

    static void mav$setMenuStyle(ThemedMenuUI themedMenuUI, JMenu jMenu, boolean bl) {
        themedMenuUI.setMenuStyle(jMenu, bl);
    }

    private class Handler
    implements MouseListener,
    PropertyChangeListener {
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.mav$setMenuStyle(ThemedMenuUI.this, menu, true);
            }
        }

        public void mouseExited(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.mav$setMenuStyle(ThemedMenuUI.this, menu, false);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JMenu menu;
            if ("ancestor".equals(e.getPropertyName()) && (menu = (JMenu)e.getSource()).isTopLevelMenu()) {
                ThemedMenuUI.mav$setMenuStyle(ThemedMenuUI.this, menu, false);
            }
        }

        private Handler() {
        }

        Handler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

