/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticScrollBarUI;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollButton;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public final class ThemedPlasticScrollBarUI
extends PlasticScrollBarUI {
    private boolean _mouseOver;
    private MouseListener _mouseListener;

    private void $init$() {
        this._mouseOver = false;
    }

    protected JButton createIncreaseButton(int orientation) {
        if (!Themes.isThemed()) {
            return super.createIncreaseButton(orientation);
        }
        this.increaseButton = new ThemedPlasticScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected JButton createDecreaseButton(int orientation) {
        if (!Themes.isThemed()) {
            return super.createDecreaseButton(orientation);
        }
        this.decreaseButton = new ThemedPlasticScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (!Themes.isThemed()) {
            super.paintTrack(g, c, trackBounds);
        } else {
            Rectangle myBounds = this.scrollbar.getBounds();
            Rectangle r = new Rectangle(0, 0, myBounds.width, myBounds.height);
            this.paintScrollBarThemePart(g, r, "scrolltrack", "normal");
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!Themes.isThemed()) {
            super.paintThumb(g, c, thumbBounds);
        } else {
            String state = "normal";
            if (this.isDragging) {
                state = "mousedown";
            } else if (this._mouseOver) {
                state = "mouseover";
            }
            this.paintScrollBarThemePart(g, thumbBounds, "scrollthumb", state);
            this.paintScrollBarThemePart(g, thumbBounds, "scrollgrip", state);
        }
    }

    private void paintScrollBarThemePart(Graphics g, Rectangle bounds, String partbase, String state) {
        String part = partbase + (this.scrollbar.getOrientation() == 1 ? "v" : "h");
        this.paintThemeBackground(g, bounds, state, part);
    }

    public static ComponentUI createUI(JComponent b) {
        return new ThemedPlasticScrollBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.scrollbar.addMouseListener(this.getRollOverMouseListener());
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this._mouseListener);
        this.increaseButton.removeMouseListener(this._mouseListener);
        this.decreaseButton.removeMouseListener(this._mouseListener);
        this._mouseListener = null;
    }

    private MouseListener getRollOverMouseListener() {
        if (this._mouseListener == null) {
            this._mouseListener = new 1();
        }
        return this._mouseListener;
    }

    private void paintThemeBackground(Graphics g, Rectangle bounds, String state, String part) {
        ThemeProperties theme = Themes.getActiveTheme().getStateProperties(part, state);
        theme.getPainter("bg").paint(g, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public ThemedPlasticScrollBarUI() {
        this.$init$();
    }

    static void mav$paintThemeBackground(ThemedPlasticScrollBarUI themedPlasticScrollBarUI, Graphics graphics, Rectangle rectangle, String string, String string2) {
        themedPlasticScrollBarUI.paintThemeBackground(graphics, rectangle, string, string2);
    }

    static boolean ra$_mouseOver(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI._mouseOver;
    }

    static MouseListener mav$getRollOverMouseListener(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI.getRollOverMouseListener();
    }

    static void wa$_mouseOver(ThemedPlasticScrollBarUI themedPlasticScrollBarUI, boolean bl) {
        themedPlasticScrollBarUI._mouseOver = bl;
    }

    static MetalScrollButton ra$increaseButton(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI.increaseButton;
    }

    static MetalScrollButton ra$decreaseButton(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI.decreaseButton;
    }

    static JScrollBar ra$scrollbar(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI.scrollbar;
    }

    static Rectangle ra$trackRect(ThemedPlasticScrollBarUI themedPlasticScrollBarUI) {
        return themedPlasticScrollBarUI.trackRect;
    }

    final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            ThemedPlasticScrollBarUI.wa$_mouseOver(ThemedPlasticScrollBarUI.this, true);
            ThemedPlasticScrollBarUI.ra$increaseButton(ThemedPlasticScrollBarUI.this).repaint();
            ThemedPlasticScrollBarUI.ra$decreaseButton(ThemedPlasticScrollBarUI.this).repaint();
            ThemedPlasticScrollBarUI.ra$scrollbar(ThemedPlasticScrollBarUI.this).repaint(ThemedPlasticScrollBarUI.ra$trackRect(ThemedPlasticScrollBarUI.this));
        }

        public void mouseExited(MouseEvent e) {
            ThemedPlasticScrollBarUI.wa$_mouseOver(ThemedPlasticScrollBarUI.this, false);
            ThemedPlasticScrollBarUI.ra$increaseButton(ThemedPlasticScrollBarUI.this).repaint();
            ThemedPlasticScrollBarUI.ra$decreaseButton(ThemedPlasticScrollBarUI.this).repaint();
            ThemedPlasticScrollBarUI.ra$scrollbar(ThemedPlasticScrollBarUI.this).repaint(ThemedPlasticScrollBarUI.ra$trackRect(ThemedPlasticScrollBarUI.this));
        }
    }

    private class ThemedPlasticScrollButton
    extends PlasticArrowButton {
        ThemedPlasticScrollButton(int direction, int width, boolean freeStanding) {
            super(direction, width, freeStanding);
            this.addMouseListener(ThemedPlasticScrollBarUI.mav$getRollOverMouseListener(ThemedPlasticScrollBarUI.this));
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            if (!Themes.isThemed()) {
                super.paint(g);
            } else {
                String state = "normal";
                if (this.getModel().isPressed()) {
                    state = "mousedown";
                } else if (ThemedPlasticScrollBarUI.ra$_mouseOver(ThemedPlasticScrollBarUI.this)) {
                    state = "mouseover";
                }
                Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                this.paintScrollButton(g, bounds, this.getDirection(), state);
            }
        }

        private void paintScrollButton(Graphics g, Rectangle bounds, int direction, String state) {
            String dir = "";
            switch (direction) {
                case 1: {
                    dir = "up";
                    break;
                }
                case 3: {
                    dir = "right";
                    break;
                }
                case 5: {
                    dir = "down";
                    break;
                }
                case 7: {
                    dir = "left";
                    break;
                }
            }
            String part = "scrollbutton" + dir;
            ThemedPlasticScrollBarUI.mav$paintThemeBackground(ThemedPlasticScrollBarUI.this, g, bounds, state, part);
        }
    }
}

