/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class ThemedTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer _originalHeaderRenderer;
    private int rolloverColumn;

    private void $init$() {
        this.rolloverColumn = -1;
    }

    public static ComponentUI createUI(JComponent h) {
        return new ThemedTableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (Themes.isThemed()) {
            this._originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this._originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new ThemedDefaultRenderer(null));
            }
        }
    }

    private void updateRolloverColumn(MouseEvent e) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(e.getPoint()) && (col = this.header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
            this.rolloverColumn = col;
            this.header.repaint();
        }
    }

    protected MouseInputListener createMouseInputListener() {
        if (Themes.isThemed()) {
            return new 1(this);
        }
        return super.createMouseInputListener();
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof ThemedDefaultRenderer) {
            this.header.setDefaultRenderer(this._originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    public ThemedTableHeaderUI() {
        this.$init$();
    }

    static JTableHeader ra$header(ThemedTableHeaderUI themedTableHeaderUI) {
        return themedTableHeaderUI.header;
    }

    static int ra$rolloverColumn(ThemedTableHeaderUI themedTableHeaderUI) {
        return themedTableHeaderUI.rolloverColumn;
    }

    static void mav$updateRolloverColumn(ThemedTableHeaderUI themedTableHeaderUI, MouseEvent mouseEvent) {
        themedTableHeaderUI.updateRolloverColumn(mouseEvent);
    }

    static void wa$rolloverColumn(ThemedTableHeaderUI themedTableHeaderUI, int n) {
        themedTableHeaderUI.rolloverColumn = n;
    }

    final class 1
    extends BasicTableHeaderUI.MouseInputHandler {
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            ThemedTableHeaderUI.mav$updateRolloverColumn(ThemedTableHeaderUI.this, e);
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            ThemedTableHeaderUI.mav$updateRolloverColumn(ThemedTableHeaderUI.this, e);
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            ThemedTableHeaderUI.wa$rolloverColumn(ThemedTableHeaderUI.this, -1);
            ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this).repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this).getReorderingAllowed()) {
                ThemedTableHeaderUI.wa$rolloverColumn(ThemedTableHeaderUI.this, -1);
                ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this).repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            ThemedTableHeaderUI.mav$updateRolloverColumn(ThemedTableHeaderUI.this, e);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            ThemedTableHeaderUI.mav$updateRolloverColumn(ThemedTableHeaderUI.this, e);
        }

        public 1(BasicTableHeaderUI basicTableHeaderUI) {
            super(basicTableHeaderUI);
        }
    }

    private class ThemedDefaultRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        final Theme theme;
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        private void $init$() {
            this.theme = Themes.getActiveTheme();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setFont(header.getFont());
            }
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            this.column = column;
            this.hasRollover = column == ThemedTableHeaderUI.ra$rolloverColumn(ThemedTableHeaderUI.this);
            this.setText(value == null ? "" : value.toString());
            this.setBorder(new EmptyBorder(this.theme.getPartProperties("tableheader").getInsets("contentmargin")));
            return this;
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this).getColumnModel();
            int column = 0;
            while (column < cm.getColumnCount()) {
                if (cm.getColumn(column) == aColumn) {
                    return column;
                }
                ++column;
            }
            return -1;
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            String state = "normal";
            if (ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this) == null) {
                return;
            }
            if (this.column == this.viewIndexForColumn(ThemedTableHeaderUI.ra$header(ThemedTableHeaderUI.this).getDraggedColumn())) {
                state = "mousedown";
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = "mouseover";
            }
            this.theme.getStateProperties("tableheader", state).getPainter("bg").paint(g, 0, 0, size.width, size.height);
            super.paint(g);
        }

        private ThemedDefaultRenderer() {
            this.$init$();
        }

        ThemedDefaultRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

