/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class ThemedToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new ThemedToolBarSeparatorUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (Themes.isThemed()) {
            JToolBar.Separator sep = (JToolBar.Separator)c;
            ThemeProperties p = Themes.getActiveTheme().getStateProperties("toolbarseparator", "normal");
            g.setColor(p.getColor("color"));
            if (sep.getOrientation() == 1) {
                int mid = sep.getSeparatorSize().width / 2;
                g.drawLine(mid, 0, mid, c.getHeight());
            }
        }
        super.paint(g, c);
    }

    protected void installDefaults(JSeparator s) {
        Dimension size;
        super.installDefaults(s);
        if (Themes.isThemed() && ((size = ((JToolBar.Separator)s).getSeparatorSize()) == null || size instanceof UIResource)) {
            JToolBar.Separator sep = (JToolBar.Separator)s;
            ThemeProperties p = Themes.getActiveTheme().getStateProperties("toolbarseparator", "normal");
            int sizeFromTheme = p.getInt("size");
            size = new DimensionUIResource(sizeFromTheme, sizeFromTheme);
            if (sep.getOrientation() == 0) {
                size = new DimensionUIResource(size.height, size.width);
            }
            sep.setSeparatorSize(size);
        }
    }
}

