/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class PromptedTextField
extends JTextField {
    private Color _promptColor;
    private String _prompt;

    private void $init$() {
        this._promptColor = UIManager.getColor("TextField.inactiveForeground");
        this._prompt = "";
    }

    public PromptedTextField() {
        this.$init$();
        this.addFocusListener(new 1());
    }

    public void setPrompt(String prompt) {
        this._prompt = prompt;
    }

    public String getPrompt() {
        return this._prompt;
    }

    public void setPromptForeground(Color c) {
        Color oldColor = this._promptColor;
        this._promptColor = c;
        if (this.isPromptVisible()) {
            super.setForeground(this._promptColor);
        }
        this.firePropertyChange("promptForeground", oldColor, c);
    }

    public Color getPromptForeground() {
        return this._promptColor;
    }

    public boolean isPromptVisible() {
        return !this.hasFocus() && this.getText().length() == 0;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isPromptVisible()) {
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            int baseline = this.getSize().height / 2 - descent / 2 + ascent / 2;
            g.setColor(this._promptColor);
            g.drawString(this._prompt, this.getMargin().left + this.getInsets().left, baseline);
            g.setColor(this.getForeground());
        }
    }

    public Document getBaseDocument() {
        return super.getDocument();
    }

    final class 1
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            PromptedTextField.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            PromptedTextField.this.repaint();
        }
    }
}

