/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

final class SlideTip {
    private static final int BALLOON_LAYER = JLayeredPane.POPUP_LAYER + 20;
    private Direction _direction;
    private boolean _isVisible;
    private JLabel _tipText;

    private void $init$() {
        this._isVisible = false;
        this._tipText = new 1();
    }

    public SlideTip() {
        this.$init$();
        this._tipText.setBackground(UIManager.getColor("ToolTip.background"));
        this._tipText.setForeground(UIManager.getColor("ToolTip.foreground"));
        this._tipText.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("ToolTip.border"), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
    }

    public void setText(String text) {
        this._tipText.setText(text);
    }

    public String getText() {
        return this._tipText.getText();
    }

    public void setIcon(Icon icon) {
        this._tipText.setIcon(icon);
    }

    public Icon getIcon() {
        return this._tipText.getIcon();
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
    }

    public Direction getDirection() {
        return this._direction;
    }

    public void show(int offset, Component c, int hideAfterInMs) {
        if (this._isVisible) {
            return;
        }
        JLayeredPane pane = SlideTip.getLayeredPane(c);
        if (pane == null) {
            throw new IllegalArgumentException("Cannot find layered pane for " + c);
        }
        this._isVisible = true;
        pane.add((Component)this._tipText, (Object)BALLOON_LAYER);
        Point basePos = SlideTip.getPositionInLayeredPane(c);
        Rectangle startBounds = new Rectangle(basePos.x + offset, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, 0);
        Rectangle endBounds = new Rectangle(basePos.x + offset, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, this._tipText.getPreferredSize().height);
        this._tipText.setBounds(basePos.x, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, 0);
        PropertyRange heightRange = PropertyRange.createPropertyRangeRectangle((String)"bounds", (Rectangle[])new Rectangle[]{startBounds, endBounds});
        ObjectModifier modifier = new ObjectModifier((Object)this._tipText, heightRange);
        TimingController animation = new TimingController(new Cycle(1000, 30), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), (TimingTarget)modifier);
        animation.start();
        if (hideAfterInMs > 0) {
            Timer t = new Timer(hideAfterInMs, new 2(this, c));
            t.setRepeats(false);
            t.start();
        }
    }

    public void show(Component c) {
        this.show(0, c, -1);
    }

    private void hide(Component c) {
        Rectangle b = this._tipText.getBounds();
        Rectangle endBounds = new Rectangle(b.x, b.y, b.width, 0);
        Rectangle startBounds = this._tipText.getBounds();
        PropertyRange heightRange = PropertyRange.createPropertyRangeRectangle((String)"bounds", (Rectangle[])new Rectangle[]{startBounds, endBounds});
        ObjectModifier modifier = new ObjectModifier((Object)this._tipText, heightRange);
        3 animation = new 3(this, new Cycle(1000, 30), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), (TimingTarget)modifier, c);
        animation.start();
    }

    private static JLayeredPane getLayeredPane(Component target) {
        Window ancestor = SwingUtilities.getWindowAncestor(target);
        JLayeredPane layeredPane = null;
        if (ancestor instanceof JFrame) {
            layeredPane = ((JFrame)ancestor).getLayeredPane();
        } else if (ancestor instanceof JDialog) {
            layeredPane = ((JDialog)ancestor).getLayeredPane();
        }
        return layeredPane;
    }

    private static Point getPositionInLayeredPane(Component c) {
        Point p = new Point();
        p.x = c.getLocation().x;
        p.y = c.getLocation().y;
        Container parent = c.getParent();
        while (parent != null) {
            Point parentLoc = parent.getLocation();
            p.x += parentLoc.x;
            p.y += parentLoc.y;
            if (parent instanceof JLayeredPane) break;
            parent = parent.getParent();
        }
        return p;
    }

    static JLayeredPane maS$getLayeredPane(Component component) {
        return SlideTip.getLayeredPane(component);
    }

    static JLabel ra$_tipText(SlideTip slideTip) {
        return slideTip._tipText;
    }

    static void wa$_isVisible(SlideTip slideTip, boolean bl) {
        slideTip._isVisible = bl;
    }

    static void mav$hide(SlideTip slideTip, Component component) {
        slideTip.hide(component);
    }

    final class 1
    extends JLabel {
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = g2d.getComposite();
            try {
                AlphaComposite rule = AlphaComposite.getInstance(3, 0.8f);
                g2d.setComposite(rule);
                g2d.setColor(UIManager.getColor("ToolTip.background"));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
            finally {
                g2d.setComposite(old);
            }
        }
    }

    final class 2
    implements ActionListener {
        private final /* synthetic */ Component v$c;
        final /* synthetic */ SlideTip this$0;

        public void actionPerformed(ActionEvent ae) {
            SlideTip.mav$hide(this.this$0, this.v$c);
        }

        public 2(SlideTip slideTip, Component component) {
            this.v$c = component;
            this.this$0 = slideTip;
        }
    }

    final class 3
    extends TimingController {
        private final /* synthetic */ Component v$c;
        final /* synthetic */ SlideTip this$0;

        public void end() {
            super.end();
            JLayeredPane pane = SlideTip.maS$getLayeredPane(this.v$c);
            pane.remove(SlideTip.ra$_tipText(this.this$0));
            pane.repaint();
            SlideTip.wa$_isVisible(this.this$0, false);
        }

        public 3(SlideTip slideTip, Cycle cycle, Envelope envelope, TimingTarget timingTarget, Component component) {
            this.v$c = component;
            this.this$0 = slideTip;
            super(cycle, envelope, timingTarget);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Direction
    extends Enum<Direction> {
        private static final /* synthetic */ Direction[] $v;
        public static final /* enum */ Direction UP;
        public static final /* enum */ Direction DOWN;
        public static final /* enum */ Direction LEFT;
        public static final /* enum */ Direction RIGHT;

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }

        public static final Direction[] values() {
            return (Direction[])$v.clone();
        }

        static {
            Direction[] directionArray = new Direction[4];
            directionArray[3] = RIGHT = new Direction("RIGHT", 3);
            directionArray[2] = LEFT = new Direction("LEFT", 2);
            directionArray[1] = DOWN = new Direction("DOWN", 1);
            directionArray[0] = UP = new Direction("UP", 0);
            $v = directionArray;
        }

        private Direction(String string2, int n2) {
        }
    }
}

