/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.simplestyle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextModel {
    private List<TextRun> runList;
    private List<List<TextRun>> lineList;

    private void $init$() {
        this.runList = new LinkedList<TextRun>();
        this.lineList = new LinkedList<List<TextRun>>();
    }

    public StyledTextModel() {
        this.$init$();
        this.lineList.add(this.runList);
    }

    public StyledTextModel(String initialText, StyledTextAttribute initialStyle) {
        this();
        this.addText(initialText, initialStyle);
    }

    public void append(StyledTextModel model) {
        this.lineList.get(this.lineList.size() - 1).addAll(model.runList);
        int line = 1;
        while (line < model.lineList.size()) {
            this.lineList.add(model.lineList.get(line));
            ++line;
        }
    }

    public void addText(String text, StyledTextAttribute attr) {
        TextRun pair = new TextRun();
        pair.text = text;
        pair.attr = attr;
        this.runList.add(pair);
    }

    public void prependText(String text, StyledTextAttribute attr) {
        TextRun pair = new TextRun();
        pair.text = text;
        pair.attr = attr;
        this.runList.add(0, pair);
    }

    public void addLineBreak() {
        this.runList = new LinkedList<TextRun>();
        this.lineList.add(this.runList);
    }

    Iterator<TextRun> runIterator(int line) {
        return this.lineList.get(line).iterator();
    }

    int getLineCount() {
        return this.lineList.size();
    }

    public String toString() {
        String s = "";
        for (List<TextRun> runList : this.lineList) {
            for (TextRun run : runList) {
                s = s + run.attr + " : " + run.text;
            }
            s = s + "\n";
        }
        return s;
    }

    static class TextRun {
        String text;
        StyledTextAttribute attr;

        TextRun() {
        }
    }
}

