/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.simplestyle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;

public class StyledTextRenderer {
    public static final String ellipses = "...";

    public static void renderText(JComponent c, Graphics graphics, StyledTextModel model, int x, int y) {
        Graphics g = graphics.create();
        g.translate(0, y);
        int line = 0;
        while (line < model.getLineCount()) {
            int lineHeight = StyledTextRenderer.getMaxAscent(c, model, line);
            g.translate(0, lineHeight);
            StyledTextRenderer.renderLine(c, g, model, x, line);
            g.translate(0, StyledTextRenderer.getMaxDescent(c, model, line));
            ++line;
        }
        g.dispose();
    }

    private static void renderLine(JComponent c, Graphics g, StyledTextModel model, int x, int line) {
        Iterator<StyledTextModel.TextRun> it = model.runIterator(line);
        while (it.hasNext()) {
            StyledTextModel.TextRun pair = it.next();
            g.setColor((Color)pair.attr.getAttribute(StyledTextAttribute.AttributeType.FOREGROUND));
            g.setFont((Font)pair.attr.getAttribute(StyledTextAttribute.AttributeType.FONT));
            int w = SwingUtilities.computeStringWidth(g.getFontMetrics(), pair.text);
            if (x + w > c.getWidth()) {
                g.drawString(StyledTextRenderer.getTruncatedText(g.getFontMetrics(), pair, c.getWidth() - x), x, 0);
                break;
            }
            g.drawString(pair.text, x, 0);
            x += w;
        }
    }

    private static String getTruncatedText(FontMetrics fm, StyledTextModel.TextRun pair, int space) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < pair.text.length()) {
            char c = pair.text.charAt(i);
            String str = sb.toString() + c + ellipses;
            int width = SwingUtilities.computeStringWidth(fm, str);
            if (width > space) {
                return sb.toString() + ellipses;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static Dimension getPreferredSize(JComponent c, StyledTextModel model) {
        Dimension d = new Dimension(2, 0);
        int line = 0;
        while (line < model.getLineCount()) {
            Iterator<StyledTextModel.TextRun> it = model.runIterator(line);
            int lineHeight = 0;
            int lineWidth = 0;
            while (it.hasNext()) {
                StyledTextModel.TextRun pair = it.next();
                Font f = (Font)pair.attr.getAttribute(StyledTextAttribute.AttributeType.FONT);
                lineWidth += SwingUtilities.computeStringWidth(c.getFontMetrics(f), pair.text) + 2;
                lineHeight = StyledTextRenderer.getMaxAscent(c, model, line);
                if (line >= model.getLineCount() - 1) continue;
                lineHeight += StyledTextRenderer.getMaxDescent(c, model, line);
            }
            d.height += lineHeight;
            d.width = Math.max(lineWidth, d.width);
            ++line;
        }
        d.height += StyledTextRenderer.getMaxDescent(c, model, line - 1);
        return d;
    }

    public static int getMaxAscent(JComponent c, StyledTextModel model, int line) {
        int height = 0;
        Iterator<StyledTextModel.TextRun> it = model.runIterator(line);
        while (it.hasNext()) {
            StyledTextModel.TextRun pair = it.next();
            Font f = (Font)pair.attr.getAttribute(StyledTextAttribute.AttributeType.FONT);
            int runH = c.getFontMetrics(f).getMaxAscent();
            height = Math.max(height, runH);
        }
        return height;
    }

    public static int getMaxDescent(JComponent c, StyledTextModel model, int line) {
        int height = 0;
        Iterator<StyledTextModel.TextRun> it = model.runIterator(line);
        while (it.hasNext()) {
            StyledTextModel.TextRun pair = it.next();
            Font f = (Font)pair.attr.getAttribute(StyledTextAttribute.AttributeType.FONT);
            FontMetrics fm = c.getFontMetrics(f);
            int runH = fm.getMaxDescent() + fm.getLeading();
            height = Math.max(height, runH);
        }
        return height;
    }
}

