/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.javatools.ui.themes.Painter;

public final class HyperlinkButtonPainter
implements Painter {
    private final AbstractButton _button;
    private final Border _focusBorder;
    private final Rectangle paintIconR;
    private final Rectangle paintTextR;
    private final Rectangle paintViewR;

    private void $init$() {
        this.paintIconR = new Rectangle();
        this.paintTextR = new Rectangle();
        this.paintViewR = new Rectangle();
    }

    public HyperlinkButtonPainter(AbstractButton button) {
        this.$init$();
        this._button = button;
        this._focusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
    }

    private Icon icon() {
        return this._button.isEnabled() ? this._button.getIcon() : this._button.getDisabledIcon();
    }

    public void paint(Graphics g, int x, int y, int w, int h) {
        this.paintViewR.x = 1;
        this.paintViewR.y = 0;
        this.paintViewR.width = this._button.getWidth();
        this.paintViewR.height = this._button.getHeight();
        this.paintIconR.setBounds(0, 0, 0, 0);
        this.paintTextR.setBounds(0, 0, 0, 0);
        FontMetrics metrics = g.getFontMetrics(this._button.getFont());
        String clippedText = SwingUtilities.layoutCompoundLabel(this._button, metrics, this._button.getText(), this.icon(), 0, 2, 0, 4, this.paintViewR, this.paintIconR, this.paintTextR, 4);
        g.setColor(this._button.getForeground());
        g.setFont(this._button.getFont());
        this.paintIcon(g);
        int textX = this.paintTextR.x;
        int textY = this.paintTextR.y + metrics.getAscent();
        this.paintText(g, clippedText, textX, textY);
        this.paintUnderline(g, metrics, clippedText, textX, textY);
        if (this._button.isFocusPainted() && this._button.hasFocus()) {
            this._focusBorder.paintBorder(this._button, g, this.paintTextR.x, this.paintTextR.y, this.paintTextR.width, this.paintTextR.height);
        }
    }

    private void paintIcon(Graphics g) {
        if (this.icon() != null) {
            this.icon().paintIcon(this._button, g, this.paintIconR.x, this.paintIconR.y);
        }
    }

    private void paintUnderline(Graphics g, FontMetrics metrics, String clippedText, int textX, int textY) {
        if (!this._button.isRolloverEnabled() || this._button.getModel().isRollover()) {
            int width = metrics.stringWidth(clippedText);
            int linePos = textY + 1;
            g.drawLine(textX, linePos, textX + width - 1, linePos);
        }
    }

    private void paintText(Graphics g, String clippedText, int textX, int textY) {
        if (this._button.isEnabled()) {
            g.setColor(this._button.getForeground());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)textX, (int)textY);
        } else {
            Color background = this._button.getBackground();
            g.setColor(background.brighter());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)(textX + 1), (int)(textY + 1));
            g.setColor(background.darker());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)textX, (int)textY);
        }
    }
}

