/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.javatools.ui.themes.ThemeProperties;

public final class Theme {
    private final Properties _properties;
    private final ThemeProperties _global;
    private final Map<String, ThemeProperties> _partAndState;
    private String _id;

    private void $init$() {
        this._partAndState = new HashMap<String, ThemeProperties>();
    }

    public Theme(Properties themeProperties) {
        this.$init$();
        if (themeProperties == null) {
            throw new NullPointerException("themeProperties is null");
        }
        this._properties = themeProperties;
        this._global = new ThemeProperties(themeProperties, "");
    }

    public void setClassLoader(ClassLoader cl) {
        this._global.setClassLoader(cl);
        for (ThemeProperties value : this._partAndState.values()) {
            value.setClassLoader(cl);
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.getGlobalProperties().getString("name");
    }

    public ThemeProperties getGlobalProperties() {
        return this._global;
    }

    public ThemeProperties getPartProperties(String partId) {
        if (partId == null) {
            throw new NullPointerException("partId is null");
        }
        return this.getPartOrStateProperties(partId + ".");
    }

    private ThemeProperties getPartOrStateProperties(String baseId) {
        ThemeProperties tp = this._partAndState.get(baseId);
        if (tp == null) {
            tp = new ThemeProperties(this._properties, baseId);
            tp.setClassLoader(this._global.getClassLoader());
            this._partAndState.put(baseId, tp);
        }
        return tp;
    }

    public ThemeProperties getStateProperties(String partId, String stateId) {
        if (partId == null) {
            throw new NullPointerException("partId is null");
        }
        if (stateId == null) {
            throw new NullPointerException("stateId is null");
        }
        return this.getPartOrStateProperties(partId + "." + stateId + ".");
    }
}

