/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.VolatileImage;
import oracle.javatools.ui.themes.Painter;

final class VolatileImageCachingPainter
implements Painter {
    private final Painter _delegate;
    private VolatileImage _cachedImage;

    public VolatileImageCachingPainter(Painter delegate) {
        this._delegate = delegate;
    }

    public void paint(Graphics g, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        do {
            GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
            if (this._cachedImage == null || this._cachedImage.getWidth() != w || this._cachedImage.getHeight() != h) {
                this.renderOffscreen(gc, true, w, h);
            } else {
                int returnCode = this._cachedImage.validate(gc);
                if (returnCode == 1) {
                    this.renderOffscreen(gc, false, w, h);
                } else if (returnCode == 2) {
                    this.renderOffscreen(gc, true, w, h);
                }
            }
            g.drawImage(this._cachedImage, x, y, null);
        } while (this._cachedImage.contentsLost());
    }

    private void renderOffscreen(GraphicsConfiguration gc, boolean create, int w, int h) {
        do {
            if (create || this._cachedImage.validate(gc) == 2) {
                this._cachedImage = gc.createCompatibleVolatileImage(w, h, 3);
            }
            Graphics2D g = this._cachedImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, w, h);
            this._delegate.paint(g, 0, 0, w, h);
            g.dispose();
        } while (this._cachedImage.contentsLost());
    }
}

