/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraCollationElementIterator;
import oracle.i18n.text.OraCollationKey;
import oracle.i18n.text.OraLinguistic;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;
import oracle.i18n.util.builder.UnicodeMapChar;

public class OraCollator
implements Cloneable,
Comparator {
    private static final int MONO = 0;
    private static final int MULTI = 1;
    private static final int BINARY = 2;
    private static final int BINARY_UNICODE = 3;
    private static final int BINARY_BASE_LETTER_ORAID = 16;
    private static final int CASE_FOLDING_TABLE_ORAID = 17;
    private static final Set UNICODE_CHARSET = new HashSet();
    private static final Set UCS4_CHARSET = new HashSet();
    private static final int SHORT_PATTERN_LEN = 20;
    private static final int BINARY_CHARSET_BASEID = 8192;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int NO_COMPOSITION = 0;
    public static final int CANONICAL_COMPOSITION = 1;
    public static final int EQUAL = 0;
    public static final int LESS = -1;
    public static final int GREATER = 1;
    private OraLinguistic tables;
    private int strength = 2;
    private int compLevel = 0;
    private String name;
    private String charSet = "UTF16";
    private int localeType = 1;
    private Locale locale = null;
    private UnicodeMapChar baseLetterTable;
    private UnicodeMapChar caseFoldingTable;
    private OraCollationElementIterator sourceCursor;
    private OraCollationElementIterator targetCursor;
    private StringBuffer primResult = null;
    private StringBuffer secResult = null;
    private StringBuffer terResult = null;
    private boolean subComp = false;
    private boolean isSubstring = false;
    private int matchedLength = 0;
    private char[] sourceArray = null;
    private char[] targetArray = null;
    int sourceIndex = 0;
    int targetIndex = 0;
    int sourceArrayPoint = 0;
    int targetArrayPoint = 0;

    protected OraCollator() {
    }

    public static OraCollator getInstance() {
        Locale locale = Locale.getDefault();
        return OraCollator.getInstance(locale);
    }

    public static OraCollator getInstance(Locale locale) {
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
        return OraCollator.getInstance(oraLocaleInfo);
    }

    public static OraCollator getInstance(OraLocaleInfo oraLocaleInfo) {
        return oraLocaleInfo.getOraCollator();
    }

    public static OraCollator getInstance(String string) {
        OraCollator oraCollator = new OraCollator();
        int n = 2;
        oraCollator.name = string = string.toUpperCase(Locale.US);
        if (string.endsWith("_AI")) {
            string = string.substring(0, string.length() - 3);
            n = 0;
        } else if (string.endsWith("_CI")) {
            string = string.substring(0, string.length() - 3);
            n = 1;
        }
        if (string.equals("BINARY") || string.equals("UNICODE_BINARY")) {
            oraCollator.localeType = 3;
            oraCollator.tables = null;
            oraCollator.setStrength(n);
            if (string.equals("UNICODE_BINARY")) {
                oraCollator.charSet = "AL32UTF8";
            }
        } else {
            OraBoot oraBoot = OraBoot.getInstance();
            if (oraBoot.getLinguisticFileName(string) == null) {
                throw new IllegalArgumentException(GDKMessage.getMessage(3001));
            }
            if (string.equals("JAPANESE")) {
                throw new IllegalArgumentException(GDKMessage.getMessage(3002));
            }
            OraLinguistic oraLinguistic = OraLinguistic.getInstance(string);
            if (oraLinguistic == null) {
                throw new IllegalArgumentException(GDKMessage.getMessage(3003));
            }
            oraCollator.tables = oraLinguistic;
            oraCollator.localeType = oraLinguistic.isMono() ? 0 : 1;
            if (oraLinguistic.isCanonicalEq()) {
                oraCollator.setComposition(1);
            }
            oraCollator.setStrength(n);
        }
        return oraCollator;
    }

    public static OraCollator getInstance(String string, String string2) {
        Object object;
        OraCollator oraCollator;
        block12: {
            block14: {
                block13: {
                    int n;
                    if ((string = string.toUpperCase(Locale.US)).startsWith("BINARY") && string2 != null) break block12;
                    oraCollator = OraCollator.getInstance(string);
                    if (oraCollator.localeType != 0 || string2 == null) {
                        return oraCollator;
                    }
                    OraBoot oraBoot = OraBoot.getInstance();
                    object = oraBoot.getCharSetId(string2.toUpperCase(Locale.US));
                    int n2 = n = object == null ? -1 : Integer.parseInt((String)object);
                    if (n == -1) {
                        return oraCollator;
                    }
                    CharacterConverter characterConverter = CharacterConverterOGS.getInstance((n += 8192) - 8192);
                    if (characterConverter == null) break block13;
                    if (characterConverter.getGroupId() >= 1) break block14;
                }
                return oraCollator;
            }
            string = "BINARY";
        }
        oraCollator = new OraCollator();
        int n = 2;
        oraCollator.name = string;
        if (string.endsWith("_AI")) {
            string = string.substring(0, string.length() - 3);
            n = 0;
        } else if (string.endsWith("_CI")) {
            string = string.substring(0, string.length() - 3);
            n = 1;
        }
        if (!string.equals("BINARY")) {
            throw new IllegalArgumentException(GDKMessage.getMessage(3001));
        }
        if (UNICODE_CHARSET.contains(string2 = string2.toUpperCase(Locale.US))) {
            oraCollator.localeType = 3;
            oraCollator.tables = null;
            oraCollator.setStrength(n);
        } else {
            object = OraLinguistic.getInstance(string + "_" + string2);
            if (object == null) {
                System.out.println("empty table" + string2);
            }
            oraCollator.tables = object;
            oraCollator.localeType = 2;
            oraCollator.setStrength(n);
        }
        oraCollator.charSet = string2;
        return oraCollator;
    }

    public static OraCollator getInstance(Locale locale, String string, String string2) {
        OraCollator oraCollator = OraCollator.getInstance(string, string2);
        oraCollator.locale = locale;
        return oraCollator;
    }

    public String getName() {
        return this.name;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException(GDKMessage.getMessage(3006));
        }
        this.strength = n;
    }

    public int getStrength() {
        return this.strength;
    }

    public synchronized void setComposition(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(GDKMessage.getMessage(3007));
        }
        this.compLevel = n;
    }

    public synchronized int getComposition() {
        return this.compLevel;
    }

    public Object clone() {
        OraCollator oraCollator = new OraCollator();
        oraCollator.tables = this.tables;
        oraCollator.strength = this.strength;
        oraCollator.compLevel = this.compLevel;
        oraCollator.name = this.name;
        oraCollator.charSet = this.charSet;
        oraCollator.localeType = this.localeType;
        oraCollator.locale = this.locale;
        return oraCollator;
    }

    public int hashCode() {
        return (this.tables != null ? this.tables.getId() * 10 : 0) + this.strength * 3 + this.compLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OraCollator)) {
            return false;
        }
        OraCollator oraCollator = (OraCollator)object;
        return this.tables == oraCollator.tables && this.strength == oraCollator.strength && this.compLevel == oraCollator.compLevel;
    }

    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public int compare(String string, String string2) {
        if (this.localeType == 0) {
            return this.compareMONO(string, string2);
        }
        if (this.localeType == 3) {
            return this.compareUNICODE(string, string2);
        }
        if (this.localeType == 2) {
            return this.compareBINARY(string, string2);
        }
        int n = this.getFirstUnmatchedChar(string, string2);
        if (n > 0) {
            boolean bl;
            boolean bl2 = n == string.length();
            boolean bl3 = bl = n == string2.length();
            if (bl2) {
                if (bl) {
                    return 0;
                }
                return -1;
            }
            if (bl) {
                if (this.subComp) {
                    this.isSubstring = true;
                    this.matchedLength = n;
                }
                return 1;
            }
            string = string.substring(n);
            string2 = string2.substring(n);
        }
        return this.compareMULTI(string, string2);
    }

    public OraCollationKey getCollationKey(String string) {
        boolean bl;
        int n = this.getStrength();
        String string2 = new String(string);
        if (this.localeType != 1) {
            if (n == 0) {
                string2 = this.convertToBaseLetter(string);
            } else if (n == 1) {
                string2 = this.convertToCaseFold(string);
            }
            n = 2;
        }
        if (this.tables == null) {
            if (UCS4_CHARSET.contains(this.charSet)) {
                return new OraCollationKey(string, this.ucs4getKey(string2));
            }
            return new OraCollationKey(string, string2);
        }
        if (this.primResult == null) {
            this.primResult = new StringBuffer();
            this.secResult = new StringBuffer();
            this.terResult = new StringBuffer();
        } else {
            this.primResult.setLength(0);
            this.secResult.setLength(0);
            this.terResult.setLength(0);
        }
        int n2 = 0;
        int[] nArray = new int[3];
        nArray[0] = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl2 = n >= 1;
        boolean bl3 = bl = n >= 2;
        if (this.sourceCursor == null) {
            this.sourceCursor = new OraCollationElementIterator(string2, this);
        } else {
            this.sourceCursor.setText(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.sourceCursor.next(nArray, false)) != -1) {
            int n6 = nArray[0];
            nArray[0] = 0;
            n3 = OraCollationElementIterator.primaryOrder(n2);
            n4 = OraCollationElementIterator.secondaryOrder(n2);
            n5 = OraCollationElementIterator.tertiaryOrder(n2);
            if (n6 == 0) {
                if (n3 != 0) {
                    if (this.tables.isReverseSort() && stringBuffer.length() > 0) {
                        this.secResult.insert(0, stringBuffer);
                        stringBuffer.setLength(0);
                    }
                    this.primResult.append((char)n3);
                    if (bl2 && (n4 != 0 || n3 == 1)) {
                        if (this.tables.isReverseSort()) {
                            stringBuffer.append((char)n4);
                        } else {
                            this.secResult.append((char)n4);
                        }
                    }
                    if (!bl || n5 == 0 && n3 != 1) continue;
                    this.terResult.append((char)n5);
                    continue;
                }
                if (bl2 && n4 != 0) {
                    if (this.tables.isReverseSort()) {
                        stringBuffer.append((char)n4);
                    } else {
                        this.secResult.append((char)n4);
                    }
                }
                if (this.localeType == 0) {
                    this.terResult.append((char)n5);
                    if (!this.subComp) continue;
                    this.primResult.append('\u0000');
                    continue;
                }
                if (!bl || n5 == 0) continue;
                this.terResult.append((char)n5);
                continue;
            }
            this.primResult.setLength(this.primResult.length() - n6);
            if (bl2) {
                if (this.tables.isReverseSort()) {
                    stringBuffer.setLength(0);
                } else {
                    this.secResult.setLength(this.secResult.length() - nArray[1]);
                }
            }
            if (!bl) continue;
            this.terResult.setLength(this.terResult.length() - nArray[2]);
        }
        if (this.tables.isReverseSort() && stringBuffer.length() > 0) {
            this.secResult.insert(0, stringBuffer);
        }
        String string3 = null;
        int n7 = 0;
        int n8 = 0;
        if (this.localeType != 0) {
            this.primResult.append('\u0000');
            this.secResult.append('\u0000');
            if (bl2) {
                n7 = this.primResult.length() << 1;
            }
            if (bl) {
                n8 = n7 + this.secResult.length();
            }
        } else {
            this.primResult.append('\u0000');
            n7 = this.primResult.length();
            this.terResult.append('\u0000');
            this.primResult.append(this.terResult.toString());
            string3 = this.compressKey(this.primResult);
            OraCollationKey oraCollationKey = new OraCollationKey(string, string3);
            oraCollationKey.secIdx = n7;
            oraCollationKey.terIdx = n8;
            return oraCollationKey;
        }
        this.secResult.append(this.terResult.toString());
        string3 = this.compressKey(this.secResult);
        this.primResult.append(string3);
        OraCollationKey oraCollationKey = new OraCollationKey(string, this.primResult.toString());
        oraCollationKey.secIdx = n7;
        oraCollationKey.terIdx = n8;
        return oraCollationKey;
    }

    private String compressKey(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = n / 2;
        char[] cArray = new char[n2 * 2 < n ? n2 + 1 : n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)((stringBuffer.charAt(2 * i) << 8) + stringBuffer.charAt(2 * i + 1));
        }
        if (n2 * 2 < n) {
            cArray[n2] = (char)(stringBuffer.charAt(n - 1) << 8);
        }
        return new String(cArray);
    }

    public String convertToBaseLetter(String string) {
        if (this.baseLetterTable == null) {
            if (this.tables == null || !this.tables.hasBaseLetterTable()) {
                OraMapTable oraMapTable = OraMapTable.getInstance((int)16);
                this.baseLetterTable = oraMapTable.getUnicodeMap("BINARY_BASE_LETTER");
            } else {
                this.baseLetterTable = this.tables.getBaseLetterTable();
            }
        }
        return this.baseLetterTable.getMapping(string);
    }

    public String convertToCaseFold(String string) {
        if (this.caseFoldingTable == null) {
            OraMapTable oraMapTable = OraMapTable.getInstance((int)17);
            this.caseFoldingTable = oraMapTable.getUnicodeMap("CASE_FOLD_TAB");
        }
        return this.caseFoldingTable.getMapping(string);
    }

    private int ucs4Compare(String string, String string2) {
        char c = '\u0000';
        char c2 = '\u0000';
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 != n && n4 != n2) {
            c = string.charAt(n3++);
            c2 = string2.charAt(n4++);
            if (this.isSurrogateLead(c) || this.isSurrogateLead(c2)) {
                char c3 = '\u0000';
                char c4 = '\u0000';
                if (n3 < n) {
                    c3 = string.charAt(n3);
                }
                if (n4 < n2) {
                    c4 = string2.charAt(n4);
                }
                if (this.isSurrogateLead(c) && this.isSurrogateFollow(c3)) {
                    if (this.isSurrogateLead(c2) && this.isSurrogateFollow(c4)) {
                        if (c == c2 && c3 == c4) {
                            ++n3;
                            ++n4;
                            continue;
                        }
                        if (c == c2) {
                            return c3 - c4;
                        }
                        return c - c2;
                    }
                    return 1;
                }
                if (this.isSurrogateLead(c2) && this.isSurrogateFollow(c4)) {
                    return -1;
                }
                if (c == c2) continue;
                return c - c2;
            }
            if (c == c2) continue;
            return c - c2;
        }
        if (n4 == n2) {
            this.isSubstring = true;
            this.matchedLength = n3;
        }
        return n - n2;
    }

    private String ucs4getKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (!this.isSurrogateLead(c2) || i == string.length() - 1) {
                stringBuffer.append('\u0000');
                stringBuffer.append(c2);
                continue;
            }
            if (this.isSurrogateFollow(c = string.charAt(++i))) {
                stringBuffer.append(c2);
                stringBuffer.append(c);
                continue;
            }
            --i;
            stringBuffer.append('\u0000');
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private boolean isSurrogateLead(int n) {
        return n >= 55296 && n <= 56319;
    }

    private boolean isSurrogateFollow(int n) {
        return n >= 56320 && n <= 57343;
    }

    OraLinguistic getTables() {
        return this.tables;
    }

    private int compareMONO(String string, String string2) {
        int n;
        boolean bl;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5;
        block64: {
            OraMapTable oraMapTable;
            boolean bl3;
            n5 = 0;
            int n6 = this.getFirstDiffChar(string, string2);
            boolean bl4 = n6 == string.length();
            boolean bl5 = bl3 = n6 == string2.length();
            if (bl4) {
                if (bl3) {
                    return n5;
                }
                return -1;
            }
            if (bl3) {
                if (this.subComp) {
                    this.isSubstring = true;
                    this.matchedLength = n6;
                }
                return 1;
            }
            if (n6 > 0) {
                string = string.substring(n6);
                string2 = string2.substring(n6);
            }
            boolean bl6 = false;
            UnicodeMapChar unicodeMapChar = null;
            if (this.strength == 0) {
                if (this.baseLetterTable == null) {
                    if (!this.tables.hasBaseLetterTable()) {
                        oraMapTable = OraMapTable.getInstance((int)16);
                        this.baseLetterTable = oraMapTable.getUnicodeMap("BINARY_BASE_LETTER");
                    } else {
                        this.baseLetterTable = this.tables.getBaseLetterTable();
                    }
                }
                bl6 = true;
                unicodeMapChar = this.baseLetterTable;
            } else if (this.strength == 1) {
                if (this.caseFoldingTable == null) {
                    oraMapTable = OraMapTable.getInstance((int)17);
                    this.caseFoldingTable = oraMapTable.getUnicodeMap("CASE_FOLD_TAB");
                }
                bl6 = true;
                unicodeMapChar = this.caseFoldingTable;
            }
            this.sourceIndex = 0;
            this.targetIndex = 0;
            char c = '\uffff';
            char c2 = '\uffff';
            n4 = string.length();
            n3 = string2.length();
            n2 = 0;
            bl2 = true;
            bl = true;
            n = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            while (true) {
                int n10;
                char c3;
                int[] nArray;
                if (bl6) {
                    if (bl2) {
                        if (this.sourceIndex == n4) break block64;
                        c = this.getNextConvertedChar(unicodeMapChar, string, true);
                        n = this.tables.getCollationItem(c);
                        bl7 = true;
                    } else {
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.targetIndex == n3) {
                            bl2 = false;
                            break block64;
                        }
                        c2 = this.getNextConvertedChar(unicodeMapChar, string2, false);
                        n7 = this.tables.getCollationItem(c2);
                        bl8 = true;
                    } else {
                        bl = true;
                    }
                } else {
                    if (bl2) {
                        if (this.sourceIndex == n4) break block64;
                        c = string.charAt(this.sourceIndex++);
                        n = this.tables.getCollationItem(c);
                        bl7 = true;
                    } else {
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.targetIndex == n3) {
                            bl2 = false;
                            break block64;
                        }
                        c2 = string2.charAt(this.targetIndex++);
                        n7 = this.tables.getCollationItem(c2);
                        bl8 = true;
                    } else {
                        bl = true;
                    }
                }
                if (this.tables.isSimple(n) && this.tables.isSimple(n7)) {
                    if (n == n7) continue;
                    n8 = n >>> 16;
                    n9 = n7 >>> 16;
                    if (n8 == 0) {
                        if (n9 != 0) {
                            bl = false;
                        }
                        if (n2 != 0) continue;
                        n2 = (n & 0xFF) - (n7 & 0xFF);
                        continue;
                    }
                    if (n9 == 0) {
                        bl2 = false;
                        if (n2 != 0) continue;
                        n2 = (n & 0xFF) - (n7 & 0xFF);
                        continue;
                    }
                    if (n8 > n9) {
                        return 1;
                    }
                    if (n8 < n9) {
                        return -1;
                    }
                    if (n2 != 0) continue;
                    n2 = (n & 0xFF) - (n7 & 0xFF);
                    continue;
                }
                int n11 = n;
                int n12 = n7;
                if (!this.tables.isSimple(n11) && bl7) {
                    if (this.tables.isContracting(n11)) {
                        nArray = new int[]{n11};
                        c3 = bl6 ? this.getNextConvertedChar(unicodeMapChar, string, true) : (this.sourceIndex < n4 ? (char)string.charAt(this.sourceIndex++) : (char)'\uffff');
                        n10 = this.getContractingKey(nArray, c, c3);
                        if (n10 == 1 && c3 != '\uffff') {
                            --this.sourceIndex;
                        }
                        n11 = nArray[0];
                        if (nArray.length == 2) {
                            n = nArray[1];
                            bl2 = false;
                        }
                    } else if (this.tables.isExpanding(n11)) {
                        c3 = this.tables.getIndex(n11);
                        nArray = this.tables.getExpandExpCharKey(c3);
                        if (nArray.length == 2) {
                            n11 = nArray[0];
                            n = nArray[1];
                            bl2 = false;
                        }
                    } else if (this.tables.isZero(n11)) {
                        n11 = c >>> 8;
                        n = c & 0xFF;
                        bl7 = false;
                        bl2 = false;
                    }
                }
                if (!this.tables.isSimple(n12) && bl8) {
                    if (this.tables.isContracting(n12)) {
                        nArray = new int[]{n12};
                        c3 = bl6 ? (char)this.getNextConvertedChar(unicodeMapChar, string2, false) : (this.targetIndex < n3 ? string2.charAt(this.targetIndex++) : (char)'\uffff');
                        n10 = this.getContractingKey(nArray, c2, c3);
                        if (n10 == 1 && c3 != '\uffff') {
                            --this.targetIndex;
                        }
                        n12 = nArray[0];
                        if (nArray.length == 2) {
                            n7 = nArray[1];
                            bl = false;
                        }
                    } else if (this.tables.isExpanding(n12)) {
                        c3 = this.tables.getIndex(n12);
                        nArray = this.tables.getExpandExpCharKey(c3);
                        if (nArray.length == 2) {
                            n12 = nArray[0];
                            n7 = nArray[1];
                            bl = false;
                        }
                    } else if (this.tables.isZero(n12)) {
                        n12 = c2 >>> 8;
                        n7 = c2 & 0xFF;
                        bl8 = false;
                        bl = false;
                    }
                }
                if (n11 == n12) continue;
                n8 = n11 >>> 16;
                n9 = n12 >>> 16;
                if (n8 == n9) {
                    if (n2 != 0) continue;
                    n2 = (n11 & 0xFF) - (n12 & 0xFF);
                    continue;
                }
                if (n8 == 0) {
                    if (n9 != 0) {
                        bl = false;
                    }
                    if (n2 != 0) continue;
                    n2 = (n11 & 0xFF) - (n12 & 0xFF);
                    continue;
                }
                if (n9 == 0) {
                    bl2 = false;
                    if (n2 != 0) continue;
                    n2 = (n11 & 0xFF) - (n12 & 0xFF);
                    continue;
                }
                if (n8 > n9) {
                    return 1;
                }
                if (n8 < n9) break;
            }
            return -1;
        }
        if (!bl2 && n >>> 16 > 0) {
            if (this.subComp) {
                this.isSubstring = true;
                this.matchedLength = this.sourceIndex - 1;
            }
            return 1;
        }
        if (this.sourceIndex == n4) {
            if (this.targetIndex == n3 && bl) {
                if (n2 > 0) {
                    n5 = 1;
                } else if (n2 < 0) {
                    n5 = -1;
                }
            } else {
                n5 = -1;
            }
        } else {
            if (this.subComp && n2 == 0) {
                this.isSubstring = true;
                this.matchedLength = this.sourceIndex - 1;
            }
            n5 = 1;
        }
        return n5;
    }

    private int compareBINARY(String string, String string2) {
        OraMapTable oraMapTable;
        boolean bl;
        int n = 0;
        int n2 = this.getFirstDiffChar(string, string2);
        boolean bl2 = n2 == string.length();
        boolean bl3 = bl = n2 == string2.length();
        if (bl2) {
            if (bl) {
                this.isSubstring = true;
                this.matchedLength = n2;
                return n;
            }
            return -1;
        }
        if (bl) {
            this.isSubstring = true;
            this.matchedLength = n2;
            return 1;
        }
        if (n2 > 0) {
            string = string.substring(n2);
            string2 = string2.substring(n2);
        }
        boolean bl4 = false;
        UnicodeMapChar unicodeMapChar = null;
        if (this.strength == 0) {
            if (this.baseLetterTable == null) {
                oraMapTable = OraMapTable.getInstance((int)16);
                this.baseLetterTable = oraMapTable.getUnicodeMap("BINARY_BASE_LETTER");
            }
            bl4 = true;
            unicodeMapChar = this.baseLetterTable;
        } else if (this.strength == 1) {
            if (this.caseFoldingTable == null) {
                oraMapTable = OraMapTable.getInstance((int)17);
                this.caseFoldingTable = oraMapTable.getUnicodeMap("CASE_FOLD_TAB");
            }
            bl4 = true;
            unicodeMapChar = this.caseFoldingTable;
        }
        this.sourceIndex = 0;
        this.targetIndex = 0;
        char c = '\uffff';
        char c2 = '\uffff';
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        int n6 = 0;
        boolean bl5 = true;
        boolean bl6 = true;
        while (!(this.sourceIndex >= n3 && bl5 || this.targetIndex >= n4 && bl6)) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if (bl4) {
                if (bl5) {
                    c = this.getNextConvertedChar(unicodeMapChar, string, true);
                    n5 = this.tables.getCollationItem(c);
                } else {
                    bl5 = true;
                }
                if (bl6) {
                    c2 = this.getNextConvertedChar(unicodeMapChar, string2, false);
                    n6 = this.tables.getCollationItem(c2);
                } else {
                    bl6 = true;
                }
                if (c == '\uffff' || c2 == '\uffff') {
                    break;
                }
            } else {
                if (bl5) {
                    c = string.charAt(this.sourceIndex++);
                    n5 = this.tables.getCollationItem(c);
                } else {
                    bl5 = true;
                }
                if (bl6) {
                    c2 = string2.charAt(this.targetIndex++);
                    n6 = this.tables.getCollationItem(c2);
                } else {
                    bl6 = true;
                }
            }
            if (this.tables.isSimple(n5) && this.tables.isSimple(n6)) {
                if (n5 == n6) continue;
                if (n5 >>> 16 > n6 >>> 16) {
                    return 1;
                }
                return -1;
            }
            int n12 = n5;
            int n13 = n6;
            if (this.tables.isZero(n12)) {
                if (c == '\u0000') {
                    n12 = 1;
                } else {
                    n12 = -65536;
                    n5 = c << 16;
                    bl5 = false;
                }
            } else if (this.tables.isSurrogate(n12)) {
                n11 = bl4 ? this.getNextConvertedChar(unicodeMapChar, string, true) : (this.sourceIndex < n3 ? (int)string.charAt(this.sourceIndex) : 65535);
                n10 = c & 0xFFFF;
                n9 = n11 & 0xFFFF;
                if (n9 > 57343 || n9 < 56320) {
                    n12 = -65536;
                    n5 = c << 16;
                    bl5 = false;
                    --this.sourceIndex;
                } else {
                    n8 = n10 - 55296 >> 6;
                    n7 = this.tables.getIndex(n5) + n9 - 56320;
                    n12 = this.tables.getSurrogateKey(n8, n7);
                    if (!this.tables.isSimple(n12)) {
                        n12 = -65536;
                        n5 = c << 16;
                        bl5 = false;
                        --this.sourceIndex;
                    }
                }
            }
            if (this.tables.isZero(n13)) {
                if (c2 == '\u0000') {
                    n13 = 1;
                } else {
                    n13 = -65536;
                    n6 = c2 << 16;
                    bl6 = false;
                }
            } else if (this.tables.isSurrogate(n12)) {
                n11 = bl4 ? (int)this.getNextConvertedChar(unicodeMapChar, string2, false) : (this.targetIndex < n4 ? (int)string2.charAt(this.targetIndex) : 65535);
                n10 = c2 & 0xFFFF;
                n9 = n11 & 0xFFFF;
                if (n9 > 57343 || n9 < 56064) {
                    n13 = -65536;
                    n6 = c2 << 16;
                    bl6 = false;
                    --this.targetIndex;
                } else {
                    n8 = n10 - 55296 >> 6;
                    n7 = this.tables.getIndex(n6) + n9 - 56320;
                    n13 = this.tables.getSurrogateKey(n8, n7);
                    if (!this.tables.isSimple(n13)) {
                        n13 = -65536;
                        n6 = c2 << 16;
                        bl6 = false;
                        --this.targetIndex;
                    }
                }
            }
            if (n12 == n13) continue;
            if (((long)n12 & 0xFFFFFFFFL) > ((long)n13 & 0xFFFFFFFFL)) {
                return 1;
            }
            return -1;
        }
        if (this.sourceIndex == n3) {
            if (this.targetIndex == n4) {
                return 0;
            }
            n = -1;
        } else {
            this.isSubstring = true;
            this.matchedLength = n4;
            n = 1;
        }
        return n;
    }

    private int compareUNICODE(String string, String string2) {
        OraMapTable oraMapTable;
        boolean bl;
        int n = 0;
        boolean bl2 = false;
        if (UCS4_CHARSET.contains(this.charSet)) {
            bl2 = true;
        }
        if (this.strength == 2) {
            n = bl2 ? this.ucs4Compare(string, string2) : string.compareTo(string2);
            if (n == 0) {
                this.matchedLength = string2.length();
                return 0;
            }
            if (n > 0) {
                if (this.subComp && string.length() > string2.length() && (n = (string = string.substring(0, string2.length())).compareTo(string2)) == 0) {
                    this.isSubstring = true;
                    this.matchedLength = string2.length();
                }
                return 1;
            }
            return -1;
        }
        int n2 = this.getFirstDiffChar(string, string2);
        boolean bl3 = n2 == string.length();
        boolean bl4 = bl = n2 == string2.length();
        if (bl3) {
            if (bl) {
                this.matchedLength = n2;
                return n;
            }
            return -1;
        }
        if (bl) {
            if (this.subComp) {
                this.isSubstring = true;
                this.matchedLength = n2;
            }
            return 1;
        }
        if (n2 > 0) {
            string = string.substring(n2);
            string2 = string2.substring(n2);
        }
        UnicodeMapChar unicodeMapChar = null;
        if (this.strength == 0) {
            if (this.baseLetterTable == null) {
                oraMapTable = OraMapTable.getInstance((int)16);
                this.baseLetterTable = oraMapTable.getUnicodeMap("BINARY_BASE_LETTER");
            }
            unicodeMapChar = this.baseLetterTable;
        } else if (this.strength == 1) {
            if (this.caseFoldingTable == null) {
                oraMapTable = OraMapTable.getInstance((int)17);
                this.caseFoldingTable = oraMapTable.getUnicodeMap("CASE_FOLD_TAB");
            }
            unicodeMapChar = this.caseFoldingTable;
        }
        this.sourceIndex = 0;
        this.targetIndex = 0;
        int n3 = 65535;
        int n4 = 65535;
        int n5 = string.length();
        int n6 = string2.length();
        while (this.sourceIndex < n5 && this.targetIndex < n6) {
            n3 = this.getNextConvertedChar(unicodeMapChar, string, true);
            n4 = this.getNextConvertedChar(unicodeMapChar, string2, false);
            if (n3 == 65535 || n4 == 65535) break;
            if (bl2 && (this.isSurrogateLead(n3) || this.isSurrogateLead(n4))) {
                char c = this.getNextConvertedChar(unicodeMapChar, string, true);
                char c2 = this.getNextConvertedChar(unicodeMapChar, string2, false);
                if (this.isSurrogateLead(n3) && this.isSurrogateFollow(c)) {
                    if (this.isSurrogateLead(n4) && this.isSurrogateFollow(c2)) {
                        if (n3 == n4 && c == c2) continue;
                        if (n3 == n4) {
                            n = c - c2;
                            break;
                        }
                        n = n3 - n4;
                        break;
                    }
                    return 1;
                }
                if (this.isSurrogateLead(n4) && this.isSurrogateFollow(c2)) {
                    return -1;
                }
                if (n3 == n4) {
                    if (c == c2) continue;
                    if (c == '\uffff') {
                        return -1;
                    }
                    if (c2 == '\uffff') {
                        return 1;
                    }
                    n = c - c2;
                    break;
                }
                n = n3 - n4;
                break;
            }
            if (n3 == n4) continue;
            if (n3 > n4) {
                return 1;
            }
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        if (this.sourceIndex == n5) {
            if (this.targetIndex == n6) {
                this.matchedLength = this.sourceIndex + n2;
                return 0;
            }
            n = -1;
        } else {
            if (this.subComp) {
                this.isSubstring = true;
                this.matchedLength = this.sourceIndex;
            }
            n = 1;
        }
        return n;
    }

    private int getFirstUnmatchedChar(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3;
        if (n4 > (n = string2.length())) {
            n4 = n;
        }
        while (n2 < n4 && string.charAt(n2) == string2.charAt(n2)) {
            ++n2;
        }
        if (n2 == 0 || n2 == n3 && n2 == n) {
            this.matchedLength = n2;
            return n2;
        }
        if (this.tables.hasContractingTable()) {
            n2 = n2 > 5 ? n2 - 5 : 0;
            return n2;
        }
        char c = '\u0000';
        char c2 = '\u0000';
        int n5 = 0;
        int n6 = 0;
        if (n2 < n3) {
            c = string.charAt(n2);
            n5 = this.tables.getCollationItem(c);
        }
        if (n2 < n) {
            c2 = string2.charAt(n2);
            n6 = this.tables.getCollationItem(c2);
        }
        if (this.tables.isIgnorable(n5) || this.tables.isIgnorable(n6)) {
            n2 -= 3;
        } else if (this.tables.isContextSensitive(n5) || this.tables.isContextSensitive(n6)) {
            n2 -= 2;
        } else if (this.tables.isHangulJamo() && ((c & 0x1100) != 0 || (c2 & 0x1100) != 0)) {
            n2 -= 2;
        } else if (this.tables.isSurrogate(n5) || this.tables.isSurrogate(n6)) {
            --n2;
        } else if (this.tables.isSwapWithNext() && (this.tables.isSwapping(c) || this.tables.isSwapping(c2))) {
            --n2;
        } else {
            return n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private int getFirstDiffChar(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3;
        if (n4 > (n = string2.length())) {
            n4 = n;
        }
        while (n2 < n4 && string.charAt(n2) == string2.charAt(n2)) {
            ++n2;
        }
        if (n2 < n4 && n2 > 0) {
            --n2;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char getNextConvertedChar(UnicodeMapChar unicodeMapChar, String string, boolean bl) {
        char c = '\uffff';
        if (bl) {
            if (this.sourceArray == null) {
                if (this.sourceIndex >= string.length()) return c;
                c = string.charAt(this.sourceIndex);
                this.sourceArray = unicodeMapChar.getMapping(c);
                if (this.sourceArray == null) {
                    if (++this.sourceIndex >= string.length()) return c;
                    this.sourceArray = unicodeMapChar.getSurrogate(c, string.charAt(this.sourceIndex));
                    if (this.sourceArray == null) {
                        return c;
                    }
                }
            }
            c = this.sourceArray[this.sourceArrayPoint++];
            if (this.sourceArrayPoint != this.sourceArray.length) return c;
            this.sourceArrayPoint = 0;
            this.sourceArray = null;
            ++this.sourceIndex;
            return c;
        } else {
            if (this.targetArray == null) {
                if (this.targetIndex >= string.length()) return c;
                c = string.charAt(this.targetIndex);
                this.targetArray = unicodeMapChar.getMapping(c);
                if (this.targetArray == null) {
                    if (++this.targetIndex >= string.length()) return c;
                    this.targetArray = unicodeMapChar.getSurrogate(c, string.charAt(this.targetIndex));
                    if (this.targetArray == null) {
                        return c;
                    }
                }
            }
            c = this.targetArray[this.targetArrayPoint++];
            if (this.targetArrayPoint != this.targetArray.length) return c;
            this.targetArrayPoint = 0;
            this.targetArray = null;
            ++this.targetIndex;
        }
        return c;
    }

    private int getContractingKey(int[] nArray, char c, char c2) {
        int n = this.tables.getIndex(nArray[0]);
        while (true) {
            char[] cArray;
            if ((cArray = this.tables.getContractConChar(n)).length == 2 && cArray[1] == c2 && cArray[0] == c) {
                nArray[0] = this.tables.getContractCollKey(n);
                return 2;
            }
            if (cArray.length == 1) {
                nArray[0] = this.tables.getContractCollKey(n);
                return 1;
            }
            if (this.tables.getContractNumOfFE(n) == 0) break;
            ++n;
        }
        nArray = new int[]{c2 >>> 8, c2 & 0xFF};
        return 1;
    }

    private int compareMULTI(String string, String string2) {
        short s;
        short s2;
        char c;
        char c2;
        int n;
        boolean bl;
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            if (n3 == 0) {
                return 0;
            }
            return -1;
        }
        if (n3 == 0) {
            return 1;
        }
        int n4 = 0;
        int n5 = this.getStrength();
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = bl = n5 >= 1;
        boolean bl3 = n5 >= 2;
        int n8 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl;
        boolean bl7 = false;
        boolean bl8 = true;
        boolean bl9 = true;
        boolean bl10 = this.subComp;
        if (this.tables.hasLatin1() && string.charAt(0) <= '\u00ff' && string2.charAt(0) <= '\u00ff') {
            int n9 = 0;
            n = 0;
            c2 = '\u0000';
            c = '\u0000';
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[2];
            int[] nArray4 = new int[2];
            s2 = 1;
            s = 1;
            int n10 = 0;
            int n11 = 0;
            boolean bl11 = false;
            while (true) {
                short s3;
                short s4;
                short s5;
                short s6;
                int n12;
                if (bl8 && s2 != 0) {
                    if (n9 >= n2) {
                        if (!bl9 || s == 0) {
                            if (bl9) {
                                n7 = 0;
                            }
                            if (s == 0) {
                                n7 |= nArray2[1];
                            }
                            if (n7 >>> 16 != 0) {
                                return -1;
                            }
                            if (bl2 && OraCollationElementIterator.secondaryOrder(n7) != 0) {
                                return -1;
                            }
                            if (bl3 && OraCollationElementIterator.tertiaryOrder(n7) != 0) {
                                return -1;
                            }
                        }
                        if (n >= n3) {
                            if (bl5) {
                                n4 = n8;
                            }
                            if (this.subComp & n4 == 0) {
                                this.isSubstring = true;
                                this.matchedLength = n9;
                            }
                            return n4;
                        }
                        n9 = n2;
                        break;
                    }
                    c2 = string.charAt(n9);
                    if (c2 <= '\u00ff') {
                        nArray3 = this.tables.getLatin1Keys(c2);
                    }
                    if (c2 > '\u00ff' || this.tables.isContracting(nArray3[0])) {
                        int n13;
                        if (n9 == 0 || !this.tables.isIgnorable(n13 = this.tables.getCollationItem(c2)) && bl9 && s != 0) break;
                        --n9;
                        --n;
                        if (nArray[0] >> 16 != 0) {
                            ++n10;
                        }
                        if (nArray[1] >> 16 != 0) {
                            ++n10;
                        }
                        if (!bl9) {
                            if (s != 0 && nArray2[1] >> 16 != 0) {
                                ++n11;
                            }
                            bl9 = true;
                        } else if (s == 0) {
                            if (nArray2[0] >> 16 != 0) {
                                ++n11;
                            }
                        } else {
                            if (nArray2[0] >> 16 != 0) {
                                ++n11;
                            }
                            if (nArray2[1] >> 16 != 0) {
                                ++n11;
                            }
                        }
                        if (n10 == n11) break;
                        bl11 = true;
                        break;
                    }
                }
                if (bl9) {
                    if (s != 0) {
                        if (n >= n3) {
                            if (bl8 && s2 != 0) break;
                            if (bl8) {
                                n6 = 0;
                            }
                            if (s2 == 0) {
                                n6 |= nArray[1];
                            }
                            if (bl10 && n8 == 0) {
                                this.isSubstring = true;
                                this.matchedLength = n9;
                            }
                            if (n6 >>> 16 != 0) {
                                return 1;
                            }
                            if (bl2 && OraCollationElementIterator.secondaryOrder(n6) != 0) {
                                return 1;
                            }
                            if (bl3 && OraCollationElementIterator.tertiaryOrder(n6) != 0) {
                                return 1;
                            }
                            if (n9 >= n2) {
                                if (bl5) {
                                    n4 = n8;
                                }
                                if (this.subComp & n4 == 0) {
                                    this.isSubstring = true;
                                    this.matchedLength = n9;
                                }
                                return n4;
                            }
                            n = n3;
                            break;
                        }
                        c = string2.charAt(n);
                        if (c <= '\u00ff') {
                            nArray4 = this.tables.getLatin1Keys(c);
                        }
                        if (c > '\u00ff' || this.tables.isContracting(nArray4[0])) {
                            int n14;
                            if (n == 0 || !this.tables.isIgnorable(n14 = this.tables.getCollationItem(c)) && bl8 && s2 != 0) break;
                            --n;
                            --n9;
                            if (nArray2[0] >> 16 != 0) {
                                ++n11;
                            }
                            if (nArray2[1] >> 16 != 0) {
                                ++n11;
                            }
                            if (!bl8) {
                                if (s2 != 0 && nArray[1] >> 16 != 0) {
                                    ++n10;
                                }
                                bl8 = true;
                            } else if (s2 == 0) {
                                if (nArray[0] >> 16 != 0) {
                                    ++n10;
                                }
                            } else {
                                if (nArray[0] >> 16 != 0) {
                                    ++n10;
                                }
                                if (nArray[1] >> 16 != 0) {
                                    ++n10;
                                }
                            }
                            if (n10 == n11) break;
                            bl11 = true;
                            break;
                        }
                        nArray2 = nArray4;
                        n7 = nArray2[0];
                        if (nArray2[1] != 0) {
                            s = 0;
                        }
                        ++n;
                    } else {
                        n7 = nArray2[1];
                        s = 1;
                    }
                } else {
                    bl9 = true;
                }
                if (!bl8) {
                    bl8 = true;
                } else if (s2 == 0) {
                    n6 = nArray[1];
                    s2 = 1;
                } else {
                    nArray = nArray3;
                    ++n9;
                    n6 = nArray[0];
                    if (nArray[1] != 0) {
                        s2 = 0;
                    }
                }
                int c3 = OraCollationElementIterator.primaryOrder(n6);
                if (n6 == n7) {
                    if (!this.tables.isReverseSort() || c3 == 0 || bl2) continue;
                    bl6 = bl2 = bl;
                    continue;
                }
                if (this.tables.isPuncuation(n6) || this.tables.isPuncuation(n7)) {
                    if (bl3 && bl2 && (n12 = OraCollationElementIterator.tertiaryOrder(n6)) != (s6 = OraCollationElementIterator.tertiaryOrder(n7))) {
                        bl3 = false;
                        n4 = n12 < s6 ? -1 : 1;
                    }
                    bl9 = false;
                    bl8 = false;
                    if (this.tables.isPuncuation(n6)) {
                        bl8 = true;
                    }
                    if (!this.tables.isPuncuation(n7)) continue;
                    bl9 = true;
                    continue;
                }
                if (!(this.tables.isIgnorable(n6) && this.tables.isIgnorable(n7) || !bl5)) {
                    bl7 = true;
                    n4 = n8;
                    bl2 = false;
                    bl5 = false;
                    n8 = 0;
                }
                if (c3 != (n12 = OraCollationElementIterator.primaryOrder(n7))) {
                    if (c3 == 0) {
                        bl7 = true;
                        if (bl2) {
                            n4 = 1;
                            bl2 = false;
                        }
                        bl9 = false;
                        continue;
                    }
                    if (n12 == 0) {
                        bl7 = true;
                        if (bl2) {
                            n4 = -1;
                            bl2 = false;
                        }
                        bl8 = false;
                        continue;
                    }
                    if (c3 < n12) {
                        return -1;
                    }
                    return 1;
                }
                if (this.tables.isReverseSort() && c3 != 0 && !bl2) {
                    bl6 = bl2 = bl;
                }
                if (!bl2) continue;
                s6 = OraCollationElementIterator.secondaryOrder(n6);
                if (s6 != (s5 = OraCollationElementIterator.secondaryOrder(n7))) {
                    if (!bl6) continue;
                    n8 = s6 < s5 ? -1 : 1;
                    bl5 = true;
                    bl6 = false;
                    continue;
                }
                if (!bl3 || (s4 = OraCollationElementIterator.tertiaryOrder(n6)) == (s3 = OraCollationElementIterator.tertiaryOrder(n7))) continue;
                n4 = s4 < s3 ? -1 : 1;
                bl3 = false;
            }
            if (bl11) {
                do {
                    char c3;
                    int[] nArray5;
                    if (n10 < n11) {
                        if (n9 <= 0) break;
                        if ((nArray5 = this.tables.getLatin1Keys(c3 = string.charAt(--n9)))[0] >> 16 != 0) {
                            ++n10;
                        }
                        if (nArray5[1] >> 16 == 0) continue;
                        ++n10;
                        continue;
                    }
                    if (n <= 0) break;
                    if ((nArray5 = this.tables.getLatin1Keys(c3 = string2.charAt(--n)))[0] >> 16 != 0) {
                        ++n11;
                    }
                    if (nArray5[1] >> 16 == 0) continue;
                    ++n11;
                } while (n10 != n11);
            }
            if (n9 == 0) {
                n = 0;
            } else if (n == 0) {
                n9 = 0;
            }
            string = string.substring(n9);
            string2 = string2.substring(n);
        }
        if (this.sourceCursor == null) {
            this.sourceCursor = new OraCollationElementIterator(string, this);
        } else {
            this.sourceCursor.setText(string);
        }
        if (this.targetCursor == null) {
            this.targetCursor = new OraCollationElementIterator(string2, this);
        } else {
            this.targetCursor.setText(string2);
        }
        int[] nArray = new int[3];
        nArray[0] = 0;
        n = 0;
        c2 = '\u0000';
        c = '\u0000';
        while (true) {
            short s7;
            int n13;
            if (bl8) {
                n6 = this.sourceCursor.next(nArray, false);
                n = nArray[0];
                if (nArray[0] > 0) {
                    c = '\u0001';
                    nArray[0] = 0;
                }
            } else {
                bl8 = true;
            }
            if (bl9) {
                n7 = this.targetCursor.next(nArray, false);
                c2 = nArray[0];
                if (nArray[0] > 0) {
                    c = '\u0001';
                    nArray[0] = 0;
                }
            } else {
                bl9 = true;
            }
            if (c != '\u0000') {
                if (n == 0) {
                    this.sourceCursor.moveback(n6);
                } else if (c2 == '\u0000') {
                    this.targetCursor.moveback(n7);
                }
                c = '\u0000';
                bl6 = bl2;
                bl5 = false;
                continue;
            }
            if (n6 == -1 || n7 == -1) break;
            int n14 = OraCollationElementIterator.primaryOrder(n6);
            if (n6 == n7) {
                if (!this.tables.isReverseSort() || n14 == 0 || bl2) continue;
                bl6 = bl2 = bl;
                continue;
            }
            if (this.tables.isPuncuation(n6) || this.tables.isPuncuation(n7)) {
                short s8;
                short s9;
                if (bl3 && bl2 && (s9 = OraCollationElementIterator.tertiaryOrder(n6)) != (s8 = OraCollationElementIterator.tertiaryOrder(n7))) {
                    bl3 = false;
                    n4 = s9 < s8 ? -1 : 1;
                }
                bl9 = false;
                bl8 = false;
                if (this.tables.isPuncuation(n6)) {
                    bl8 = true;
                }
                if (!this.tables.isPuncuation(n7)) continue;
                bl9 = true;
                continue;
            }
            if (!(this.tables.isIgnorable(n6) && this.tables.isIgnorable(n7) || !bl5)) {
                bl7 = true;
                n4 = n8;
                bl2 = false;
                bl5 = false;
                n8 = 0;
            }
            if (n14 != (n13 = OraCollationElementIterator.primaryOrder(n7))) {
                if (n14 == 0) {
                    bl7 = true;
                    if (bl2) {
                        n4 = 1;
                        bl2 = false;
                    }
                    bl9 = false;
                    continue;
                }
                if (n13 == 0) {
                    bl7 = true;
                    if (bl2) {
                        n4 = -1;
                        bl2 = false;
                    }
                    bl8 = false;
                    continue;
                }
                if (n14 < n13) {
                    return -1;
                }
                return 1;
            }
            if (this.tables.isReverseSort() && n14 != 0 && !bl2) {
                bl6 = bl2 = bl;
            }
            if (!bl2) continue;
            short s10 = OraCollationElementIterator.secondaryOrder(n6);
            if (s10 != (s7 = OraCollationElementIterator.secondaryOrder(n7))) {
                if (!bl6) continue;
                n8 = s10 < s7 ? -1 : 1;
                bl5 = true;
                bl6 = false;
                continue;
            }
            if (!bl3 || (s2 = OraCollationElementIterator.tertiaryOrder(n6)) == (s = OraCollationElementIterator.tertiaryOrder(n7))) continue;
            n4 = s2 < s ? -1 : 1;
            bl3 = false;
        }
        if (n6 != -1) {
            do {
                if (OraCollationElementIterator.primaryOrder(n6) != 0) {
                    if (n7 == -1 && this.subComp && n8 == 0 && n4 == 0) {
                        this.isSubstring = true;
                        this.matchedLength = this.sourceCursor.getCurPos() + 1;
                    }
                    return 1;
                }
                if (OraCollationElementIterator.secondaryOrder(n6) != 0) {
                    if (!bl2) continue;
                    n4 = 1;
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                if (OraCollationElementIterator.tertiaryOrder(n6) == 0 || !bl3) continue;
                n4 = 1;
                bl3 = false;
            } while ((n6 = this.sourceCursor.next(nArray, bl7)) != -1);
        } else if (n7 != -1) {
            do {
                if (OraCollationElementIterator.primaryOrder(n7) != 0) {
                    return -1;
                }
                if (OraCollationElementIterator.secondaryOrder(n7) != 0) {
                    if (!bl2) continue;
                    n4 = -1;
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                if (OraCollationElementIterator.tertiaryOrder(n7) == 0 || !bl3) continue;
                n4 = -1;
                bl3 = false;
            } while ((n7 = this.sourceCursor.next(nArray, bl7)) != -1);
        }
        if (bl5) {
            n4 = n8;
        }
        return n4;
    }

    public int[] matchFirst(String string, String string2) {
        int n = this.getStrength();
        String string3 = new String(string);
        int[] nArray = new int[3];
        nArray[2] = -1;
        nArray[1] = -1;
        nArray[0] = -1;
        if (string2.length() < 20 && this.localeType != 2 && this.localeType != 3 && !this.tables.isReverseSort()) {
            int n2 = 0;
            this.subComp = true;
            OraCollationKey oraCollationKey = this.getCollationKey(string2);
            byte[] byArray = oraCollationKey.toByteArray();
            int n3 = oraCollationKey.primIdx;
            int n4 = oraCollationKey.secIdx;
            int n5 = oraCollationKey.terIdx;
            int n6 = 0;
            while (0 < string.length()) {
                if (n6 != 0) {
                    string = string.substring(1);
                }
                this.isSubstring = false;
                n2 = this.localeType == 1 ? this.isMultiKeyMatch(string, byArray, oraCollationKey) : this.isMonoKeyMatch(string, byArray, oraCollationKey);
                if (n2 > 0) {
                    nArray[1] = n2 + n6;
                    nArray[0] = n6;
                    return nArray;
                }
                oraCollationKey.primIdx = n3;
                oraCollationKey.secIdx = n4;
                oraCollationKey.terIdx = n5;
                ++n6;
            }
            this.subComp = false;
        } else {
            int n7 = 0;
            int n8 = 0;
            while (0 < string.length()) {
                if (n8 != 0) {
                    string = string.substring(1);
                }
                this.subComp = true;
                this.isSubstring = false;
                n7 = this.compare(string, string2);
                if (n7 == 0 || this.isSubstring) {
                    nArray[1] = this.matchedLength + n8;
                    nArray[0] = n8;
                    this.subComp = false;
                    return nArray;
                }
                ++n8;
            }
        }
        this.subComp = false;
        return nArray;
    }

    public int[] matchLast(String string, String string2) {
        int n = this.getStrength();
        String string3 = new String(string);
        int n2 = string.length();
        int[] nArray = new int[3];
        nArray[2] = -1;
        nArray[1] = -1;
        nArray[0] = -1;
        this.subComp = true;
        if (string2.length() < 20 && this.localeType != 2 && this.localeType != 3 && !this.tables.isReverseSort()) {
            int n3 = 0;
            OraCollationKey oraCollationKey = this.getCollationKey(string2);
            byte[] byArray = oraCollationKey.toByteArray();
            int n4 = oraCollationKey.primIdx;
            int n5 = oraCollationKey.secIdx;
            int n6 = oraCollationKey.terIdx;
            for (int i = n2 - 1; i >= 0; --i) {
                string3 = string.substring(i, n2);
                n3 = this.localeType == 1 ? this.isMultiKeyMatch(string3, byArray, oraCollationKey) : this.isMonoKeyMatch(string3, byArray, oraCollationKey);
                if (n3 > 0) {
                    nArray[1] = n3 + i;
                    nArray[0] = i;
                    return nArray;
                }
                oraCollationKey.primIdx = n4;
                oraCollationKey.secIdx = n5;
                oraCollationKey.terIdx = n6;
            }
        } else {
            int n7 = 0;
            for (int i = n2 - 1; i >= 0; --i) {
                string3 = string.substring(i, n2);
                this.subComp = true;
                this.isSubstring = false;
                n7 = this.compare(string3, string2);
                if (n7 != 0 && !this.isSubstring) continue;
                nArray[1] = this.matchedLength + i;
                nArray[0] = i;
                this.subComp = false;
                return nArray;
            }
        }
        this.subComp = false;
        return nArray;
    }

    private int isMultiKeyMatch(String string, byte[] byArray, OraCollationKey oraCollationKey) {
        int n;
        int[] nArray;
        int[] nArray2;
        int n2;
        boolean bl;
        boolean bl2;
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n4;
        int n5;
        block41: {
            boolean bl6 = false;
            int n6 = string.length();
            int n7 = oraCollationKey.getSourceString().length();
            if (n6 == 0) {
                return 0;
            }
            if (n7 == 0) {
                return 1;
            }
            int n8 = this.getStrength();
            n5 = 0;
            n4 = 0;
            bl4 = bl5 = n8 >= 1;
            bl3 = n8 >= 2;
            n3 = 0;
            boolean bl7 = false;
            bl2 = false;
            boolean bl8 = bl5;
            bl = false;
            boolean bl9 = true;
            boolean bl10 = true;
            boolean bl11 = this.subComp;
            n2 = string.length();
            Object var22_22 = null;
            this.matchedLength = 0;
            if (this.sourceCursor == null) {
                this.sourceCursor = new OraCollationElementIterator(string, this);
            } else {
                this.sourceCursor.setText(string);
            }
            nArray2 = new int[3];
            nArray2[0] = 0;
            int n9 = 0;
            boolean bl12 = false;
            boolean bl13 = false;
            nArray = new int[6];
            n = 0;
            nArray = oraCollationKey.getNextMultiKeys(byArray);
            while (true) {
                short s;
                short s2;
                short s3;
                short s4;
                int n10;
                if (bl9) {
                    n5 = this.sourceCursor.next(nArray2, false);
                    n9 = nArray2[0];
                    if (nArray2[0] > 0) {
                        bl13 = true;
                        nArray2[0] = 0;
                    }
                } else {
                    bl9 = true;
                }
                if (bl10) {
                    if ((n4 = nArray[n++]) == 0) {
                        nArray = oraCollationKey.getNextMultiKeys(byArray);
                        n = 0;
                        n4 = nArray[n++];
                    }
                } else {
                    bl10 = true;
                }
                if (bl13) {
                    if (n9 == 0) {
                        this.sourceCursor.moveback(n5);
                    }
                    bl13 = false;
                    bl8 = bl4;
                    bl2 = false;
                    continue;
                }
                if (n5 == -1 || n4 == 0) break block41;
                int n11 = OraCollationElementIterator.primaryOrder(n5);
                if (n5 == n4) {
                    if (!this.tables.isReverseSort() || n11 == 0 || bl4) continue;
                    bl8 = bl4 = bl5;
                    continue;
                }
                if (this.tables.isPuncuation(n5) || this.tables.isPuncuation(n4)) {
                    if (bl3 && bl4 && (n10 = OraCollationElementIterator.tertiaryOrder(n5)) != (s4 = OraCollationElementIterator.tertiaryOrder(n4))) {
                        return 0;
                    }
                    bl10 = false;
                    bl9 = false;
                    if (this.tables.isPuncuation(n5)) {
                        bl9 = true;
                    }
                    if (!this.tables.isPuncuation(n4)) continue;
                    bl10 = true;
                    continue;
                }
                if (!(this.tables.isIgnorable(n5) && this.tables.isIgnorable(n4) || !bl2)) {
                    bl = true;
                    n2 = n3;
                    bl4 = false;
                    bl2 = false;
                    n3 = 0;
                }
                if (n11 != (n10 = OraCollationElementIterator.primaryOrder(n4))) {
                    if (n11 == 0) {
                        if (bl4) {
                            bl = true;
                            n2 = 0;
                            bl4 = false;
                        }
                        bl10 = false;
                        continue;
                    }
                    if (n10 == 0) {
                        if (bl4) {
                            bl = true;
                            n2 = 0;
                            return n2;
                        }
                        bl9 = false;
                        continue;
                    }
                    return 0;
                }
                if (this.tables.isReverseSort() && n11 != 0 && !bl4) {
                    bl8 = bl4 = bl5;
                }
                if (!bl4) continue;
                s4 = OraCollationElementIterator.secondaryOrder(n5);
                if (s4 != (s3 = OraCollationElementIterator.secondaryOrder(n4))) {
                    if (!bl8) continue;
                    n3 = s4 < s3 ? -1 : 1;
                    bl2 = true;
                    bl8 = false;
                    continue;
                }
                if (bl3 && (s2 = OraCollationElementIterator.tertiaryOrder(n5)) != (s = OraCollationElementIterator.tertiaryOrder(n4))) break;
            }
            n2 = 0;
            return n2;
        }
        if (n5 != -1) {
            do {
                if (OraCollationElementIterator.primaryOrder(n5) != 0) {
                    if (!(n4 != -1 && n4 != 0 || !this.subComp || n3 != 0 || bl5 && bl)) {
                        this.isSubstring = true;
                        this.matchedLength = this.sourceCursor.getCurPos() - 1;
                    } else {
                        this.matchedLength = 0;
                    }
                    return this.matchedLength;
                }
                if (OraCollationElementIterator.secondaryOrder(n5) != 0) {
                    if (!bl4) continue;
                    n2 = 0;
                    bl4 = false;
                    bl3 = false;
                    continue;
                }
                if (OraCollationElementIterator.tertiaryOrder(n5) == 0 || !bl3) continue;
                n2 = 0;
                bl3 = false;
            } while ((n5 = this.sourceCursor.next(nArray2, bl)) != -1);
        } else if (n4 != 0) {
            do {
                if (OraCollationElementIterator.primaryOrder(n4) != 0) {
                    return 0;
                }
                if (OraCollationElementIterator.secondaryOrder(n4) != 0) {
                    if (bl4) {
                        n2 = 0;
                        bl4 = false;
                        bl3 = false;
                    }
                } else if (OraCollationElementIterator.tertiaryOrder(n4) != 0 && bl3) {
                    n2 = 0;
                    bl3 = false;
                }
                if ((n4 = nArray[n++]) != 0) continue;
                nArray = oraCollationKey.getNextMultiKeys(byArray);
                n = 0;
                n4 = nArray[n++];
            } while (n4 != 0);
        }
        if (bl2) {
            n2 = 0;
        }
        if (n2 == 0) {
            return n2;
        }
        return this.sourceCursor.getCurPos();
    }

    private int isMonoKeyMatch(String string, byte[] byArray, OraCollationKey oraCollationKey) {
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4;
        int n5;
        block44: {
            OraMapTable oraMapTable;
            n5 = 0;
            boolean bl2 = false;
            UnicodeMapChar unicodeMapChar = null;
            if (this.strength == 0) {
                if (this.baseLetterTable == null) {
                    if (!this.tables.hasBaseLetterTable()) {
                        oraMapTable = OraMapTable.getInstance((int)16);
                        this.baseLetterTable = oraMapTable.getUnicodeMap("BINARY_BASE_LETTER");
                    } else {
                        this.baseLetterTable = this.tables.getBaseLetterTable();
                    }
                }
                bl2 = true;
                unicodeMapChar = this.baseLetterTable;
            } else if (this.strength == 1) {
                if (this.caseFoldingTable == null) {
                    oraMapTable = OraMapTable.getInstance((int)17);
                    this.caseFoldingTable = oraMapTable.getUnicodeMap("CASE_FOLD_TAB");
                }
                bl2 = true;
                unicodeMapChar = this.caseFoldingTable;
            }
            this.sourceIndex = 0;
            this.targetIndex = 0;
            int n6 = 65535;
            int n7 = 65535;
            n4 = string.length();
            n3 = 0;
            bl = true;
            boolean bl3 = true;
            n2 = 0;
            n = 0;
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            while (true) {
                if (bl2) {
                    if (bl) {
                        if (this.sourceIndex == n4) break block44;
                        n6 = this.getNextConvertedChar(unicodeMapChar, string, true);
                        n2 = this.tables.getCollationItem((char)n6);
                        if (n2 == 0) {
                            n2 = n6;
                        }
                        bl4 = true;
                    } else {
                        bl = true;
                    }
                    n = oraCollationKey.getNextMonoKeys(byArray);
                    if (n == 0) {
                        break block44;
                    }
                } else {
                    if (bl) {
                        if (this.sourceIndex == n4) break block44;
                        if ((n2 = this.tables.getCollationItem((char)(n6 = string.charAt(this.sourceIndex++)))) == 0) {
                            n2 = n6;
                        }
                        bl4 = true;
                    } else {
                        bl = true;
                    }
                    n = oraCollationKey.getNextMonoKeys(byArray);
                    if (n == 0) break block44;
                }
                if (this.tables.isSimple(n2) && this.tables.isSimple(n)) {
                    if (n2 == n) continue;
                    n8 = n2 >>> 16;
                    n9 = n >>> 16;
                    if (n8 == 0) {
                        if (n9 != 0) {
                            bl3 = false;
                        }
                        if (n3 != 0) continue;
                        n3 = (n2 & 0xFF) - (n & 0xFF);
                        continue;
                    }
                    if (n9 == 0) {
                        bl = false;
                        if (n3 != 0) continue;
                        n3 = (n2 & 0xFF) - (n & 0xFF);
                        continue;
                    }
                    if (n8 != n9) {
                        return 0;
                    }
                    if (n3 == 0) {
                        n3 = (n2 & 0xFF) - (n & 0xFF);
                        if (n3 == 0) continue;
                        return 0;
                    }
                    return 0;
                }
                int n10 = n2;
                int n11 = n;
                if (!this.tables.isSimple(n10) && bl4) {
                    char c;
                    int[] nArray;
                    if (this.tables.isContracting(n10)) {
                        nArray = new int[]{n10};
                        c = bl2 ? this.getNextConvertedChar(unicodeMapChar, string, true) : (this.sourceIndex < n4 ? (char)string.charAt(this.sourceIndex++) : (char)'\uffff');
                        int n12 = this.getContractingKey(nArray, (char)n6, c);
                        if (n12 == 1 && c != '\uffff') {
                            --this.sourceIndex;
                        }
                        n10 = nArray[0];
                        if (nArray.length == 2) {
                            n2 = nArray[1];
                            bl = false;
                        }
                    } else if (this.tables.isExpanding(n10)) {
                        c = this.tables.getIndex(n10);
                        nArray = this.tables.getExpandExpCharKey(c);
                        if (nArray.length == 2) {
                            n10 = nArray[0];
                            n2 = nArray[1];
                            bl = false;
                        }
                    } else if (this.tables.isZero(n10)) {
                        n10 = n6 >>> 8;
                        n2 = n6 & 0xFF;
                        bl4 = false;
                        bl = false;
                    }
                }
                if ((n11 & 0xFFFF0000) == 0) {
                    n = n11 & 0xFF;
                    n11 >>>= 8;
                    bl5 = false;
                    bl3 = false;
                }
                if (n10 == n11) continue;
                n8 = n10 >>> 16;
                n9 = n11 >>> 16;
                if (n8 == n9) {
                    if (n3 != 0) continue;
                    n3 = (n10 & 0xFF) - (n11 & 0xFF);
                    continue;
                }
                if (n8 == 0) {
                    if (n9 != 0) {
                        bl3 = false;
                    }
                    if (n3 != 0) continue;
                    n3 = (n10 & 0xFF) - (n11 & 0xFF);
                    continue;
                }
                if (n9 == 0) {
                    bl = false;
                    if (n3 != 0) continue;
                    n3 = (n10 & 0xFF) - (n11 & 0xFF);
                    continue;
                }
                if (n8 != n9) break;
            }
            return 0;
        }
        if (!bl && n2 >>> 16 > 0) {
            if (this.subComp) {
                this.isSubstring = true;
                this.matchedLength = this.sourceIndex - 1;
            }
            return 0;
        }
        if (this.sourceIndex == n4) {
            if (n == 0) {
                n5 = n3 != 0 ? 0 : this.sourceIndex - 1;
            } else {
                if (n != 0) {
                    n = oraCollationKey.getNextMonoKeys(byArray);
                }
                n5 = n == 0 && n3 == 0 ? n4 : 0;
            }
        } else {
            n5 = n3 == 0 ? this.sourceIndex - 1 : 0;
        }
        return n5;
    }

    private void setSubstringComp(boolean bl) {
        this.subComp = bl;
        this.matchedLength = 0;
    }

    private boolean getSubstringComp() {
        return this.subComp;
    }

    private void setIsSubstring(boolean bl) {
        this.isSubstring = bl;
    }

    private boolean getIsSubstring() {
        return this.isSubstring;
    }

    public static void main(String[] stringArray) {
        try {
            OraCollator oraCollator = OraCollator.getInstance("GENERIC_M_ci");
            System.out.println(oraCollator.getName() + " " + oraCollator.getCharSet());
            String string = "a\u4e00\u4e00";
            String string2 = "A\u4e00\u4e00";
            int n = oraCollator.compare(string, string2);
            System.out.println(string + " " + string2);
            System.out.println("the result is " + n);
            OraCollationKey oraCollationKey = oraCollator.getCollationKey(string);
            OraCollationKey oraCollationKey2 = oraCollator.getCollationKey(string2);
            System.out.println(oraCollationKey);
            System.out.println(oraCollationKey2);
            OraCollator oraCollator2 = OraCollator.getInstance(Locale.US, "binary_ai", "ucs4");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            oraCollator2.compare("abc", "\u00c0b");
            oraCollator2.compare("ab", "abc");
            oraCollator2.compare("abc", "ab");
            oraCollator2.compare("abc", "abd");
            oraCollator2 = OraCollator.getInstance(Locale.US, "binary", "ja16sjis");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            oraCollationKey = oraCollator2.getCollationKey("A\u007f\uff61\uff70\uff9d\u3000\uff21");
            oraCollationKey = oraCollator2.getCollationKey("\uff21\uff41");
            System.out.println(oraCollationKey);
            oraCollationKey2 = oraCollator2.getCollationKey("\uff21M\uff41");
            System.out.println(oraCollationKey2);
            oraCollator2 = OraCollator.getInstance(Locale.US, "xfrench_ai", "ja16sjis");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            OraCollationKey oraCollationKey3 = oraCollator2.getCollationKey("\uff21\uff41");
            System.out.println(oraCollationKey3);
            int[] nArray = oraCollator2.matchFirst("\uff21\uff41", "\uff21\uff21");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            OraCollationKey oraCollationKey4 = oraCollator2.getCollationKey("\uff21M\uff41");
            nArray = oraCollator2.matchFirst("\uff21M\uff41", "\uff21M\uff21");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            System.out.println(oraCollationKey4);
            nArray = oraCollator2.matchFirst("\uff47\uff4f\uff32\uff4f\uff44", "\uff52\uff4f\uff44");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchFirst("goldenrod", "rod");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator2 = OraCollator.getInstance("binary_ai", "ja16sjis");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            oraCollationKey = oraCollator2.getCollationKey("\uff21\uff22");
            nArray = oraCollator2.matchFirst("\uff47\uff32\uff4f\uff44", "\uff52\uff4f\uff44");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator2 = OraCollator.getInstance("binary_ai", "al32utf8");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            nArray = oraCollator2.matchLast("abcbBc", "bc");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator2 = OraCollator.getInstance(Locale.US, "schinese_pinyin_m", "we8dec");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            nArray = oraCollator2.matchFirst("a\u0101\u00e1\u01ce\u00e0", "a\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchLast("a\u0101\u00e1\u01ce\u00e0", "a\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator2 = OraCollator.getInstance(Locale.US, "schinese_pinyin_m_ci", "ucs4");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            nArray = oraCollator2.matchFirst("a\u0101\u00e1\u01ce\u00e0", "A\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchLast("a\u0101\u00e1\u01ce\u00e0", "A\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator2 = OraCollator.getInstance(Locale.US, "schinese_pinyin_m_ai", "ucs4");
            System.out.println(oraCollator2.getName() + " " + oraCollator2.getCharSet());
            nArray = oraCollator2.matchFirst("a\u0101\u00e1\u01ce\u00e0", "A\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchLast("a\u0101\u00e1\u01ce\u00e0", "A\u0101\u00e1");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchFirst("a\u0101\u00e1\u01ce\u00e0", "Aaa");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchLast("a\u0101\u00e1\u01ce\u00e0", "Aaa");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchFirst("aabcd", "a");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchLast("a\u0101\u00e1\u01ce", "a\u0101\u00e1\u01ce");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchFirst("goldenrod", "rod");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            OraCollator oraCollator3 = OraCollator.getInstance(Locale.US, "tchinese_stroke_m", "ucs4");
            System.out.println(oraCollator3.getName() + " " + oraCollator3.getCharSet());
            nArray = oraCollator3.matchFirst("\ud834\udd5e\u55c0", "\ud834\udd5e");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchLast("abc\ud834\udd5e\u55c0", "\ud834\udd5e");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchFirst("\ud834\udd5e\u55c0", "\ud834\udd5eA");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchLast("\ud834\udd5e\u55c0", "\ud834\udd5eA");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchFirst("\ud834\udd5eABCD", "\ud834\udd5eABCD");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchLast("\ud834\udd5eABCD", "\ud834\udd5eABCD");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator2.matchFirst("McaeE", "Mcaee");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            oraCollator3 = OraCollator.getInstance(Locale.US, "French_m_ai", "ucs4");
            System.out.println(oraCollator3.getName() + " " + oraCollator3.getCharSet());
            nArray = oraCollator3.matchFirst("\u00caeited\u00cct", "it");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator3.matchLast("\u00caeited\u00cct", "it");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            OraCollator oraCollator4 = OraCollator.getInstance(Locale.US, "GENERIC_M_CI", "ucs4");
            System.out.println(oraCollator4.getName() + " " + oraCollator4.getCharSet());
            nArray = oraCollator4.matchFirst("12aBcDe", "bc");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator4.matchLast("12aBcDe", "bc");
            System.out.println("MatchLast Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator4.matchFirst("Bc", "bc");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
            nArray = oraCollator4.matchLast("abcabc", "bc");
            System.out.println("Match Found:" + nArray[0] + "    Offset:" + nArray[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
        }
    }

    static {
        UNICODE_CHARSET.add("UNICODE");
        UNICODE_CHARSET.add("UTF16");
        UNICODE_CHARSET.add("AL16UTF16");
        UNICODE_CHARSET.add("UCS2");
        UNICODE_CHARSET.add("UTF8");
        UNICODE_CHARSET.add("AL32UTF8");
        UNICODE_CHARSET.add("UCS4");
        UNICODE_CHARSET.add("UTF32");
        UCS4_CHARSET.add("UCS4");
        UCS4_CHARSET.add("UTF32");
        UCS4_CHARSET.add("AL32UTF8");
    }
}

