/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.HashMap;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.OraLinguisticSetter;
import oracle.i18n.util.builder.UnicodeMapChar;

public class OraLinguistic
implements Serializable {
    private static final String LINGUISTICNAMEPREFIX = GDKOracleMetaData.getDataPath() + "lx3";
    private static final String LINGUISTICIDPREFIX = "0000";
    private static final int BINARYIDPREFIX = 8192;
    private static final int SECTERORDERMASK = 65535;
    private static HashMap OraLingCache = null;
    private static HashMap m_linguisticToID = null;
    public static final int KEY_IGN = 0;
    public static final long KEY_MAX = 0xFFC00000L;
    public static final int KEY_CON = -4128768;
    public static final int KEY_EXP = -4063232;
    public static final int KEY_CTX = -3997696;
    public static final int KEY_SWP = -3932160;
    public static final int KEY_SG = -3866624;
    public static final int KEY_UNDEFINED = -65536;
    public static final long KEY_EPK = 0xFFF00000L;
    public static final int PRIMARYORDERMASK = -65536;
    public static final int SECONDARYORDERMASK = 65280;
    public static final int TERTIARYORDERMASK = 255;
    public static final int PRIMARYORDERSHIFT = 16;
    public static final int SECONDARYORDERSHIFT = 8;
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    protected String VERSION;
    protected String SORTNAME;
    protected int SORTID;
    protected String BASESORTNAME;
    protected int BASESORTID;
    protected boolean Canonical_equivalence = false;
    protected boolean Reverse_secondary = false;
    protected boolean Swap_with_next = false;
    protected boolean Hangul_jamo_composition = false;
    protected int[] collationLevel1;
    protected int[] collationLevel2;
    protected int[] contractCollKey;
    protected byte[] contractNumOfFE;
    protected char[][] contractConChar;
    protected int[][] expandExpCharKey;
    protected int[] contextPrevCpt;
    protected int[] contextCollKey;
    protected char[] contextSenChar;
    protected byte[] contextNumOfFE;
    protected int[][] surrogateTable = null;
    protected UnicodeMapChar baseLetterTable = null;
    protected boolean monolingual = false;
    protected int[][] LatinOneTable = null;

    public static synchronized OraLinguistic getInstance(String string) {
        Object object;
        String string2 = string.toLowerCase();
        OraLinguistic oraLinguistic = null;
        OraBoot oraBoot = OraBoot.getInstance();
        int n = -1;
        String string3 = oraBoot.getLinguisticFileName(string2);
        if (string3 != null) {
            n = Integer.parseInt(string3.substring(3), 16);
        }
        if (n == -1 && string2.startsWith("binary")) {
            object = string2.substring(7);
            String string4 = oraBoot.getCharSetId((String)object);
            n = string4 == null ? -1 : Integer.parseInt(string4);
            n += 8192;
        }
        if (n == -1 || n == 8191) {
            return oraLinguistic;
        }
        oraLinguistic = OraLinguistic.getInstance(n);
        if (oraLinguistic == null && n >= 8192 && (object = CharacterConverterOGS.getInstance(n - 8192)) != null && (oraLinguistic = OraLinguisticSetter.buildFromCharSet((CharacterConverter)object, n - 8192)) != null) {
            OraLingCache.put(Integer.toHexString(n), oraLinguistic);
        }
        return oraLinguistic;
    }

    public static synchronized OraLinguistic getInstance(int n) {
        String string;
        String string2 = Integer.toHexString(n);
        OraLinguistic oraLinguistic = null;
        if (OraLingCache != null) {
            oraLinguistic = (OraLinguistic)OraLingCache.get(string2);
            if (oraLinguistic != null) {
                return oraLinguistic;
            }
        } else {
            OraLingCache = new HashMap();
        }
        if ((oraLinguistic = (OraLinguistic)OraBoot.readObj((String)(string = LINGUISTICNAMEPREFIX + LINGUISTICIDPREFIX.substring(0, 4 - string2.length()) + string2 + ".glb"))) != null) {
            OraLingCache.put(string2, oraLinguistic);
        }
        return oraLinguistic;
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public String getName() {
        return this.SORTNAME;
    }

    public int getId() {
        return this.SORTID;
    }

    public String getBASESORTNAME() {
        return this.BASESORTNAME;
    }

    public int getBASESORTID() {
        return this.BASESORTID;
    }

    public int getCollationItem(char c) {
        return this.collationLevel2[this.collationLevel1[c >>> 8] + (c & 0xFF)];
    }

    public boolean isIgnorable(int n) {
        return (n & 0xFFFF0000) == 0 && (n & 0xFF00) != 0;
    }

    public boolean isContracting(int n) {
        return (n & 0xFFFF0000) == -4128768;
    }

    public boolean isExpanding(int n) {
        return (n & 0xFFFF0000) == -4063232;
    }

    public boolean isContextSensitive(int n) {
        return (n & 0xFFFF0000) == -3997696;
    }

    public boolean isSwapping(char c) {
        return c >= '\u0e40' && c <= '\u0e44' || c >= '\u0ec0' && c <= '\u0ec4';
    }

    public boolean isSurrogate(int n) {
        return (n & 0xFFFF0000) == -3866624;
    }

    public boolean isSimple(int n) {
        long l = (long)n & 0xFFFFFFFFL;
        return l <= 0xFFC00000L && l != 0L;
    }

    public boolean isZero(int n) {
        return n == 0;
    }

    public boolean isPuncuation(int n) {
        return (n & 0xFFFF0000) == 0 && (n & 0xFF00) == 0 && n != 0;
    }

    public boolean isExtendedPrimary(int n) {
        long l = (long)n & 0xFFFFFFFFL;
        return l >= 0xFFF00000L;
    }

    public int getIndex(int n) {
        return n & 0xFFFF;
    }

    public int getContractCollKey(int n) {
        return this.contractCollKey[n];
    }

    public byte getContractNumOfFE(int n) {
        return this.contractNumOfFE[n];
    }

    public char[] getContractConChar(int n) {
        return this.contractConChar[n];
    }

    public int[] getExpandExpCharKey(int n) {
        return this.expandExpCharKey[n];
    }

    public int getMaxExpansion(int n) {
        int n2 = 1;
        if (this.expandExpCharKey != null) {
            for (int i = 0; i < this.expandExpCharKey.length; ++i) {
                int[] nArray = this.expandExpCharKey[i];
                int n3 = nArray.length;
                if (n3 <= n2 || nArray[n3 - 1] != n) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public char getContextPrevCpt(int n) {
        return (char)(this.contextPrevCpt[n] >>> 16);
    }

    public int getContextCollKey(int n) {
        return this.contextCollKey[n];
    }

    public byte getContextNumOfFE(int n) {
        return this.contextNumOfFE[n];
    }

    public int getSurrogateKey(int n, int n2) {
        return this.surrogateTable[n][n2];
    }

    public boolean hasBaseLetterTable() {
        return this.baseLetterTable != null;
    }

    public UnicodeMapChar getBaseLetterTable() {
        return this.baseLetterTable;
    }

    public boolean isMono() {
        return this.monolingual;
    }

    public boolean isReverseSort() {
        return this.Reverse_secondary;
    }

    public boolean isCanonicalEq() {
        return this.Canonical_equivalence;
    }

    public boolean isSwapWithNext() {
        return this.Swap_with_next;
    }

    public boolean isHangulJamo() {
        return this.Hangul_jamo_composition;
    }

    public boolean hasContractingTable() {
        return this.contractCollKey != null;
    }

    public boolean hasLatin1() {
        return this.LatinOneTable != null;
    }

    public int[] getLatin1Keys(char c) {
        return this.LatinOneTable[c];
    }
}

