/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.Window;
import java.net.URL;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.vhv.VHVContextProcessor;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVNode;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVURLHelper;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.resource.VHVArb;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class VHVCommand
extends Command {
    public static final String VHV_CMD = VHVCommand.class.getName();
    public static final int VHV_CMD_ID = Ide.findOrCreateCmdID((String)VHV_CMD);

    public static final IdeAction getVHVAction(String command) {
        return IdeAction.get((int)Ide.findOrCreateCmdID((String)command), (String)command, (String)StringUtils.stripMnemonic((String)VHVArb.getString(16)), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)VHVArb.getString(16))), (ArrayResourceBundle)VHVArb.getInstance(), (int)35, null, (boolean)true);
    }

    protected VHVCommand(int cmdId) {
        super(cmdId, 1);
    }

    public int doit() throws Exception {
        URL url = this.getContextLocatables(this.getContext())[0].getURL();
        VHVCommand.show(url, this.createQuery(), this.createCustomizer(), this.getVersionPath(url));
        return 0;
    }

    protected Locatable[] getContextLocatables(Context context) {
        return VHVContextProcessor.getInstance().getContextLocatables(context);
    }

    protected abstract VHVQuery createQuery();

    protected abstract String getVersionPath(URL var1);

    protected VHVCustomizer createCustomizer() {
        return null;
    }

    public static final void show(URL url, VHVQuery query, VHVCustomizer customizer, String versionPath) {
        try {
            URL vhvUrl = VHVURLHelper.newVHVURL(url, versionPath);
            VHVNode vhvNode = (VHVNode)NodeFactory.findOrCreate(VHVNode.class, (URL)vhvUrl);
            vhvNode.setQuery(query);
            Context context = Context.newIdeContext();
            context.setNode((Node)vhvNode);
            context.setElement((Element)vhvNode);
            context.setProperty("VHVViewer.CUSTOMIZER", (Object)customizer);
            EditorManager.getEditorManager().openEditorInFrame(VHVViewer.class, context);
        }
        catch (InstantiationException ie) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ie);
        }
        catch (IllegalAccessException ille) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ille);
        }
    }
}

