/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import oracle.ide.Context;
import oracle.ide.vhv.VHVInContextResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.view.VHVControl;
import oracle.ide.view.View;

public class VHVContext {
    private VHVContext() {
    }

    public static final boolean isVHVContext(Context context) {
        return context.getView() instanceof VHVViewer;
    }

    public static final VHVInContextResource getSelectedResource(Context context) {
        VHVControl vhvControl = VHVContext.getVHVControl(context);
        GraphElement graphElement = vhvControl.getSelectedGraphElement();
        return graphElement != null ? VHVContext.constructContextResource(graphElement) : null;
    }

    public static final VHVInContextResource getSecondSelectedResource(Context context) {
        VHVControl vhvControl = VHVContext.getVHVControl(context);
        GraphElement graphElement = vhvControl.getSecondSelectedGraphElement();
        return graphElement != null ? VHVContext.constructContextResource(graphElement) : null;
    }

    public static final VHVInContextResource getPreviousResource(Context context) {
        return VHVContext.getPreviousResource(VHVContext.getSelectedResource(context));
    }

    public static final VHVInContextResource getPreviousResource(VHVInContextResource inContextResource) {
        return VHVContext.getPreviousResource(inContextResource.getGraphElement());
    }

    private static final VHVInContextResource getPreviousResource(GraphElement graphElement) {
        if (graphElement == null) {
            return null;
        }
        try {
            VHVInContextResource vHVInContextResource = VHVContext.constructContextResource(((VHVVersionableResource)graphElement.getResource()).isFirstVersionOnBranch() ? graphElement.getOwnerElement().getParentElement() : graphElement.getParentElement());
            return vHVInContextResource;
        }
        catch (VHVResourceException vhvre) {
            vhvre.printStackTrace();
            VHVInContextResource vHVInContextResource = null;
            return vHVInContextResource;
        }
    }

    private static final VHVInContextResource constructContextResource(GraphElement graphElement) {
        VHVVersionableResource versionableResource = (VHVVersionableResource)graphElement.getResource();
        VHVInContextResource contextResource = new VHVInContextResource();
        try {
            contextResource.setBranch(versionableResource.getBranch());
            contextResource.setVersionNumber(versionableResource.getVersionNumber());
            contextResource.setName(versionableResource.getName());
            contextResource.setNotes(versionableResource.getNotes());
            contextResource.setCheckedOut(graphElement instanceof CheckOutElement);
            contextResource.setReserved(contextResource.isCheckedOut() && ((CheckOutElement)graphElement).isReservedCheckOut());
            contextResource.setData(versionableResource.getData());
            contextResource.setGraphElement(graphElement);
        }
        catch (VHVResourceException vhvre) {
            vhvre.printStackTrace();
        }
        return contextResource;
    }

    public static final VHVControl getVHVControl(Context context) {
        View view = context != null ? context.getView() : null;
        return view instanceof VHVViewer ? ((VHVViewer)view).getVHVControl() : null;
    }
}

