/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.vhv.resource.VHVArb;

public class VHVURLHelper
extends URLFileSystemHelper {
    public static final String PROTOCOL = "ide.vhv";

    public static URL newVHVURL(URL realUrl, String versionPath) {
        URL url = URLFactory.replaceQueryPart((URL)realUrl, (String)versionPath);
        return URLFactory.newIdeURL((String)PROTOCOL, (URL)url);
    }

    public static URL getRealURL(URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        int i = protocol.lastIndexOf(".");
        if (i < 0) {
            return url;
        }
        url = URLFactory.replaceProtocolPart((URL)url, (String)protocol.substring(i + 1));
        url = URLFactory.replaceQueryPart((URL)url, null);
        return url;
    }

    public String getFileName(URL url) {
        return VHVArb.format(86, new String[]{URLFileSystem.getFileName((URL)VHVURLHelper.getRealURL(url))});
    }

    public String getPlatformPathName(URL url) {
        return VHVArb.format(86, new String[]{url.getQuery()});
    }

    public String getSuffix(URL url) {
        return "";
    }

    public InputStream openInputStream(URL url) {
        return new ByteArrayInputStream(new byte[0]);
    }
}

