/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.vhv.VHVBranchResource;
import oracle.ide.vhv.VHVCheckoutResource;
import oracle.ide.vhv.VHVMergeResource;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.model.ElementKind;
import oracle.ide.vhv.model.MergeType;
import oracle.ide.vhv.model.RootBranchResource;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VHVVersionTree
extends VersionTree {
    public VHVVersionTree(VHVVersionableResource[] versionResources, VHVMergeResource[] mergeResources, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        super(true);
        VHVVersionableResource viewVersionResource = null;
        HashMap<VHVBranchResource, Collection<VHVVersionableResource>> versionsByBranch = new HashMap<VHVBranchResource, Collection<VHVVersionableResource>>();
        this.populateVersionsByBranch(versionsByBranch, versionResources);
        Iterator itr = versionsByBranch.values().iterator();
        while (itr.hasNext()) {
            Collections.sort((List)itr.next(), new 1());
        }
        RootBranchResource rootBranchResource = new RootBranchResource();
        ArrayList<VersionElement> versionElements = new ArrayList<VersionElement>();
        for (Map.Entry entry : versionsByBranch.entrySet()) {
            VHVBranchResource branchResource = (VHVBranchResource)entry.getKey();
            List versionResources0 = (List)((Collection)entry.getValue());
            VHVResource userResource = new VHVResource();
            userResource.setName(branchResource.getUser());
            VHVResource branchSource = branchResource.getSource();
            versionElements.add(new VersionElement((VHVBranchResource)entry.getKey(), branchSource != null ? branchSource : rootBranchResource, versionResources0.size() > 0 ? (VHVVersionableResource)versionResources0.iterator().next() : null, ElementKind.BRANCH, null, branchResource.getNotes(), branchResource.getName(), branchResource.getDate(), userResource));
            int i = 0;
            while (i < versionResources0.size()) {
                VHVVersionableResource versionResource = (VHVVersionableResource)versionResources0.get(i);
                VHVVersionableResource lastResource = i > 0 ? (VHVVersionableResource)versionResources0.get(i - 1) : null;
                VHVVersionableResource nextResource = i < versionResources0.size() - 1 ? (VHVVersionableResource)versionResources0.get(i + 1) : null;
                userResource = new VHVResource();
                userResource.setName(versionResource.getUser());
                versionElements.add(new VersionElement(versionResource, lastResource != null ? lastResource : branchResource, nextResource, nextResource != null ? ElementKind.NODE : ElementKind.TIP, null, versionResource.getNotes(), versionResource.getVersionLabel(), versionResource.getDate(), userResource));
                if (versionResource.isViewVersion()) {
                    viewVersionResource = versionResource;
                }
                ++i;
            }
        }
        if (mergeResources != null) {
            VHVMergeResource[] vHVMergeResourceArray = mergeResources;
            int n = 0;
            while (n < vHVMergeResourceArray.length) {
                VHVMergeResource mergeResource = vHVMergeResourceArray[n];
                VHVResource userResource = new VHVResource();
                userResource.setName(mergeResource.getUser());
                versionElements.add(new VersionElement(mergeResource, mergeResource.getSource(), mergeResource.getTarget(), ElementKind.MERGE, MergeType.SYSTEM, mergeResource.getNotes(), mergeResource.getName(), mergeResource.getDate(), userResource));
                ++n;
            }
        }
        VHVVersionableResource checkedOutVersionResource = null;
        if (checkoutResource != null) {
            VHVVersionableResource[] vHVVersionableResourceArray = versionResources;
            int n = 0;
            while (n < vHVVersionableResourceArray.length) {
                VHVVersionableResource versionResource = vHVVersionableResourceArray[n];
                if (versionResource.getVersionNumber().compareTo(checkoutResource.getVersionNumber()) == 0) {
                    checkedOutVersionResource = versionResource;
                    break;
                }
                ++n;
            }
        }
        if (checkoutResource != null && checkedOutVersionResource != null) {
            VHVVersionableResource checkoutVersionableResource = new VHVVersionableResource();
            checkoutVersionableResource.setBranch(checkedOutVersionResource.getBranch());
            checkoutVersionableResource.setVersionNumber(checkoutResource.getVersionNumber());
            checkoutVersionableResource.setName(checkoutResource.getName());
            checkoutVersionableResource.setNotes(checkoutResource.getNotes());
            checkoutVersionableResource.setDate(checkoutResource.getDate());
            checkoutVersionableResource.setUser(checkoutResource.getUser());
            checkoutVersionableResource.setVersionLabel(checkedOutVersionResource.getVersionLabel());
            checkoutVersionableResource.setFirstVersionOnBranch(false);
            VHVResource userResource = new VHVResource();
            userResource.setName(checkoutVersionableResource.getUser());
            versionElements.add(new VersionElement(checkoutVersionableResource, checkedOutVersionResource, null, checkoutResource.isReserved() ? ElementKind.RESERVED_CHECKOUT : ElementKind.UNRESERVED_CHECKOUT, null, checkoutVersionableResource.getNotes(), checkoutVersionableResource.getName(), checkoutVersionableResource.getDate(), userResource));
        }
        this.createVersionTree(versionElements.toArray(new VersionElement[0]));
        if (viewVersionResource != null) {
            this.setInContextVersion(viewVersionResource);
        }
    }

    private void populateVersionsByBranch(Map<VHVBranchResource, Collection<VHVVersionableResource>> versionsByBranch, VHVVersionableResource[] versionResources) throws VHVResourceException {
        VHVVersionableResource[] vHVVersionableResourceArray = versionResources;
        int n = 0;
        while (n < vHVVersionableResourceArray.length) {
            VHVVersionableResource versionResource = vHVVersionableResourceArray[n];
            this.populateVersionsByBranch(versionsByBranch, versionResource);
            ++n;
        }
    }

    private void populateVersionsByBranch(Map<VHVBranchResource, Collection<VHVVersionableResource>> versionsByBranch, VHVVersionableResource versionResource) throws VHVResourceException {
        VHVBranchResource branchResource = versionResource.getBranch();
        if (branchResource == null) {
            return;
        }
        Collection<VHVVersionableResource> versionResources = versionsByBranch.get(branchResource);
        if (versionResources == null) {
            versionResources = new ArrayList<VHVVersionableResource>();
            versionsByBranch.put(branchResource, versionResources);
        }
        versionResources.add(versionResource);
    }

    final class 1
    implements Comparator {
        public int compare(VHVVersionableResource o1, VHVVersionableResource o2) {
            try {
                int n = o1.getVersionNumber().compareTo(o2.getVersionNumber());
                return n;
            }
            catch (VHVResourceException re) {
                re.printStackTrace();
                int n = 0;
                return n;
            }
        }
    }
}

