/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.diffmerge.impl.LocalActionCache;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.SwingWorker;
import oracle.ide.vhv.VHVConstants;
import oracle.ide.vhv.VHVController;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVDockableFactory;
import oracle.ide.vhv.VHVNode;
import oracle.ide.vhv.VHVPropertiesWindow;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVURLHelper;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.VHVControl;
import oracle.ide.view.View;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;

public class VHVViewer
extends Editor
implements PopupManager {
    public static final String CUSTOMIZER = "VHVViewer.CUSTOMIZER";
    private static final String PROPERTIES_DTCACHE_KEY = "VHV.Properties";
    private VHVQuery _query;
    private VHVControl _vhvControl;
    private VHVCustomizer _customizer;
    private VHVToolbar _toolbar;
    private final LocalActionCache _localActionCache;
    private final CardLayout _cl;
    private JPanel _gui;
    private boolean _inProgress;
    private ProgressPanel _progressPanel;

    private void $init$() {
        this._cl = new CardLayout();
        this._inProgress = true;
    }

    public VHVViewer() {
        this.$init$();
        VHVController.getInstance();
        this._localActionCache = new LocalActionCache((View)this);
    }

    public boolean isInProgress() {
        return this._inProgress;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public VHVControl getVHVControl() {
        if (this._vhvControl == null) {
            this._vhvControl = new VHVControl((View)this, this._customizer, this._localActionCache);
            this._vhvControl.setScrollingEnabled(false);
        }
        return this._vhvControl;
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            this._customizer = (VHVCustomizer)context.getProperty(CUSTOMIZER);
            if (this._customizer == null) {
                this._customizer = new VHVCustomizer();
            }
            this.initializeCustomizer(this._customizer);
            try {
                this._query = this.getQuery(context);
                this.initializeProgressPanel();
            }
            catch (VHVResourceException vhvre) {
                this._customizer.getExceptionHandler().handleException(vhvre, IdeUtil.getMainWindow());
            }
        }
    }

    private void initializeProgressPanel() {
        if (this._progressPanel == null || this._query == null) {
            return;
        }
        this._progressPanel.setCancelEnabled(this._query.isCancelable());
        this._progressPanel.addCancelActionListener((ActionListener)new 1());
    }

    protected void initializeCustomizer(VHVCustomizer customizer) {
    }

    protected VHVQuery getQuery(Context context) throws VHVResourceException {
        if (context.getNode() instanceof VHVNode) {
            return ((VHVNode)context.getNode()).getQuery();
        }
        throw new IllegalStateException();
    }

    private URL getRealURL(Context context) {
        URL url = context.getNode().getURL();
        if (url.getProtocol().startsWith("ide.vhv")) {
            url = VHVURLHelper.getRealURL(url);
        }
        return url;
    }

    public void open() {
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VHVNode) {
                node.open();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (Ide.getDTCache().getBoolean(PROPERTIES_DTCACHE_KEY, true)) {
            VHVDockableFactory.showPropertiesWindow();
        }
        VHVToolbar.mav$initialize((VHVToolbar)this.getToolbar(), (View)this, this._customizer);
        this._open(false);
    }

    private void _open(boolean requery) {
        this.getVHVControl().setActionsSuspended(true);
        new 2(this, requery).start();
    }

    private void _openImpl(boolean requery) {
        if (this._query == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        try {
            this._query.query(this.getRealURL(this.getContext()));
            if (this._query.isCanceled()) {
                this.closeEditor();
                return;
            }
        }
        catch (Exception e) {
            this._customizer.getExceptionHandler().handleException(e, IdeUtil.getMainWindow());
            this.closeEditor();
            return;
        }
        if (this._query.getVersionTree() != null) {
            this._query.getVersionTree().setRequeryListener(new 3());
            if (requery) {
                this.getVHVControl().getVersionTree().getContextResource().setVersionTree(this._query.getVersionTree());
                return;
            }
            try {
                this.getVHVControl().install(this._query.getVersionTree());
                if (HelpSystem.getHelpSystem() != null) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)this.getVHVControl(), VHVArb.getString(18));
                }
            }
            catch (Exception e) {
                this._customizer.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
                this.closeEditor();
            }
            this.getVHVControl().getVersionTreeDiagramPane().getGUI().addAncestorListener(new 4());
            long pause = 1000L - (System.currentTimeMillis() - t1);
            if (pause > 0L) {
                try {
                    Thread.sleep(pause);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initializeDiagramPaneOnRealization() {
        this.getVHVControl().getVersionTreeDiagramPane().zoomToSize(1.0);
        this.getVHVControl().getVersionTreeDiagramPane().scrollToInContextVersion();
        this.getVHVControl().getVersionTreeDiagramPane().getGUI().requestFocusInWindow();
        this.getVHVControl().updateContextSensitiveActions();
    }

    private void closeEditor() {
        EventQueue.invokeLater(new 5());
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute != null && attribute.equals("scrollable")) {
            return Boolean.FALSE;
        }
        if (attribute != null && attribute.equals("custom_horizontal_scrollbar")) {
            return this.getVHVControl().getHorizontalScrollBar();
        }
        if (attribute != null && attribute.equals("custom_vertical_scrollbar")) {
            return this.getVHVControl().getVerticalScrollBar();
        }
        if (attribute != null && attribute.equals("horizontal_scrollbar_policy")) {
            return 31;
        }
        if (attribute != null && attribute.equals("vertical_scrollbar_policy")) {
            return 21;
        }
        return super.getEditorAttribute(attribute);
    }

    public void close() {
        super.close();
        this.getVHVControl().removePopupManager(this);
        this.getVHVControl().deinstall();
        this._vhvControl = null;
        this._toolbar.removeAll();
        this._toolbar.dispose();
        this._toolbar = null;
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VHVNode) {
                node.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        int openCount = 0;
        Iterator itr = EditorManager.getEditorManager().getAllEditors().iterator();
        while (itr.hasNext()) {
            if (!(itr.next() instanceof VHVViewer)) continue;
            ++openCount;
        }
        VHVPropertiesWindow dockable = VHVPropertiesWindow.getInstance();
        Ide.getDTCache().putBoolean(PROPERTIES_DTCACHE_KEY, dockable != null && DockStation.getDockStation().isDockableVisible((Dockable)dockable));
        if (dockable != null && openCount == 0) {
            DockStation.getDockStation().close((Dockable)dockable);
        }
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public ContextMenu getContextMenu() {
        return VHVController.getInstance().getContextMenu();
    }

    public Controller getController() {
        return VHVController.getInstance();
    }

    public Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._gui = new JPanel(new BorderLayout());
        this._gui.setLayout(this._cl);
        this._progressPanel = new ProgressPanel();
        this._progressPanel.setCancelEnabled(false);
        this._progressPanel.setCancelingText(VHVArb.getString(12));
        this._progressPanel.setLabelText(VHVArb.getString(78));
        this.initializeProgressPanel();
        this.getVHVControl().addPopupManager(this);
        this._gui.add((Component)this._progressPanel, "progress");
        this._gui.add((Component)this.getVHVControl(), "vhv");
        return this._gui;
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null && context instanceof Context) {
            context.setView((View)this);
        }
        return context;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new VHVToolbar(null);
        }
        return this._toolbar;
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        if (this.getContextMenu() != null) {
            this.getContextMenu().show(this.getContext(mouseEvent));
        }
    }

    public void hidePopup(BasicEditorPane editorPane) {
    }

    static LocalActionCache ra$_localActionCache(VHVViewer vHVViewer) {
        return vHVViewer._localActionCache;
    }

    static VHVQuery ra$_query(VHVViewer vHVViewer) {
        return vHVViewer._query;
    }

    static CardLayout ra$_cl(VHVViewer vHVViewer) {
        return vHVViewer._cl;
    }

    static ProgressPanel ra$_progressPanel(VHVViewer vHVViewer) {
        return vHVViewer._progressPanel;
    }

    static void wa$_inProgress(VHVViewer vHVViewer, boolean bl) {
        vHVViewer._inProgress = bl;
    }

    static void mav$_open(VHVViewer vHVViewer, boolean bl) {
        vHVViewer._open(bl);
    }

    static void mav$_openImpl(VHVViewer vHVViewer, boolean bl) {
        vHVViewer._openImpl(bl);
    }

    static void mav$initializeDiagramPaneOnRealization(VHVViewer vHVViewer) {
        vHVViewer.initializeDiagramPaneOnRealization();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            VHVViewer.ra$_query(VHVViewer.this).cancel();
        }
    }

    final class 2
    extends SwingWorker {
        private final /* synthetic */ boolean v$requery;
        final /* synthetic */ VHVViewer this$0;

        public Object construct() {
            VHVViewer.mav$_openImpl(this.this$0, this.v$requery);
            return null;
        }

        public void finished() {
            this.this$0.getVHVControl().setActionsSuspended(false);
            VHVViewer.ra$_cl(this.this$0).show((Container)this.this$0.getGUI(), "vhv");
            this.this$0.getVHVControl().requestFocusInWindow();
            this.this$0.getVHVControl().setScrollingEnabled(true);
            VHVViewer.wa$_inProgress(this.this$0, false);
            IdeAction.find((int)16).updateAction();
            VHVPropertiesWindow.updatePropertiesPanel();
        }

        public 2(VHVViewer vHVViewer, boolean bl) {
            this.v$requery = bl;
            this.this$0 = vHVViewer;
        }
    }

    final class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            VHVViewer.ra$_query(VHVViewer.this).invalidate();
            VHVViewer.ra$_cl(VHVViewer.this).show((Container)VHVViewer.this.getGUI(), "progress");
            VHVViewer.ra$_progressPanel(VHVViewer.this).requestFocusInWindow();
            VHVViewer.this.getVHVControl().resetScrollBars();
            VHVViewer.this.getVHVControl().setScrollingEnabled(false);
            VHVViewer.wa$_inProgress(VHVViewer.this, true);
            IdeAction.find((int)16).updateAction();
            VHVPropertiesWindow.updatePropertiesPanel();
            VHVViewer.mav$_open(VHVViewer.this, true);
        }
    }

    final class 4
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent event) {
            EventQueue.invokeLater(new 1());
            VHVViewer.this.getVHVControl().getVersionTreeDiagramPane().getGUI().removeAncestorListener(this);
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        final class 1
        implements Runnable {
            public void run() {
                VHVViewer.mav$initializeDiagramPaneOnRealization(VHVViewer.this);
            }
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            EditorManager.getEditorManager().closeEditors(Collections.singletonList(VHVViewer.this));
        }
    }

    private class VHVToolbar
    extends Toolbar {
        private void initialize(View view, VHVCustomizer customizer) {
            this.removeAll();
            if (HelpSystem.getHelpSystem() != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), VHVArb.getString(49));
            }
            this.add((ToggleAction)this.getLocalAction(51, view));
            if (customizer.getCheckOutAction() != null || customizer.getCheckInAction() != null || customizer.getUndoCheckoutAction() != null) {
                this.addSeparator();
            }
            if (customizer.getCheckOutAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getCheckOutAction().getCommandId(), view));
            }
            if (customizer.getCheckInAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getCheckInAction().getCommandId(), view));
            }
            if (customizer.getUndoCheckoutAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getUndoCheckoutAction().getCommandId(), view));
            }
            this.addSeparator();
            if (customizer.getComparePreviousCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID, view));
            }
            if (customizer.getCompareOtherCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_OTHER_CMD_ID, view));
            }
            if (customizer.getMergeCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_MERGE_CMD_ID, view));
            }
            if (customizer.getComparePreviousCommand() != null || customizer.getCompareOtherCommand() != null || customizer.getMergeCommand() != null) {
                this.addSeparator();
            }
            ToggleToolButton toggleToolButton = this.addToggleButton((ToggleAction)this.getLocalAction(VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID, view));
            toggleToolButton.setSelected(false);
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID, view));
            this.addSeparator();
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_IN_CMD_ID, view));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_OUT_CMD_ID, view));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID, view));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID, view));
            toggleToolButton = this.addToggleButton((ToggleAction)this.getLocalAction(VHVConstants.VHV_PAN_CMD_ID, view));
            toggleToolButton.setSelected(false);
            this.addSeparator();
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID, view));
        }

        protected IdeAction getLocalAction(int cmdId, View view) {
            return VHVViewer.ra$_localActionCache(VHVViewer.this).getLocalAction(cmdId);
        }

        private VHVToolbar() {
        }

        VHVToolbar(1 var2_2) {
            this();
        }

        static void mav$initialize(VHVToolbar vHVToolbar, View view, VHVCustomizer vHVCustomizer) {
            vHVToolbar.initialize(view, vHVCustomizer);
        }

        public final class 1 {
        }
    }
}

