/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import oracle.ide.vhv.model.BranchType;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.GraphElementVisitor;
import oracle.ide.vhv.model.HolderElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.RootBranchResource;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.model.VersionTreeElement;

public class BranchElement
extends GraphElement {
    private String m_shortLabel;
    private boolean m_frozen;
    private boolean m_locked;
    private boolean m_obsolete;
    private boolean m_private;

    BranchElement() {
    }

    BranchElement(VersionElement element) {
        super(element);
        if (element.getFromResource() instanceof RootBranchResource) {
            this.setChildElement(new HolderElement(element.getToResource()));
        } else {
            this.setParentElement(new HolderElement(element.getFromResource()));
            this.setChildElement(new HolderElement(element.getToResource()));
            this.setOwnerElement(new HolderElement(VersionTree.ROOT_BRANCH));
        }
        if (element.getType() == BranchType.FROZEN) {
            this.m_frozen = true;
        }
        if (element.getType() == BranchType.OBSOLETE) {
            this.m_obsolete = true;
        }
        if (element.getType() == BranchType.PRIVATE) {
            this.m_private = true;
        }
    }

    public String getShortLabel() {
        return this.m_shortLabel;
    }

    public void setShortLabel(String label) {
        this.m_shortLabel = label;
    }

    public boolean isFrozen() {
        return this.m_frozen;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public boolean isObsolete() {
        return this.m_obsolete;
    }

    public boolean isPrivate() {
        return this.m_private;
    }

    public boolean isRoot() {
        return this.getParentElement() instanceof VersionTreeElement;
    }

    public void validateElement(VersionTree tree) {
        super.validateElement(tree);
        if (this.getParentElement() == null && this.getOwnerElement() == null) {
            VersionTreeElement te = new VersionTreeElement(tree);
            this.setParentElement(te);
            this.setOwnerElement(te);
        }
    }

    Point getTopConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x + this.getWidth() / 2, location.y);
    }

    Point getRightConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x + this.getWidth(), location.y);
    }

    Point getBottomConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x + this.getWidth() / 2, location.y + this.getHeight());
    }

    Point getLeftConnectionPoint() {
        return (Point)this.getLocation().clone();
    }

    public void accept(GraphElementVisitor geVisitor) throws Exception {
        geVisitor.visitBranchElement(this);
    }

    public String getDisplayName(INameHelper nameHelper) {
        return nameHelper.getBranchName(this);
    }

    public String toString() {
        return "B: " + (this.getResource() == null ? null : this.getResource().toString());
    }
}

