/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.ElementKind;
import oracle.ide.vhv.model.GraphElementVisitor;
import oracle.ide.vhv.model.HolderElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.MergeList;
import oracle.ide.vhv.model.MergeTarget;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.resource.VHVArb;

public class CheckOutElement
extends ContextElement
implements MergeTarget {
    private int m_checkOutState;
    private MergeList m_targetMerges;

    private void $init$() {
        this.m_targetMerges = null;
    }

    CheckOutElement() {
        this.$init$();
    }

    CheckOutElement(VersionElement element) throws VHVResourceException {
        super(element);
        this.$init$();
        this.setOwnerElement(new HolderElement(this.getVersionableResource().getBranch()));
        this.setParentElement(new HolderElement(element.getFromResource()));
        if (element.getKind() == ElementKind.RESERVED_CHECKOUT) {
            this.m_checkOutState = 1;
        } else if (element.getKind() == ElementKind.UNRESERVED_CHECKOUT) {
            this.m_checkOutState = 2;
        }
    }

    public boolean isReservedCheckOut() {
        return this.m_checkOutState == 1;
    }

    public void setReservedCheckOut(int checkOutState) {
        this.m_checkOutState = checkOutState;
    }

    public boolean isUnreservedCheckOut() {
        return this.m_checkOutState == 2;
    }

    public boolean isMergeTarget() {
        return this.m_targetMerges != null;
    }

    public void addTargetMerge(MergeElement me) {
        if (this.m_targetMerges == null) {
            this.m_targetMerges = new MergeList();
        }
        this.m_targetMerges.add(me);
    }

    public MergeList getTargetMerges() {
        return this.m_targetMerges;
    }

    public void validateElement(VersionTree tree) {
        super.validateElement(tree);
        ((SuccessorElement)this.getParentElement()).addCheckOut(this);
    }

    Point getTopConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x, location.y - this.getHeight() / 2);
    }

    Point getRightConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x + this.getWidth() / 2, location.y);
    }

    Point getBottomConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x, location.y + this.getHeight() / 2);
    }

    Point getLeftConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x - this.getWidth() / 2, location.y);
    }

    public void accept(GraphElementVisitor geVisitor) throws Exception {
        geVisitor.visitCheckOutElement(this);
    }

    public String getDisplayName(INameHelper nameHelper) {
        SuccessorElement parent = (SuccessorElement)this.getParentElement();
        StringBuffer s = new StringBuffer();
        String name = nameHelper.getObjectName(this);
        if (name != null) {
            s.append(name);
        }
        s.append("{");
        s.append(nameHelper.getBranchName(this));
        s.append(";");
        try {
            s.append(parent.getVersionableResource().getVersionLabel());
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
        }
        s.append("} ");
        s.append("CO");
        return s.toString();
    }

    public String getDisplayVersion(INameHelper nameHelper) {
        SuccessorElement parent = (SuccessorElement)this.getParentElement();
        Object[] branchAndVersion = null;
        try {
            branchAndVersion = new String[]{nameHelper.getBranchName(this), parent.getVersionableResource().getVersionLabel()};
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
            branchAndVersion = new String[]{nameHelper.getBranchName(this), ""};
        }
        return VHVArb.format(88, branchAndVersion);
    }

    public String toString() {
        return "N: " + (this.getResource() == null ? null : this.getResource().toString());
    }

    public interface CheckOutState {
        public static final int RESERVED = 1;
        public static final int UNRESERVED = 2;
    }
}

