/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.GraphElementVisitor;
import oracle.ide.vhv.model.HolderElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.MergeSource;
import oracle.ide.vhv.model.MergeTarget;
import oracle.ide.vhv.model.MergeType;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTree;

public class MergeElement
extends GraphElement {
    private boolean m_isSystemMerge;
    private int m_childConnectionSide;

    MergeElement() {
    }

    MergeElement(VersionElement element) {
        super(element);
        this.setParentElement(new HolderElement(element.getFromResource()));
        this.setChildElement(new HolderElement(element.getToResource()));
        this.setOwnerElement(new HolderElement(element.getFromResource()));
        this.m_isSystemMerge = element.getType() == MergeType.SYSTEM;
    }

    public boolean isSystemMerge() {
        return this.m_isSystemMerge;
    }

    public void validateElement(VersionTree tree) {
        super.validateElement(tree);
        ((MergeSource)((Object)this.getParentElement())).addSourceMerge(this);
        ((MergeTarget)((Object)this.getChildElement())).addTargetMerge(this);
    }

    Point getTopConnectionPoint() {
        return null;
    }

    Point getRightConnectionPoint() {
        return null;
    }

    Point getBottomConnectionPoint() {
        return null;
    }

    Point getLeftConnectionPoint() {
        return null;
    }

    public int getChildConnectionSide() {
        return this.m_childConnectionSide;
    }

    void setChildConnectionSide(int side) {
        this.m_childConnectionSide = side;
    }

    public Point getChildConnectionPoint() {
        switch (this.m_childConnectionSide) {
            case 1: {
                return this.getChildElement().getTopConnectionPoint();
            }
            case 2: {
                return this.getChildElement().getRightConnectionPoint();
            }
            case 3: {
                return this.getChildElement().getBottomConnectionPoint();
            }
            case 4: {
                return this.getChildElement().getLeftConnectionPoint();
            }
        }
        return null;
    }

    public void accept(GraphElementVisitor geVisitor) throws Exception {
        geVisitor.visitMergeElement(this);
    }

    public String getDisplayName(INameHelper nameHelper) {
        SuccessorElement source = (SuccessorElement)this.getParentElement();
        StringBuffer s = new StringBuffer("{");
        s.append(nameHelper.getBranchName(source));
        s.append(";");
        try {
            s.append(source.getVersionableResource().getVersionNumber());
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
        }
        s.append("} ");
        GraphElement target = this.getChildElement();
        StringBuffer sTarget = new StringBuffer();
        if (target instanceof SuccessorElement) {
            sTarget.append("{");
            sTarget.append(nameHelper.getBranchName(target));
            sTarget.append(";");
            try {
                sTarget.append(((SuccessorElement)target).getVersionableResource().getVersionNumber());
            }
            catch (VHVResourceException re) {
                re.printStackTrace();
            }
            sTarget.append("} ");
        } else if (target instanceof CheckOutElement) {
            SuccessorElement parent = (SuccessorElement)this.getParentElement();
            sTarget.append("{");
            sTarget.append(nameHelper.getBranchName(target));
            sTarget.append(";");
            try {
                sTarget.append(parent.getVersionableResource().getVersionNumber());
            }
            catch (VHVResourceException re) {
                re.printStackTrace();
            }
            sTarget.append("} ");
            sTarget.append("CO");
        }
        s.append(" -> ").append(sTarget.toString());
        return s.toString();
    }

    public String toString() {
        return "M: " + this.getParentElement() + " -> " + this.getChildElement();
    }
}

