/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.rlog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.vhv.rlog.RlogModel;
import oracle.javatools.util.Version;

public class RlogFormat {
    private static final String LOG_SEPARATOR = "----------------------------";
    private static final String LOG_RULE = "===================================================================";
    private static final String NL = "([\\n\\r\\f\\s;]+)";
    private static final Pattern RE_LOG_SEPARATOR = Pattern.compile("----------------------------", 8);
    private static final Pattern RE_LOG_RULE = Pattern.compile("===================================================================", 8);
    private static final Pattern RE_REVISION = Pattern.compile("revision ([^\\t]*)([\\n\\r\\f\\s;]+)date: ([^;]*);([\\n\\r\\f\\s;]+)author: ([^;]*)([\\n\\r\\f\\s;]+)state: ([^;]*)([\\n\\r\\f\\s;]+)(lines: ([^\\n\\r\\f;]*))?([\\n\\r\\f\\s;]+)?(branches:(.*))?([\\n\\r\\f\\s;]+)?(kopt: ([^;]*))?([\\n\\r\\f\\s;]+)?(commitid: ([^;]*))?([\\n\\r\\f\\s;]+)?(filename: ([^;]*))?([\\n\\r\\f\\s;]+)?", 2);
    private static final int PAREN_REVISION = 1;
    private static final int PAREN_DATE = 3;
    private static final int PAREN_AUTHOR = 5;
    private static final int PAREN_STATE = 7;
    private static final int PAREN_LINES = 10;

    public RlogModel parse(Reader reader) throws IOException {
        String line;
        String line2;
        RlogModel model = new RlogModel();
        BufferedReader br = new BufferedReader(reader);
        HashMap<String, Version> tagsMap = new HashMap<String, Version>();
        boolean readingTags = false;
        while ((line2 = br.readLine()) != null && line2.indexOf(LOG_SEPARATOR) < 0) {
            if (line2.startsWith("RCS file: ")) {
                model.setRCSFile(line2.substring(9).trim());
                continue;
            }
            if (!readingTags) {
                if (line2.indexOf("symbolic names:") < 0) continue;
                readingTags = true;
                continue;
            }
            if (!line2.startsWith("\t")) break;
            int i = line2.indexOf(58);
            tagsMap.put(line2.substring(0, i).trim(), new Version(line2.substring(i + 1).trim()));
        }
        model.setSymbolicNames(tagsMap);
        StringBuffer logBuffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            logBuffer.append(line);
            logBuffer.append('\n');
        }
        String log = logBuffer.toString();
        String[] revisions = RE_LOG_SEPARATOR.split(log);
        ArrayList<RlogModel.Entry> entries = new ArrayList<RlogModel.Entry>();
        int i = 0;
        while (i < revisions.length) {
            RlogModel.Entry entry = new RlogModel.Entry();
            Matcher matcher = RE_REVISION.matcher(revisions[i]);
            if (matcher.find()) {
                String[] other;
                entry.setRevision(new Version(matcher.group(1).trim()));
                entry.setDate(this.parseDate(matcher.group(3).trim() + " GMT"));
                entry.setAuthor(matcher.group(5).trim());
                entry.setState(matcher.group(7).trim());
                String lines = matcher.group(10);
                if (lines != null) {
                    entry.setLines(lines.trim());
                }
                if ((other = RE_REVISION.split(revisions[i])).length > 0) {
                    entry.setMessage((other = RE_LOG_RULE.split(other[1])).length > 0 ? other[0] : "");
                }
                entries.add(entry);
            }
            ++i;
        }
        model.setEntries(entries.toArray(new RlogModel.Entry[0]));
        return model;
    }

    private Date parseDate(String dateToken) {
        try {
            Date date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z", Locale.US).parse(dateToken);
            return date;
        }
        catch (ParseException parseException) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US).parse(dateToken);
                return date;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                return new Date(0L);
            }
        }
    }
}

