/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.rlog;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vhv.VHVBranchResource;
import oracle.ide.vhv.VHVCheckoutResource;
import oracle.ide.vhv.VHVMergeResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionTree;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.rlog.RlogModel;

public class RlogVersionTree
extends VHVVersionTree {
    static final /* synthetic */ boolean $assertionsDisabled;

    private RlogVersionTree(VHVVersionableResource[] versionResources, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        super(versionResources, null, checkoutResource);
    }

    private RlogVersionTree(VHVVersionableResource[] versionResources, VHVMergeResource[] mergeResources, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        super(versionResources, mergeResources, checkoutResource);
    }

    static {
        $assertionsDisabled = RlogVersionTree.class.desiredAssertionStatus() ^ true;
    }

    public static final RlogVersionTree createVersionTree(URL url, String workareaName, RlogModel rlogModel, String viewRevision, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        HashMap<String, VHVVersionableResource> versionableResourceCache = new HashMap<String, VHVVersionableResource>();
        RlogModel.Entry[] entryArray = rlogModel.getEntries();
        int n = 0;
        while (n < entryArray.length) {
            RlogModel.Entry rlogEntry = entryArray[n];
            VHVVersionableResource versionableResource = new VHVVersionableResource();
            String revision = rlogEntry.getRevision().toString();
            versionableResource.setPath(rlogModel.getRCSFile() + "@@" + revision);
            versionableResource.setName(URLFileSystem.getFileName((URL)url));
            versionableResource.setNotes(rlogEntry.getMessage());
            versionableResource.setDate(rlogEntry.getDate());
            versionableResource.setUser(rlogEntry.getAuthor());
            versionableResource.setVersionLabel(revision);
            versionableResource.setVersionNumber((Comparable)rlogEntry.getRevision());
            versionableResource.setFirstVersionOnBranch(revision.endsWith(".1"));
            versionableResource.setWorkareaName(workareaName);
            if (viewRevision != null && revision.equals(viewRevision)) {
                versionableResource.setViewVersion(true);
            }
            versionableResourceCache.put(revision, versionableResource);
            ++n;
        }
        HashMap<String, VHVBranchResource> branchResourceCache = new HashMap<String, VHVBranchResource>();
        for (Map.Entry entry : versionableResourceCache.entrySet()) {
            String parentRevision = RlogVersionTree.getParentRevisionNumber(entry.getKey().toString());
            if (!$assertionsDisabled && parentRevision == null) {
                throw new AssertionError();
            }
            VHVBranchResource parentResource = (VHVBranchResource)branchResourceCache.get(parentRevision);
            if (parentResource == null) {
                parentResource = new VHVBranchResource();
                parentResource.setName(parentRevision);
                branchResourceCache.put(parentRevision, parentResource);
            }
            ((VHVVersionableResource)entry.getValue()).setBranch(parentResource);
        }
        for (Map.Entry entry : branchResourceCache.entrySet()) {
            String parentRevision = RlogVersionTree.getParentRevisionNumber(((String)entry.getKey()).toString());
            if (parentRevision == null) continue;
            VHVVersionableResource parentResource = (VHVVersionableResource)versionableResourceCache.get(parentRevision);
            if (!$assertionsDisabled && parentResource == null) {
                throw new AssertionError();
            }
            ((VHVBranchResource)entry.getValue()).setSource(parentResource);
        }
        RlogVersionTree versionTree = new RlogVersionTree(versionableResourceCache.values().toArray(new VHVVersionableResource[0]), checkoutResource);
        for (VHVVersionableResource versionableResource : versionableResourceCache.values()) {
            versionableResource.setVersionTree(versionTree);
        }
        return versionTree;
    }

    private static final String getParentRevisionNumber(String revision) {
        int i = revision.lastIndexOf(46);
        return i >= 0 ? revision.substring(0, i) : null;
    }
}

