/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.BranchList;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.VersionTreeDiagram;

public class BranchShape
extends GraphShape {
    Rectangle2D m_shape;

    BranchShape(String label, Point location, int width, int height, GraphShape parent, int connectionSide, GraphElement clientObject) {
        super(label, parent, connectionSide, clientObject);
        this.m_shape = new Rectangle2D.Double(location.x, location.y, width, height);
    }

    public String getToolTipText() {
        try {
            String string = VHVArb.format(55, new String[]{this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paint(Graphics2D g, boolean paintText) {
        if (g.getClip().intersects(this.getBounds2D())) {
            Color c = VersionTreeDiagram.getHidingChildrenNodeColor() != null && this.isHidingChildren() ? VersionTreeDiagram.getHidingChildrenNodeColor() : VersionTreeDiagram.getDefaultBranchColor();
            g.setColor(c);
            g.fill(this.m_shape);
            g.setColor(Color.black);
            if (this.isHighlighted()) {
                g.setStroke(new BasicStroke(3.0f));
            }
            g.draw(this.m_shape);
            g.setStroke(new BasicStroke(1.0f));
            if (this.isSelected()) {
                g.setStroke(new BasicStroke(2.0f));
                GeneralPath gp = new GeneralPath();
                double size = (this.m_shape.getMaxY() - this.m_shape.getMinY()) / 6.0;
                gp.moveTo((float)this.m_shape.getMinX() - 3.0f, (float)(this.m_shape.getMinY() - 3.0 + size));
                gp.lineTo((float)this.m_shape.getMinX() - 3.0f, (float)this.m_shape.getMinY() - 3.0f);
                gp.lineTo((float)(this.m_shape.getMinX() - 3.0 + size), (float)this.m_shape.getMinY() - 3.0f);
                gp.moveTo((float)this.m_shape.getMaxX() + 3.0f, (float)(this.m_shape.getMinY() - 3.0 + size));
                gp.lineTo((float)this.m_shape.getMaxX() + 3.0f, (float)this.m_shape.getMinY() - 3.0f);
                gp.lineTo((float)(this.m_shape.getMaxX() + 3.0 - size), (float)this.m_shape.getMinY() - 3.0f);
                gp.moveTo((float)this.m_shape.getMaxX() + 3.0f, (float)(this.m_shape.getMaxY() + 3.0 - size));
                gp.lineTo((float)this.m_shape.getMaxX() + 3.0f, (float)this.m_shape.getMaxY() + 3.0f);
                gp.lineTo((float)(this.m_shape.getMaxX() + 3.0 - size), (float)this.m_shape.getMaxY() + 3.0f);
                gp.moveTo((float)this.m_shape.getMinX() - 3.0f, (float)(this.m_shape.getMaxY() + 3.0 - size));
                gp.lineTo((float)this.m_shape.getMinX() - 3.0f, (float)this.m_shape.getMaxY() + 3.0f);
                gp.lineTo((float)(this.m_shape.getMinX() - 3.0 + size), (float)this.m_shape.getMaxY() + 3.0f);
                g.draw(gp);
                g.setStroke(new BasicStroke(1.0f));
            }
            if (paintText) {
                g.setFont(VersionTreeDiagram.getDisplayFont());
                Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(this.getLabel(), g);
                int labelWidth = (int)Math.round(Math.ceil(labelBounds.getWidth()));
                int labelHeight = (int)Math.round(Math.floor(g.getFontMetrics().getLineMetrics(this.getLabel(), g).getAscent() - g.getFontMetrics().getLineMetrics(this.getLabel(), g).getLeading()));
                g.setFont(VersionTreeDiagram.getDisplayFont());
                if (BranchShape.isDarkColor(c)) {
                    g.setColor(Color.white);
                }
                int x = (int)Math.round(this.m_shape.getCenterX() - (double)(labelWidth / 2));
                int y = (int)Math.round(this.m_shape.getCenterY() + (double)(labelHeight / 2));
                g.drawString(this.getLabel(), x, y);
            }
        }
        if (this.getParentShape() != null) {
            g.setColor(Color.black);
            Point2D cp = this.getLeftConnectionPoint();
            Point2D pcp = this.getConnectionPoint();
            Line2D.Double line = new Line2D.Double(cp, pcp);
            if (g.getClip().getBounds2D().intersectsLine(line)) {
                g.draw(line);
            }
        }
        if (this.isHidingChildren()) {
            this.paintStub(g);
        }
    }

    public void move(double dX, double dY) {
        this.m_shape.setFrame(this.m_shape.getX() + dX, this.m_shape.getY() + dY, this.m_shape.getWidth(), this.m_shape.getHeight());
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.m_shape.getMinX(), this.m_shape.getMinY());
    }

    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    public Rectangle2D getBounds2D() {
        int border = 5;
        if (this.isSelected()) {
            border = 9;
        }
        double minX = this.m_shape.getMinX() - (double)border;
        double minY = this.m_shape.getMinY() - (double)border;
        double maxX = this.m_shape.getMaxX() + (double)border;
        double maxY = this.m_shape.getMaxY() + (double)border;
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public Rectangle2D getTotalBounds2D() {
        Rectangle2D bounds = this.getBounds2D();
        BranchElement be = (BranchElement)this.getGraphElement();
        if (this.getConnectionPoint() != null) {
            bounds.add(this.getConnectionPoint());
        }
        if (be.getDisplayedChildElement() != null) {
            bounds.add(be.getDisplayedChildElement().getShape().getTopConnectionPoint());
        }
        return bounds;
    }

    public ArrayList select(boolean shiftDown) {
        this.m_isSelected = true;
        ArrayList<GraphShape> result = new ArrayList<GraphShape>();
        result.add(this);
        if (shiftDown) {
            GraphElement ge = this.getGraphElement();
            while (ge.getDisplayedChildElement() != null) {
                CheckOutElement co;
                GraphShape gs = (GraphShape)(ge = ge.getDisplayedChildElement()).getShape();
                if (gs != null) {
                    result.add(gs);
                    gs.select();
                }
                if (!(ge instanceof SuccessorElement) || (co = ((SuccessorElement)ge).getReservedCheckOut()) == null || (gs = (GraphShape)co.getShape()) == null) continue;
                result.add(gs);
                gs.select();
            }
        }
        return result;
    }

    public Point2D getTopConnectionPoint() {
        return new Point2D.Double(Math.floor(this.m_shape.getCenterX()), this.m_shape.getMinY());
    }

    public Point2D getBottomConnectionPoint() {
        return new Point2D.Double(Math.floor(this.m_shape.getCenterX()), this.m_shape.getMaxY());
    }

    public Point2D getLeftConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMinX(), this.m_shape.getMinY());
    }

    public Point2D getRightConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMaxX(), this.m_shape.getMinY());
    }

    public int getScrollX() {
        return (int)Math.ceil(this.m_shape.getMaxX() + 32.0);
    }

    public int getScrollY() {
        return (int)Math.ceil(this.m_shape.getMaxY() + 32.0);
    }

    public GraphShape getRight() {
        if (!((BranchElement)this.getGraphElement()).isRoot()) {
            SuccessorElement se;
            GraphElement next = se = (SuccessorElement)this.getGraphElement().getParentElement();
            BranchList branches = se.getBranches();
            BranchElement be = null;
            ListIterator i = branches.listIterator();
            while (i.hasNext()) {
                i.next();
            }
            while (i.hasPrevious()) {
                be = ((Branch)i.previous()).getBranchElement();
                if (be.equals(this.getGraphElement())) break;
                next = be;
            }
            return (GraphShape)next.getShape();
        }
        return this;
    }

    public GraphShape getLeft() {
        if (!((BranchElement)this.getGraphElement()).isRoot()) {
            SuccessorElement se;
            GraphElement prev = se = (SuccessorElement)this.getGraphElement().getParentElement();
            BranchList branches = se.getBranches();
            Iterator i = branches.iterator();
            while (i.hasNext()) {
                BranchElement be = ((Branch)i.next()).getBranchElement();
                if (be.equals(this.getGraphElement())) break;
                prev = be;
            }
            return (GraphShape)prev.getShape();
        }
        return this;
    }
}

