/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.util.ArrayList;
import oracle.ide.vhv.view.BranchShape;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.MergeShape;
import oracle.ide.vhv.view.ReservedCheckOutShape;
import oracle.ide.vhv.view.SuccessorShape;
import oracle.ide.vhv.view.UnreservedCheckOutShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrawList
extends ArrayList {
    private static final int DRAW_ORDER_MRG = 5;
    private static final int DRAW_ORDER_RCO = 4;
    private static final int DRAW_ORDER_UCO = 3;
    private static final int DRAW_ORDER_SUC = 2;
    private static final int DRAW_ORDER_BRN = 1;
    private static final int DRAW_ORDER_DFLT = 0;

    @Override
    public boolean add(GraphShape gs) {
        int drawOrder = this.getDrawOrder(gs);
        int i = 0;
        i = 0;
        while (i < this.size()) {
            GraphShape current = (GraphShape)this.get(i);
            if (drawOrder < this.getDrawOrder(current)) break;
            ++i;
        }
        this.add(i, gs);
        return true;
    }

    private int getDrawOrder(GraphShape gs) {
        int drawOrder = 0;
        if (gs instanceof MergeShape) {
            drawOrder = 5;
        } else if (gs instanceof ReservedCheckOutShape) {
            drawOrder = 4;
        } else if (gs instanceof UnreservedCheckOutShape) {
            drawOrder = 3;
        } else if (gs instanceof SuccessorShape) {
            drawOrder = 2;
        } else if (gs instanceof BranchShape) {
            drawOrder = 1;
        }
        return drawOrder;
    }

    DrawList() {
    }
}

