/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.GraphElementShape;

public abstract class GraphShape
extends GraphElementShape {
    static int STUB_MARK_SIZE = 6;
    static int STUB_SIZE = 8;
    boolean m_isSelected;
    boolean m_isHighlighted;
    private boolean m_isHiding;
    private boolean m_isHidingChildren;

    private void $init$() {
        this.m_isSelected = false;
        this.m_isHighlighted = false;
        this.m_isHiding = false;
        this.m_isHidingChildren = false;
    }

    GraphShape(String label, GraphShape parent, int connectionSide, GraphElement clientObject) {
        super(label, parent, connectionSide, clientObject);
        this.$init$();
    }

    public ArrayList select(boolean shiftDown) {
        this.select();
        ArrayList<GraphShape> result = new ArrayList<GraphShape>();
        result.add(this);
        return result;
    }

    public void select() {
        this.m_isSelected = true;
    }

    public void deselect() {
        this.m_isSelected = false;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void highlight() {
        this.m_isHighlighted = true;
    }

    public void dehighlight() {
        this.m_isHighlighted = false;
    }

    public boolean isHighlighted() {
        return this.m_isHighlighted;
    }

    public boolean isMoveable() {
        return true;
    }

    public boolean isHiding() {
        return this.m_isHiding;
    }

    void setHiding(boolean hiding) {
        this.m_isHiding = hiding;
    }

    public boolean isHidingChildren() {
        return this.m_isHidingChildren;
    }

    void setHidingChildren(boolean hidingChildren) {
        this.m_isHidingChildren = hidingChildren;
    }

    public String getToolTipText() {
        return null;
    }

    void paintStub(Graphics2D g) {
        Point2D cp = this.getBottomConnectionPoint();
        Line2D.Double line = new Line2D.Double(cp.getX(), cp.getY(), cp.getX(), cp.getY() + (double)STUB_SIZE);
        g.draw(line);
        this.paintStubMark(g, new Point2D.Double(cp.getX(), cp.getY() + (double)STUB_SIZE));
    }

    void paintStubMark(Graphics2D g, Point2D location) {
        Ellipse2D.Double mark = new Ellipse2D.Double(location.getX() - (double)(STUB_MARK_SIZE / 2), location.getY() - (double)(STUB_MARK_SIZE / 2), STUB_MARK_SIZE, STUB_MARK_SIZE);
        g.draw(mark);
    }

    public abstract void paint(Graphics2D var1, boolean var2);

    public abstract Shape getShape();

    public abstract Rectangle2D getBounds2D();

    public abstract Rectangle2D getTotalBounds2D();

    public abstract boolean contains(double var1, double var3);

    public abstract void move(double var1, double var3);

    public abstract int getScrollX();

    public abstract int getScrollY();

    public double getWidth() {
        return this.getGraphElement().getWidth();
    }

    public double getHeight() {
        return this.getGraphElement().getHeight();
    }

    public GraphShape getAbove() {
        if (this.getGraphElement().getDisplayedParentElement() != null) {
            return (GraphShape)this.getGraphElement().getDisplayedParentElement().getShape();
        }
        return this;
    }

    public GraphShape getBelow() {
        if (this.getGraphElement().getDisplayedChildElement() != null) {
            return (GraphShape)this.getGraphElement().getDisplayedChildElement().getShape();
        }
        return this;
    }

    public GraphShape getRight() {
        return this;
    }

    public GraphShape getLeft() {
        return this;
    }
}

