/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.BranchList;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.CheckOutList;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.MergeList;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.BranchShape;
import oracle.ide.vhv.view.DrawList;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.MergeShape;
import oracle.ide.vhv.view.ReservedCheckOutShape;
import oracle.ide.vhv.view.SuccessorShape;
import oracle.ide.vhv.view.UnreservedCheckOutShape;
import oracle.ide.vhv.view.VHVControl;

public class VersionTreeDiagram {
    private VersionTree m_tree;
    private static Font FONT = new Font("SansSerif", 0, 12);
    private static FontMetrics FONT_METRICS;
    private static Color m_defaultNodeColor;
    private static Color m_majorNodeColor;
    private static Color m_leafNodeColor;
    private static Color m_inContextNodeColor;
    private static Color m_reservedCheckOutNodeColor;
    private static Color m_unreservedCheckOutNodeColor;
    private static Color m_defaultBranchColor;
    private static Color m_manualMergeColor;
    private static Color m_systemMergeColor;
    private static Color m_hidingChildrenNodeColor;
    private DrawList m_shapes;
    private Dimension m_preferredSize;
    private boolean m_rememberChildHiding;
    private ArrayList m_mergesToValidate;
    private static String CHECKOUT_LABEL;

    private void $init$() {
        this.m_tree = null;
        this.m_shapes = new DrawList();
        this.m_preferredSize = new Dimension(0, 0);
        this.m_rememberChildHiding = true;
        this.m_mergesToValidate = null;
    }

    static {
        m_defaultNodeColor = VHVControl.NODE_COLOR;
        m_majorNodeColor = VHVControl.MAJOR_NODE_COLOR;
        m_leafNodeColor = VHVControl.LEAF_NODE_COLOR;
        m_inContextNodeColor = VHVControl.IN_CONTEXT_NODE_COLOR;
        m_reservedCheckOutNodeColor = VHVControl.RESERVED_CHECKOUT_NODE_COLOR;
        m_unreservedCheckOutNodeColor = VHVControl.UNRESERVED_CHECKOUT_NODE_COLOR;
        m_defaultBranchColor = VHVControl.BRANCH_COLOR;
        m_manualMergeColor = VHVControl.NON_REPOSITORY_MERGE_COLOR;
        m_systemMergeColor = VHVControl.REPOSITORY_MERGE_COLOR;
        m_hidingChildrenNodeColor = Color.gray;
        JPanel jp = new JPanel();
        FONT_METRICS = jp.getFontMetrics(FONT);
        CHECKOUT_LABEL = VHVArb.getString(71);
    }

    public VersionTreeDiagram() {
        this.$init$();
    }

    public VersionTreeDiagram(VersionTree tree) {
        this.$init$();
        this.m_tree = tree;
        this.populateDiagram();
    }

    public VersionTree getVersionTree() {
        return this.m_tree;
    }

    public void setVersionTree(VersionTree tree) {
        this.m_tree = tree;
        this.clearDiagram();
        this.populateDiagram();
    }

    public void requery() throws VHVResourceException {
        VersionTree tree = this.getVersionTree().requery();
        this.setVersionTree(tree);
    }

    public void setInContextVersion(ContextElement ce) {
        if (this.m_tree.setInContextVersion(ce)) {
            this.clearDiagram();
            this.populateDiagram();
        }
    }

    public void setInContextVersion(VHVResource resource) {
        if (this.m_tree.setInContextVersion(resource)) {
            this.clearDiagram();
            this.populateDiagram();
        }
    }

    public static int getStringWidth(String string) {
        return FONT_METRICS.stringWidth(string);
    }

    public static int getStringHeight() {
        return FONT_METRICS.getHeight();
    }

    public static void setDisplayFont(Font f) {
        FONT = f;
        JPanel jp = new JPanel();
        FONT_METRICS = jp.getFontMetrics(FONT);
    }

    public static Font getDisplayFont() {
        return FONT;
    }

    public static void setLeafNodeColor(Color c) {
        m_leafNodeColor = c;
    }

    public static Color getLeafNodeColor() {
        return m_leafNodeColor;
    }

    public static void setMajorNodeColor(Color c) {
        m_majorNodeColor = c;
    }

    public static Color getMajorNodeColor() {
        return m_majorNodeColor;
    }

    public static void setReservedCheckOutNodeColor(Color c) {
        m_reservedCheckOutNodeColor = c;
    }

    public static Color getReservedCheckOutNodeColor() {
        return m_reservedCheckOutNodeColor;
    }

    public static void setUnreservedCheckOutNodeColor(Color c) {
        m_unreservedCheckOutNodeColor = c;
    }

    public static Color getUnreservedCheckOutNodeColor() {
        return m_unreservedCheckOutNodeColor;
    }

    public static void setHidingChildrenNodeColor(Color c) {
        m_hidingChildrenNodeColor = c;
    }

    public static Color getHidingChildrenNodeColor() {
        return m_hidingChildrenNodeColor;
    }

    public static void setDefaultNodeColor(Color c) {
        m_defaultNodeColor = c;
    }

    public static Color getDefaultNodeColor() {
        return m_defaultNodeColor;
    }

    public static void setDefaultBranchColor(Color c) {
        m_defaultBranchColor = c;
    }

    public static Color getDefaultBranchColor() {
        return m_defaultBranchColor;
    }

    public static void setSystemMergeColor(Color c) {
        m_systemMergeColor = c;
    }

    public static Color getSystemMergeColor() {
        return m_systemMergeColor;
    }

    public static void setManualMergeColor(Color c) {
        m_manualMergeColor = c;
    }

    public static Color getManualMergeColor() {
        return m_manualMergeColor;
    }

    public static void setInContextNodeColor(Color c) {
        m_inContextNodeColor = c;
    }

    public static Color getInContextNodeColor() {
        return m_inContextNodeColor;
    }

    BranchShape addBranchShape(String label, Point location, int width, int height, GraphShape parent, int connectionSide, GraphElement graphElement) {
        BranchShape bs = new BranchShape(label, location, width, height, parent, connectionSide, graphElement);
        this.addShape(bs);
        return bs;
    }

    SuccessorShape addSuccessorShape(String label, Point location, int size, GraphShape parent, int connectionSide, GraphElement graphElement) {
        SuccessorShape ss = new SuccessorShape(label, location, size, parent, connectionSide, graphElement);
        this.addShape(ss);
        return ss;
    }

    MergeShape addMergeShape(String label, GraphShape parent, int parentConnectionSide, GraphShape child, int childConnectionSide, GraphElement graphElement) {
        MergeShape ms = new MergeShape(label, parent, parentConnectionSide, child, childConnectionSide, graphElement);
        this.addShape(ms);
        return ms;
    }

    ReservedCheckOutShape addReservedCheckOutShape(String label, Point location, int size, GraphShape parent, int connectionSide, GraphElement graphElement) {
        ReservedCheckOutShape ss = new ReservedCheckOutShape(label, location, size, parent, connectionSide, graphElement);
        this.addShape(ss);
        return ss;
    }

    UnreservedCheckOutShape addUnreservedCheckOutShape(String label, Point location, int size, GraphShape parent, int connectionSide, GraphElement graphElement) {
        UnreservedCheckOutShape ss = new UnreservedCheckOutShape(label, location, size, parent, connectionSide, graphElement);
        this.addShape(ss);
        return ss;
    }

    void addShape(GraphShape shape) {
        this.m_shapes.add(shape);
    }

    public void showAllNodes() {
        if (this.m_tree.showAllNodes()) {
            this.defaultLayout();
        }
    }

    public void showMajorNodes() {
        if (this.m_tree.showMajorNodes()) {
            this.defaultLayout();
        }
    }

    public void toggleAllNodesMajorNodes() {
        this.m_tree.toggleAllNodesMajorNodes();
        this.defaultLayout();
    }

    public boolean isShowingAllNodes() {
        return this.m_tree.isShowingAllNodes();
    }

    private void clearDiagram() {
        Iterator i = this.m_shapes.iterator();
        while (i.hasNext()) {
            ((GraphShape)i.next()).getGraphElement().setShape(null);
        }
        this.m_shapes = new DrawList();
    }

    private void populateDiagram() {
        this.addGraphShape(this.m_tree.getRootElement());
        this.validateMerges();
        this.m_preferredSize = new Dimension(this.m_tree.getMaxX(), this.m_tree.getMaxY());
    }

    public void defaultLayout() {
        this.clearDiagram();
        this.populateDiagram();
    }

    private void addGraphShape(GraphElement ge) {
        if (ge instanceof SuccessorElement) {
            this.addGraphShape((SuccessorElement)ge);
        } else if (ge instanceof BranchElement) {
            this.addGraphShape((BranchElement)ge);
        } else if (ge instanceof MergeElement) {
            this.addGraphShape((MergeElement)ge);
        }
    }

    private void addGraphShape(BranchElement be) {
        String branchName;
        try {
            branchName = be.getResource().getName();
        }
        catch (VHVResourceException e) {
            branchName = "Unable to find branch name";
        }
        BranchShape node = this.addBranchShape(branchName, be.getLocation(), be.getWidth(), be.getHeight(), be.isRoot() ? null : (GraphShape)be.getDisplayedParentElement().getShape(), be.isRoot() ? 0 : 2, be);
        be.setShape(node);
        this.addGraphShape(be.getDisplayedChildElement());
    }

    private void addGraphShape(SuccessorElement se) {
        MergeList merges;
        BranchList branches;
        CheckOutList col;
        String versionNumber = null;
        try {
            versionNumber = se.getVersionableResource().getVersionLabel();
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
            return;
        }
        SuccessorShape node = this.addSuccessorShape(versionNumber, se.getLocation(), 24, (GraphShape)se.getDisplayedParentElement().getShape(), se.getConnectionSide(), se);
        se.setShape(node);
        CheckOutElement co = se.getReservedCheckOut();
        if (co != null) {
            this.addGraphShape(co);
        }
        if ((col = se.getUnreservedCheckOuts()) != null) {
            int i = 1;
            while (i <= col.size()) {
                this.addGraphShape((CheckOutElement)col.get(col.size() - i));
                ++i;
            }
        }
        if ((branches = se.getBranches()) != null) {
            Iterator i = branches.iterator();
            while (i.hasNext()) {
                this.addGraphShape(((Branch)i.next()).getBranchElement());
            }
        }
        if ((merges = se.getSourceMerges()) != null) {
            Iterator i = merges.iterator();
            while (i.hasNext()) {
                this.addGraphShape((MergeElement)i.next());
            }
        }
        this.addGraphShape(se.getDisplayedChildElement());
    }

    private void addGraphShape(MergeElement me) {
        MergeShape node = this.addMergeShape("", (GraphShape)me.getDisplayedParentElement().getShape(), me.getConnectionSide(), (GraphShape)me.getDisplayedChildElement().getShape(), me.getChildConnectionSide(), me);
        me.setShape(node);
        this.addMergeShapeForValidation(node);
    }

    private void addMergeShapeForValidation(MergeShape ms) {
        if (this.m_mergesToValidate == null) {
            this.m_mergesToValidate = new ArrayList();
        }
        this.m_mergesToValidate.add(ms);
    }

    private void validateMerges() {
        if (this.m_mergesToValidate != null) {
            for (MergeShape ms : this.m_mergesToValidate) {
                if (ms.getChildShape() == null) {
                    ms.setChildShape((GraphShape)ms.getGraphElement().getDisplayedChildElement().getShape());
                }
                if (ms.getParentShape() != null) continue;
                ms.setParentShape((GraphShape)ms.getGraphElement().getDisplayedParentElement().getShape());
            }
            this.m_mergesToValidate = null;
        }
    }

    private void addGraphShape(CheckOutElement coe) {
        GraphShape node = coe.isReservedCheckOut() ? this.addReservedCheckOutShape(CHECKOUT_LABEL, coe.getLocation(), coe.getWidth(), (GraphShape)coe.getDisplayedParentElement().getShape(), coe.getConnectionSide(), coe) : this.addUnreservedCheckOutShape(CHECKOUT_LABEL, coe.getLocation(), coe.getWidth(), (GraphShape)coe.getDisplayedParentElement().getShape(), coe.getConnectionSide(), coe);
        coe.setShape(node);
    }

    public void hideChildren(GraphElement ge) {
        this.hideChildren((GraphShape)ge.getShape(), true);
    }

    private void hideChildren(GraphElement ge, boolean setFlag) {
        this.hideChildren((GraphShape)ge.getShape(), setFlag);
    }

    public void hideChildren(GraphShape gs) {
        this.hideChildren(gs, true);
    }

    private void hideChildren(GraphShape gs, boolean setFlag) {
        if (gs instanceof SuccessorShape) {
            this.hideChildren((SuccessorShape)gs, setFlag);
        } else if (gs instanceof BranchShape) {
            this.hideChildren((BranchShape)gs, setFlag);
        }
    }

    public void hideChildren(SuccessorShape ss) {
        this.hideChildren(ss, true);
    }

    private void hideChildren(SuccessorShape ss, boolean setFlag) {
        GraphElement child;
        CheckOutElement coe;
        SuccessorElement se = (SuccessorElement)ss.getGraphElement();
        BranchList branches = se.getBranches();
        if (branches != null) {
            Iterator i = branches.iterator();
            while (i.hasNext()) {
                BranchElement be = ((Branch)i.next()).getBranchElement();
                this.hide(be);
                this.hideChildren(be, false);
            }
        }
        if ((coe = se.getReservedCheckOut()) != null) {
            this.hide(coe);
        }
        if ((child = se.getDisplayedChildElement()) != null) {
            this.hide(child);
            this.hideChildren(child, false);
        }
        if (setFlag) {
            ss.setHidingChildren(true);
        }
    }

    public void hideChildren(BranchShape bs) {
        this.hideChildren(bs, true);
    }

    private void hideChildren(BranchShape bs, boolean setFlag) {
        GraphElement child = bs.getGraphElement().getDisplayedChildElement();
        this.hide(child);
        this.hideChildren(child, false);
        if (setFlag) {
            bs.setHidingChildren(true);
        }
    }

    private void hide(GraphElement ge) {
        this.hide((GraphShape)ge.getShape());
    }

    private void hide(GraphShape gs) {
        this.m_shapes.remove(gs);
        gs.setHiding(true);
    }

    public void showChildren(GraphElement ge) {
        this.showChildren(ge, true);
    }

    private void showChildren(GraphElement ge, boolean resetFlag) {
        this.showChildren((GraphShape)ge.getShape(), resetFlag);
    }

    public void showChildren(GraphShape gs) {
        this.showChildren(gs, true);
    }

    private void showChildren(GraphShape gs, boolean setFlag) {
        if (gs instanceof SuccessorShape) {
            this.showChildren((SuccessorShape)gs, setFlag);
        } else if (gs instanceof BranchShape) {
            this.showChildren((BranchShape)gs, setFlag);
        }
    }

    public void showChildren(SuccessorShape ss) {
        this.showChildren(ss, true);
    }

    private void showChildren(SuccessorShape ss, boolean resetFlag) {
        GraphElement child;
        CheckOutElement coe;
        if (this.isChildHidingRemembered() && ss.isHidingChildren() && !resetFlag) {
            return;
        }
        SuccessorElement se = (SuccessorElement)ss.getGraphElement();
        BranchList branches = se.getBranches();
        if (branches != null) {
            Iterator i = branches.iterator();
            while (i.hasNext()) {
                BranchElement be = ((Branch)i.next()).getBranchElement();
                this.show(be);
                this.showChildren(be, this.isChildHidingRemembered() ^ true);
            }
        }
        if ((coe = se.getReservedCheckOut()) != null) {
            this.show(coe);
        }
        if ((child = se.getDisplayedChildElement()) != null) {
            this.show(child);
            this.showChildren(child, this.isChildHidingRemembered() ^ true);
        }
        ss.setHidingChildren(false);
    }

    public void showChildren(BranchShape bs) {
        this.showChildren(bs, true);
    }

    private void showChildren(BranchShape bs, boolean resetFlag) {
        if (bs.isHidingChildren() && !resetFlag) {
            return;
        }
        GraphElement child = bs.getGraphElement().getDisplayedChildElement();
        this.show(child);
        this.showChildren(child, this.isChildHidingRemembered() ^ true);
        bs.setHidingChildren(false);
    }

    private void show(GraphElement ge) {
        this.show((GraphShape)ge.getShape());
    }

    private void show(GraphShape gs) {
        this.m_shapes.add(gs);
        gs.setHiding(false);
    }

    public void paint(Graphics2D g, boolean paintText) {
        try {
            for (GraphShape gs : this.m_shapes) {
                gs.paint(g, paintText);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public GraphShape getGraphShape(double x, double y) {
        GraphShape selected = null;
        ListIterator i = this.m_shapes.listIterator();
        while (i.hasNext()) {
            i.next();
        }
        while (i.hasPrevious()) {
            GraphShape gs = (GraphShape)i.previous();
            if (!gs.contains(x, y)) continue;
            selected = gs;
            break;
        }
        return selected;
    }

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.m_preferredSize = preferredSize;
    }

    public void setRememberChildHiding(boolean hiding) {
        this.m_rememberChildHiding = hiding;
    }

    public boolean isChildHidingRemembered() {
        return this.m_rememberChildHiding;
    }

    public List getShapeList() {
        return this.m_shapes;
    }
}

