/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.SelectionMode;
import oracle.ide.vhv.view.VersionTreeDiagram;
import oracle.ide.vhv.view.VersionTreeDiagramEvent;
import oracle.ide.vhv.view.VersionTreeDiagramListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionTreeDiagramPane {
    public static final double MIN_DEFAULT_ZOOM = 1.0;
    private VersionTreeDiagram _diagram;
    private double _zoom;
    private ArrayList<GraphShape> _selected;
    private GraphShape _highlighted;
    private ArrayList _scrollBarAdjustmentListeners;
    private static final double ZOOM_FACTOR = 1.2;
    private static final double MIN_ZOOM_FOR_TEXT = 0.25;
    static final double MAX_ZOOM = 32.0;
    static final double MIN_ZOOM = 0.03125;
    private static final int SCROLL_RIGHT = 1;
    private static final int SCROLL_LEFT = 2;
    private static final int SCROLL_DOWN = 4;
    private static final int SCROLL_UP = 8;
    private static final int HOT_ZONE = 30;
    private boolean _useAntialiasing;
    private boolean _useAlphaBlending;
    private boolean _isSelectionEnabled;
    private VersionTreeDiagramPanel _panel;
    private final JScrollBar _hScrollBar;
    private final JScrollBar _vScrollBar;
    private JViewport _viewport;
    private AdjustmentListener _scrollBarAdjustmentListener;

    private void $init$() {
        this._zoom = 1.0;
        this._selected = new ArrayList();
        this._highlighted = null;
        this._scrollBarAdjustmentListeners = new ArrayList();
        this._useAntialiasing = true;
        this._useAlphaBlending = false;
        this._isSelectionEnabled = true;
        this._panel = new VersionTreeDiagramPanel();
        this._viewport = new JViewport();
    }

    public VersionTreeDiagramPane(VersionTree tree) {
        this(tree, new JScrollBar(0), new JScrollBar(1));
    }

    public VersionTreeDiagramPane(VersionTree tree, JScrollBar hScrollBar, JScrollBar vScrollBar) {
        this.$init$();
        this._diagram = new VersionTreeDiagram(tree);
        this._viewport.setView(this._panel);
        this._viewport.setScrollMode(0);
        this._hScrollBar = hScrollBar;
        this._vScrollBar = vScrollBar;
        this._hScrollBar.setUnitIncrement(20);
        this._vScrollBar.setUnitIncrement(20);
        this._hScrollBar.setBlockIncrement(50);
        this._vScrollBar.setBlockIncrement(50);
        this._hScrollBar.setMinimum(0);
        this._vScrollBar.setMinimum(0);
        this._hScrollBar.setMaximum(0);
        this._vScrollBar.setMaximum(0);
        this._viewport.addComponentListener(new 1());
        this._scrollBarAdjustmentListener = new 2();
        this._hScrollBar.addAdjustmentListener(this._scrollBarAdjustmentListener);
        this._vScrollBar.addAdjustmentListener(this._scrollBarAdjustmentListener);
        this._viewport.addMouseWheelListener(new 3());
    }

    VersionTreeDiagramPanel getPanel() {
        return this._panel;
    }

    public JComponent getGUI() {
        return this.getPanel();
    }

    public JViewport getViewport() {
        return this._viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this._hScrollBar;
    }

    public JScrollBar getVerticalScrollBar() {
        return this._vScrollBar;
    }

    public VersionTreeDiagram getVersionTreeDiagram() {
        return this._diagram;
    }

    public VersionTree getVersionTree() {
        return this._diagram.getVersionTree();
    }

    public void updateScrollBars() {
        if (!this._hScrollBar.isEnabled()) {
            return;
        }
        this._panel.setPreferredSize(this._panel.calculatePreferredSize());
        this._hScrollBar.removeAdjustmentListener(this._scrollBarAdjustmentListener);
        this._vScrollBar.removeAdjustmentListener(this._scrollBarAdjustmentListener);
        this._hScrollBar.setMaximum(this._panel.getPreferredSize().width);
        this._hScrollBar.setValue(this._viewport.getViewPosition().x);
        this._hScrollBar.setVisibleAmount(this._panel.getVisibleRect().width);
        this._vScrollBar.setMaximum(this._panel.getPreferredSize().height);
        this._vScrollBar.setValue(this._viewport.getViewPosition().y);
        this._vScrollBar.setVisibleAmount(this._panel.getVisibleRect().height);
        this._hScrollBar.setBlockIncrement(this._panel.getVisibleRect().width);
        this._vScrollBar.setBlockIncrement(this._panel.getVisibleRect().height);
        this._hScrollBar.addAdjustmentListener(this._scrollBarAdjustmentListener);
        this._vScrollBar.addAdjustmentListener(this._scrollBarAdjustmentListener);
    }

    public void validateAllAndResize() {
        this.updateDiagramPreferredSize();
        this._validateAll();
    }

    public void validateAll() {
        this.updateScrollBars();
        this._validateAll();
    }

    private void _validateAll() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 4());
            return;
        }
        this.getViewport().validate();
        this.getViewport().revalidate();
        this.getViewport().repaint();
    }

    public void setVersionTree(VersionTree tree) {
        this._diagram.setVersionTree(tree);
        this.validateAllAndResize();
    }

    public void requery() throws VHVResourceException {
        this._diagram.requery();
        EventQueue.invokeLater(new 5());
        EventQueue.invokeLater(new 6());
    }

    public void setInContextVersion(ContextElement ce) {
        this._diagram.setInContextVersion(ce);
        this._panel.repaint();
    }

    public void setInContextVersion(VHVResource resource) {
        this._diagram.setInContextVersion(resource);
        this._panel.repaint();
    }

    public void zoomIn() {
        this.setZoom(1.2 * this.getZoom());
    }

    public void zoomOut() {
        this.setZoom(this.getZoom() / 1.2);
    }

    public void zoomToSize() {
        this.zoomToSize(-1.0);
    }

    public void zoomToSize(double minimum) {
        Dimension d1 = this._viewport.getSize();
        Dimension d2 = this._diagram.getPreferredSize();
        this.setZoom(Math.min((double)d1.height / (double)d2.height, (double)d1.width / (double)d2.width), minimum);
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, -1.0);
    }

    public void setZoom(double zoom, double minimum) {
        if (zoom > 32.0) {
            zoom = 32.0;
        }
        if (zoom < 0.03125) {
            zoom = 0.03125;
        }
        if (minimum > 0.0 && zoom < minimum) {
            zoom = minimum;
        }
        Point p = this.getViewport().getViewPosition();
        double zoomChange = zoom / this._zoom;
        this._zoom = zoom;
        p.x = (int)Math.round((double)p.x * zoomChange);
        p.y = (int)Math.round((double)p.y * zoomChange);
        this.getViewport().setViewPosition(p);
        this.validateAllAndResize();
    }

    public void defaultLayout() {
        this._diagram.defaultLayout();
        this.validateAllAndResize();
    }

    public void showAllNodes() {
        this._diagram.showAllNodes();
        this.validateAllAndResize();
    }

    public void showMajorNodes() {
        this._diagram.showMajorNodes();
        this.validateAllAndResize();
    }

    public void toggleAllNodesMajorNodes() {
        this._diagram.toggleAllNodesMajorNodes();
        this.validateAllAndResize();
    }

    public boolean isShowingAllNodes() {
        return this._diagram.isShowingAllNodes();
    }

    public boolean isSelectionEnabled() {
        return this._isSelectionEnabled;
    }

    public void setSelectionEnabled(boolean enabled) {
        if (this._highlighted != null) {
            this._highlighted.dehighlight();
            this._highlighted = null;
            this._panel.repaint();
        }
        this._isSelectionEnabled = enabled;
    }

    public void addVersionTreeDiagramListener(VersionTreeDiagramListener vtl) {
        if (!this._scrollBarAdjustmentListeners.contains(vtl)) {
            this._scrollBarAdjustmentListeners.add(vtl);
        }
    }

    public void removeVersionTreeListener(VersionTreeDiagramListener vtl) {
        this._scrollBarAdjustmentListeners.remove(vtl);
    }

    private void fireGraphElementSelected(MouseEvent me) {
        VersionTreeDiagramEvent vte = this._selected.size() == 0 ? new VersionTreeDiagramEvent(null, me, 0) : (this._selected.size() == 1 ? new VersionTreeDiagramEvent(this._selected.get(0), me, 1) : new VersionTreeDiagramEvent(null, me, 2));
        this.fireGraphElementSelected(vte);
    }

    private void fireGraphElementSelected(VersionTreeDiagramEvent vte) {
        Iterator i = this._scrollBarAdjustmentListeners.iterator();
        while (i.hasNext()) {
            ((VersionTreeDiagramListener)i.next()).graphNodeSelected(vte);
        }
    }

    private void fireGraphElementSelected(GraphShape gs, boolean lmb) {
        int x = gs == null ? 0 : (int)Math.round(gs.getBounds2D().getCenterX());
        int y = gs == null ? 0 : (int)Math.round(gs.getBounds2D().getCenterY());
        MouseEvent me = new MouseEvent(this._panel, 501, System.currentTimeMillis(), lmb ? 16 : 4, x, y, 1, lmb ^ true);
        this.fireGraphElementSelected(new VersionTreeDiagramEvent(gs, me, gs == null ? 0 : 1));
    }

    private void fireGraphElementIndicated(VersionTreeDiagramEvent vte) {
        Iterator i = this._scrollBarAdjustmentListeners.iterator();
        while (i.hasNext()) {
            ((VersionTreeDiagramListener)i.next()).graphNodeIndicated(vte);
        }
    }

    private void fireGraphElementIndicated(GraphShape gs) {
        int x = gs == null ? 0 : (int)Math.round(gs.getBounds2D().getCenterX());
        int y = gs == null ? 0 : (int)Math.round(gs.getBounds2D().getCenterY());
        MouseEvent me = new MouseEvent(this._panel, 501, System.currentTimeMillis(), 0, x, y, 1, false);
        this.fireGraphElementIndicated(new VersionTreeDiagramEvent(gs, me, gs == null ? 0 : 1));
    }

    public void setAntialiasing(boolean antialias) {
        this._useAntialiasing = antialias;
        this._panel.repaint();
    }

    public boolean isUsingAntialiasing() {
        return this._useAntialiasing;
    }

    public void setAlphaBlending(boolean alphaBlend) {
        this._useAlphaBlending = alphaBlend;
        this._panel.repaint();
    }

    public boolean isUsingAlphaBlending() {
        return this._useAlphaBlending;
    }

    public void selectInContextVersion() {
        ContextElement contextElement = this.getVersionTree().getInContextVersion();
        if (contextElement != null) {
            this.select((GraphShape)contextElement.getShape());
        }
    }

    public void scrollToInContextVersion() {
        ContextElement contextElement = this.getVersionTree().getInContextVersion();
        if (contextElement != null) {
            this.scrollTo((GraphShape)contextElement.getShape());
        }
    }

    public void selectAndScrollTo(GraphShape gs) {
        this.select(gs);
        this.scrollTo(gs);
    }

    public void select(GraphShape gs) {
        int i = 0;
        while (i < this._selected.size()) {
            this._selected.get(i).deselect();
            ++i;
        }
        this._selected = new ArrayList();
        if (gs != null) {
            this._selected.add(gs);
            gs.select();
        }
        MouseEvent e = new MouseEvent(this._panel, 501, System.currentTimeMillis(), 0, (int)Math.round(gs.getLocation().getX()), (int)Math.round(gs.getLocation().getY()), 1, false);
        this.fireGraphElementSelected(new VersionTreeDiagramEvent(gs, e, 1));
    }

    public Collection<GraphShape> getSelection() {
        return Collections.unmodifiableCollection(this._selected);
    }

    public void select(Collection<GraphShape> c) {
        int i = 0;
        while (i < this._selected.size()) {
            this._selected.get(i).deselect();
            ++i;
        }
        this._selected = new ArrayList();
        this._selected.addAll(c);
        for (GraphShape gs : c) {
            gs.select();
        }
        GraphShape gs = null;
        int st = 0;
        if (c.size() == 1) {
            st = 1;
            gs = c.iterator().next();
        }
        if (c.size() > 1) {
            st = 2;
        }
        this.fireGraphElementSelected(new VersionTreeDiagramEvent(gs, null, st));
    }

    public void scrollTo(GraphShape gs) {
        double x = gs.getLocation().getX() * this._zoom - this.getViewport().getSize().getWidth() / 2.0;
        double y = gs.getLocation().getY() * this._zoom - this.getViewport().getSize().getHeight() / 2.0;
        double maxX = this._panel.getSize().getWidth() - (double)this._panel.getVisibleRect().width;
        double maxY = this._panel.getSize().getHeight() - (double)this._panel.getVisibleRect().height;
        this.getViewport().setViewPosition(new Point(Math.max(0, (int)Math.round(Math.min(x, maxX))), Math.max(0, (int)Math.round(Math.min(y, maxY)))));
        this.validateAll();
    }

    private void updateDiagramPreferredSize() {
        Dimension size = new Dimension();
        for (GraphShape gs : this._diagram.getShapeList()) {
            size.width = Math.max(size.width, gs.getScrollX());
            size.height = Math.max(size.height, gs.getScrollY());
        }
        this._diagram.setPreferredSize(size);
        this._panel.setPreferredSize(this._panel.calculatePreferredSize());
        if (EventQueue.isDispatchThread()) {
            this.updateScrollBars();
        }
        EventQueue.invokeLater(new 7());
    }

    static ArrayList ra$_selected(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._selected;
    }

    static double ra$_zoom(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._zoom;
    }

    static VersionTreeDiagram ra$_diagram(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._diagram;
    }

    static void mav$fireGraphElementIndicated(VersionTreeDiagramPane versionTreeDiagramPane, VersionTreeDiagramEvent versionTreeDiagramEvent) {
        versionTreeDiagramPane.fireGraphElementIndicated(versionTreeDiagramEvent);
    }

    static JScrollBar ra$_hScrollBar(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._hScrollBar;
    }

    static AdjustmentListener ra$_scrollBarAdjustmentListener(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._scrollBarAdjustmentListener;
    }

    static JScrollBar ra$_vScrollBar(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._vScrollBar;
    }

    static VersionTreeDiagramPanel ra$_panel(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._panel;
    }

    static void mav$updateDiagramPreferredSize(VersionTreeDiagramPane versionTreeDiagramPane) {
        versionTreeDiagramPane.updateDiagramPreferredSize();
    }

    static void mav$fireGraphElementSelected(VersionTreeDiagramPane versionTreeDiagramPane, MouseEvent mouseEvent) {
        versionTreeDiagramPane.fireGraphElementSelected(mouseEvent);
    }

    static void wa$_selected(VersionTreeDiagramPane versionTreeDiagramPane, ArrayList arrayList) {
        versionTreeDiagramPane._selected = arrayList;
    }

    static void mav$fireGraphElementSelected(VersionTreeDiagramPane versionTreeDiagramPane, VersionTreeDiagramEvent versionTreeDiagramEvent) {
        versionTreeDiagramPane.fireGraphElementSelected(versionTreeDiagramEvent);
    }

    static boolean ra$_useAntialiasing(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._useAntialiasing;
    }

    static boolean ra$_useAlphaBlending(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._useAlphaBlending;
    }

    static GraphShape ra$_highlighted(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._highlighted;
    }

    static void mav$fireGraphElementSelected(VersionTreeDiagramPane versionTreeDiagramPane, GraphShape graphShape, boolean bl) {
        versionTreeDiagramPane.fireGraphElementSelected(graphShape, bl);
    }

    static void wa$_highlighted(VersionTreeDiagramPane versionTreeDiagramPane, GraphShape graphShape) {
        versionTreeDiagramPane._highlighted = graphShape;
    }

    static void mav$fireGraphElementIndicated(VersionTreeDiagramPane versionTreeDiagramPane, GraphShape graphShape) {
        versionTreeDiagramPane.fireGraphElementIndicated(graphShape);
    }

    static void mav$_validateAll(VersionTreeDiagramPane versionTreeDiagramPane) {
        versionTreeDiagramPane._validateAll();
    }

    static JViewport ra$_viewport(VersionTreeDiagramPane versionTreeDiagramPane) {
        return versionTreeDiagramPane._viewport;
    }

    final class 1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent ce) {
            VersionTreeDiagramPane.this.validateAllAndResize();
            VersionTreeDiagramPane.this.updateScrollBars();
        }

        public void componentResized(ComponentEvent ce) {
            VersionTreeDiagramPane.this.validateAllAndResize();
            VersionTreeDiagramPane.this.updateScrollBars();
        }
    }

    final class 2
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            JScrollBar scrollBar = (JScrollBar)ae.getSource();
            if (scrollBar == VersionTreeDiagramPane.ra$_hScrollBar(VersionTreeDiagramPane.this)) {
                VersionTreeDiagramPane.ra$_viewport(VersionTreeDiagramPane.this).setViewPosition(new Point(scrollBar.getValue(), VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).getValue()));
            }
            if (scrollBar == VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this)) {
                VersionTreeDiagramPane.ra$_viewport(VersionTreeDiagramPane.this).setViewPosition(new Point(VersionTreeDiagramPane.ra$_hScrollBar(VersionTreeDiagramPane.this).getValue(), scrollBar.getValue()));
            }
        }
    }

    final class 3
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            if (mwe.getScrollType() == 0) {
                int totalScroll = mwe.getUnitsToScroll() * VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).getUnitIncrement();
                VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).setValue(VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).getValue() + totalScroll);
            }
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            VersionTreeDiagramPane.mav$_validateAll(VersionTreeDiagramPane.this);
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            VersionTreeDiagramPane.this.zoomToSize(1.0);
        }
    }

    final class 6
    implements Runnable {
        public void run() {
            VersionTreeDiagramPane.this.scrollToInContextVersion();
        }
    }

    final class 7
    implements Runnable {
        public void run() {
            VersionTreeDiagramPane.this.updateScrollBars();
        }
    }

    class VersionTreeDiagramPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private boolean _dragOkay;
        private boolean _isDragging;
        private Dimension _preferredSize;
        private int _mouseX;
        private int _mouseY;
        private Point _screenPoint;
        private NavigationListener _navigationListener;
        private NavigationActionListener _navigationActionListener;
        private SelectionMode _selectionMode;
        private final Cursor _panDropCursor;
        private final Cursor _panDragCursor;

        private void $init$() {
            this._dragOkay = false;
            this._isDragging = false;
            this._preferredSize = new Dimension();
            this._navigationListener = new NavigationListener(null);
            this._navigationActionListener = new NavigationActionListener(null);
            this._selectionMode = SelectionMode.SELECT;
            this._panDropCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/PanDropCursor.gif")), new Point(0, 0), "Hand Tool Drop");
            this._panDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(VHVArb.class.getResource("images/PanDragCursor.gif")), new Point(0, 0), "Hand Tool Drag");
        }

        VersionTreeDiagramPanel() {
            this.$init$();
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setBackground(Color.white);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setDoubleBuffered(true);
            this.registerKeyboardAction(this._navigationListener, "UP", KeyStroke.getKeyStroke(38, 2, false), 0);
            this.registerKeyboardAction(this._navigationListener, "DOWN", KeyStroke.getKeyStroke(40, 2, false), 0);
            this.registerKeyboardAction(this._navigationListener, "RIGHT", KeyStroke.getKeyStroke(39, 2, false), 0);
            this.registerKeyboardAction(this._navigationListener, "LEFT", KeyStroke.getKeyStroke(37, 2, false), 0);
            this.registerKeyboardAction(this._navigationActionListener, "ENTER", KeyStroke.getKeyStroke(10, 0, false), 0);
            this.registerKeyboardAction(this._navigationActionListener, "SPACE", KeyStroke.getKeyStroke(32, 0, false), 0);
        }

        public void setSelectionMode(SelectionMode selectionMode) {
            this._selectionMode = selectionMode;
            if (this._selectionMode == SelectionMode.SELECT) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this._selectionMode == SelectionMode.PAN) {
                this.setCursor(this._panDropCursor);
            }
        }

        public void paintChildren(Graphics g) {
            this.paintChildren(g, VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this));
        }

        private void paintChildren(Graphics g, double zoom) {
            try {
                Graphics2D g2d = (Graphics2D)g;
                if (VersionTreeDiagramPane.ra$_useAntialiasing(VersionTreeDiagramPane.this)) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                if (VersionTreeDiagramPane.ra$_useAlphaBlending(VersionTreeDiagramPane.this)) {
                    AlphaComposite comp = AlphaComposite.getInstance(3);
                    g2d.setComposite(comp);
                } else {
                    AlphaComposite comp = AlphaComposite.getInstance(2);
                    g2d.setComposite(comp);
                }
                g2d.scale(zoom, zoom);
                boolean paintText = !(zoom < 0.25);
                VersionTreeDiagramPane.ra$_diagram(VersionTreeDiagramPane.this).paint(g2d, paintText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Dimension calculatePreferredSize() {
            if (this._isDragging) {
                return new Dimension((int)Math.ceil((double)this._preferredSize.width * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this)), (int)Math.ceil((double)this._preferredSize.height * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this)));
            }
            Dimension preferredSize = VersionTreeDiagramPane.ra$_diagram(VersionTreeDiagramPane.this).getPreferredSize();
            return new Dimension((int)Math.ceil((double)preferredSize.width * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this)), (int)Math.ceil((double)preferredSize.height * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this)));
        }

        public void mouseClicked(MouseEvent e) {
            if (this._selectionMode == SelectionMode.PAN && !e.isPopupTrigger()) {
                return;
            }
            VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, e);
        }

        public void mousePressed(MouseEvent e) {
            this.requestFocusInWindow();
            this._mouseX = e.getX();
            this._mouseY = e.getY();
            this._screenPoint = MouseInfo.getPointerInfo().getLocation();
            if (this._selectionMode == SelectionMode.PAN && !e.isPopupTrigger()) {
                this.setCursor(this._panDragCursor);
                return;
            }
            GraphShape selected = VersionTreeDiagramPane.ra$_diagram(VersionTreeDiagramPane.this).getGraphShape((double)this._mouseX / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this), (double)this._mouseY / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this));
            if (selected == null) {
                this._dragOkay = false;
                return;
            }
            if (!e.isControlDown() && VersionTreeDiagramPane.this.isSelectionEnabled()) {
                Iterator i = VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).iterator();
                while (i.hasNext()) {
                    ((GraphShape)i.next()).deselect();
                }
                VersionTreeDiagramPane.wa$_selected(VersionTreeDiagramPane.this, new ArrayList());
            }
            if (VersionTreeDiagramPane.this.isSelectionEnabled()) {
                if (selected != null) {
                    ArrayList newSelection = selected.select(e.isShiftDown());
                    for (GraphShape gs : newSelection) {
                        if (VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).contains(gs)) continue;
                        VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).add(gs);
                    }
                    this._preferredSize = (Dimension)VersionTreeDiagramPane.ra$_diagram(VersionTreeDiagramPane.this).getPreferredSize().clone();
                }
                this._dragOkay = true;
                this.repaint();
                VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, e);
            } else {
                VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, new VersionTreeDiagramEvent(selected, e, selected == null ? 0 : 1));
                this._dragOkay = false;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this._selectionMode == SelectionMode.PAN && !e.isPopupTrigger()) {
                this.setCursor(this._panDropCursor);
                return;
            }
            if (this._isDragging && (e.getModifiers() & 0x10) != 0 && VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).size() > 0) {
                VersionTreeDiagramPane.mav$updateDiagramPreferredSize(VersionTreeDiagramPane.this);
                this._isDragging = false;
                this.revalidate();
                this.repaint();
            }
            VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, e);
        }

        private void updatePanelPreferredSize() {
            Dimension size = this._preferredSize;
            for (GraphShape gs : VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this)) {
                size.width = Math.max(size.width, gs.getScrollX());
                size.height = Math.max(size.height, gs.getScrollY());
            }
            this._preferredSize = size;
            VersionTreeDiagramPane.ra$_panel(VersionTreeDiagramPane.this).setPreferredSize(VersionTreeDiagramPane.ra$_panel(VersionTreeDiagramPane.this).calculatePreferredSize());
        }

        public void mouseEntered(MouseEvent e) {
            this._dragOkay = true;
        }

        public void mouseExited(MouseEvent e) {
            this._dragOkay = false;
        }

        public void mouseDragged(MouseEvent e) {
            if (this._selectionMode == SelectionMode.PAN && !e.isPopupTrigger()) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                double x = (double)this._screenPoint.x - p.getX();
                double y = (double)this._screenPoint.y - p.getY();
                this._screenPoint = p;
                p = VersionTreeDiagramPane.this.getViewport().getViewPosition();
                p.x = (int)((double)p.x + x);
                p.y = (int)((double)p.y + y);
                Component view = VersionTreeDiagramPane.this.getViewport().getView();
                Rectangle r = VersionTreeDiagramPane.this.getViewport().getViewRect();
                p.x = Math.min(Math.max(p.x, 0), view.getWidth() - r.width);
                p.y = Math.min(Math.max(p.y, 0), view.getHeight() - r.height);
                VersionTreeDiagramPane.ra$_hScrollBar(VersionTreeDiagramPane.this).removeAdjustmentListener(VersionTreeDiagramPane.ra$_scrollBarAdjustmentListener(VersionTreeDiagramPane.this));
                VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).removeAdjustmentListener(VersionTreeDiagramPane.ra$_scrollBarAdjustmentListener(VersionTreeDiagramPane.this));
                VersionTreeDiagramPane.ra$_hScrollBar(VersionTreeDiagramPane.this).setValue(p.x);
                VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).setValue(p.y);
                VersionTreeDiagramPane.this.getViewport().setViewPosition(p);
                VersionTreeDiagramPane.ra$_hScrollBar(VersionTreeDiagramPane.this).addAdjustmentListener(VersionTreeDiagramPane.ra$_scrollBarAdjustmentListener(VersionTreeDiagramPane.this));
                VersionTreeDiagramPane.ra$_vScrollBar(VersionTreeDiagramPane.this).addAdjustmentListener(VersionTreeDiagramPane.ra$_scrollBarAdjustmentListener(VersionTreeDiagramPane.this));
                return;
            }
            if (this.selectionIsMoveable() && this._dragOkay && (e.getModifiers() & 0x10) != 0) {
                this._isDragging = true;
                int dX = e.getX() - this._mouseX;
                int dY = e.getY() - this._mouseY;
                this._mouseX = e.getX();
                this._mouseY = e.getY();
                this.moveSelection(dX, dY);
                int direction = 0;
                if ((double)this._mouseX > VersionTreeDiagramPane.this.getViewport().getViewRect().getMaxX() - 30.0) {
                    ++direction;
                } else if ((double)this._mouseX < VersionTreeDiagramPane.this.getViewport().getViewRect().getMinX() + 30.0) {
                    direction += 2;
                }
                if ((double)this._mouseY > VersionTreeDiagramPane.this.getViewport().getViewRect().getMaxY() - 30.0) {
                    direction += 4;
                } else if ((double)this._mouseY < VersionTreeDiagramPane.this.getViewport().getViewRect().getMinY() + 30.0) {
                    direction += 8;
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            VersionTreeDiagramEvent vte;
            GraphShape mouseover = VersionTreeDiagramPane.ra$_diagram(VersionTreeDiagramPane.this).getGraphShape((double)e.getX() / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this), (double)e.getY() / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this));
            if (mouseover == null) {
                this.setToolTipText(null);
                vte = new VersionTreeDiagramEvent(null, e, 0);
            } else {
                this.setToolTipText(mouseover.getToolTipText());
                vte = new VersionTreeDiagramEvent(mouseover, e, 1);
            }
            VersionTreeDiagramPane.mav$fireGraphElementIndicated(VersionTreeDiagramPane.this, vte);
        }

        private void moveSelection(int dX, int dY) {
            Rectangle r = null;
            for (GraphShape gs : VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this)) {
                if (r == null) {
                    r = gs.getTotalBounds2D().getBounds();
                } else {
                    r.add(gs.getTotalBounds2D().getBounds());
                }
                gs.move((double)dX / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this), (double)dY / VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this));
                r.add(gs.getBounds2D().getBounds());
            }
            this.updatePanelPreferredSize();
            r.setLocation((int)Math.round(Math.ceil((r.getX() - 5.0) * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this))), (int)Math.round(Math.ceil((r.getY() - 5.0) * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this))));
            r.setSize((int)Math.round(Math.ceil((r.getWidth() + 10.0) * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this))), (int)Math.round(Math.ceil((r.getHeight() + 10.0) * VersionTreeDiagramPane.ra$_zoom(VersionTreeDiagramPane.this))));
            this.repaint(r);
            this.revalidate();
        }

        private boolean selectionIsMoveable() {
            if (VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).size() > 0) {
                boolean result = false;
                Iterator i = VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).iterator();
                while (i.hasNext()) {
                    result |= ((GraphShape)i.next()).isMoveable();
                }
                return result;
            }
            return false;
        }

        private class NavigationActionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                GraphShape action = VersionTreeDiagramPane.this.isSelectionEnabled() && VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).size() > 0 ? (GraphShape)VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).get(0) : VersionTreeDiagramPane.ra$_highlighted(VersionTreeDiagramPane.this);
                if (action == null) {
                    return;
                }
                if (e.getActionCommand().equals("ENTER") || e.getActionCommand().equals("SPACE")) {
                    VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, action, true);
                }
            }

            private NavigationActionListener() {
            }

            NavigationActionListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private class NavigationListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                GraphShape current = null;
                GraphShape next = null;
                current = VersionTreeDiagramPane.this.isSelectionEnabled() && VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).size() > 0 ? (GraphShape)VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).get(0) : VersionTreeDiagramPane.ra$_highlighted(VersionTreeDiagramPane.this);
                if (current == null) {
                    next = VersionTreeDiagramPane.this.isSelectionEnabled() ? (GraphShape)VersionTreeDiagramPane.this.getVersionTree().getRootElement().getShape() : (VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).size() > 0 ? (GraphShape)VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).get(0) : (GraphShape)VersionTreeDiagramPane.this.getVersionTree().getRootElement().getShape());
                } else {
                    if (VersionTreeDiagramPane.this.isSelectionEnabled()) {
                        Iterator i = VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).iterator();
                        while (i.hasNext()) {
                            ((GraphShape)i.next()).deselect();
                        }
                    } else {
                        current.dehighlight();
                    }
                    if (e.getActionCommand().equals("UP")) {
                        next = current.getAbove();
                    } else if (e.getActionCommand().equals("DOWN")) {
                        next = current.getBelow();
                    } else if (e.getActionCommand().equals("RIGHT")) {
                        next = current.getRight();
                    } else if (e.getActionCommand().equals("LEFT")) {
                        next = current.getLeft();
                    }
                }
                if (VersionTreeDiagramPane.this.isSelectionEnabled()) {
                    VersionTreeDiagramPane.wa$_selected(VersionTreeDiagramPane.this, new ArrayList());
                    if (next == null) {
                        throw new IllegalStateException();
                    }
                    VersionTreeDiagramPane.ra$_selected(VersionTreeDiagramPane.this).add(next);
                    next.select();
                    VersionTreeDiagramPane.mav$fireGraphElementSelected(VersionTreeDiagramPane.this, next, true);
                } else {
                    VersionTreeDiagramPane.wa$_highlighted(VersionTreeDiagramPane.this, next);
                    next.highlight();
                    VersionTreeDiagramPane.mav$fireGraphElementIndicated(VersionTreeDiagramPane.this, next);
                }
                VersionTreeDiagramPane.this.scrollTo(next);
                VersionTreeDiagramPanel.this.repaint();
            }

            private NavigationListener() {
            }

            NavigationListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

