/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.access;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.access.BasicPanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public class AccessConnectionPanel
extends IConnectionPanel {
    private BasicPanel m_basicPanel;
    private JPanel m_panel;
    private static final String DRIVER_CLASSNAME = "sun.jdbc.odbc.JdbcOdbcDriver";

    public AccessConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this.m_basicPanel = new BasicPanel(this);
        CardLayout cardLayout = new CardLayout(0, 0);
        this.m_panel = new JPanel(cardLayout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((int)34));
        this.m_panel.add((Component)this.m_basicPanel, "Basic");
        this.add(this.m_panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        cardLayout.show(this.m_panel, "Basic");
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("user", "  ");
        properties.setProperty("password", "  ");
        properties.put("SavePassword", Boolean.toString(true));
        properties.put("subtype", "ODBCBridge");
        properties.put("driver", DRIVER_CLASSNAME);
        properties.put("RaptorConnectionType", "ACCESS");
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(properties);
        return properties;
    }

    private void testAccessTablesAvailable(String string) {
        try {
            Class.forName(DRIVER_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"JDBC ODBC Driver not found.", (String)"JDBC ODBC Error", null);
        }
        try {
            Connection connection = DriverManager.getConnection(string, "", "");
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select top 1 * from MSysObjects");
        }
        catch (SQLException sQLException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"No Read Access to System Tables. Modify Access db before retrying", (String)"Microsoft Access Permissions Error", null);
        }
    }

    public void clear() {
        this.getPanel().clear();
    }

    public void updatePrompts(Properties properties) {
        ((BasicPanel)this.getPanel()).setFileName(properties.getProperty("MDBFILENAME"));
    }

    private CDComponentView getPanel() {
        return this.m_basicPanel;
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    protected void testConnection(Properties properties) throws ConnectionException {
        super.testConnection(properties);
        this.testAccessTablesAvailable(properties.getProperty("customUrl"));
    }

    public void setDefaultPrompts() {
        this.getPanel().setDefaultPrompts();
        this.getDialog().useUserName(false);
        this.getDialog().usePassword(false);
    }

    public String getConnectionType() {
        return "ACCESS";
    }
}

