/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.access;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.thirdparty.access.AccessConnectionPanel;
import oracle.dbtools.thirdparty.access.AccessExplorerResource;
import oracle.dbtools.thirdparty.access.MdbFileFilter;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class BasicPanel
extends JPanel
implements CDComponentView {
    private JLabel m_fileNameLabel;
    private JTextField m_fileNameTfd;
    private JButton m_browseButton;
    private AccessConnectionPanel m_panel;
    private String accessURL = "";
    public static final String MDB_FILENAME = "MDBFILENAME";
    public static final String MDB_SECURITY = "MDBSECURITY";
    private String m_accessFileName = "";
    private boolean security = false;

    public BasicPanel(AccessConnectionPanel accessConnectionPanel) {
        this.m_panel = accessConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.m_fileNameLabel = new JLabel();
        this.m_fileNameTfd = new JTextField();
        ResourceUtils.resLabel((JLabel)this.m_fileNameLabel, (Component)this.m_fileNameTfd, (String)AccessExplorerResource.getString(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.m_fileNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_fileNameTfd, gridBagConstraints);
        this.m_browseButton = new JButton();
        this.m_browseButton.setText(AccessExplorerResource.getString(1));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 0;
        this.add((Component)this.m_browseButton, gridBagConstraints);
        ResourceUtils.resButton((AbstractButton)this.m_browseButton, (String)AccessExplorerResource.getString(1));
        this.m_browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicPanel.this.chooseMdb();
                    BasicPanel.this.createURL();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
                }
            }
        });
    }

    private void createURL() {
        this.accessURL = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + this.m_fileNameTfd.getText() + ";DriverID=22;READONLY=false}";
    }

    public void populateComponent(Properties properties) {
        this.createURL();
        properties.setProperty("customUrl", this.accessURL);
        properties.setProperty(MDB_FILENAME, this.m_accessFileName);
        properties.put("password", " ");
        properties.put("DeployPassword", "true");
    }

    public void clear() {
        this.m_fileNameTfd.setText("");
    }

    private void chooseMdb() throws FileNotFoundException {
        int n = 0;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new MdbFileFilter());
        n = jFileChooser.showOpenDialog(this);
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                String string = jFileChooser.getSelectedFile().getPath();
                if (string != null && string.toLowerCase().endsWith("mdb")) {
                    this.m_fileNameTfd.setText(string);
                    this.m_accessFileName = string;
                    break;
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AccessExplorerResource.getString(2), (String)CommonArb.getString((int)3), null);
                break;
            }
        }
    }

    public void setFileName(String string) {
        this.m_fileNameTfd.setText(string);
        this.m_accessFileName = string;
    }

    public String getFileName() {
        return this.m_accessFileName;
    }

    protected boolean isSecurity() {
        return this.security;
    }

    public void setDefaultPrompts() {
        this.clear();
    }
}

