/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.autotrace.AutotraceTreeModel;
import oracle.dbtools.sqlworksheet.autotrace.AutotraceTreeNode;
import oracle.dbtools.sqlworksheet.autotrace.TabColumnsInfo;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutotracePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JTreeTable tbl;
    public AutotraceTreeModel mdl = new AutotraceTreeModel(this);
    private JPopupMenu popup = this.getPopupMenu();
    public JTable mystats;
    public Property mystatsData = new Property();
    public CopyableResultSetTableAdapter copyAdapter;
    boolean isExplainPlan = false;
    private ColumnsListener colsListener = new ColumnsListener();
    private static final TableCellRenderer cellRenderer = new CellRenderer();

    public AutotracePane(boolean bl) {
        this.isExplainPlan = bl;
        this.init();
        DBConfig dBConfig = DBConfig.getInstance();
        dBConfig.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                AbstractTableModel abstractTableModel = (AbstractTableModel)AutotracePane.this.tbl.getModel();
                abstractTableModel.fireTableStructureChanged();
                AutotracePane.this.tbl.revalidate();
                AutotracePane.this.initColumnWidths();
            }
        });
    }

    public void setConnection(Connection connection) {
        this.mdl.setConnection(connection);
    }

    private void init() {
        Serializable serializable;
        this.tbl = new JTreeTable((TreeTableModel)this.mdl){
            private KeyStroke copy;
            private ActionListener _copyListener;
            {
                this.copy = KeyStroke.getKeyStroke(67, 2, false);
                this._copyListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AutotracePane.this.copyAdapter.setNullString("");
                        AutotracePane.this.copyAdapter.copyToClipboard();
                    }
                };
                this.registerKeyboardAction(this._copyListener, "Copy", this.copy, 0);
            }
        };
        this.tbl.setAutoResizeMode(0);
        this.tbl.setCellSelectionEnabled(true);
        this.tbl.setColumnSelectionAllowed(true);
        this.tbl.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tbl);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        for (int i = 1; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
            serializable = this.tbl.getColumnModel().getColumn(i);
            serializable.setCellRenderer(cellRenderer);
        }
        JTree jTree = this.tbl.getTree();
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new NodeRenderer());
        jTree.setShowsRootHandles(true);
        serializable = this.tbl.getBackground();
        jScrollPane.setBackground((Color)serializable);
        jScrollPane.getViewport().setBackground((Color)serializable);
        this.tbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            private void checkPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AutotracePane.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.initColumnWidths();
        if (this.isExplainPlan) {
            this.add(jScrollPane);
        } else {
            this.mystats = new JTable(this.mystatsData);
            JScrollPane jScrollPane2 = new JScrollPane(this.mystats);
            JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(600);
            this.add(jSplitPane);
        }
    }

    public void initColumnWidths() {
        try {
            TabColumnsInfo tabColumnsInfo = TabColumnsInfo.read();
            for (int i = 0; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
                TableColumn tableColumn = this.tbl.getColumnModel().getColumn(i);
                Object object = tableColumn.getHeaderValue();
                if (object != null && tabColumnsInfo.columnWidths.get(object) != null) {
                    tableColumn.setPreferredWidth(tabColumnsInfo.columnWidths.get(object));
                    continue;
                }
                tableColumn.setPreferredWidth(i == 0 ? 300 : 200);
            }
        }
        catch (Exception exception) {
            for (int i = 0; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
                this.tbl.getColumnModel().getColumn(i).setPreferredWidth(i == 0 ? 300 : 200);
            }
        }
        this.setColumnsListener();
        this.tbl.getColumnModel().setColumnMargin(10);
    }

    private void setColumnsListener() {
        for (int i = 0; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.tbl.getColumnModel().getColumn(i);
            tableColumn.addPropertyChangeListener(this.colsListener);
        }
    }

    public List<String> displayedColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OPERATION");
        DBConfig dBConfig = DBConfig.getInstance();
        if (this.isExplainPlan && dBConfig.getBoolean("EXPL_OBJECT_NAME").booleanValue()) {
            arrayList.add("OBJECT_NAME");
        } else if (!this.isExplainPlan && dBConfig.getBoolean("AUTO_OBJECT_NAME").booleanValue()) {
            arrayList.add("OBJECT_NAME");
        }
        if (this.isExplainPlan && dBConfig.getBoolean("EXPL_OPTIONS").booleanValue()) {
            arrayList.add("OPTIONS");
        } else if (!this.isExplainPlan && dBConfig.getBoolean("AUTO_OPTIONS").booleanValue()) {
            arrayList.add("OPTIONS");
        }
        if (this.isExplainPlan && dBConfig.getBoolean("EXPL_COST").booleanValue()) {
            arrayList.add("COST");
        } else if (!this.isExplainPlan && dBConfig.getBoolean("AUTO_COST").booleanValue()) {
            arrayList.add("COST");
        }
        if (this.isExplainPlan && dBConfig.getBoolean("EXPL_CARDINALITY").booleanValue()) {
            arrayList.add("CARDINALITY");
        } else if (!this.isExplainPlan && dBConfig.getBoolean("AUTO_CARDINALITY").booleanValue()) {
            arrayList.add("CARDINALITY");
        }
        if (!this.isExplainPlan && dBConfig.getBoolean("LAST_OUTPUT_ROWS").booleanValue()) {
            arrayList.add("LAST_OUTPUT_ROWS");
        }
        if (!this.isExplainPlan && dBConfig.getBoolean("LAST_CR_BUFFER_GETS").booleanValue()) {
            arrayList.add("LAST_CR_BUFFER_GETS");
        }
        if (!this.isExplainPlan && dBConfig.getBoolean("LAST_ELAPSED_TIME").booleanValue()) {
            arrayList.add("LAST_ELAPSED_TIME");
        }
        if (!this.isExplainPlan && dBConfig.getBoolean("LAST_STARTS").booleanValue()) {
            arrayList.add("LAST_STARTS");
        }
        if (this.isExplainPlan && !dBConfig.getBoolean("EXPL_PREDICATES").booleanValue()) {
            arrayList.add("ACCESS_PREDICATES");
            arrayList.add("FILTER_PREDICATES");
        } else if (!this.isExplainPlan && !dBConfig.getBoolean("AUTO_PREDICATES").booleanValue()) {
            arrayList.add("ACCESS_PREDICATES");
            arrayList.add("FILTER_PREDICATES");
        }
        if (this.mdl.showPartitionColumns) {
            arrayList.add("PARTITION_START");
            arrayList.add("PARTITION_STOP");
        }
        return arrayList;
    }

    public boolean showPredicates() {
        if (this.isExplainPlan) {
            return DBConfig.getInstance().getBoolean("EXPL_PREDICATES");
        }
        return DBConfig.getInstance().getBoolean("AUTO_PREDICATES");
    }

    public boolean showProjection() {
        if (this.isExplainPlan) {
            return DBConfig.getInstance().getBoolean("EXPL_PROJECTION");
        }
        return DBConfig.getInstance().getBoolean("AUTO_PROJECTION");
    }

    public boolean showOtherXML() {
        if (this.isExplainPlan) {
            return DBConfig.getInstance().getBoolean("EXPL_OTHER_XML");
        }
        return DBConfig.getInstance().getBoolean("AUTO_OTHER_XML");
    }

    public static boolean showMyStat() {
        return DBConfig.getInstance().getBoolean("V$MYSTAT");
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand predicates", OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotracePane.this.expandPredicates();
                AutotracePane.this.tbl.revalidate();
            }
        });
        jMenuItem = new JMenuItem("Collapse predicates", OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotracePane.this.collapsePredicates();
                AutotracePane.this.tbl.revalidate();
            }
        });
        return jPopupMenu;
    }

    public void collapsePredicates() {
        JTree jTree = this.tbl.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)treePath.getLastPathComponent();
            if (!autotraceTreeNode.operation.endsWith("Predicates")) continue;
            jTree.collapsePath(treePath);
        }
    }

    public void expandPredicates() {
        JTree jTree = this.tbl.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)treePath.getLastPathComponent();
            if (!autotraceTreeNode.operation.endsWith("Predicates")) continue;
            jTree.expandPath(treePath);
        }
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jLabel.setIcon(this.getNodeIcon(object));
            try {
                AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)object;
                if (autotraceTreeNode.color != null) {
                    jLabel.setForeground(autotraceTreeNode.color);
                } else {
                    jLabel.setForeground(Color.BLACK);
                }
                jLabel.setToolTipText(autotraceTreeNode.tooltip());
            }
            catch (Exception exception) {
                jLabel.setForeground(Color.RED);
            }
            this.setBackgroundSelectionColor(AutotracePane.this.tbl.getBackground());
            return jLabel;
        }

        protected Icon getNodeIcon(Object object) {
            Icon icon = null;
            if (object instanceof AutotraceTreeNode) {
                AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)object;
                icon = SQLWorksheetArb.getString(46).equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(47) : (SQLWorksheetArb.getString(48).equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(49) : ("NESTED LOOPS".equals(autotraceTreeNode.operation) || "MERGE JOIN".equals(autotraceTreeNode.operation) || "HASH JOIN".equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(53) : ("UNION-ALL".equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(55) : (autotraceTreeNode.operation != null && autotraceTreeNode.operation.startsWith("TABLE") ? SQLWorksheetArb.getIcon(56) : ("VIEW".equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(59) : ("OR".equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(58) : ("AND".equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(57) : (SQLWorksheetArb.getString(50).equals(autotraceTreeNode.operation) ? SQLWorksheetArb.getIcon(54) : (autotraceTreeNode.isSpanned ? SQLWorksheetArb.getIcon(60) : SQLWorksheetArb.getIcon(52))))))))));
            }
            return icon;
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            try {
                Long.valueOf((String)object);
                jLabel.setHorizontalAlignment(4);
            }
            catch (Exception exception) {
                jLabel.setHorizontalAlignment(2);
            }
            jLabel.setToolTipText((String)object);
            return jLabel;
        }
    }

    public static final class Property
    extends AbstractTableModel {
        public Map<Integer, String> names = new HashMap<Integer, String>();
        public Map<Integer, Long> values = new HashMap<Integer, Long>();

        public void reset() {
            this.names = new HashMap<Integer, String>();
            this.values = new HashMap<Integer, Long>();
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "V$STATNAME Name";
            }
            return "V$MYSTAT Value";
        }

        public int getRowCount() {
            return this.names.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.values.get(n);
            }
            return this.names.get(n);
        }
    }

    private class ColumnsListener
    implements PropertyChangeListener {
        private ColumnsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            Object object = tableColumn.getHeaderValue();
            int n = tableColumn.getWidth();
            TabColumnsInfo tabColumnsInfo = null;
            try {
                tabColumnsInfo = TabColumnsInfo.read();
            }
            catch (IOException iOException) {
                tabColumnsInfo = new TabColumnsInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer n2 = tabColumnsInfo.columnWidths.get(object);
            if (n2 == null || Math.abs(n - n2) > 10) {
                tabColumnsInfo.columnWidths.put(object, n);
            }
            try {
                tabColumnsInfo.write();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

