/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.autotrace;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.autotrace.AutotracePane;
import oracle.dbtools.sqlworksheet.autotrace.AutotraceTreeNode;
import oracle.ide.Ide;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.dialogs.MessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutotraceTreeModel
extends AbstractTreeTableModel {
    private AutotracePane src = null;
    boolean showPartitionColumns = false;
    protected Connection _conn = null;
    protected String _strStmt = null;

    public AutotraceTreeModel(AutotracePane autotracePane) {
        super((Object)new AutotraceTreeNode("..."));
        this.src = autotracePane;
    }

    public void setConnection(Connection connection) {
        this._conn = connection;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void setStatement(String string) {
        String string2;
        String string3 = string.trim();
        if (string3.endsWith(";") && !(string2 = string3.toUpperCase()).endsWith("END;")) {
            string3 = string3.substring(0, string3.lastIndexOf(";"));
        }
        this._strStmt = string3;
    }

    public void reset() {
        AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode();
        autotraceTreeNode.id = "0";
        autotraceTreeNode.operation = "...";
        this.root = autotraceTreeNode;
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public void reload(String string, String string2, Connection connection) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select s.last_elapsed_time \n   , s.last_output_rows \n   , s.last_cr_buffer_gets \n   , s.last_starts \n   , p.* \nfrom v$sql_plan p, v$sql_plan_statistics s \nwhere p.hash_value = ? and p.child_number = ? \nand p.hash_value = s.hash_value(+)  \nand p.child_number = s.child_number(+)and p.id = s.operation_id(+)order by p.id");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            this.getPlanAndStats(hashMap, preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"No data in v$sql_plan?", null);
        }
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public void explainPlan(String string, String string2) {
        try {
            Statement statement = this._conn.createStatement();
            statement.execute("explain plan SET STATEMENT_ID = '" + string2 + "' for " + string);
            statement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"Failed to explain plan", null);
        }
    }

    public void displayPlan(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            PreparedStatement preparedStatement = this._conn.prepareStatement("select 'N/A' last_elapsed_time \n   , 'N/A' last_output_rows \n   , 'N/A' last_cr_buffer_gets \n   , 'N/A' last_starts \n   , p.* \nfrom plan_table p \nwhere p.statement_id = ? \norder by p.id");
            preparedStatement.setString(1, string2);
            this.getPlanAndStats(hashMap, preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"Failed to query plan_table", null);
        }
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    private void getPlanAndStats(Map<String, Object> map, PreparedStatement preparedStatement) throws SQLException {
        Serializable serializable;
        ResultSet resultSet = preparedStatement.executeQuery();
        AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode();
        boolean bl = this.showPartitionColumns;
        this.showPartitionColumns = false;
        while (resultSet.next()) {
            Object object;
            serializable = new AutotraceTreeNode();
            ((AutotraceTreeNode)serializable).id = resultSet.getString("id");
            String string = resultSet.getString("parent_id");
            ((AutotraceTreeNode)serializable).operation = resultSet.getString("operation");
            ((AutotraceTreeNode)serializable).objectName = resultSet.getString("object_name");
            ((AutotraceTreeNode)serializable).options = resultSet.getString("options");
            ((AutotraceTreeNode)serializable).cardinality = resultSet.getString("cardinality");
            ((AutotraceTreeNode)serializable).cost = resultSet.getString("cost");
            ((AutotraceTreeNode)serializable).rows = resultSet.getString("last_output_rows");
            ((AutotraceTreeNode)serializable).gets = resultSet.getString("last_cr_buffer_gets");
            ((AutotraceTreeNode)serializable).time = resultSet.getString("last_elapsed_time");
            ((AutotraceTreeNode)serializable).starts = resultSet.getString("last_starts");
            ((AutotraceTreeNode)serializable).partitionStart = resultSet.getString("PARTITION_START");
            ((AutotraceTreeNode)serializable).partitionStop = resultSet.getString("PARTITION_STOP");
            if (((AutotraceTreeNode)serializable).partitionStart != null || ((AutotraceTreeNode)serializable).partitionStop != null) {
                this.showPartitionColumns = true;
            }
            String string2 = null;
            String string3 = null;
            try {
                ((AutotraceTreeNode)serializable).accessPredicates = resultSet.getString("access_predicates");
                ((AutotraceTreeNode)serializable).filterPredicates = resultSet.getString("filter_predicates");
                string2 = resultSet.getString("projection");
                ((AutotraceTreeNode)serializable).qBlockName = resultSet.getString("qblock_name");
                object = resultSet.getClob("other_xml");
                if (object != null) {
                    string3 = object.getSubString(1L, (int)object.length());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            map.put(((AutotraceTreeNode)serializable).id, serializable);
            if ("0".equals(((AutotraceTreeNode)serializable).id)) {
                this.root = serializable;
            } else {
                object = (AutotraceTreeNode)map.get(string);
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)((Object)serializable));
                ((AutotraceTreeNode)serializable).parent = object;
            }
            if (((AutotraceTreeNode)serializable).accessPredicates != null && this.src.showPredicates()) {
                object = new AutotraceTreeNode();
                ((AutotraceTreeNode)object).operation = SQLWorksheetArb.getString(46);
                ((AutotraceTreeNode)object).color = new Color(170);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((AutotraceTreeNode)object).predicates = ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", ""));
            }
            if (((AutotraceTreeNode)serializable).filterPredicates != null && this.src.showPredicates()) {
                object = new AutotraceTreeNode();
                ((AutotraceTreeNode)object).operation = SQLWorksheetArb.getString(48);
                ((AutotraceTreeNode)object).color = new Color(170);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((AutotraceTreeNode)object).predicates = ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", ""));
            }
            if (string2 != null && this.src.showProjection()) {
                object = new AutotraceTreeNode();
                ((AutotraceTreeNode)object).operation = SQLWorksheetArb.getString(50);
                ((AutotraceTreeNode)object).color = new Color(21777);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                AutotraceTreeModel.projection((AutotraceTreeNode)object, string2.replaceAll("\"", ""));
            }
            if (string3 == null || !this.src.showOtherXML()) continue;
            AutotraceTreeModel.parseXML(autotraceTreeNode, string3.replaceAll("\"", ""));
        }
        resultSet.close();
        if (bl != this.showPartitionColumns) {
            serializable = (AbstractTableModel)this.src.tbl.getModel();
            ((AbstractTableModel)serializable).fireTableStructureChanged();
        }
    }

    public String getStatement() {
        return this._strStmt;
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public int getColumnCount() {
        return this.src.displayedColumns().size();
    }

    public String getColumnName(int n) {
        try {
            String string = this.src.displayedColumns().get(n);
            if (string != null) {
                return string;
            }
            return "??";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "?";
        }
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object object, int n) {
        String string = this.getColumnName(n);
        return ((AutotraceTreeNode)object).getValue(string);
    }

    private static int minLevel(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n2;
            } else if (string.charAt(i) == ')') {
                --n2;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static void predicates(AutotraceTreeNode autotraceTreeNode, String string) {
        Object object;
        Object object2;
        String string2 = string.trim();
        if (string2.startsWith("(") && string2.endsWith(")") && AutotraceTreeModel.minLevel((String)(object2 = string2.substring(1, string2.length() - 1))) >= 0) {
            AutotraceTreeModel.predicates(autotraceTreeNode, (String)object2);
            return;
        }
        object2 = new StringTokenizer(string2, "() ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            n2 += ((String)object).length();
            if (" ".equals(object)) continue;
            if ("(".equals(object)) {
                ++n3;
                continue;
            }
            if (")".equals(object)) {
                --n3;
                continue;
            }
            if (n3 == 0 && !bl && "and".equalsIgnoreCase((String)object)) {
                arrayList.add(string2.substring(n, n2 - "and".length()));
                n = n2;
                continue;
            }
            if (n3 != 0 || !"or".equalsIgnoreCase((String)object)) continue;
            if (!bl) {
                arrayList = new ArrayList();
                n = 0;
                bl = true;
            }
            arrayList.add(string2.substring(n, n2 - "or".length()));
            n = n2;
        }
        if (arrayList.size() > 0) {
            arrayList.add(string2.substring(n));
            object = new AutotraceTreeNode();
            ((AutotraceTreeNode)object).color = new Color(204);
            ((AutotraceTreeNode)object).operation = bl ? "OR" : "AND";
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, (String)arrayList.get(i));
            }
        } else {
            object = new AutotraceTreeNode();
            ((AutotraceTreeNode)object).color = new Color(238);
            ((AutotraceTreeNode)object).operation = string2;
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
        }
    }

    public static void projection(AutotraceTreeNode autotraceTreeNode, String string) {
        int n = string.indexOf("], ");
        n = n < 0 ? string.length() : ++n;
        String string2 = string.substring(0, n);
        int n2 = string2.indexOf(91);
        if (n2 < 0) {
            return;
        }
        int n3 = string2.indexOf(44, n2);
        if (n3 < 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode();
            autotraceTreeNode2.color = new Color(26197);
            autotraceTreeNode2.isSpanned = true;
            autotraceTreeNode2.operation = string3 + "[" + string4 + "]";
            autotraceTreeNode.add(autotraceTreeNode2);
        } else {
            String string5 = string2.substring(0, n2);
            String string6 = string2.substring(n2 + 1, n3);
            String string7 = string2.substring(n3 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode3 = new AutotraceTreeNode();
            autotraceTreeNode3.color = new Color(0x556600);
            autotraceTreeNode3.operation = string5 + "[" + string6 + "," + string7 + "]";
            autotraceTreeNode3.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode3);
        }
        if (n < string.length()) {
            AutotraceTreeModel.projection(autotraceTreeNode, string.substring(n + 2));
        }
    }

    public static void parseXML(AutotraceTreeNode autotraceTreeNode, String string) {
        String string2 = string.trim();
        if (!string2.startsWith("<")) {
            AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode();
            autotraceTreeNode2.color = new Color(0x886600);
            autotraceTreeNode2.operation = string2;
            autotraceTreeNode2.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode2);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "<> ", true);
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            AutotraceTreeNode autotraceTreeNode3;
            String string6 = stringTokenizer.nextToken();
            if (string5 != null) {
                string5 = string5 + string6;
            }
            if ("<".equals(string6)) {
                bl = true;
                continue;
            }
            if (">".equals(string6)) {
                bl = false;
                if (string3 == null || string5 != null) continue;
                string5 = "";
                continue;
            }
            if (!bl) continue;
            if (string3 == null) {
                string3 = string6;
                string4 = string6;
                if (!string3.startsWith("!")) continue;
                autotraceTreeNode3 = new AutotraceTreeNode();
                autotraceTreeNode3.color = new Color(0x886600);
                string4 = string4.replace("![CDATA[", "");
                autotraceTreeNode3.operation = string4 = string4.replace("]]", "");
                autotraceTreeNode3.isSpanned = true;
                autotraceTreeNode.add(autotraceTreeNode3);
                string3 = null;
                string4 = null;
                string5 = null;
                continue;
            }
            if (string6.startsWith("/") && string6.substring(1).equals(string3)) {
                autotraceTreeNode3 = new AutotraceTreeNode();
                autotraceTreeNode3.color = new Color(0x668800);
                autotraceTreeNode3.operation = string4;
                autotraceTreeNode3.isSpanned = true;
                autotraceTreeNode.add(autotraceTreeNode3);
                int n = string5.lastIndexOf("</");
                AutotraceTreeModel.parseXML(autotraceTreeNode3, string5.substring(0, n));
                string3 = null;
                string4 = null;
                string5 = null;
                continue;
            }
            if (string5 != null) continue;
            string4 = string4 + string6;
        }
    }

    public static void printPredicates(AutotraceTreeNode autotraceTreeNode, int n) {
        int n2;
        System.out.println();
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("   ");
        }
        System.out.print(autotraceTreeNode.operation);
        for (n2 = 0; n2 < autotraceTreeNode.getChildCount(); ++n2) {
            AutotraceTreeModel.printPredicates((AutotraceTreeNode)autotraceTreeNode.getChildAt(n2), n + 1);
        }
    }

    public static void main(String[] stringArray) {
        String string = "(( (\"O\".\"TYPE#\"=1 AND =1)) AND (INTERNAL_FUNCTION(\"O\".\"OWNER#\") OR (\"O\".\"TYPE#\"<>11 AND \"O\".\"TYPE#\"<>14 AND  IS NOT NULL) OR (INTERNAL_FUNCTION(\"O\".\"TYPE#\") AND  IS NOT NULL)           ))";
        AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode();
        AutotraceTreeModel.predicates(autotraceTreeNode, string);
        AutotraceTreeModel.printPredicates(autotraceTreeNode, 0);
    }
}

