/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.bindDialog;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogModel;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public final class BindDialogBuilder {
    private static final String[] SUPPORTED_TYPES = new String[]{"VARCHAR2", "NUMERIC", SQLWorksheetArb.getString(23), SQLWorksheetArb.getString(24)};

    private BindDialogBuilder() {
    }

    private static JEWTDialog _createDialog(BindDialogModel bindDialogModel, BindDialogPanel bindDialogPanel, String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        String string2 = bindDialogModel.getObjectType();
        String string3 = "f1_bindvariables_html";
        boolean bl = true;
        String string4 = SQLWorksheetArb.getString(25) + " " + string;
        string3 = "f1_bindvariables_html";
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, string4, 7);
        jEWTDialog.setContent((Component)bindDialogPanel);
        jEWTDialog.setInitialFocus((Component)bindDialogPanel.fldName);
        HelpSystem.getHelpSystem().registerTopic((JComponent)bindDialogPanel, string3);
        bindDialogPanel.setUseType(bl);
        bindDialogPanel.setTypesList(bindDialogModel.getTypesList());
        return jEWTDialog;
    }

    public static BindDialogModel _getDefaultModel(Context context) {
        String string = null;
        BindDialogModel bindDialogModel = new BindDialogModel(string, null);
        bindDialogModel.setTypesList(BindDialogBuilder._getTypesList());
        return bindDialogModel;
    }

    private static String _validateModel(String string, String string2, PropertyChangeEvent propertyChangeEvent) {
        String string3 = "";
        if (string2 == null) {
            string3 = SQLWorksheetArb.getString(28);
        } else if (string != null && !string.equals("")) {
            if (string2.equals("NUMERIC")) {
                try {
                    new BigDecimal(string);
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = SQLWorksheetArb.getString(27);
                }
            } else if (string2.equals(SQLWorksheetArb.getString(23))) {
                if (!BindDialogBuilder.checkDate(string, "dd/MM/yyyy")) {
                    string3 = SQLWorksheetArb.getString(26);
                }
            } else if (string2.equals(SQLWorksheetArb.getString(24)) && !BindDialogBuilder.checkDate(string, "MM/dd/yyyy")) {
                string3 = SQLWorksheetArb.getString(26);
            }
        }
        return string3;
    }

    private static boolean checkDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = null;
        boolean bl = true;
        try {
            date = new Date(simpleDateFormat.parse(string).getTime());
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    public static BindDialogModel createBindDialog(Context context, String string) {
        final BindDialogModel bindDialogModel = BindDialogBuilder._getDefaultModel(context);
        bindDialogModel.setIsValid(false);
        String string2 = bindDialogModel.getObjectType();
        final BindDialogPanel bindDialogPanel = new BindDialogPanel();
        final JEWTDialog jEWTDialog = BindDialogBuilder._createDialog(bindDialogModel, bindDialogPanel, string);
        if (jEWTDialog != null) {
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                        String string = bindDialogPanel.getObjectType();
                        String string2 = bindDialogPanel.getObjectName();
                        String string3 = BindDialogBuilder._validateModel(string2, string, propertyChangeEvent);
                        if (!string3.equals("")) {
                            MessageDialog.error((Component)jEWTDialog, (Object)string3, (String)SQLWorksheetArb.getString(29), null);
                            throw new PropertyVetoException(string3, propertyChangeEvent);
                        }
                        bindDialogModel.setObjectType(string);
                        bindDialogModel.setObjectName(string2);
                    }
                }
            });
            bindDialogModel.setIsValid(WizardLauncher.runDialog((JDialog)jEWTDialog));
        }
        return bindDialogModel;
    }

    private static List _getTypesList() {
        return Arrays.asList(SUPPORTED_TYPES);
    }
}

