/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.dbmsoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.dbtools.sqlworksheet.dbmsoutput.SqlEditorOutputPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.ide.Ide;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public class DbmsOutputPane
extends SqlEditorOutputPane
implements ConnectionListener {
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private JTextField bufferSize;
    private int pollCycle = 15;
    private Timer localTimer = null;
    private Connection connLocal = null;
    private boolean enabled = false;
    private final Toolbar _toolbar = new Toolbar();
    Timer timer;
    boolean frozen = false;
    int delay;

    public DbmsOutputPane(SqlEditorMainPanel sqlEditorMainPanel) {
        super(sqlEditorMainPanel);
        this.initGUI();
        Connections.getInstance().addConnectionListener((ConnectionListener)this);
    }

    public void setDividerLocation(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDbmsOutput() {
        if (!this.enabled) {
            String string;
            try {
                if (this.localTimer != null) {
                    this.localTimer.cancel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.localTimer = null;
            String string2 = this.bufferSize.getText();
            try {
                int n = Integer.parseInt(string2);
                string = "BEGIN DBMS_OUTPUT.ENABLE(" + string2 + "); END;";
            }
            catch (NumberFormatException numberFormatException) {
                string = "BEGIN DBMS_OUTPUT.ENABLE(-1); END;";
            }
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.connLocal.prepareCall(string);
                callableStatement.execute();
                this._toolbar.getComponent(6).setEnabled(true);
                this._toolbar.getComponent(7).setEnabled(true);
                this._toolbar.getComponent(8).setEnabled(true);
                this._toolbar.getComponent(9).setEnabled(true);
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "set serveroutput on\n", null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
                this.start_poll(this.connLocal);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableDbmsOutput() {
        if (this.enabled) {
            String string = "BEGIN DBMS_OUTPUT.DISABLE(); END;";
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.connLocal.prepareCall(string);
                callableStatement.execute();
                this._toolbar.getComponent(6).setEnabled(false);
                this._toolbar.getComponent(7).setEnabled(false);
                this._toolbar.getComponent(8).setEnabled(false);
                this._toolbar.getComponent(9).setEnabled(false);
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "set serveroutput off\n", null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
                this.stop_poll(this.connLocal);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.enabled = false;
        }
    }

    public void setupPoller() {
    }

    public void setConnection(Connection connection) {
        this.connLocal = connection;
        if (this.enabled) {
            this.enabled = false;
            this.enableDbmsOutput();
        }
    }

    public void setStatement(String string) {
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void stop_poll(Connection connection) {
        try {
            if (this.localTimer != null) {
                this.localTimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.localTimer = null;
    }

    private void start_poll(Connection connection) {
        try {
            if (this.localTimer != null) {
                this.localTimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.localTimer = null;
        this.localTimer = new Timer();
        this.localTimer.schedule((TimerTask)new Poller(connection, this.textPanelArea), 0L, 3000L);
    }

    protected void initGUI() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.installToolbar("DBMSOutput.Toolbar", this._toolbar, (View)this.getMainPanel().getEditor());
        this._toolbar.addSeparator(new Dimension(15, 15));
        JLabel jLabel = new JLabel("Buffer Size:");
        this._toolbar.add((Component)jLabel);
        this.bufferSize = new JTextField();
        this.bufferSize.setColumns(10);
        this.bufferSize.setText("20000");
        this.bufferSize.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == 'u') {
                    DbmsOutputPane.this.bufferSize.setText("unlimited");
                    keyEvent.consume();
                } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    DbmsOutputPane.this.getToolkit().beep();
                    keyEvent.consume();
                }
            }
        });
        this.bufferSize.setMaximumSize(new Dimension(70, 20));
        this._toolbar.add((Component)this.bufferSize);
        JSlider jSlider = new JSlider();
        jSlider.setMaximum(15);
        jSlider.setPaintTicks(true);
        jSlider.setToolTipText("Poll frequency [Max 15s]");
        jSlider.setFont(new Font("Dialog", 0, 7));
        jSlider.setMinorTickSpacing(1);
        jSlider.setMajorTickSpacing(15);
        jSlider.setMaximumSize(new Dimension(80, 20));
        jSlider.setActionMap(new ActionMap());
        jSlider.setSnapToTicks(true);
        MouseListener mouseListener = new MouseListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                int n = jSlider.getValue();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                JSlider jSlider = (JSlider)mouseEvent.getSource();
                int n = jSlider.getValue();
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        jSlider.addMouseListener(mouseListener);
        this._toolbar.add((Component)jSlider);
        JLabel jLabel2 = new JLabel("Poll");
        this._toolbar.add((Component)jLabel2);
        JScrollPane jScrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.add((Component)jScrollPane, "Center");
        UIUtils.addFontListener((Component)this.textPanelArea);
    }

    public void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateVisibleActions() {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.stop_poll(null);
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        this.stop_poll(null);
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        this.stop_poll(null);
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
        this.stop_poll(null);
    }

    public boolean isFocussed() {
        return this.textPanelArea.isFocusOwner();
    }

    public String getOutputText() {
        return this.textPanelArea.getText();
    }

    public String getPaneName() {
        return "DBMS Output";
    }

    protected void initCommands() {
        this.SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"dbmsoutput.save_output");
        this.PRINT_CMD_ID = Ide.findOrCreateCmdID((String)"dbmsoutput.print_output");
        this.CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"dbmsoutput.clear");
    }

    class Poller
    extends TimerTask {
        private Connection localConn = null;
        private CallableStatement show_stmt;
        private BasicEditorPane textPanelArea;

        public Poller(Connection connection, BasicEditorPane basicEditorPane) {
            this.textPanelArea = basicEditorPane;
            this.localConn = connection;
            try {
                this.show_stmt = this.largeBuffer(connection) ? this.localConn.prepareCall("declare     l_line varchar2(32767);     l_done number;     l_buffer varchar2(32767) := '';    l_lengthbuffer number := 0;    l_lengthline number := 0;  begin   loop     dbms_output.get_line( l_line, l_done );     if (l_buffer is null) then       l_lengthbuffer := 0;     else       l_lengthbuffer := length(l_buffer);     end if;     if (l_line is null) then       l_lengthline := 0;     else       l_lengthline := length(l_line);     end if;     exit when l_lengthbuffer + l_lengthline > :maxbytes OR l_lengthbuffer + l_lengthline > 32767 OR l_done = 1;     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer;  :line := l_line; end;") : this.localConn.prepareCall("declare     l_line varchar2(255);     l_done number;     l_buffer long; begin   loop     exit when length(l_buffer)+255 > :maxbytes OR l_done = 1;     dbms_output.get_line( l_line, l_done );     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer; end;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private boolean largeBuffer(Connection connection) {
            boolean bl = false;
            int[] nArray = DBUtil.getDbVersion((Connection)connection).toIntArray();
            if (nArray[0] > 10) {
                bl = true;
            } else if (nArray[0] == 10 && nArray[1] >= 2) {
                bl = true;
            }
            return bl;
        }

        public void run() {
            int n = 0;
            try {
                this.show_stmt.registerOutParameter(2, 4);
                this.show_stmt.registerOutParameter(3, 12);
                if (this.largeBuffer(this.localConn)) {
                    this.show_stmt.registerOutParameter(4, 12);
                }
                do {
                    this.show_stmt.setInt(1, DbmsOutputPane.this.pollCycle * 1000);
                    this.show_stmt.executeUpdate();
                    String string = "";
                    if (this.largeBuffer(this.localConn)) {
                        String string2 = this.show_stmt.getString(3);
                        if (string2 != null) {
                            string = this.show_stmt.getString(3);
                        }
                        string = (string2 = this.show_stmt.getString(4)) != null ? string + this.show_stmt.getString(4) + "\n" : string + "\n";
                    } else {
                        string = this.show_stmt.getString(3);
                    }
                    if (string.length() <= 1) continue;
                    try {
                        this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                    }
                } while ((n = this.show_stmt.getInt(2)) != 1);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    class OutputRedirectorZ
    extends Thread {
        PipedInputStream in;
        Document text;
        JScrollPane display;
        String line = "";
        BufferedReader reader;

        public OutputRedirectorZ(PipedInputStream pipedInputStream, Document document) {
            this.in = pipedInputStream;
            this.text = document;
            this.reader = new BufferedReader(new InputStreamReader(pipedInputStream));
        }

        public void run() {
            try {
                while (this.line != null) {
                    try {
                        this.text.insertString(DbmsOutputPane.this.textPanelArea.getDocument().getLength(), this.line + "\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                    }
                    this.line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

