/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.dbmsoutput;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.util.Translate;
import oracle.dbtools.util.Utility;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public abstract class SqlEditorOutputPane
extends JPanel {
    public int SAVE_CMD_ID = 11;
    public int PRINT_CMD_ID = 16;
    public int CLEAR_CMD_ID = -11111;
    protected SqlEditorMainPanel mainPanel;

    public SqlEditorOutputPane(SqlEditorMainPanel sqlEditorMainPanel) {
        this.mainPanel = sqlEditorMainPanel;
        this.initCommands();
    }

    protected abstract void initCommands();

    protected abstract void initGUI();

    public boolean saveFile(URL uRL) {
        String string = this.getEncoding();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(uRL.getPath());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write(this.getOutputText());
            outputStreamWriter.close();
            return true;
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Translate.translate((String)"Could Not Create File"), (String)(uRL.getPath() + uRL.getFile()), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
    }

    public boolean printOutput() {
        return Utility.printText((String)this.getPaneName(), (String)this.getOutputText());
    }

    public abstract void clear();

    public abstract void setConnection(Connection var1);

    public abstract void setStatement(String var1);

    public SqlEditorMainPanel getMainPanel() {
        return this.mainPanel;
    }

    public abstract boolean isFocussed();

    public abstract String getPaneName();

    public abstract String getOutputText();

    public String getEncoding() {
        return IdeUtil.getIdeEncoding();
    }
}

