/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.explainPlan;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.FilePanelAcc;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.dialogs.MessageDialog;

public class ExplainContextMenuListener
implements ContextMenuListener {
    private JMenu _menu;
    private JTable _table;
    private static ExplainContextMenuListener _instance;
    private static final Object LOCK;
    private static File _lastUrl;
    String ext = "";
    FilePanelAcc panelAcc = new FilePanelAcc();

    private ExplainContextMenuListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExplainContextMenuListener getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ExplainContextMenuListener();
            }
        }
        return _instance;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        contextMenu.addSeparator();
        contextMenu.add((Component)this.getMenu());
        this._table = (JTable)contextMenu.getContext().getProperty("EXPLAINTABLE");
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public JMenu getMenu() {
        if (this._menu == null) {
            this._menu = new JMenu("Export");
            List list = FormatRegistry.getTypes();
            for (final String string : list) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        File file = ExplainContextMenuListener.this.getFileName(string);
                        if (file != null) {
                            OutputStreamWriter outputStreamWriter;
                            FileOutputStream fileOutputStream;
                            try {
                                fileOutputStream = new FileOutputStream(file);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Unable to open file", (String)"Error", null);
                                return;
                            }
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                            try {
                                outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, ExplainContextMenuListener.this.panelAcc.getEncoding());
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
                            }
                            IResultFormatter iResultFormatter = FormatRegistry.getFormatter((String)actionEvent.getActionCommand());
                            iResultFormatter.setTableName("EXPLAIN_PLAN");
                            iResultFormatter.setDataProvider((ResultsFormatterWrapper)new TableFormatterWrapper(ExplainContextMenuListener.this._table));
                            iResultFormatter.setOutWriter(outputStreamWriter);
                            iResultFormatter.print();
                            try {
                                outputStreamWriter.close();
                            }
                            catch (IOException iOException) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Error closing file", (String)"Error", null);
                            }
                            ExplainContextMenuListener.this._table = null;
                        }
                    }
                });
                this._menu.add(jMenuItem);
            }
        }
        return this._menu;
    }

    public File getFileName(String string) {
        String string2;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAccessory((JComponent)this.panelAcc);
        jFileChooser.setDialogTitle("Choose File");
        if ("TEXT".equals(string)) {
            this.ext = "txt";
        } else if ("CSV".equals(string)) {
            this.ext = "csv";
        } else if ("LOADER".equals(string)) {
            this.ext = "dat";
        } else if ("INSERT".equals(string)) {
            this.ext = "sql";
        } else if ("XML".equals(string)) {
            this.ext = "xml";
        } else if ("HTML".equals(string)) {
            this.ext = "htm";
        } else if ("XLS".equals(string)) {
            this.ext = "xls";
        }
        if (_lastUrl == null) {
            string2 = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
            if (string2 == null || string2.equals("")) {
                string2 = System.getProperty("user.home");
            }
            File file = new File(string2 + "explain." + this.ext);
            jFileChooser.setSelectedFile(file);
        } else {
            jFileChooser.setSelectedFile(_lastUrl);
        }
        if (jFileChooser.showSaveDialog(null) == 0) {
            int n;
            string2 = jFileChooser.getSelectedFile().toString();
            String string3 = string2.substring(n = string2.lastIndexOf(File.separator));
            _lastUrl = string3.lastIndexOf(".") > -1 ? jFileChooser.getSelectedFile() : new File(jFileChooser.getSelectedFile().toString() + "." + this.ext);
            return _lastUrl;
        }
        return null;
    }

    static {
        LOCK = new Object();
    }
}

