/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.owaoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.dbmsoutput.SqlEditorOutputPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.ide.Ide;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public class OWAOutputPane
extends SqlEditorOutputPane {
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private int pollCycle = 15;
    private Timer localTimer = null;
    private Connection connLocal = null;
    private boolean enabled = false;
    private final Toolbar _toolbar = new Toolbar();
    Timer timer;
    boolean frozen = false;
    int delay;

    public OWAOutputPane(SqlEditorMainPanel sqlEditorMainPanel) {
        super(sqlEditorMainPanel);
        this.initGUI();
    }

    public void setDividerLocation(int n) {
    }

    public void enableOwaOutput() {
        if (!this.enabled) {
            try {
                if (this.localTimer != null) {
                    this.localTimer.cancel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.localTimer = null;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (OWAOutputPane.this.connLocal != null) {
                        Connections.getInstance().lock(OWAOutputPane.this.connLocal);
                        Statement statement = null;
                        try {
                            statement = OWAOutputPane.this.connLocal.createStatement();
                            statement.execute("declare\n    nm  owa.vc_arr;\n    vl  owa.vc_arr;\nbegin\n    nm(1) := 'SERVER_PORT';\n    vl(1) := '80';\n    owa.init_cgi_env( 1, nm, vl );\nend;");
                        }
                        catch (SQLException sQLException) {
                        }
                        finally {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            Connections.getInstance().unlock(OWAOutputPane.this.connLocal);
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setName("OwaInit");
            thread.start();
            try {
                this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "OWA output on\n", null);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
            }
            this.start_poll(this.connLocal);
        }
        this.enabled = true;
    }

    public void disableOwaOutput() {
        if (this.enabled) {
            try {
                this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "OWA output off\n", null);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
            }
            this.stop_poll(this.connLocal);
        }
        this.enabled = false;
    }

    public void setupPoller() {
    }

    public void setConnection(Connection connection) {
        this.connLocal = connection;
    }

    public void setStatement(String string) {
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void stop_poll(Connection connection) {
        try {
            if (this.localTimer != null) {
                this.localTimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.localTimer = null;
    }

    private void start_poll(Connection connection) {
        try {
            if (this.localTimer != null) {
                this.localTimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.localTimer = null;
        this.localTimer = new Timer();
        this.localTimer.schedule((TimerTask)new Poller(connection, this.textPanelArea), 0L, 3000L);
    }

    protected void initGUI() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.installToolbar("OWAOutput.Toolbar", this._toolbar, (View)this.getMainPanel().getEditor());
        this._toolbar.addSeparator(new Dimension(15, 15));
        this._toolbar.getComponent(0).setEnabled(true);
        this._toolbar.getComponent(2).setEnabled(true);
        this._toolbar.getComponent(1).setEnabled(true);
        this._toolbar.getComponent(3).setEnabled(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.add((Component)jScrollPane, "Center");
        PipedInputStream pipedInputStream = new PipedInputStream();
    }

    public void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateVisibleActions() {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    public boolean isFocussed() {
        return this.textPanelArea.isFocusOwner();
    }

    public String getOutputText() {
        return this.textPanelArea.getText();
    }

    public String getPaneName() {
        return "OWA Output";
    }

    protected void initCommands() {
        this.SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"owaoutput.save_output");
        this.PRINT_CMD_ID = Ide.findOrCreateCmdID((String)"owaoutput.print_output");
        this.CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"owaoutput.clear");
    }

    class Poller
    extends TimerTask {
        private Connection localConn = null;
        private int gDB_State;
        private CallableStatement show_stmt;
        static final int STATE_NONE = 0;
        static final int STATE_FETCHING = 1;
        static final int STATE_FINISHED = 2;
        static final int MAX_PL_LINES = 127;
        private BasicEditorPane textPanelArea;

        public Poller(Connection connection, BasicEditorPane basicEditorPane) {
            this.textPanelArea = basicEditorPane;
            this.localConn = connection;
        }

        public void run() {
            try {
                this.getGeneratedStream();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }

        public void getGeneratedStream() throws SQLException {
            StringBuffer stringBuffer = new StringBuffer();
            this.gDB_State = 0;
            while (this.gDB_State != 2) {
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), this.getDataBlock(), null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataBlock() throws SQLException {
            String string;
            Statement statement = null;
            try {
                String string2 = "declare nlns number;\n buf_t varchar2(32767);\n lines htp.htbuf_arr;\nbegin\n  nlns := ?;\n  OWA.GET_PAGE(lines, nlns);\n  if (nlns < 1) then\n   buf_t := null;\n  else \n   for i in 1..nlns loop\n     buf_t:=buf_t||lines(i);\n   end loop;\n  end if;\n  ? := buf_t; ? := nlns;\nend;";
                int n = 127;
                statement = this.localConn.prepareCall(string2);
                statement.setInt(1, n);
                statement.registerOutParameter(2, 12);
                statement.registerOutParameter(3, -5);
                statement.execute();
                n = statement.getInt(3);
                this.gDB_State = 1;
                if (n < 127) {
                    this.gDB_State = 2;
                    if (n < 1) {
                        String string3 = "";
                        return string3;
                    }
                }
                string = statement.getString(2);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string;
        }
    }
}

