/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.scriptRunner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.sqlworksheet.dbmsoutput.SqlEditorOutputPane;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.javatools.editor.BasicEditorPane;

public abstract class BaseScriptRunnerPane
extends SqlEditorOutputPane {
    protected Logger logger = Logger.getLogger(ScriptRunnerPane.class.getName());
    protected BasicEditorPane textPanelArea = new BasicEditorPane();
    protected ScriptRunnerContext scriptRunnerContext = null;
    protected ScriptRunner runner;
    protected boolean interrupted = false;
    protected Connection connLocal = null;

    public BaseScriptRunnerPane(SqlEditorMainPanel sqlEditorMainPanel) {
        super(sqlEditorMainPanel);
    }

    public void cancelScript() {
        if (this.runner != null) {
            this.runner.interrupt();
        } else {
            this.interrupted = true;
        }
    }

    public boolean isFinished() {
        return !this.runner.isAlive();
    }

    public BasicEditorPane getScriptOutput() {
        return this.textPanelArea;
    }

    public void setDividerLocation(int n) {
    }

    public void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getEncoding() {
        return "UTF8";
    }

    public void setStatement(String string) {
        BufferedOutputStream bufferedOutputStream;
        PipedInputStream pipedInputStream;
        block3: {
            pipedInputStream = new PipedInputStream();
            bufferedOutputStream = null;
            this.getScriptRunnerContext();
            try {
                bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
            }
            catch (IOException iOException) {
                if (this.interrupted) break block3;
                this.logger.log(Level.SEVERE, "setStatement", iOException);
            }
        }
        this.runner = new ScriptRunner(this.getConnection());
        this.scriptRunnerContext.setTopLevel(true);
        this.scriptRunnerContext.setLastUrl(this.getLastURL());
        this.runner.setOut(bufferedOutputStream);
        this.runner.setScriptRunnerContext(this.scriptRunnerContext);
        this.runner.setStmt(string);
        this.runner.setName("SQL Worksheet Execution Thread");
        if (!this.interrupted) {
            this.runner.start();
        }
        this.interrupted = false;
        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, this.textPanelArea.getDocument(), this.textPanelArea);
        outputRedirector.setName("Worksheet output reader");
        outputRedirector.start();
    }

    protected abstract URL getLastURL();

    protected Connection getConnection() {
        return this.connLocal;
    }

    public void moveToLastRow() {
        this.textPanelArea.setCaretPositionCenter(this.textPanelArea.getDocument().getLength());
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        if (this.scriptRunnerContext == null) {
            this.scriptRunnerContext = new ScriptRunnerContext();
        }
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }

    public void setConnection(Connection connection) {
        this.connLocal = connection;
    }

    protected void initGUI() {
        JScrollPane jScrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    protected void setToolbar(JToolBar jToolBar) {
        this.add((Component)jToolBar, "First");
    }

    public boolean isFocussed() {
        return this.textPanelArea.isFocusOwner();
    }
}

