/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.BindConfig;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.scriptrunner.Substitution;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.autotrace.AutotracePane;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogModel;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorAddin;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorHistory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;

public final class SqlEditor
extends Editor
implements FindableEditor,
IDBEditor,
ChangeListener,
StatusProvider,
IStatusMessageProvider {
    private Logger logger = Logger.getLogger(SqlEditor.class.getName());
    public static final Class _editorClass = SqlEditor.class;
    public static final String PROTOCOL = "ide.sqleditor";
    SqlEditorMainPanel view = null;
    private boolean _isOracle = true;
    private SqlEditorController _controller = SqlEditorController.getInstance();
    Component focusedComponent;
    private CopyableResultSetTableAdapter _copyableTableAdapter;
    private boolean _isExecuting;
    private Component _activeSubPage = null;
    private Database _db = null;
    private String bindLabel = null;
    private boolean runReport;
    private BindDialogModel dialogModel = null;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqlWorksheet-attributes");
    private static final String ROOT_TAG = "ExplainPlanTable";
    private static boolean _isOpening = false;
    private SqlEditorHistory _history = SqlEditorHistory.getInstance();
    NamedSwingWorker worker = null;
    private boolean interrupted = false;
    long duration = 0L;
    long start = 0L;
    private String _md5;
    private JLabel _statusConn;
    private String _lastStatus;
    private HighlightLayer _hl;
    private HighlightStyle _hs;
    private HighlightedText _h;
    private Version _cachedVersion;
    private Connection _cachedConnection;
    private static final String TMP_FILE_PREFIX = "sqldev";
    public static final String EDITOR_CONTEXT = "sqldev.editor.context";
    private static final String UNSUFFICIENT_PRIVILEGES = "Insufficient privileges";

    public int getHistorySize() {
        if (this._history == null) {
            return 0;
        }
        SqlEditor sqlEditor = this;
        return sqlEditor._history.getHistorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecute() {
        try {
            block5: {
                try {
                    if (this.view != null) {
                        this.view.cancelScript();
                    }
                    if (this.worker == null) break block5;
                    this.worker.interrupt();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    Object var3_2 = null;
                    this.view.toggleProgress(false);
                }
            }
            Object var3_1 = null;
            this.view.toggleProgress(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.view.toggleProgress(false);
            throw throwable;
        }
    }

    public Component getActiveSubPage() {
        return this._activeSubPage;
    }

    public final void commit() {
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Exception)sQLException);
        }
        this.setStatusBarMessage("Commit Processed.");
    }

    public final void rollback() {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Exception)sQLException);
        }
        this.setStatusBarMessage("Rollback Processed.");
    }

    public final void executeSql() {
        this.executeSql(null, null);
    }

    public final void autotrace() {
        Object object;
        final Connection connection = this._db.getConnection();
        String string = "<current user>";
        try {
            string = connection.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String string2 = "Failed to access V$MYSTAT.\nPlease obtain read catalog privilege\nfrom your database administrator:\ngrant SELECT_CATALOG_ROLE to " + string + "\n" + "grant SELECT ANY DICTIONARY to " + string + "\n" + "NOTE: you need to reconnect your current session\n" + "in order for the settings change to have an effect";
        try {
            object = connection.createStatement();
            object.execute("alter session set statistics_level=ALL");
            object.execute("alter session set TIMED_STATISTICS = TRUE");
            object.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Failed to set statistics_level=ALL", (String)UNSUFFICIENT_PRIVILEGES, null);
            return;
        }
        object = new HashMap();
        if (AutotracePane.showMyStat()) {
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("  select name,value, ROW_NUMBER() OVER (ORDER BY pt.STATISTIC#) num \n  from V$STATNAME sn, V$mystat pt \n  where NAME IN ('recursive calls','db block gets','consistent gets',  'physical reads','redo size','bytes sent via SQL*Net to client',  'bytes received via SQL*Net from client','SQL*Net roundtrips to/from client',  'sorts (memory)','sorts (disk)')\n  and sn.STATISTIC# = pt.STATISTIC#\n  order by pt.STATISTIC#\n");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt("num") - 1;
                    long l = resultSet.getLong("value");
                    object.put(n, l);
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 942) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)UNSUFFICIENT_PRIVILEGES, null);
                    return;
                }
                this.logger.fine("sql=  select name,value, ROW_NUMBER() OVER (ORDER BY pt.STATISTIC#) num \n  from V$STATNAME sn, V$mystat pt \n  where NAME IN ('recursive calls','db block gets','consistent gets',  'physical reads','redo size','bytes sent via SQL*Net to client',  'bytes received via SQL*Net from client','SQL*Net roundtrips to/from client',  'sorts (memory)','sorts (disk)')\n  and sn.STATISTIC# = pt.STATISTIC#\n  order by pt.STATISTIC#\n");
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                throw new RuntimeException("Failed to query mystat");
            }
        }
        long l = System.currentTimeMillis();
        String string3 = "Auto#" + l;
        String string4 = this.executeSql(null, string3);
        if (string4 == null || "".equals(string4.trim())) {
            return;
        }
        this.view.southAutotracePanel.initColumnWidths();
        this.view.southAutotracePanel.mdl.reset();
        this.view.southAutotracePanel.tbl.revalidate();
        this.view.southAutotracePanel.mystatsData.reset();
        this.view.southAutotracePanel.mystats.revalidate();
        this.view.setFocusForAutotrace();
        NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Autotrace", (Map)object, string3, string2){
            final /* synthetic */ Map val$snapshotBefore;
            final /* synthetic */ String val$marker;
            final /* synthetic */ String val$GRANT_CATALOG_ROLE;
            {
                this.val$snapshotBefore = map;
                this.val$marker = string2;
                this.val$GRANT_CATALOG_ROLE = string3;
                super(string);
            }

            public void interrupt() {
                SqlEditor.this.interrupted = true;
                this.interruptActions();
                super.interrupt();
            }

            private void interruptActions() {
                SqlEditor.this.runReport = false;
            }

            public Object construct() {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                for (int i = 0; i == 0 || SqlEditor.this.isExecuteInProgress() && ExceptionHandler.wasException() == null; ++i) {
                    try {
                        Thread.sleep(100L, 0);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                        throw new RuntimeException("Interrupted: not supposed to");
                    }
                }
                Exception exception = ExceptionHandler.wasException();
                if (exception != null) {
                    ExceptionHandler.reset();
                    if (!(exception instanceof SQLException)) {
                        return null;
                    }
                    if (((SQLException)exception).getErrorCode() != 1013) {
                        return null;
                    }
                } else {
                    ExceptionHandler.reset();
                }
                SqlEditor.this.view.toggleProgress(true);
                if (AutotracePane.showMyStat()) {
                    try {
                        object4 = connection.prepareStatement("  select name,value, ROW_NUMBER() OVER (ORDER BY pt.STATISTIC#) num \n  from V$STATNAME sn, V$mystat pt \n  where NAME IN ('recursive calls','db block gets','consistent gets',  'physical reads','redo size','bytes sent via SQL*Net to client',  'bytes received via SQL*Net from client','SQL*Net roundtrips to/from client',  'sorts (memory)','sorts (disk)')\n  and sn.STATISTIC# = pt.STATISTIC#\n  order by pt.STATISTIC#\n");
                        object3 = object4.executeQuery();
                        while (object3.next()) {
                            int n = object3.getInt("num") - 1;
                            object2 = object3.getString("name");
                            long l = object3.getLong("value");
                            SqlEditor.this.view.southAutotracePanel.mystatsData.names.put(n, (String)object2);
                            SqlEditor.this.view.southAutotracePanel.mystatsData.values.put(n, l - (Long)this.val$snapshotBefore.get(n));
                        }
                        object3.close();
                        object4.close();
                        SqlEditor.this.view.southAutotracePanel.mystatsData.fireTableDataChanged();
                        SqlEditor.this.view.southAutotracePanel.mystats.invalidate();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        SqlEditor.this.view.toggleProgress(false);
                        throw new RuntimeException("Failed to query mystat");
                    }
                }
                object4 = null;
                object3 = null;
                try {
                    object = connection.prepareStatement("select hash_value, child_number from v$sql \n where sql_text like ?  \n order by last_load_time desc");
                    object.setString(1, "%" + this.val$marker + "%");
                    object2 = object.executeQuery();
                    object2.next();
                    object4 = object2.getString("hash_value");
                    object3 = object2.getString("child_number");
                    object2.close();
                    object.close();
                }
                catch (SQLException sQLException) {
                    SqlEditor.this.view.toggleProgress(false);
                    if (sQLException.getErrorCode() == 942) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.val$GRANT_CATALOG_ROLE, (String)SqlEditor.UNSUFFICIENT_PRIVILEGES, null);
                        return null;
                    }
                    SqlEditor.this.logger.log(Level.WARNING, "select hash_value from v$sql", sQLException);
                    return null;
                }
                SqlEditor.this.logger.info("hash_value=" + (String)object4);
                SqlEditor.this.view.southAutotracePanel.mdl.reload((String)object4, (String)object3, connection);
                object = SqlEditor.this.view.southAutotracePanel.tbl.getTree();
                for (int i = 0; i < ((JTree)object).getRowCount(); ++i) {
                    ((JTree)object).expandRow(i);
                }
                SqlEditor.this.view.southAutotracePanel.tbl.revalidate();
                SqlEditor.this.view.toggleProgress(false);
                try {
                    Statement statement = connection.createStatement();
                    statement.execute("rollback");
                    statement.execute("alter session set statistics_level=TYPICAL");
                    statement.close();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException("Failed to restore statistics_level=TYPICAL");
                }
                return new Object();
            }

            public void finished() {
                SqlEditor.this.view.southAutotracePanel.initColumnWidths();
            }
        };
        namedSwingWorker.start();
    }

    public final String executeSql(String string, String string2) {
        Object object;
        int n;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        Object object3 = -1;
        Object object4 = -1;
        this.view.toggleProgress(true);
        if (string == null) {
            string = this.view.getSqlStatement();
            bl = this.view.isTextSelected();
            if (bl) {
                object2 = this.view.getSelectionLineColumn();
                object3 = object2[0];
                object4 = object2[1];
                bl2 = true;
            }
        } else if (string.toUpperCase().equals("COMMIT") || string.toUpperCase().equals("ROLLBACK")) {
            bl = true;
        }
        object2 = new ScriptParser(string, this.getConnection());
        object2.parse();
        SQLCommand[] sQLCommandArray = object2.getSqlStatements();
        int n2 = this.view.getCaretLine();
        int n3 = 0;
        int n4 = 0;
        if (bl2) {
            for (n = n4; n < sQLCommandArray.length; ++n) {
                if (sQLCommandArray[n].getStmtId() == "22") continue;
                n4 = n;
                break;
            }
        }
        if (!bl) {
            for (n3 = 0; n3 < sQLCommandArray.length; ++n3) {
                if (n2 - 1 < sQLCommandArray[n3].getStartLine() || n2 - 1 > sQLCommandArray[n3].getEndLine()) continue;
                n4 = n3;
                if (this._hl == null) {
                    this._hl = this.view.getSQLEditorPane().createHighlightLayer();
                }
                if (this._hs == null) {
                    this._hs = this.view.getSQLEditorPane().getHighlightRegistry().createStyle("current_sql", "Current SQL", 0, null, Color.LIGHT_GRAY);
                }
                n = this.view.getSQLEditorPane().getLineStartOffset(sQLCommandArray[n3].getStartLine());
                int n5 = sQLCommandArray[n3].getEndLine();
                LineMap lineMap = ((BasicDocument)this.view.getSQLEditorPane().getDocument()).getLineMap();
                object = this.view.getSQLEditorPane().getLineEndOffset(n5 - 1);
                if (this._h != null) {
                    this._hl.removeHighlight(this._h);
                }
                this._h = this._hl.addHighlight(this._hs, n, object);
                this.view.getSQLEditorPane().ensurePositionVisible(n);
                bl = true;
            }
        }
        if (bl && sQLCommandArray.length > 0) {
            Substitution substitution = new Substitution(this.view.getScriptRunnerContext());
            String string3 = substitution.replaceSubstitution(sQLCommandArray[n4]);
            if (string3 != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, null, null);
                this.view.toggleProgress(false);
                return null;
            }
            string = sQLCommandArray[n4].getSql();
        } else {
            string = null;
        }
        if (string == null || string.trim().length() < 1 || sQLCommandArray[n4].getStmtId() == "22") {
            this.setStatusBarMessage(ConnectionArb.getString((int)37));
            this.view.toggleProgress(false);
            return null;
        }
        String string4 = sQLCommandArray[n4].getSQLOrig();
        final SQLCommand sQLCommand = sQLCommandArray[n4];
        Object object5 = object3;
        object = object4;
        final boolean bl3 = bl2;
        if (string4.trim().toUpperCase().startsWith("DESC") || string4.trim().toUpperCase().startsWith("@") || string4.trim().toUpperCase().startsWith("START ") || sQLCommand.getStmtId() == "29" || sQLCommand.getStmtId() == "87" || sQLCommand.getStmtId() == "73" || sQLCommand.getStmtId() == "20") {
            this.executeScriptRunnerPlan(true);
            return null;
        }
        this.view.setEnabled(false);
        this.setExecuteInProgress(true);
        View.updateToolbarActions((Toolbar)this.getToolbar());
        this.view.setFocusForResultSet();
        if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null) {
            string = "/*" + string2 + "*/ " + string;
        }
        final String string5 = string;
        int n6 = n4;
        Object object6 = object3;
        Object object7 = object4;
        this.worker = new NamedSwingWorker("worksheet", (int)object5, (int)object, (int)object6, (int)object7){
            Statement stmt;
            Connection conn;
            ResultWrapper result;
            PreparedStatement pstmt;
            Runnable showDialog;
            final /* synthetic */ int val$selectLine;
            final /* synthetic */ int val$selectColumn;
            final /* synthetic */ int val$line;
            final /* synthetic */ int val$col;
            {
                this.val$selectLine = n;
                this.val$selectColumn = n2;
                this.val$line = n3;
                this.val$col = n4;
                super(string);
                this.stmt = null;
                this.conn = null;
                this.result = null;
                this.pstmt = null;
                this.showDialog = null;
            }

            public void interrupt() {
                SqlEditor.this.interrupted = true;
                this.interruptActions();
                super.interrupt();
            }

            private void interruptActions() {
                try {
                    if (SqlEditor.this.view != null) {
                        SqlEditor.this.view.toggleProgress(false);
                        SqlEditor.this.view.getResultSetTable().cancel();
                        SqlEditor.this.logger.fine("canceled stmt in model");
                    }
                    SqlEditor.this.runReport = false;
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object construct() {
                boolean bl = false;
                SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(64)));
                this.result = null;
                if (SqlEditor.this.getConnectionName() != null) {
                    try {
                        this.conn = Connections.getInstance().getConnection(SqlEditor.this.getConnectionName());
                    }
                    catch (Exception exception) {
                        SqlEditor.this.logger.severe(Translate.translate((String)"Could not get connection."));
                        if (SqlEditor.this.view != null) {
                            ResultSetTable resultSetTable = SqlEditor.this.view.getResultSetTable();
                            if (resultSetTable != null && resultSetTable.getMdl() != null) {
                                resultSetTable.getMdl().setConn(null);
                                resultSetTable.closeModel();
                            }
                            SqlEditor.this.view.getDbSelector().setCurrentConnection(null);
                        }
                        this.conn = null;
                        return null;
                    }
                }
                if (this.conn == null) {
                    SqlEditor.this.logger.severe(Translate.translate((String)"Could not get connection"));
                    return null;
                }
                if (!Connections.getInstance().lock(this.conn)) {
                    return null;
                }
                SqlEditor.this.view.setResultSet(null, ConnectionArb.getString((int)36), false, string5);
                String string = sQLCommand.getResultsType();
                Connection connection = this.conn;
                synchronized (connection) {
                    String string2;
                    block76: {
                        block74: {
                            block73: {
                                List list;
                                int n = 0;
                                string2 = "";
                                SqlEditor.this.runReport = true;
                                String string3 = sQLCommand.getStmtId();
                                boolean bl2 = string3.equals("48") || string3.equals("88") || string3.equals("31") || string3.equals("72") || string3.equals("51") || string3.equals("92");
                                HashMap hashMap = null;
                                List list2 = list = bl2 ? DBUtil.getBinds((String)string5) : new ArrayList();
                                if (list.size() == 0 && !"1".equals(string)) {
                                    this.stmt = this.conn.createStatement();
                                    this.stmt.setEscapeProcessing(false);
                                    SqlEditor.this.start = System.nanoTime();
                                    n = this.stmt.executeUpdate(string5);
                                    ScriptParser scriptParser = new ScriptParser(sQLCommand.getSql());
                                    String string4 = scriptParser.stripLine(sQLCommand.getSql());
                                    if (string4.indexOf("setnls") > 0 || string4.startsWith("altersessionsettime_zone")) {
                                        NLSUtils.populateNLS((Connection)this.conn);
                                    }
                                    SqlEditor.this.duration = System.nanoTime() - SqlEditor.this.start;
                                } else {
                                    String string52;
                                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                                    final Query query = new Query();
                                    if (list.size() != 0) {
                                        SqlEditor.this.runReport = false;
                                        for (int i = 0; i < list.size(); ++i) {
                                            String string6;
                                            SqlEditor.this.bindLabel = (String)list.get(i);
                                            if (SqlEditor.this.bindLabel.startsWith(":") && SqlEditor.this.bindLabel.length() > 1) {
                                                SqlEditor.this.bindLabel = SqlEditor.this.bindLabel.substring(1);
                                            }
                                            if ((string6 = BindConfig.getInstance().getString(SqlEditor.this.bindLabel)) == null) {
                                                string6 = "NULL_VALUE";
                                            }
                                            string52 = new Bind(SqlEditor.this.bindLabel, SqlEditor.this.bindLabel, SqlEditor.this.bindLabel, string6, SqlEditor.this.bindLabel);
                                            if (hashMap2.get(SqlEditor.this.bindLabel) != null) continue;
                                            hashMap2.put(SqlEditor.this.bindLabel, "a value");
                                            query.addBind((Bind)string52);
                                        }
                                        try {
                                            this.showDialog = new Runnable(){

                                                public void run() {
                                                    BindInfo bindInfo = new BindInfo(query);
                                                    HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
                                                    final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)SQLWorksheetArb.getString(68), (int)14);
                                                    jEWTDialog.setDefaultButton(8);
                                                    jEWTDialog.addActionListener(new ActionListener(){

                                                        public void actionPerformed(ActionEvent actionEvent) {
                                                            SqlEditor.this.runReport = true;
                                                            jEWTDialog.dispose();
                                                        }
                                                    });
                                                    jEWTDialog.setSize(600, 300);
                                                    jEWTDialog.setPreferredSize(bindInfo.getPreferredSize());
                                                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
                                                    jEWTDialog.setVisible(true);
                                                }
                                            };
                                            Connection connection2 = this.conn;
                                            synchronized (connection2) {
                                                SwingUtilities.invokeAndWait(this.showDialog);
                                            }
                                        }
                                        catch (InterruptedException interruptedException) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            // empty catch block
                                        }
                                    }
                                    if (SqlEditor.this.runReport) {
                                        hashMap = query.getBindValues();
                                        for (String string6 : hashMap.keySet()) {
                                            string52 = null;
                                            Object v = hashMap.get(string6);
                                            if (v != null && !DBUtil.NULL_VALUE.equals(v)) {
                                                string52 = v instanceof String ? (String)v : v.toString();
                                            }
                                            BindConfig.getInstance().setString(string6, string52);
                                        }
                                        if (!"1".equals(string)) {
                                            this.pstmt = this.conn.prepareStatement(sQLCommand.getSql());
                                            this.pstmt.setEscapeProcessing(false);
                                            DBUtil.getInstance().bind(this.pstmt, (Map)hashMap);
                                            SqlEditor.this.start = System.nanoTime();
                                            n = this.pstmt.executeUpdate();
                                            SqlEditor.this.duration = System.nanoTime() - SqlEditor.this.start;
                                            this.stmt = this.pstmt;
                                        }
                                    }
                                }
                                SqlEditor.this._history.saveSql(sQLCommand.getSQLOrig().trim(), Connections.getDisplayName((String)Connections.getInstance().getConnectionName(SqlEditor.this._db)), SqlEditorHistory.TYPE_SQL_HISTORY);
                                if (SqlEditor.this.runReport) {
                                    if (string3.equals("26") || string3.equals("27")) {
                                        this.result = new ResultWrapper(null, Integer.toString(this.stmt.getUpdateCount()), true, hashMap);
                                        string2 = Translate.translate((String)SqlEditor.this.processOthers(string5));
                                    } else if (string != null && string.equals("1")) {
                                        this.result = new ResultWrapper(null, "", true, hashMap);
                                    } else {
                                        this.result = new ResultWrapper(null, Integer.toString(this.stmt.getUpdateCount()), true, hashMap);
                                        string2 = n + " " + Translate.translate((String)"rows") + " ";
                                        string2 = string3.equals("48") ? n + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"inserted") : (string3.equals("88") ? n + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"updated") : (string3.equals("31") ? n + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"deleted") : (string3.equals("51") ? n + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"merged") : (string3.equals("21") ? Translate.translate((String)"Commit complete") : (string3.equals("68") ? Translate.translate((String)"Rollback complete") : Translate.translate((String)SqlEditor.this.processOthers(string5)))))));
                                    }
                                    break block73;
                                }
                                this.result = null;
                            }
                            Object var17_30 = null;
                            if (bl) break block74;
                            Connections.getInstance().unlock(this.conn);
                            bl = true;
                        }
                        if (SqlEditor.this.interrupted) {
                            SqlEditor.this.interrupted = false;
                            SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(63)));
                        }
                        if (this.result != null && this.result._resultSet != null) break block76;
                        try {
                            if (this.stmt != null) {
                                this.stmt.close();
                            }
                        }
                        catch (Exception exception) {
                            SqlEditor.this.logger.log(Level.SEVERE, "stmt.close", exception);
                        }
                        this.stmt = null;
                        {
                            break block76;
                            catch (SQLException sQLException) {
                                if (!bl) {
                                    Connections.getInstance().unlock(this.conn);
                                    bl = true;
                                }
                                int n = DBUtil.getInstance().getErrorOffset(this.conn, sQLCommand.getSql());
                                if (bl3) {
                                    ExceptionHandler.handleException((Exception)sQLException, (String)sQLCommand.getSql(), (int)n, (int)this.val$selectLine, (int)this.val$selectColumn);
                                } else {
                                    ExceptionHandler.handleException((Exception)sQLException, (String)sQLCommand.getSql(), (int)n, (int)(sQLCommand.startLine + 1), (int)1);
                                }
                                SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(62)));
                                Object var17_31 = null;
                                if (!bl) {
                                    Connections.getInstance().unlock(this.conn);
                                    bl = true;
                                }
                                if (SqlEditor.this.interrupted) {
                                    SqlEditor.this.interrupted = false;
                                    SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(63)));
                                }
                                if (this.result != null && this.result._resultSet != null) break block76;
                                try {
                                    if (this.stmt != null) {
                                        this.stmt.close();
                                    }
                                }
                                catch (Exception exception) {
                                    SqlEditor.this.logger.log(Level.SEVERE, "stmt.close", exception);
                                }
                                this.stmt = null;
                                break block76;
                            }
                            catch (Exception exception) {
                                String string7;
                                if (!bl) {
                                    Connections.getInstance().unlock(this.conn);
                                    bl = true;
                                }
                                this.result = new ResultWrapper(null, (string7 = exception.toString()) != null ? string7.trim() : string7, false, null);
                                SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(62)));
                                Object var17_32 = null;
                                if (!bl) {
                                    Connections.getInstance().unlock(this.conn);
                                    bl = true;
                                }
                                if (SqlEditor.this.interrupted) {
                                    SqlEditor.this.interrupted = false;
                                    SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(63)));
                                }
                                if (this.result != null && this.result._resultSet != null) break block76;
                                try {
                                    if (this.stmt != null) {
                                        this.stmt.close();
                                    }
                                }
                                catch (Exception exception2) {
                                    SqlEditor.this.logger.log(Level.SEVERE, "stmt.close", exception2);
                                }
                                this.stmt = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_33 = null;
                            if (!bl) {
                                Connections.getInstance().unlock(this.conn);
                                bl = true;
                            }
                            if (SqlEditor.this.interrupted) {
                                SqlEditor.this.interrupted = false;
                                SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(63)));
                            }
                            if (this.result == null || this.result._resultSet == null) {
                                try {
                                    if (this.stmt != null) {
                                        this.stmt.close();
                                    }
                                }
                                catch (Exception exception) {
                                    SqlEditor.this.logger.log(Level.SEVERE, "stmt.close", exception);
                                }
                                this.stmt = null;
                            }
                            throw throwable;
                        }
                    }
                    if (this.result != null) {
                        this.result._stmt = this.stmt;
                        try {
                            if (this.stmt != null) {
                                this.stmt.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    SqlEditor.this.setStatusBarMessage(Translate.translate((String)string2));
                }
                if (SqlEditor.this.view != null && this.result != null) {
                    if (string != null && string.equals("1")) {
                        SqlEditor.this.start = System.nanoTime();
                        if (this.val$line >= 0) {
                            SqlEditor.this.view.setQueryResultSet(this.result._resultSet, this.result._resultString, this.result._success, string5, this.result._binds, this.val$line, this.val$col);
                        } else {
                            SqlEditor.this.view.setQueryResultSet(this.result._resultSet, this.result._resultString, this.result._success, string5, this.result._binds, sQLCommand.startLine + 1, 1);
                        }
                        SqlEditor.this.duration = System.nanoTime() - SqlEditor.this.start;
                    } else {
                        SqlEditor.this.view.setResultSet(this.result._resultSet, this.result._resultString, this.result._success, string5, this.result._binds);
                    }
                    if (string != null && string.equals("1")) {
                        try {
                            if (this.result._resultSet != null) {
                                this.result._resultSet.close();
                            }
                            if (this.result._stmt != null) {
                                this.result._stmt.close();
                            }
                            this.result = null;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                return new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (SqlEditor.this.interrupted) {
                        SqlEditor.this.interrupted = false;
                        SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(63)));
                    }
                    if (SqlEditor.this.view != null) {
                        SqlEditor.this.view.setEnabled(true);
                        SqlEditor.this.setExecuteInProgress(false);
                        SqlEditor.this.updateVisibleActions();
                        View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                        SqlEditor.this.updateTimer(SqlEditor.this.duration);
                        SqlEditor.this.view.toggleProgress(false);
                        SqlEditor.this.view.getResultSetTable().revalidate();
                        SqlEditor.this.view.getResultSetTable().repaint();
                    }
                }
            }
        };
        this.worker.start();
        return string5;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this.view.updateVisibleActions();
    }

    private String processOthers(String string) {
        String string2 = "";
        string2 = this.giveTokens(string) + " Statement Processed";
        return string2;
    }

    private String giveTokens(String string) {
        String string2 = "";
        String[] stringArray = string.trim().split("[ \t\n\r]");
        if (stringArray != null) {
            for (int i = 0; i < 2; ++i) {
                if (stringArray.length <= i) continue;
                string2 = string2 + " " + stringArray[i].toLowerCase();
            }
            if (stringArray[1].equalsIgnoreCase("public") || stringArray[1].equalsIgnoreCase("materialized") || stringArray[1].equalsIgnoreCase("database")) {
                string2 = string2 + " " + stringArray[2];
            } else if (stringArray[1].equalsIgnoreCase("or") && stringArray[2].equalsIgnoreCase("replace")) {
                string2 = string2 + " " + stringArray[2] + " " + stringArray[3];
            }
        }
        return string2;
    }

    public Database getDb() {
        return this._db;
    }

    public void setDb(Database database) {
        if (database == null) {
            ResultSetTable resultSetTable;
            this._db = database;
            this._isOracle = this._db == null ? false : Connections.getInstance().isOracle(this._db.getConnection());
            if (this.getContext().getNode() instanceof SqlEditorNode) {
                ((SqlEditorNode)this.getContext().getNode()).setDatbase(this._db);
                if (this.view != null) {
                    resultSetTable = this.view.getResultSetTable();
                    if (resultSetTable != null && resultSetTable.getMdl() != null) {
                        resultSetTable.getMdl().setConn(null);
                        resultSetTable.closeModel();
                    }
                    this.view.getDbSelector().setCurrentConnection(null);
                }
            }
            if (this.getContext().getNode() instanceof SqlNode && this.view != null) {
                resultSetTable = this.view.getResultSetTable();
                if (resultSetTable != null && resultSetTable.getMdl() != null) {
                    resultSetTable.getMdl().setConn(null);
                    resultSetTable.closeModel();
                }
                this.view.getDbSelector().setCurrentConnection(null);
            }
        } else if (database != this._db) {
            this._db = database;
            Connection connection = this._db.getConnection();
            this._isOracle = Connections.getInstance().isOracle(this._db.getConnection());
            if (this.getContext().getNode() instanceof SqlEditorNode) {
                ((SqlEditorNode)this.getContext().getNode()).setDatbase(this._db);
            }
            this.view.setConnections(connection);
            this.view.invokeInsight();
        }
        this.getContext().getNode().notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        if (this._db != null) {
            this._cachedVersion = DBUtil.getDbVersion((Connection)this._db.getConnection());
            this._cachedConnection = this._db.getConnection();
        }
    }

    public Connection getCachedConnection() {
        return this._cachedConnection;
    }

    public Version getVersion() {
        return this._cachedVersion;
    }

    protected Element[] getSelectionFromUI() {
        Element[] elementArray;
        Node node = this.getContext().getNode();
        if (node != null) {
            Element[] elementArray2 = new Element[1];
            elementArray = elementArray2;
            elementArray2[0] = node;
        } else {
            elementArray = super.getSelectionFromUI();
        }
        return elementArray;
    }

    final void saveWorksheet() {
        this.saveWorksheet(false);
    }

    final void saveWorksheet(boolean bl) {
        this.view.saveView(bl);
    }

    public void markDirty(boolean bl) {
        this.getContext().getNode().markDirty(bl);
    }

    final void printWorksheet() {
        this.view.printView();
    }

    final void openWorksheet() {
        this.view.openWsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void executeExplainPlan() {
        try {
            try {
                String string = null;
                if (this.view.isTextSelected()) {
                    string = this.view.getSQLEditorPane().getSelectedText();
                }
                if (string == null) {
                    string = this.getStatementAtLine(this.view.getSqlStatement());
                }
                if (string == null || string.length() < 1) {
                    this.setStatusBarMessage(ConnectionArb.getString((int)37));
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)"No Statement at Cursor", (String)"Failed to Explain Plan", null);
                    return;
                }
                this.view.southExplainPanel.initColumnWidths();
                this.view.southExplainPanel.mdl.reset();
                this.view.southExplainPanel.tbl.revalidate();
                this.view.setForFocusExplainPlan();
                this.view.toggleProgress(true);
                this.setExecuteInProgress(true);
                View.updateToolbarActions((Toolbar)this.getToolbar());
                if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
                    string = string.substring(0, string.length() - 1);
                }
                final String string2 = string;
                this.worker = new NamedSwingWorker("Explain Plan"){

                    public Object construct() {
                        SqlEditor.this.view.explainPlan(string2);
                        return new Object();
                    }

                    public void finished() {
                        SqlEditor.this.view.southExplainPanel.initColumnWidths();
                        SqlEditor.this.view.displayPlan();
                        SqlEditor.this.view.toggleProgress(false);
                        SqlEditor.this.setExecuteInProgress(false);
                        View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                    }

                    public void interrupt() {
                        SqlEditor.this.setExecuteInProgress(false);
                        SqlEditor.this.view.toggleProgress(false);
                        View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                        super.interrupt();
                    }
                };
                this.worker.start();
                return;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "executeExplainPlan", exception);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            throw throwable;
        }
    }

    private String getStatementAtLine(String string) {
        ScriptParser scriptParser = new ScriptParser(string);
        scriptParser.parse();
        SQLCommand[] sQLCommandArray = scriptParser.getSqlStatements();
        int n = this.view.getCaretLine();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < sQLCommandArray.length; ++n2) {
            if (n - 1 < sQLCommandArray[n2].getStartLine() || n - 1 > sQLCommandArray[n2].getEndLine()) continue;
            n3 = n2;
            bl = true;
        }
        string = bl ? sQLCommandArray[n3].getSql() : null;
        return string;
    }

    final void executeScriptRunnerPlan() {
        this.executeScriptRunnerPlan(false);
    }

    final void executeScriptRunnerPlan(boolean bl) {
        boolean bl2 = true;
        try {
            if (DBUtil.isOracleConnectionAlive((Connection)this.getConnection())) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = false;
            String string = Connections.getInstance().getConnectionName(this.getConnection());
            ExceptionHandler.handleException((Exception)exception, (String)string, (boolean)true, (boolean)false);
        }
        if (bl2) {
            String string = this.view.getSqlStatement();
            if (bl) {
                string = SqlEditor.getStatementSQL(string, this.view.getCaretLine(), this.getConnection());
            }
            this.executeScriptRunnerPlan(string);
        }
    }

    private void executeScriptRunnerPlan(String string) {
        this.view.toggleProgress(true);
        try {
            Object object;
            this.start = System.nanoTime();
            if (!ModelUtil.hasLength((String)string)) {
                this.setStatusBarMessage(ConnectionArb.getString((int)37));
                return;
            }
            this.setExecuteInProgress(true);
            View.updateToolbarActions((Toolbar)this.getToolbar());
            this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(65)));
            this.view.scriptRunner(string);
            if (string.trim().replaceAll("[ \t\n\r]", "").equals(this.view.getSQLText().trim().replaceAll("[ \t\n\r]", "")) && (object = this.getContext().getNode()) instanceof SqlNode) {
                string = object.getURL().toString();
            }
            this._history.saveSql(string.trim(), Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this._db)), SqlEditorHistory.TYPE_SCRIPT_HISTORY);
            this.view.setEnabled(true);
            this.updateVisibleActions();
            object = new NamedSwingWorker("Waiter"){

                public Object construct() {
                    while (SqlEditor.this.view != null && !SqlEditor.this.view.isFinished()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        if (SqlEditor.this.view != null) {
                            SqlEditor.this.duration = System.nanoTime() - SqlEditor.this.start;
                            SqlEditor.this.updateTimer(SqlEditor.this.duration);
                            SqlEditor.this.view.toggleProgress(false);
                            SqlEditor.this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(67)));
                            SqlEditor.this.setExecuteInProgress(false);
                            View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                        }
                    }
                }
            };
            object.start();
        }
        catch (Exception exception) {
            this.setStatusBarMessage(Translate.translate((String)SQLWorksheetArb.getString(66)));
            this.logger.log(Level.SEVERE, "executeScriptRunnerPlan", exception);
        }
    }

    private static String getStatementSQL(String string, int n, Connection connection) {
        ScriptParser scriptParser = new ScriptParser(string, connection);
        scriptParser.parse();
        SQLCommand[] sQLCommandArray = scriptParser.getSqlStatements();
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < sQLCommandArray.length; ++n2) {
            if (n - 1 < sQLCommandArray[n2].getStartLine() || n - 1 > sQLCommandArray[n2].getEndLine()) continue;
            n3 = n2;
        }
        return sQLCommandArray[n3].getSQLOrig();
    }

    public void setText(String string) {
        if (this.view != null) {
            this.view.setSQLText(string);
        }
    }

    public String getText() {
        return this.view != null ? this.view.getSQLText() : null;
    }

    public boolean hasText(boolean bl) {
        return this.view != null && this.view.hasText(bl);
    }

    public boolean canRefreshView() {
        return this.view != null && this.view.canRefreshView();
    }

    public void refreshView() {
        if (this.view != null) {
            this.view.refreshView();
        }
    }

    public Component getGUI() {
        if (null == this.view) {
            this._createGUI();
        }
        return this.view;
    }

    public Object getEditorAttribute(String string) {
        if ("horizontal_scrollbar_policy".equals(string)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return new Integer(21);
        }
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public Component getDefaultFocusComponent() {
        return this.view.getSQLEditorPane();
    }

    public String getTitleLabel() {
        Node node = this.getContext().getNode();
        return node != null ? SqlEditor._getTitle(node.getURL()) : super.getTitleLabel();
    }

    private static String _getTitle(URL uRL) {
        return uRL.getPath();
    }

    public void open() {
        this._controller.attachToContextMenu();
        if (this.getContext().getNode() instanceof SqlEditorNode) {
            ((SqlEditorNode)this.getContext().getNode()).getSqlNode().addNodeListener(new NodeListener(){

                public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
                    SqlEditor.this.markDirty(bl);
                }
            });
        }
    }

    boolean isExplainPlanAllowed() {
        return this._isOracle;
    }

    boolean isScriptRunnerAllowed() {
        return true;
    }

    synchronized boolean isExecuteInProgress() {
        return this._isExecuting;
    }

    synchronized void setExecuteInProgress(boolean bl) {
        this._isExecuting = bl;
    }

    public synchronized void close() {
        if (this.isExecuteInProgress()) {
            this.cancelExecute();
        }
        Node node = this.getContext().getNode();
        try {
            if (Connections.isUnsharedWorksheetConnection((String)this._db.getQualifiedName())) {
                DatabaseNavigatorController.closeAndDeleteConnection((Connection)this._db.getConnection(), (Context)this.getContext());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<SqlEditor> arrayList = new ArrayList<SqlEditor>();
        arrayList.add(this);
        try {
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this._controller.detachToContextMenu();
        this._releaseGUI();
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Controller getController() {
        return this._controller;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return (BasicEditorPane)(this.getFocusedComponent() instanceof BasicEditorPane ? this.getFocusedComponent() : this.view.getSQLEditorPane());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_sqlviewer_html");
    }

    private void _createGUI() {
        SqlNode sqlNode;
        File file;
        this.view = new SqlEditorMainPanel(this);
        this.view.getCustomTabbedPanel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SqlEditor.this._activeSubPage = SqlEditor.this.view.getActivePanel();
                SqlEditor.this.updateVisibleActions();
            }
        });
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        keyStrokeOptions.addChangeListener((ChangeListener)this);
        this.updateKeyMap(keyStrokeOptions);
        Context context = this.getContext();
        Node node = null;
        if (context != null) {
            node = context.getNode();
        }
        if (node instanceof SqlNode && !(file = new File((sqlNode = (SqlNode)node).getURL().getFile())).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Create File", (String)file.getAbsolutePath(), null);
            }
        }
        this.view.setNode(node);
    }

    public String getMD5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            return new String(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void setMD5(String string) {
        this._md5 = this.getMD5(string);
    }

    public boolean hasChanged() {
        SqlNode sqlNode = null;
        if (this.getContext().getNode() instanceof SqlNode) {
            sqlNode = (SqlNode)this.getContext().getNode();
        } else if (this.getContext().getNode() instanceof SqlEditorNode) {
            sqlNode = ((SqlEditorNode)this.getContext().getNode()).getSqlNode();
        }
        return sqlNode.isDirty();
    }

    private void _releaseGUI() {
        if (this.view != null) {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.removeChangeListener((ChangeListener)this);
            this.view.dispose();
            this.view = null;
        }
    }

    CopyableResultSetTableAdapter getCopyableJTableAdapter() {
        return this._copyableTableAdapter;
    }

    void setCopyableJTableAdapter(CopyableResultSetTableAdapter copyableResultSetTableAdapter) {
        this._copyableTableAdapter = copyableResultSetTableAdapter;
    }

    public Component getFocusedComponent() {
        return this.focusedComponent;
    }

    void setFocusedComponent(Component component) {
        this.focusedComponent = component;
    }

    public Toolbar getToolbar() {
        return this.view != null ? this.view.getToolbar() : null;
    }

    public Connection getConnection() {
        try {
            return this._db == null ? null : this._db.getConnection(false);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String getConnectionName() {
        return this.view != null ? this.view.getConnectionName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SqlEditor openNewEditor(SqlNode sqlNode, String string) {
        SqlEditor sqlEditor;
        block10: {
            sqlEditor = null;
            try {
                try {
                    if (sqlNode == null || _isOpening) break block10;
                    _isOpening = true;
                    SqlEditorNode sqlEditorNode = new SqlEditorNode(string);
                    sqlEditorNode.setSqlNode(sqlNode);
                    sqlNode.ensureOpen();
                    Database database = sqlEditorNode.getDatabase();
                    if (database == null) {
                        SqlEditor sqlEditor2 = null;
                        Object var12_8 = null;
                        _isOpening = false;
                        return sqlEditor2;
                    }
                    Context context = Context.newIdeContext((Node)sqlEditorNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    openEditorOptions.setFlags(1);
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    try {
                        block11: {
                            try {
                                waitCursor.show();
                                sqlEditor = (SqlEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
                                ((SqlEditorNode)sqlEditor.getContext().getNode()).add(sqlEditor);
                                if (string == null) break block11;
                                sqlEditor.setDb(database);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(SqlEditor.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                Object var10_15 = null;
                                waitCursor.hide();
                                break block10;
                            }
                        }
                        Object var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        waitCursor.hide();
                        throw throwable;
                    }
                    waitCursor.hide();
                }
                catch (Exception exception) {
                    Logger.getLogger(SqlEditor.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    Object var12_10 = null;
                    _isOpening = false;
                    return sqlEditor;
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                _isOpening = false;
                throw throwable;
            }
        }
        Object var12_9 = null;
        _isOpening = false;
        return sqlEditor;
    }

    public static SqlEditor openNewEditor(String string, String string2) {
        SqlEditor sqlEditor = null;
        try {
            FileOutputStream fileOutputStream;
            File file = File.createTempFile(TMP_FILE_PREFIX, ".sql", Resource.raptorUserTmp);
            file.deleteOnExit();
            if (string != null) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(string.getBytes());
            }
            fileOutputStream = null;
            fileOutputStream = (SqlNode)NodeFactory.findOrCreate((URL)file.toURL());
            fileOutputStream.attach((Observer)SqlEditorAddin.getSqlHistoryDockable().getGUI());
            fileOutputStream.ensureOpen();
            sqlEditor = SqlEditor.openNewEditor((SqlNode)fileOutputStream, string2);
            if (sqlEditor != null) {
                SqlEditorNode sqlEditorNode = (SqlEditorNode)sqlEditor.getContext().getNode();
                sqlEditorNode.setTempFile(true);
                sqlEditorNode.add(sqlEditor);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(SqlEditor.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return sqlEditor;
    }

    public static SqlEditor openNewEditor(String string) {
        return SqlEditor.openNewEditor((String)null, string);
    }

    public Database getDatabase() {
        return this._db;
    }

    public void updateTimer(long l) {
        this.view.updateTimer(l);
    }

    public void refreshTimer() {
        this.view.refreshTimer();
    }

    public SqlEditorMainPanel getView() {
        return this.view;
    }

    public void setFocusOnNextTab() {
        CustomTabbedPane customTabbedPane = this.view.getCustomTabbedPanel();
        int n = customTabbedPane.getSelectedIndex();
        int n2 = customTabbedPane.getNumberOfTabs() - 1;
        boolean bl = false;
        if (this.focusedComponent == this.getDefaultFocusComponent()) {
            bl = true;
        }
        if (bl) {
            customTabbedPane.setSelectedIndex(0);
        } else if (n == n2) {
            Component component = this.getDefaultFocusComponent();
            component.requestFocus();
        } else {
            customTabbedPane.setSelectedIndex(n + 1);
        }
    }

    public void setFocusOnPreviousTab() {
        CustomTabbedPane customTabbedPane = this.view.getCustomTabbedPanel();
        int n = customTabbedPane.getSelectedIndex();
        int n2 = customTabbedPane.getNumberOfTabs() - 1;
        boolean bl = false;
        if (this.focusedComponent == this.getDefaultFocusComponent()) {
            bl = true;
        }
        if (bl) {
            customTabbedPane.setSelectedIndex(n2);
        } else if (n == 0) {
            Component component = this.getDefaultFocusComponent();
            component.requestFocus();
        } else {
            customTabbedPane.setSelectedIndex(n - 1);
        }
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        if (context != null && this._db != null) {
            context.setProperty("Connections.db_name", (Object)Connections.getInstance().getConnectionName(this._db));
        }
        return context;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        if (changeEvent.getSource() == keyStrokeOptions) {
            this.updateKeyMap(keyStrokeOptions);
        }
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        MultiMapAdapter.fillLocalMap((MultiInputMap)multiInputMap, (KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        this.view.setInputMap(1, (InputMap)multiInputMap);
    }

    public JComponent[] getCustomCells() {
        if (this.view != null && this.view.getStatusBar() != null) {
            return this.view.getStatusBar().getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public boolean isOracle() {
        return this._isOracle;
    }

    public String getStatusMessage() {
        return this.view.get_lastStatusbarMessage();
    }

    public void updateURL() {
        SqlEditorNode sqlEditorNode;
        if (this.getContext().getNode() instanceof SqlEditorNode && (sqlEditorNode = (SqlEditorNode)this.getContext().getNode()).isTempFile()) {
            sqlEditorNode.setURL(SqlEditor.createSqlEditorURL(this.getConnectionName()));
            sqlEditorNode.setTabName(sqlEditorNode.getShortLabel());
        }
    }

    public static URL createSqlEditorURL(String string) {
        URL uRL = URLFactory.newURL((String)"sqldev.worksheet", (String)(System.currentTimeMillis() + "/" + SqlEditorController.getUniqueTabName(string)));
        return uRL;
    }

    public void setStatusBarMessage(String string) {
        if (Ide.getMainWindow().getLastActiveView() == this) {
            Log.status((String)string);
        } else {
            this.view.set_lastStatusbarMessage(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultWrapper {
        private ResultSet _resultSet;
        private String _resultString;
        private boolean _success;
        private Statement _stmt;
        private Map<String, Object> _binds;

        ResultWrapper(ResultSet resultSet, String string, boolean bl, Map<String, Object> map) {
            this._resultSet = resultSet;
            this._resultString = string;
            this._success = bl;
            this._binds = map;
        }
    }
}

