/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.apex.PublishQueryToApexApplication;
import oracle.dbtools.raptor.controls.table.CountRowsMenu;
import oracle.dbtools.raptor.controls.table.RSTableHeaderMenu;
import oracle.dbtools.raptor.controls.table.SingleRecordViewMenu;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.commands.RePopulateNLSMap;
import oracle.dbtools.sqlworksheet.commands.SetWorkSheetTab;
import oracle.dbtools.sqlworksheet.dbmsoutput.DbmsOutputController;
import oracle.dbtools.sqlworksheet.owaoutput.OWAOutputController;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerController;
import oracle.dbtools.sqlworksheet.sqlview.ConnectionVarHandler;
import oracle.dbtools.sqlworksheet.sqlview.SQLEditorURLFormatHelper;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorPrintFactory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorWizard;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryDockable;
import oracle.dbtools.sqlworksheet.sqlview.SqlLaunchOnOpen;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Recognizer;
import oracle.ide.print.PrintManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.MenuSpec;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;

public final class SqlEditorAddin
extends EditorAddin
implements DockableFactory {
    public static final int OPEN_SQL_WORKSHEET = Ide.findOrCreateCmdID((String)"openSQLWorksheet");
    private static final int SQL_HISTORY_CMD = Ide.findOrCreateCmdID((String)"sqlworksheet.history");
    private static SqlHistoryDockable _sqlHistoryDockable = null;
    public static final String WORKSHEET_NAME_DELIMITER = "~";
    private ActionListener _openSQLEditor = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            WizardManager.getInstance().invokeWizard((Wizard)new SqlEditorWizard(), Context.newIdeContext(), null, null);
        }
    };

    public void initialize() {
        DBURLFormatHelper.registerFormatHelper((String)"sqldev.worksheet", (DBURLFormatHelper)new SQLEditorURLFormatHelper());
        SqlEditorNode.registerProtocol(this.getNodeProtocol(), this.getNodeClass());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)this);
        SqlEditorController.createActions();
        new DbmsOutputController().createActions();
        new OWAOutputController().createActions();
        new ScriptRunnerController().createActions();
        new SqlLaunchOnOpen();
        this.initMenu();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/dbtools/sqlworksheet/accelerators.xml");
        PrintManager.getPrintManager().registerDocumentPrintFactory(SqlEditor.class, SqlEditorPrintFactory.class);
        Recognizer.registerConversion(SqlNode.class, SqlEditorNode.class);
        Class[] classArray = new Class[]{SqlNode.class, SqlEditorNode.class};
        EditorManager.getEditorManager().register((EditorAddin)AddinManager.getAddinManager().getAddin(SqlEditorAddin.class), classArray);
        if (RaptorExtensionConstants.isStandAlone()) {
            // empty if block
        }
        CommandRegistry.addListener(SetWorkSheetTab.class);
        CommandRegistry.addListener(RePopulateNLSMap.class);
        ContextMenu contextMenu = EditorManager.getEditorManager().getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
        SingleRecordViewMenu.getInstance().registerContextMenu(contextMenu, SqlEditor.class);
        contextMenu.addContextMenuListener((ContextMenuListener)RSTableHeaderMenu.getInstance());
        contextMenu.addContextMenuListener((ContextMenuListener)CountRowsMenu.getInstance());
        contextMenu.addContextMenuListener((ContextMenuListener)PublishQueryToApexApplication.getInstance());
        RaptorDBAddin.registerSqlOpener((ISQLEditor)new ISQLEditor(){

            public Editor openNewEditor(SqlNode sqlNode, String string) {
                return SqlEditor.openNewEditor(sqlNode, string);
            }

            public Editor openNewEditor(String string, String string2) {
                return SqlEditor.openNewEditor(string, string2);
            }
        });
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory("SQLHISTORY_VIEW_TYPE", (DockableFactory)this);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        TemplateVariableHandler.getVariablesMap().put("#user#", ConnectionVarHandler.class);
    }

    public void initMenu() {
        String string = ConnectionArb.getString((int)30);
        IdeAction ideAction = IdeAction.get((int)OPEN_SQL_WORKSHEET, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ArrayResourceBundle)SQLWorksheetArb.getInstance(), (int)9, null, (boolean)true);
        String string2 = SQLWorksheetArb.getString(38);
        IdeAction ideAction2 = IdeAction.get((int)SQL_HISTORY_CMD, null, (String)StringUtils.stripMnemonic((String)string2), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ResourceBundle)SQLWorksheetArb.getInstance(), null, null, (boolean)true);
        ideAction2.addController((Controller)new C());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)ideAction2, 1.0f);
        jMenuItem.addActionListener(this._openSQLEditor);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
        menubar.add((Component)jMenuItem2, MenuManager.getJMenu((String)"View"));
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isDuplicable() {
        return false;
    }

    public Class getEditorClass() {
        return SqlEditor.class;
    }

    protected Wizard getWizard() {
        return new SqlEditorWizard();
    }

    protected String getNodeProtocol() {
        return "sqldev.worksheet";
    }

    protected Class getNodeClass() {
        return SqlEditorNode.class;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(Translate.translate((String)"SQL_Worksheet"), null, null);
    }

    public float getEditorWeight(Element element) {
        return element instanceof SqlEditorNode ? 0.5f : Float.NaN;
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(3);
            DockStation dockStation = DockStation.getDockStation();
            SqlHistoryDockable sqlHistoryDockable = new SqlHistoryDockable();
            dockStation.dock((Dockable)sqlHistoryDockable, dockingParam);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return SqlEditorAddin.getSqlHistoryDockable();
    }

    public static SqlHistoryDockable getSqlHistoryDockable() {
        if (_sqlHistoryDockable == null) {
            _sqlHistoryDockable = new SqlHistoryDockable();
        }
        return _sqlHistoryDockable;
    }

    private class C
    implements Controller {
        private C() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (SQL_HISTORY_CMD == ideAction.getCommandId()) {
                SqlEditorController.showSqlHistory(context);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

