/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.sql.Connection;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.monitor.MonitorSql;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.PopupDescribe;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorAddin;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorTempFileTimer;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorWizard;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryDockable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.model.SqlNode;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.Version;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.runner.run.RunArb;

public final class SqlEditorController
implements Controller,
ContextMenuListener,
DynamicMenuListener {
    static final String ACCELERATOR_FILE = "oracle/dbtools/sqlworksheet/sqlview/accelerators.xml";
    static final String GLOBAL_ACTIONS_ACCELERATOR_FILE = "oracle/dbtools/sqlworksheet/accelerators.xml";
    private static SqlEditorController _instance;
    private int ctxCount;
    private static final String openToolbarEditor = "open.sqleditor";
    static final int HISTORY_CMD_ID;
    public static final int EXPLAIN_PLAN_CMD_ID;
    public static final int AUTOTRACE_CMD_ID;
    static final int EXECUTE_SQL_CMD_ID;
    static final int SCRIPT_RUNNER_CMD_ID;
    static final int SW_PRINT_CMD_ID;
    static final int OPEN_SW_CMD_ID;
    static final int CLEAR_CMD_ID;
    static final int CANCEL_CMD_ID;
    static final int COMMIT_CMD_ID;
    static final int ROLLBACK_CMD_ID;
    static final int POPUP_DESCR;
    public static final int MONITOR_CMD_ID;
    static final int NEW_WORKSHEET_CMD_ID;
    static final int TOGGLE_WORKSHEET_AREA_CMD_ID;
    private static IdeAction connClosedAction;
    private static Connections _conns;
    static String category;
    private static IdeAction ideCompletionInsightAction;
    private static IdeAction ideSmartCompletionInsightAction;
    private static IdeAction ideParameterInsightAction;
    private static IdeAction ideToggleCommentsAction;
    private static IdeAction ideBlockIndentAction;
    private static IdeAction ideBlockOutdentAction;
    private static boolean _timerInit;
    private static Map<String, Integer> _tabNameList;
    private static Version _v11;
    private static final JComponent[] EMPTY_MENUS;

    private static void attachController() {
        SqlEditorController sqlEditorController = SqlEditorController.getInstance();
        IdeAction.find((int)73).addController((Controller)sqlEditorController);
        IdeAction.find((int)74).addController((Controller)sqlEditorController);
        IdeAction.find((int)11).addController((Controller)sqlEditorController);
    }

    static void createActions() {
        IdeAction.find((int)74).setEnabled(true);
        IdeAction.find((int)73).setEnabled(true);
        SqlEditorController.attachController();
        category = ConnectionArb.getString((int)1);
        connClosedAction = SqlEditorController.createAction(IDBEditor.CONN_CLOSED_CMD_ID, "Connection Closed", 17, category, RunArb.getInstance());
        IdeAction ideAction = IdeAction.get((int)OPEN_SW_CMD_ID);
        if (ideAction != null) {
            ideAction.putValue("ActionMenuActions", (Object)new IdeAction[0]);
        }
        _conns.addConnectionListener(new ConnectionListener(){

            public void connectionAdded(ConnectionEvent connectionEvent) {
                SqlEditorController.updateOpenToolbarAction();
            }

            public void connectionRemoved(ConnectionEvent connectionEvent) {
                SqlEditorController.updateOpenToolbarAction();
            }

            public void connectionRenamed(ConnectionEvent connectionEvent) {
                SqlEditorController.updateOpenToolbarAction();
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
                SqlEditorController.updateOpenToolbarAction();
            }

            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            public void connectionClosed(ConnectionEvent connectionEvent) {
            }
        });
    }

    private static IdeAction[] getConnectionActions() {
        String[] stringArray = _conns.getConnNames();
        Arrays.sort(stringArray, Collator.getInstance());
        IdeAction[] ideActionArray = new IdeAction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ideActionArray[i] = SqlEditorController.createToolbarAction(stringArray[i]);
        }
        return ideActionArray;
    }

    private static IdeAction createToolbarAction(String string) {
        IdeAction ideAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)("9/" + string)), (String)null, (String)string);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)SqlEditorController.getInstance());
        ideAction.putValue("Name", (Object)Connections.getDisplayName((String)string));
        ideAction.putValue(openToolbarEditor, (Object)string);
        return ideAction;
    }

    private static IdeAction createAction(int n, String string, int n2, String string2, ArrayResourceBundle arrayResourceBundle) {
        String string3 = StringUtils.stripMnemonic((String)string);
        Integer n3 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        return IdeAction.get((int)n, null, (String)string3, (String)string2, (Integer)n3, (ArrayResourceBundle)arrayResourceBundle, (int)n2, null, (boolean)false);
    }

    static synchronized SqlEditorController getInstance() {
        if (_instance == null) {
            _instance = new SqlEditorController();
        }
        return _instance;
    }

    private SqlEditorController() {
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        SqlEditorController.initializeIDEActions();
        ideCompletionInsightAction.addController((Controller)this);
        ideSmartCompletionInsightAction.addController((Controller)this);
        ideParameterInsightAction.addController((Controller)this);
        ideToggleCommentsAction.addController((Controller)this);
        ideBlockIndentAction.addController((Controller)this);
        ideBlockOutdentAction.addController((Controller)this);
    }

    public static void setupTimer() {
        if (!_timerInit) {
            Ide.addIdeListener((IdeListener)new IdeListener(){

                public void addinsLoaded(IdeEvent ideEvent) {
                }

                public void mainWindowClosing(IdeEvent ideEvent) {
                }

                public void mainWindowOpened(IdeEvent ideEvent) {
                    long l = 5000L;
                    long l2 = 60000L;
                    Timer timer = new Timer();
                    timer.scheduleAtFixedRate(SqlEditorTempFileTimer.getInstance(), l, l2);
                    _timerInit = true;
                }
            });
        }
    }

    void attachToContextMenu() {
        if (this.ctxCount++ == 0) {
            EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this, null);
        }
    }

    void detachToContextMenu() {
        if (--this.ctxCount == 0) {
            EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        }
    }

    private static void initializeIDEActions() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        EditorKeyStrokes editorKeyStrokes = keymapManager.getEditorKeyStrokes();
        ideCompletionInsightAction = editorKeyStrokes.lookupAction("completion-insight");
        ideSmartCompletionInsightAction = editorKeyStrokes.lookupAction("smart-completion-insight");
        ideParameterInsightAction = editorKeyStrokes.lookupAction("tooltip-insight");
        ideToggleCommentsAction = editorKeyStrokes.lookupAction("toggle-java-comments");
        ideBlockIndentAction = editorKeyStrokes.lookupAction("block-indent");
        ideBlockOutdentAction = editorKeyStrokes.lookupAction("block-outdent");
    }

    private static void updateOpenToolbarAction() {
        IdeAction ideAction = IdeAction.get((int)OPEN_SW_CMD_ID);
        if (ideAction != null) {
            ideAction.putValue("ActionMenuActions", (Object)SqlEditorController.getConnectionActions());
            ideAction.setEnabled(true);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        View view = context.getView();
        if (!(view instanceof SqlEditor)) {
            return false;
        }
        SqlEditor sqlEditor = (SqlEditor)view;
        Component component = sqlEditor.getFocusedComponent();
        boolean bl = sqlEditor.isOracle();
        boolean bl2 = sqlEditor.hasText(true);
        boolean bl3 = sqlEditor.isExecuteInProgress();
        boolean bl4 = Connections.getInstance().isAccess(sqlEditor.getConnectionName());
        boolean bl5 = false;
        if (sqlEditor.getDatabase() != null) {
            bl5 = true;
        }
        if (n == 14) {
            Node node = context.getNode();
            if (node instanceof SqlEditorNode && ((SqlEditorNode)node).getSqlNode() != null && ((SqlEditorNode)node).isTempFile()) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
        if (n == 17) {
            ideAction.setEnabled(SqlEditorController.canPerformCut(component));
            return true;
        }
        if (n == 18) {
            ideAction.setEnabled(this.canPerformCopy(sqlEditor, component));
            return true;
        }
        if (n == 19 || n == 78) {
            ideAction.setEnabled(SqlEditorController.canPerformPaste(component));
            return true;
        }
        if (n == 20) {
            ideAction.setEnabled(this.canPerformDelete(component));
            return true;
        }
        if (n == 22) {
            ideAction.setEnabled(SqlEditorController.canPerformSelectAll(component));
            return true;
        }
        if (n == 57) {
            ideAction.setEnabled(false);
            return false;
        }
        if (n == EXPLAIN_PLAN_CMD_ID) {
            boolean bl6 = sqlEditor.isExplainPlanAllowed();
            ideAction.setEnabled(bl && bl6 && bl2 && !bl3 && bl5);
            return true;
        }
        if (n == AUTOTRACE_CMD_ID) {
            boolean bl7 = sqlEditor.isExplainPlanAllowed();
            ideAction.setEnabled(bl && bl7 && bl2 && !bl3 && bl5);
            return true;
        }
        if (n == SCRIPT_RUNNER_CMD_ID) {
            boolean bl8 = sqlEditor.isScriptRunnerAllowed();
            ideAction.setEnabled(bl8 && bl2 && !bl3);
            return true;
        }
        if (n == EXECUTE_SQL_CMD_ID) {
            ideAction.setEnabled(bl2 && !bl3);
            return true;
        }
        if (n == IDBEditor.CONN_CLOSED_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == SW_PRINT_CMD_ID) {
            ideAction.setEnabled(!bl3);
            return true;
        }
        if (n == HISTORY_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 51 && sqlEditor.getDatabase() != null) {
            ideAction.setEnabled(sqlEditor.canRefreshView() && !bl3);
            return true;
        }
        if (n == CLEAR_CMD_ID) {
            ideAction.setEnabled(!bl3);
            return true;
        }
        if (n == CANCEL_CMD_ID && sqlEditor.getDatabase() != null) {
            ideAction.setEnabled(false);
            if (bl3) {
                ideAction.setEnabled(true);
            }
            return true;
        }
        if (n == 11) {
            ideAction.setEnabled(sqlEditor.getContext().getNode().isDirty());
            return true;
        }
        if (n == COMMIT_CMD_ID) {
            ideAction.setEnabled(bl5 && !bl3 && !bl4);
            return true;
        }
        if (n == ROLLBACK_CMD_ID) {
            ideAction.setEnabled(bl5 && !bl3 && !bl4);
            return true;
        }
        if (n == POPUP_DESCR) {
            ideAction.setEnabled(bl5);
            return true;
        }
        if (n == MONITOR_CMD_ID) {
            ideAction.setEnabled(bl && sqlEditor.getVersion() != null && sqlEditor.getVersion().compareTo((Object)_v11) > -1);
            return true;
        }
        if (n == ideCompletionInsightAction.getCommandId() || n == ideSmartCompletionInsightAction.getCommandId() || n == ideParameterInsightAction.getCommandId() || n == ideToggleCommentsAction.getCommandId() || n == ideBlockIndentAction.getCommandId() || n == ideBlockOutdentAction.getCommandId()) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view;
        int n = ideAction.getCommandId();
        if (n == OPEN_SW_CMD_ID) {
            SqlEditorController.toolbarAction(null);
            return true;
        }
        if (ideAction.getValue(openToolbarEditor) != null) {
            SqlEditorController.toolbarAction((String)ideAction.getValue(openToolbarEditor));
        }
        if (!((view = context.getView()) instanceof SqlEditor)) {
            return false;
        }
        SqlEditor sqlEditor = (SqlEditor)view;
        Log.status((String)Translate.translate((String)""));
        sqlEditor.refreshTimer();
        Component component = sqlEditor.getFocusedComponent();
        if (component == null && (component = sqlEditor.getDefaultFocusComponent()) == null) {
            return false;
        }
        if (n == 17) {
            this.performCut(component);
            component.requestFocus();
            return true;
        }
        if (n == 18) {
            this.performCopy(sqlEditor, component);
            component.requestFocus();
            return true;
        }
        if (n == 19) {
            this.performPaste(component);
            component.requestFocus();
            return true;
        }
        if (n == 78) {
            ClipboardStack.adjustCurrentClipboard();
            component.requestFocus();
            sqlEditor.getView().getSQLEditorPane().paste();
            return true;
        }
        if (n == 20) {
            this.performDelete(component);
            component.requestFocus();
            return true;
        }
        if (n == 22) {
            this.performSelectAll(component);
            component.requestFocus();
            return true;
        }
        if (n == POPUP_DESCR) {
            PopupDescribe.showPopup((Context)context);
            return true;
        }
        if (n == EXPLAIN_PLAN_CMD_ID && sqlEditor.getDatabase() != null) {
            sqlEditor.executeExplainPlan();
            component.requestFocus();
            return true;
        }
        if (n == AUTOTRACE_CMD_ID && sqlEditor.getDatabase() != null) {
            sqlEditor.autotrace();
            component.requestFocus();
            return true;
        }
        if (n == SCRIPT_RUNNER_CMD_ID) {
            if (sqlEditor.getDatabase() == null) {
                this.getOrCreateConnection(sqlEditor);
            }
            if (sqlEditor.getDatabase() == null) {
                return true;
            }
            sqlEditor.executeScriptRunnerPlan();
            component.requestFocus();
            return true;
        }
        if (n == EXECUTE_SQL_CMD_ID) {
            if (sqlEditor.getDatabase() == null) {
                this.getOrCreateConnection(sqlEditor);
            }
            if (sqlEditor.getDatabase() == null) {
                return true;
            }
            sqlEditor.executeSql();
            try {
                component.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (n == IDBEditor.CONN_CLOSED_CMD_ID) {
            DBConfig dBConfig = DBConfig.getInstance();
            if (dBConfig.getBoolean("WORKSHEETCLOSE").booleanValue()) {
                IdeAction ideAction2 = IdeAction.get((int)48);
                EditorManager.getEditorManager().handleEvent(ideAction2, context);
            } else {
                sqlEditor.setDb(null);
                View.updateToolbarActions((Toolbar)sqlEditor.getToolbar());
                Log.status((String)SQLWorksheetArb.getString(71));
            }
            return true;
        }
        if (n == HISTORY_CMD_ID) {
            SqlEditorController.showSqlHistory(context);
            return true;
        }
        if (n == SW_PRINT_CMD_ID) {
            sqlEditor.printWorksheet();
            return true;
        }
        if (n == CLEAR_CMD_ID) {
            sqlEditor.setText("");
            View.updateToolbarActions((Toolbar)sqlEditor.getToolbar());
            return true;
        }
        if (n == CANCEL_CMD_ID) {
            sqlEditor.cancelExecute();
            return true;
        }
        if (n == 11) {
            sqlEditor.saveWorksheet();
            return true;
        }
        if (n == 12) {
            sqlEditor.saveWorksheet(true);
            return true;
        }
        if (n == COMMIT_CMD_ID) {
            sqlEditor.commit();
            return true;
        }
        if (n == ROLLBACK_CMD_ID) {
            sqlEditor.rollback();
            return true;
        }
        if (n == NEW_WORKSHEET_CMD_ID) {
            return SqlEditorController.openNewUnsharedWorksheet(sqlEditor);
        }
        if (n == TOGGLE_WORKSHEET_AREA_CMD_ID) {
            return this.toggleWorksheetArea(sqlEditor);
        }
        if (n == ideBlockOutdentAction.getCommandId()) {
            sqlEditor.getView().getSQLEditorPane().requestFocus();
            sqlEditor.getView().getSQLEditorPane().invokeAction("block-outdent");
            return true;
        }
        if (n == ideBlockIndentAction.getCommandId()) {
            sqlEditor.getView().getSQLEditorPane().requestFocus();
            sqlEditor.getView().getSQLEditorPane().invokeAction("block-indent");
            return true;
        }
        if (n == ideCompletionInsightAction.getCommandId()) {
            sqlEditor.getView().getSQLEditorPane().requestFocus();
            sqlEditor.getView().getSQLEditorPane().invokeAction("completion-insight");
            return true;
        }
        if (n == ideSmartCompletionInsightAction.getCommandId()) {
            sqlEditor.getView().getSQLEditorPane().requestFocus();
            sqlEditor.getView().getSQLEditorPane().invokeAction("smart-completion-insight");
            return true;
        }
        if (n == ideToggleCommentsAction.getCommandId()) {
            sqlEditor.getView().getSQLEditorPane().requestFocus();
            sqlEditor.getView().getSQLEditorPane().invokeAction("toggle-java-comments");
            return true;
        }
        if (n == MONITOR_CMD_ID) {
            MonitorSql.monitor((String)sqlEditor.getConnectionName(), (Connection)sqlEditor.getCachedConnection());
            return true;
        }
        return false;
    }

    private boolean toggleWorksheetArea(SqlEditor sqlEditor) {
        JSplitPane jSplitPane = sqlEditor.getView().getSplitPane();
        if (jSplitPane.getDividerLocation() != jSplitPane.getMinimumDividerLocation()) {
            jSplitPane.setDividerLocation(jSplitPane.getMinimumDividerLocation());
        } else {
            jSplitPane.setDividerLocation(jSplitPane.getMaximumDividerLocation());
        }
        return true;
    }

    private void getOrCreateConnection(SqlEditor sqlEditor) {
        String string = "";
        string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((int)32), (String)ConnectionArb.getString((int)31), (String)string, (boolean)false);
        sqlEditor.getView().getDbSelector().setCurrentConnection(string);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        Node node = context.getNode();
        if (context.getEvent().getSource() instanceof ResultSetTable) {
            return;
        }
        if (view instanceof SqlEditor && (node instanceof SqlEditorNode || node instanceof SqlNode)) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(HISTORY_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            float f = JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU - 0.01f;
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(EXECUTE_SQL_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(EXPLAIN_PLAN_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(AUTOTRACE_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(SCRIPT_RUNNER_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(SW_PRINT_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(CLEAR_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(CANCEL_CMD_ID, view));
            contextMenu.add((Component)jMenuItem, f);
            contextMenu.remove((Component)EditorConstants.NAVIGATE_ITEM);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean canPerformCut(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCut();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEditable() && jTextComponent.isEnabled() && SqlEditorController.hasSelection(jTextComponent);
        }
        return false;
    }

    private boolean canPerformCopy(SqlEditor sqlEditor, Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCopy();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && SqlEditorController.hasSelection(jTextComponent);
        }
        if (component instanceof JTreeTable) {
            CopyableResultSetTableAdapter copyableResultSetTableAdapter = sqlEditor.view.southAutotracePanel.copyAdapter;
            return copyableResultSetTableAdapter.canCopy();
        }
        if (component instanceof JTable) {
            CopyableResultSetTableAdapter copyableResultSetTableAdapter = sqlEditor.getCopyableJTableAdapter();
            return copyableResultSetTableAdapter.canCopy();
        }
        return false;
    }

    private static boolean canPerformPaste(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canPaste();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && jTextComponent.isEditable();
        }
        return false;
    }

    private boolean canPerformDelete(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && jTextComponent.isEditable();
        }
        return false;
    }

    private static boolean canPerformSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled();
        }
        return component instanceof JTable;
    }

    private void performCut(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.cut();
        }
    }

    private void performCopy(SqlEditor sqlEditor, Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.copy();
        } else if (component instanceof JTreeTable) {
            CopyableResultSetTableAdapter copyableResultSetTableAdapter = sqlEditor.view.southAutotracePanel.copyAdapter;
            copyableResultSetTableAdapter.copyToClipboard();
        } else if (component instanceof JTable) {
            CopyableResultSetTableAdapter copyableResultSetTableAdapter = sqlEditor.getCopyableJTableAdapter();
            copyableResultSetTableAdapter.copyToClipboard();
        }
    }

    private void performPaste(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.paste();
        }
    }

    private void performDelete(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                BasicEditorPane basicEditorPane = (BasicEditorPane)component;
                basicEditorPane.invokeAction("delete-next");
            } else {
                Action action;
                JTextComponent jTextComponent = (JTextComponent)component;
                ActionMap actionMap = jTextComponent.getActionMap();
                if (actionMap != null && (action = actionMap.get("delete-next")) != null) {
                    ActionEvent actionEvent = new ActionEvent(jTextComponent, 1001, "delete-next");
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    private void performSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.selectAll();
        } else if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            jTable.selectAll();
        }
    }

    private static boolean hasSelection(JTextComponent jTextComponent) {
        int n;
        int n2 = jTextComponent.getSelectionStart();
        return n2 != (n = jTextComponent.getSelectionEnd());
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view instanceof SqlEditor) {
            Menubar menubar = Ide.getMenubar();
            return new JComponent[]{menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(EXECUTE_SQL_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(connClosedAction, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(POPUP_DESCR, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(SCRIPT_RUNNER_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(EXPLAIN_PLAN_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(AUTOTRACE_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(MONITOR_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(SW_PRINT_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(HISTORY_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(CLEAR_CMD_ID, view)), menubar.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(CANCEL_CMD_ID, view))};
        }
        return EMPTY_MENUS;
    }

    private static IdeAction createLocalAction(int n, View view) {
        return SqlEditorController.createLocalAction(IdeAction.get((int)n), view);
    }

    private static IdeAction createLocalAction(IdeAction ideAction, View view) {
        IdeAction ideAction2 = ideAction.newLocalAction(view);
        ideAction2.setEnabled(ideAction.isEnabled());
        return ideAction2;
    }

    private static void toolbarAction(String string) {
        Context context = Context.newIdeContext();
        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
        if (string != null) {
            context.setProperty("Connections.db_name", (Object)string);
        }
        WizardManager.getInstance().invokeWizard((Wizard)new SqlEditorWizard(), context, null, null);
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
    }

    public static void createTempTimer() {
        int n = 5000;
        int n2 = 60000;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new SqlEditorTempFileTimer(), n, (long)n2);
    }

    public static boolean openNewUnsharedWorksheet(SqlEditor sqlEditor) {
        if (sqlEditor.getConnectionName() == null || sqlEditor.getConnectionName().equals("") || Connections.isUnsharedWorksheetConnection((String)sqlEditor.getConnectionName())) {
            return false;
        }
        String string = null;
        try {
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            List<String> list = Arrays.asList(Connections.getInstance().getConnNames());
            string = SqlEditorController.getUniqueName(list, sqlEditor.getConnectionName(), false);
            Properties properties = Connections.getInstance().getConnectionInfo(sqlEditor.getConnectionName());
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            properties2.put("MultipleUnsharedWorksheetConnection", Boolean.TRUE.toString());
            databaseConnections.addConnection(Connections.getDisplayName((String)string), properties2);
            SqlEditor sqlEditor2 = SqlEditor.openNewEditor(string);
            if (sqlEditor2 != null) {
                sqlEditor2.getFocusedEditorPane().requestFocus();
            }
            return true;
        }
        catch (ConnectionException connectionException) {
            Logger.getLogger(SqlEditor.class.getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
            return false;
        }
    }

    public static String getUniqueName(Collection collection, String string, boolean bl) {
        String string2 = null;
        if (collection == null || !collection.contains(string)) {
            string2 = string;
        } else {
            int n = 1;
            int n2 = string.length() - 1;
            if (bl) {
                while (Character.isDigit(string.charAt(n2))) {
                    if (n2 > 0) {
                        --n2;
                        continue;
                    }
                    n2 = string.length() - 1;
                    break;
                }
                try {
                    n = Integer.parseInt(string.substring(n2 + 1));
                    string = string.substring(0, n2 + 1);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                string = string + "__";
            }
            int n3 = n;
            while (string2 == null) {
                String string3 = string + n3;
                if (!collection.contains(string3)) {
                    string2 = string3;
                }
                ++n3;
            }
        }
        return string2;
    }

    public static void showSqlHistory(Context context) {
        SqlHistoryDockable sqlHistoryDockable = SqlEditorAddin.getSqlHistoryDockable();
        DockUtil.smartToggleDockableWindow((DockableView)sqlHistoryDockable, (Context)context);
    }

    public static String getUniqueTabName(String string) {
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (_tabNameList == null) {
            _tabNameList = new HashMap<String, Integer>();
        }
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Object e : list) {
            URL uRL;
            if (!(e instanceof SqlEditor)) continue;
            SqlEditor sqlEditor = (SqlEditor)e;
            if (sqlEditor.getConnectionName() != null && sqlEditor.getConnectionName().equals(string)) {
                bl = true;
                break;
            }
            if (sqlEditor.getConnectionName() != null || !(sqlEditor.getContext().getNode() instanceof SqlEditorNode) || !DBURLFormatHelper.getConnectionName((URL)(uRL = ((SqlEditorNode)sqlEditor.getContext().getNode()).getURL())).equals(Connections.getDisplayName((String)string))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            _tabNameList.remove(string);
        }
        if (!_tabNameList.containsKey(string)) {
            _tabNameList.put(string, n);
            string2 = string;
        } else {
            int n2 = _tabNameList.get(string);
            int n3 = n2 + 1;
            _tabNameList.put(string, n3);
            string2 = string + "~" + n3;
        }
        return string2;
    }

    static {
        HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.history");
        EXPLAIN_PLAN_CMD_ID = Ide.findOrCreateCmdID((String)"SQL_ExpPl_Command");
        AUTOTRACE_CMD_ID = Ide.findOrCreateCmdID((String)"SQL_Autotrace_Command");
        EXECUTE_SQL_CMD_ID = Ide.findOrCreateCmdID((String)"SQL_ExecSql_Command");
        SCRIPT_RUNNER_CMD_ID = Ide.findOrCreateCmdID((String)"Script_Runner_Command");
        SW_PRINT_CMD_ID = Ide.findOrCreateCmdID((String)"SQL Worksheet Print");
        OPEN_SW_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.open_new");
        CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.clear");
        CANCEL_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.cancel");
        COMMIT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.commit");
        ROLLBACK_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.rollback");
        POPUP_DESCR = Ide.findOrCreateCmdID((String)"popup_describe");
        MONITOR_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.monitor");
        NEW_WORKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.new_worksheet");
        TOGGLE_WORKSHEET_AREA_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.toggle_worksheet_area");
        _conns = Connections.getInstance();
        category = null;
        _timerInit = false;
        _tabNameList = null;
        _v11 = new Version("11.0");
        EMPTY_MENUS = new JComponent[0];
    }
}

