/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryPanel;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SqlEditorHistory {
    private static SqlEditorHistory _sqlEditorHistory = null;
    public static String HISTORY_FILE_PATH = Resource.raptorUser.getAbsolutePath() + File.separator + "SqlHistory.xml";
    public static String TYPE_SQL_HISTORY = Translate.translate((String)"SQL");
    public static String TYPE_SCRIPT_HISTORY = Translate.translate((String)"Script");
    public static String[] titles = new String[]{Translate.translate((String)"SQL"), Translate.translate((String)"Connection"), Translate.translate((String)"TimeStamp"), Translate.translate((String)"Executed"), Translate.translate((String)"Type")};
    private static DefaultTableModel _model = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    private static SqlHistoryPanel _gui = null;

    public static synchronized SqlEditorHistory getInstance() {
        if (_sqlEditorHistory == null) {
            _sqlEditorHistory = new SqlEditorHistory();
        }
        return _sqlEditorHistory;
    }

    private SqlEditorHistory() {
        this.readHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readHistory() {
        XMLDocument xMLDocument = null;
        BufferedReader bufferedReader = null;
        if (_model.getColumnCount() != 0) return;
        for (int i = 0; i < titles.length; ++i) {
            _model.addColumn(titles[i]);
        }
        File file = new File(HISTORY_FILE_PATH);
        DOMParser dOMParser = new DOMParser();
        bufferedReader = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")));
        dOMParser.setPreserveWhitespace(false);
        dOMParser.parse((Reader)bufferedReader);
        xMLDocument = dOMParser.getDocument();
        if (xMLDocument != null) {
            Node node = xMLDocument.getFirstChild();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = XMLHelper.getNodeValue((Node)nodeList.item(i), (String)titles[0]);
                String string2 = XMLHelper.getNodeValue((Node)nodeList.item(i), (String)titles[1]);
                String string3 = XMLHelper.getNodeValue((Node)nodeList.item(i), (String)titles[2]);
                String string4 = XMLHelper.getNodeValue((Node)nodeList.item(i), (String)titles[4]);
                if (string4 == null || string4.equals("")) {
                    string4 = TYPE_SQL_HISTORY;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)titles[3]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Object[] objectArray = new Object[]{string, string2, string3, n, string4};
                _model.addRow(objectArray);
            }
        }
        Object var15_18 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (SAXException sAXException) {
                Object var15_19 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                Object var15_20 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeHistory(JTable jTable) {
        File file = new File(HISTORY_FILE_PATH);
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
        XMLFormatter xMLFormatter = null;
        xMLFormatter = (XMLFormatter)FormatRegistry.getFormatter((String)"XML");
        xMLFormatter.setDataProvider((ResultsFormatterWrapper)new TableFormatterWrapper(jTable));
        xMLFormatter.setOutWriter(outputStreamWriter);
        xMLFormatter.setResult(false);
        xMLFormatter.print();
        Object var7_7 = null;
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(SqlEditorHistory.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return;
        {
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)file.getName(), null);
                System.err.println(iOException);
                Object var7_8 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException2) {
                    Logger.getLogger(SqlEditorHistory.class.getClass().getName()).log(Level.WARNING, iOException2.getStackTrace()[0].toString(), iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Logger.getLogger(SqlEditorHistory.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            throw throwable;
        }
    }

    private static boolean hasPassword(String string) {
        return SqlEditorHistory.hasTokens(string);
    }

    private static boolean hasTokens(String string) {
        String[] stringArray = string.trim().split("[ \t\n\r]");
        if (stringArray != null && stringArray.length > 2) {
            if (stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("database") && stringArray[2].equalsIgnoreCase("link") || stringArray[0].equalsIgnoreCase("connect") || stringArray[0].equalsIgnoreCase("alter") && stringArray[1].equalsIgnoreCase("user")) {
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (i <= 1 || !stringArray[i - 1].equalsIgnoreCase("identified") || !stringArray[i].equalsIgnoreCase("by")) continue;
                return true;
            }
        }
        return false;
    }

    public static DefaultTableModel getHistoryModel() {
        return _model;
    }

    public static int getHistorySize() {
        if (_model == null) {
            return 0;
        }
        return _model.getRowCount();
    }

    private static int isDuplicate(String string) {
        for (int i = 0; i < _model.getRowCount(); ++i) {
            if (!string.equals((String)_model.getValueAt(i, 0))) continue;
            return i;
        }
        return -1;
    }

    private static int sqlTimesExecuted(int n) {
        String string = _model.getValueAt(n, 3).toString();
        return Integer.parseInt(string);
    }

    public synchronized void saveSql(String string, String string2, String string3) {
        if (!SqlEditorHistory.hasPassword(string)) {
            int n;
            int n2 = 0;
            int n3 = 0;
            Object[] objectArray = new Object[]{};
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            String string4 = dateFormat.format(date);
            n3 = n = 1;
            int n4 = SqlEditorHistory.isDuplicate(string);
            if (string3.equals(TYPE_SCRIPT_HISTORY)) {
                // empty if block
            }
            if (n4 > -1) {
                n3 = SqlEditorHistory.sqlTimesExecuted(n4) + 1;
                _model.removeRow(n4);
                objectArray = new Object[]{string, string2, string4, n3, string3};
            } else {
                objectArray = new Object[]{string, string2, string4, n, string3};
            }
            String string5 = System.getProperty("raptor.historysize");
            n2 = string5 == null ? 500 : Integer.parseInt(string5);
            if (_model.getRowCount() >= n2) {
                _model.removeRow(_model.getRowCount() - 1);
                _model.insertRow(0, objectArray);
            } else {
                _model.insertRow(0, objectArray);
            }
            _model.fireTableDataChanged();
            SqlEditorHistory.writeHistory(this.getHistoryPanel().getTable());
        }
    }

    public SqlHistoryPanel getHistoryPanel() {
        if (_gui == null) {
            _gui = new SqlHistoryPanel(_model);
        }
        return _gui;
    }

    public String getSqlAt(int n, boolean bl) {
        return this.getHistoryPanel().getSqlAt(n, bl);
    }
}

