/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.PlsNode;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.SQLWorksheetExtensionArb;
import oracle.dbtools.sqlworksheet.autotrace.AutotracePane;
import oracle.dbtools.sqlworksheet.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.sqlworksheet.owaoutput.OWAOutputPane;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorHistory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMarginMark;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorUndoWrapper;
import oracle.dbtools.sqlworksheet.sqlview.SqlLaunchOnOpen;
import oracle.dbtools.util.Utility;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.jdevimpl.runner.run.RunArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlEditorMainPanel
extends JPanel
implements GutterClickListener,
GutterColumnListener {
    private Logger logger = Logger.getLogger(SqlEditorMainPanel.class.getName());
    private static final String RESULT_PANEL_DATA = "Data";
    private static final String RESULT_PANEL_EXPLAIN = "Explain";
    private static final String RESULT_PANEL_TEXT = "Text";
    private static final String RESULT_PANEL_SCRIPT = "Script";
    private static final String RESULT_DBMS_OUTPUT_PANEL = "DbmsOutput";
    private static final String RESULT_OWA_OUTPUT_PANEL = "OWAOutput";
    private static final String LINE_NUMBER = "SqlEditorContext.LINE_NUMBER";
    private static final String MARK_CATEGORY = "sqlbookmark";
    private static final GridBagConstraints LBL_CONS = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0);
    private static final GridBagConstraints PNL_CONS = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints DBS_CONS = new GridBagConstraints(0, 1, 1, 1, 2.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints OWA_CONS = new GridBagConstraints(0, 1, 1, 1, 3.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private JSplitPane spMain = new JSplitPane();
    private JPanel northPanel = new JPanel();
    private JPanel southPane = new JPanel();
    private JPanel southDataPanel = new JPanel();
    private JPanel southTextPanel = new JPanel();
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private JScrollPane spTextPanelArea = new JScrollPane((Component)this.textPanelArea, 22, 32);
    private JPanel southPlanPanel = new JPanel();
    private ScriptRunnerPane southScriptRunnerPanel = new ScriptRunnerPane(this);
    public AutotracePane southExplainPanel = new AutotracePane(true);
    public AutotracePane southAutotracePanel = new AutotracePane(false);
    private DbmsOutputPane southDbmsOutputPane = new DbmsOutputPane(this);
    private OWAOutputPane southOWAOutputPane = new OWAOutputPane(this);
    private Toolbar toolBar = new Toolbar();
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml")};
    private BasicEditorPane taSql = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
    private JScrollPane spSql = new JScrollPane((Component)this.taSql, 22, 32);
    private JViewport viewRows = new JViewport();
    private LineGutterPlugin sqlGutter = new LineGutterPlugin();
    public static HighlightStyle bookMarkHighlightStyle;
    private FileOverviewMargin fileOverviewMargin;
    private JPopupMenu _gridCtxMenu;
    private ResultSetTable tblResults = new ResultSetTable(false);
    private JScrollPane spResults = new JScrollPane((Component)this.tblResults, 22, 30);
    private IdeAction actExecute;
    private IdeAction actExplain;
    private IdeAction actAutotrace;
    private IdeAction actScript;
    private IdeAction actHistory;
    private IdeAction actRefresh;
    private IdeAction actClear;
    private IdeAction actCancel;
    private IdeAction actCommit;
    private IdeAction actRollback;
    private IdeAction actTemplate;
    private IdeAction actMonitor;
    private SqlEditor _editor;
    private SqlEditorHandler _handler;
    private FocusHelper _focusHelper;
    private DBConnectionComboBox dbSelector;
    private int gutterLineNo;
    private SqlEditorMainPanel columnListenerPanel;
    private JLabel timerLabel = null;
    private CustomTabbedPane customTab;
    private JProgressBar progressBar;
    private URL _lastUrl;
    private boolean _selectedText = false;
    private Node _node;
    private JLabel _lblSql = null;
    private EditorStatusBar _statusBar;
    private static int _lastDividerLocation;
    private String _lastStatusbarMessage = "";
    private CompletionInsight insight = null;
    private List marksList;
    private List marginMarkList;
    private Icon bookMark;

    SqlEditorMainPanel(SqlEditor sqlEditor) {
        try {
            this._editor = sqlEditor;
            this.createActions();
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private SqlEditorMainPanel() {
        try {
            this.createActions();
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public boolean isFinished() {
        return this.southScriptRunnerPanel.isFinished();
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.southScriptRunnerPanel.getScriptRunnerContext();
    }

    public void cancelScript() {
        if (this.southScriptRunnerPanel != null) {
            this.southScriptRunnerPanel.cancelScript();
        }
    }

    void updateVisibleActions() {
        this.southScriptRunnerPanel.updateVisibleActions();
        this.southDbmsOutputPane.updateVisibleActions();
        this.southOWAOutputPane.updateVisibleActions();
    }

    public void addSelectionListener(ChangeListener changeListener) {
        this.customTab.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.customTab.removeChangeListener(changeListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.taSql.setEditable(bl);
    }

    public int getCaretLine() {
        int n = this.taSql.getCaretPosition();
        BasicDocument basicDocument = (BasicDocument)this.taSql.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        return n2;
    }

    public int[] getSelectionLineColumn() {
        int n = this.taSql.getSelectionStart();
        BasicDocument basicDocument = (BasicDocument)this.taSql.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        int n3 = lineMap.getLineStartOffset(n2 - 1);
        int n4 = n - n3 + 1;
        int[] nArray = new int[]{n2, n4};
        return nArray;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._handler == null) {
            this._handler = new SqlEditorHandler();
            this.taSql.addPopupManager((PopupManager)this._handler);
            this.taSql.addKeyListener((KeyListener)this._handler);
            Document document = this.taSql.getDocument();
            document.addUndoableEditListener(this._handler);
            this._focusHelper = new FocusHelper(document);
            this._editor.setCopyableJTableAdapter(new CopyableResultSetTableAdapter((JTable)this.tblResults));
            this.southAutotracePanel.copyAdapter = new CopyableResultSetTableAdapter((JTable)this.southAutotracePanel.tbl);
            this.tblResults.addMouseListener((MouseListener)this._handler);
            this.tblResults.getTableHeader().addMouseListener(this._handler);
        }
    }

    @Override
    public void removeNotify() {
        if (this._handler != null) {
            this.taSql.removePopupManager((PopupManager)this._handler);
            this.taSql.removeKeyListener((KeyListener)this._handler);
            this.tblResults.getTableHeader().removeMouseListener(this._handler);
            this.tblResults.removeMouseListener((MouseListener)this._handler);
            this._editor.setCopyableJTableAdapter(null);
            this.southAutotracePanel.copyAdapter = null;
            this.taSql.removeMouseListener((MouseListener)this._handler);
            Document document = this.taSql.getDocument();
            document.removeUndoableEditListener(this._handler);
            this._focusHelper.cleanup();
            this._focusHelper = null;
            this._handler = null;
        }
        super.removeNotify();
    }

    public void dispose() {
        this.tblResults.closeModel();
        this.taSql.dispose();
        this.textPanelArea.dispose();
        this.toolBar.dispose();
        this.setNode(null);
        this._editor = null;
    }

    private static IdeAction createAction(String string, int n) {
        IdeAction ideAction = IdeAction.get((int)n, (String)null, (String)string);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)SqlEditorController.getInstance());
        ideAction.putValue("sqlworksheet.run", (Object)string);
        return ideAction;
    }

    public static void preLoad() {
        SqlEditorMainPanel sqlEditorMainPanel = new SqlEditorMainPanel();
        sqlEditorMainPanel = null;
    }

    public void createActions() {
        boolean bl = false;
        if (this._editor != null && this._editor.getDatabase() != null) {
            bl = true;
        }
        this.actExecute = IdeAction.newLocalAction((int)SqlEditorController.EXECUTE_SQL_CMD_ID, (View)this._editor);
        this.actExecute.setEnabled(true);
        this.actScript = IdeAction.newLocalAction((int)SqlEditorController.SCRIPT_RUNNER_CMD_ID, (View)this._editor);
        this.actScript.setEnabled(true);
        this.actExplain = IdeAction.newLocalAction((int)SqlEditorController.EXPLAIN_PLAN_CMD_ID, (View)this._editor);
        this.actExplain.setEnabled(false);
        this.actAutotrace = IdeAction.newLocalAction((int)SqlEditorController.AUTOTRACE_CMD_ID, (View)this._editor);
        this.actAutotrace.setEnabled(false);
        IdeAction ideAction = IdeAction.find((int)SqlEditorController.HISTORY_CMD_ID);
        this.actHistory = ideAction.newLocalAction((View)this._editor);
        this.actHistory.setEnabled(true);
        IdeAction ideAction2 = IdeAction.get((int)SqlEditorController.MONITOR_CMD_ID);
        this.actMonitor = ideAction2.newLocalAction((View)this._editor);
        this.actMonitor.setEnabled(true);
        this.actRefresh = IdeAction.newLocalAction((int)51, (View)this._editor);
        this.actClear = IdeAction.newLocalAction((int)SqlEditorController.CLEAR_CMD_ID, (View)this._editor);
        this.actClear.setEnabled(true);
        this.actCancel = IdeAction.newLocalAction((int)SqlEditorController.CANCEL_CMD_ID, (View)this._editor);
        this.actCancel.setEnabled(false);
        this.actCommit = IdeAction.newLocalAction((int)SqlEditorController.COMMIT_CMD_ID, (View)this._editor);
        this.actCommit.setEnabled(bl);
        this.actRollback = IdeAction.newLocalAction((int)SqlEditorController.ROLLBACK_CMD_ID, (View)this._editor);
        this.actRollback.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
        ToolButton toolButton = null;
        this.setLayout(new BorderLayout());
        this.spMain.setOrientation(0);
        this.spMain.setOneTouchExpandable(true);
        this.spMain.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                    _lastDividerLocation = SqlEditorMainPanel.this.spMain.getDividerLocation();
                }
            }
        });
        this.southDataPanel.setLayout(new GridBagLayout());
        this.southTextPanel.setLayout(new GridBagLayout());
        this.southPlanPanel.setLayout(new GridBagLayout());
        this.textPanelArea.setText("");
        toolButton = this.toolBar.add((ToggleAction)this.actExecute);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("EXECUTE_STATEMENT")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actExecute.getCommandId()) + ")");
        toolButton = this.toolBar.add((ToggleAction)this.actScript);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("RUN_SCRIPT")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actScript.getCommandId()) + ")");
        toolButton = this.toolBar.add((ToggleAction)this.actCommit);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("COMMIT")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actCommit.getCommandId()) + ")");
        toolButton = this.toolBar.add((ToggleAction)this.actRollback);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("ROLLBACK")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actRollback.getCommandId()) + ")");
        toolButton = this.toolBar.add((ToggleAction)this.actCancel);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("SQLWORKSHEET_CANCEL")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actCancel.getCommandId()) + ")");
        this.toolBar.addSeparator();
        toolButton = this.toolBar.add((ToggleAction)this.actExplain);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("EXPLAIN_MENUITEM")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actExplain.getCommandId()) + ")");
        toolButton = this.toolBar.add((ToggleAction)this.actAutotrace);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("AUTOTRACE_MENUITEM")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actAutotrace.getCommandId()) + ")");
        this.toolBar.addSeparator();
        toolButton = this.toolBar.add((ToggleAction)this.actClear);
        toolButton.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetExtensionArb.get("CLEAR_LABEL")) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)this.actClear.getCommandId()) + ")");
        this.toolBar.addSeparator();
        this.progressBar = new JProgressBar(0, 60);
        this.progressBar.setIndeterminate(true);
        Dimension dimension = this.progressBar.getMinimumSize();
        this.progressBar.setMinimumSize(new Dimension(65, dimension.height));
        this.progressBar.setVisible(false);
        this.progressBar.setMaximumSize(new Dimension(65, dimension.height));
        this.toolBar.add((Component)this.progressBar);
        this.timerLabel = new JLabel();
        this.timerLabel.setSize(10, 2);
        this.toolBar.add((Component)this.timerLabel);
        this.toolBar.add(Box.createHorizontalGlue());
        if (this._editor != null) {
            this._editor.addViewListener(new ViewListener(){

                public void viewActivated(ViewEvent viewEvent) {
                    View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.getToolbar());
                }

                public void viewClosed(ViewEvent viewEvent) {
                }

                public void viewDeactivated(ViewEvent viewEvent) {
                    SqlEditorMainPanel.this._lastStatusbarMessage = Ide.getStatusBar().getText();
                }
            });
            this.dbSelector = new DBConnectionComboBox((Container)this.toolBar);
            this.dbSelector.getJComboBox().addItemListener(new ItemListener(){
                private String lastConn;

                public void itemStateChanged(ItemEvent itemEvent) {
                    DefaultListModel defaultListModel;
                    if (itemEvent.getStateChange() == 1 && SqlEditorMainPanel.this._editor != null) {
                        SqlLaunchOnOpen.OPEN_DEFAULT = false;
                        try {
                            defaultListModel = SqlEditorMainPanel.this.dbSelector.getCurrentDatabase();
                            SqlEditorMainPanel.this._editor.setDb((Database)defaultListModel);
                            if (SqlEditorMainPanel.this._editor.getConnectionName() != null && this.lastConn != null && !this.lastConn.equals(SqlEditorMainPanel.this._editor.getConnectionName())) {
                                SqlEditorMainPanel.this._editor.updateURL();
                            }
                            SqlEditorMainPanel.this.updateToolBarActions();
                        }
                        catch (DBException dBException) {
                            DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
                            ExceptionHandler.handleException((Exception)((Object)dBException2));
                            if (this.lastConn != null) {
                                SqlEditorMainPanel.this.dbSelector.setCurrentConnection(this.lastConn);
                            }
                            SqlEditorMainPanel.this.dbSelector.getJComboBox().setSelectedIndex(-1);
                        }
                        View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.getToolbar());
                        SqlLaunchOnOpen.OPEN_DEFAULT = true;
                    } else if (itemEvent.getStateChange() == 2 && Connections.getInstance().isConnectionOpen((String)itemEvent.getItem())) {
                        this.lastConn = (String)itemEvent.getItem();
                    }
                    defaultListModel = SqlEditorMainPanel.this.customTab.getTabModel();
                    for (int i = 0; i < defaultListModel.getSize(); ++i) {
                        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)defaultListModel.get(i);
                        if (SqlEditorMainPanel.this._editor != null && Connections.getInstance().isOracle(SqlEditorMainPanel.this._editor.getConnectionName())) {
                            defaultCustomTabPage.setEnabled(true);
                            continue;
                        }
                        if (!(defaultCustomTabPage.getUserObject() instanceof AutotracePane) && !(defaultCustomTabPage.getUserObject() instanceof DbmsOutputPane) && !(defaultCustomTabPage.getUserObject() instanceof OWAOutputPane)) continue;
                        defaultCustomTabPage.setEnabled(false);
                    }
                    if (SqlEditorMainPanel.this.getNode() != null) {
                        UpdateMessage.fireObjectRenamed((Subject)SqlEditorMainPanel.this.getNode());
                    }
                    Ide.getMainWindow().updateTitle();
                }
            });
        }
        this._lblSql = new JLabel();
        ResourceUtils.resLabel((JLabel)this._lblSql, (Component)this.taSql, (String)ConnectionArb.getString((int)27));
        this.taSql.setText("");
        this.taSql.setDocument((Document)new BasicDocument("foo.plsql"));
        this.taSql.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._statusBar = new EditorStatusBar();
        this.taSql.installPlugin((EditorPlugin)this._statusBar);
        this.taSql.installPlugin((EditorPlugin)this.sqlGutter);
        this.taSql.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.spSql.setRowHeaderView((Component)this.sqlGutter);
        this.sqlGutter.addGutterClickListener((GutterClickListener)this);
        this.createContextMenu();
        this.fileOverviewMargin = new FileOverviewMargin();
        this.taSql.installPlugin((EditorPlugin)this.fileOverviewMargin);
        this.northPanel.setLayout(new GridBagLayout());
        this.northPanel.add((Component)this._lblSql, LBL_CONS);
        this.northPanel.add((Component)this.spSql, PNL_CONS);
        this.northPanel.setPreferredSize(new Dimension(200, 200));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.northPanel, "Center");
        jPanel.add((Component)this.fileOverviewMargin, "East");
        this.spMain.setLeftComponent(jPanel);
        this.textPanelArea.setDocument((Document)new BasicDocument("foo.txt"));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.textPanelArea.installPlugin((EditorPlugin)lineGutterPlugin);
        this.spTextPanelArea.setRowHeaderView((Component)lineGutterPlugin);
        JTable jTable = this.tblResults.getRowHeader();
        this.viewRows.setView(jTable);
        this.viewRows.setPreferredSize(jTable.getMaximumSize());
        this.spResults.setRowHeader(this.viewRows);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.tblResults, (String)ConnectionArb.getString((int)28));
        this.southDataPanel.add((Component)jLabel, LBL_CONS);
        this.southDataPanel.add((Component)this.spResults, PNL_CONS);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.southExplainPanel, (String)ConnectionArb.getString((int)29));
        this.southPlanPanel.add((Component)jLabel2, LBL_CONS);
        this.southPlanPanel.add((Component)this.southExplainPanel, PNL_CONS);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.southScriptRunnerPanel, (String)"Script Results");
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.southScriptRunnerPanel, (String)"DBMS Output");
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.southScriptRunnerPanel, (String)"OWA Output");
        this.southPlanPanel.add((Component)jLabel3, LBL_CONS);
        this.southPlanPanel.add((Component)this.southScriptRunnerPanel, PNL_CONS);
        this.southPlanPanel.add((Component)jLabel4, LBL_CONS);
        this.southPlanPanel.add((Component)this.southDbmsOutputPane, DBS_CONS);
        this.southPlanPanel.add((Component)jLabel5, LBL_CONS);
        this.southPlanPanel.add((Component)this.southOWAOutputPane, OWA_CONS);
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.textPanelArea, (String)ConnectionArb.getString((int)28));
        this.southTextPanel.add((Component)jLabel6, LBL_CONS);
        this.southTextPanel.add((Component)this.spTextPanelArea, PNL_CONS);
        this.southPane.setLayout(new CardLayout());
        this.southPane.add(RESULT_PANEL_DATA, this.southDataPanel);
        this.southPane.add(RESULT_PANEL_SCRIPT, this.southPlanPanel);
        this.southPane.add(RESULT_PANEL_EXPLAIN, this.southPlanPanel);
        this.southPane.add(RESULT_PANEL_TEXT, this.southTextPanel);
        this.southPane.add(RESULT_DBMS_OUTPUT_PANEL, this.southTextPanel);
        this.southPane.add(RESULT_OWA_OUTPUT_PANEL, this.southTextPanel);
        this.customTab = new CustomTabbedPane();
        this.customTab.addTab(RunArb.getIcon((int)17), "Results", (Component)this.southPane);
        this.customTab.addTab(this.getIcon(SQLWorksheetExtensionArb.get("RUN_SCRIPT_ICON")), "Script Output", (Component)this.southScriptRunnerPanel);
        this.customTab.addTab(OracleIcons.getIcon((String)"explain.png"), RESULT_PANEL_EXPLAIN, (Component)this.southExplainPanel);
        this.customTab.addTab(this.getIcon(SQLWorksheetExtensionArb.get("AUTOTRACE_ICON")), "Autotrace", (Component)this.southAutotracePanel);
        this.customTab.addTab(SQLWorksheetArb.getIcon(39), "DBMS Output", (Component)this.southDbmsOutputPane);
        this.customTab.addTab(SQLWorksheetArb.getIcon(10), "OWA Output", (Component)this.southOWAOutputPane);
        this.spMain.setRightComponent((Component)this.customTab);
        Dimension dimension2 = new Dimension(0, 0);
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.toolBar);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.taSql.getDocument().addDocumentListener(documentListener);
        this.taSql.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeDocumentListener(documentListener);
                    if (SqlEditorMainPanel.this._handler != null) {
                        document2.removeUndoableEditListener(SqlEditorMainPanel.this._handler);
                    }
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addDocumentListener(documentListener);
                    if (SqlEditorMainPanel.this._handler != null) {
                        document.addUndoableEditListener(SqlEditorMainPanel.this._handler);
                    }
                }
            }
        });
        this.spMain.revalidate();
        this.spMain.setDividerLocation(_lastDividerLocation);
        this.spMain.setResizeWeight(1.0);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.spMain, "Center");
        new RaptorDnD((JTextComponent)this.taSql);
        this.tblResults.setTranslatedColNames(false);
        this.tblResults.setThreaded(false);
    }

    private Icon getIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    public JSplitPane getSplitPane() {
        return this.spMain;
    }

    public void invokeInsight() {
        Context context = this._editor.getContext();
        if (Connections.getInstance().isOracle(this._editor.getConnectionName())) {
            if (this.insight != null) {
                this.taSql.deinstallPlugin((EditorPlugin)this.insight);
            }
            this.insight = new CompletionInsight(context, this._editor.getDatabase());
            this.taSql.installPlugin((EditorPlugin)this.insight);
        }
    }

    Toolbar getToolbar() {
        return this.toolBar;
    }

    public boolean isTextSelected() {
        return this._selectedText;
    }

    public String getSqlStatement() {
        String string = this.taSql.getSelectedText();
        String string2 = "";
        if (string != null) {
            string2 = string;
            this._selectedText = true;
        } else {
            string2 = this.taSql.getText();
            this._selectedText = false;
        }
        if (string2 == null) {
            return string2;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasText(boolean bl) {
        boolean bl2;
        block7: {
            bl2 = false;
            TextBuffer textBuffer = ((BasicDocument)this.taSql.getDocument()).getTextBuffer();
            textBuffer.readLock();
            try {
                int n = 0;
                try {
                    n = textBuffer.getLength();
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    // empty catch block
                }
                if (!bl) {
                    bl2 = n > 0;
                    break block7;
                }
                int n2 = 0;
                while (n2 < n) {
                    char c;
                    if (Character.isWhitespace(c = textBuffer.getChar(n2++))) continue;
                    bl2 = true;
                    break;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        return bl2;
    }

    public String stripCarriageReturns(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\r') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public void updateToolBarActions() {
        if (this._editor.getDatabase() != null) {
            this.actExecute.setEnabled(true);
            this.actExplain.setEnabled(true);
            this.actAutotrace.setEnabled(true);
            this.actScript.setEnabled(true);
            this.actHistory.setEnabled(true);
            this.actRefresh.setEnabled(true);
            this.actClear.setEnabled(true);
            this.actCancel.setEnabled(false);
            if (this._editor.isOracle() && DBUtil.checkVersion((String)this.getConnectionName(), (Version)new Version("99.0"), (Version)new Version("11.0"))) {
                this.actMonitor.setEnabled(true);
            } else {
                this.actMonitor.setEnabled(false);
            }
        } else {
            this.actMonitor.setEnabled(false);
        }
    }

    public void setSqlStatement(String string) {
        this.updateToolBarActions();
        this.taSql.setText(string);
    }

    public boolean canRefreshView() {
        return this.southDataPanel.isShowing();
    }

    public void refreshView() {
        if (this.tblResults != null) {
            this.tblResults.refresh();
        }
    }

    void setSQLText(String string) {
        this.setSqlStatement(string);
    }

    String getSQLText() {
        return this.taSql.getText();
    }

    TextBuffer getSQLTextAsBuffer() {
        BasicDocument basicDocument = (BasicDocument)this.taSql.getDocument();
        return basicDocument.getTextBuffer();
    }

    public BasicEditorPane getSQLEditorPane() {
        return this.taSql;
    }

    public BasicEditorPane getScriptOutputArea() {
        return this.southScriptRunnerPanel.getScriptOutput();
    }

    public final void setResultSet(ResultSet resultSet, String string, boolean bl, String string2) {
        this._closeTableModel();
        if (resultSet == null) {
            this._setResultSetText(string, bl);
        } else {
            this._setResultSetData(resultSet, string2);
        }
    }

    public final void setFocusForResultSet() {
        this.customTab.setSelectedIndex(0);
    }

    public final void setQueryResultSet(ResultSet resultSet, String string, boolean bl, String string2, Map<String, Object> map, int n, int n2) {
        this._closeTableModel();
        this._setQueryResultSetData(resultSet, string2, map, n, n2);
    }

    public final void setResultSet(ResultSet resultSet, String string, boolean bl, String string2, Map<String, Object> map) {
        this._closeTableModel();
        if (resultSet == null) {
            this._setResultSetText(string, bl);
        } else {
            this._setResultSetData(resultSet, string2, map);
        }
    }

    private final void _setResultSetData(ResultSet resultSet, String string) {
        assert (resultSet != null) : "(null) ResultSet passed to _setResultSetData";
        this.tblResults.setQuery(this._editor.getConnection(), resultSet, string);
    }

    private final void _setQueryResultSetData(ResultSet resultSet, String string, Map map, int n, int n2) {
        this.tblResults.setQuery(this._editor.getConnection(), resultSet, string, map, n, n2, true);
    }

    private final void _setResultSetData(ResultSet resultSet, String string, Map map) {
        assert (resultSet != null) : "(null) ResultSet passed to _setResultSetData";
        this.tblResults.setQuery(this._editor.getConnection(), resultSet, string, map);
    }

    private void _closeTableModel() {
        this.tblResults.closeModel();
    }

    private final void _setResultSetText(String string, boolean bl) {
        if (bl) {
            String string2 = string.equals("0") || string.equals("-1") ? ConnectionArb.getString((int)33) : (string.equals("1") ? ConnectionArb.getString((int)34) : ConnectionArb.format((int)35, (Object)string));
            final String string3 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SqlEditorMainPanel.this.textPanelArea.setEditable(true);
                    SqlEditorMainPanel.this.textPanelArea.setText(string3);
                    SqlEditorMainPanel.this.textPanelArea.setEditable(false);
                }
            });
        } else {
            final String string4 = string;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SqlEditorMainPanel.this.textPanelArea.setEditable(true);
                    SqlEditorMainPanel.this.textPanelArea.setText(string4);
                    SqlEditorMainPanel.this.textPanelArea.setEditable(false);
                }
            });
        }
    }

    public final String explainPlan(String string) {
        String string2 = "" + System.currentTimeMillis();
        this.southExplainPanel.mdl.explainPlan(string, string2);
        this.southExplainPanel.mdl.displayPlan(string, string2);
        return string2;
    }

    public final void displayPlan() {
        JTree jTree = this.southExplainPanel.tbl.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        this.southExplainPanel.tbl.revalidate();
    }

    public final void setForFocusExplainPlan() {
        this.customTab.setSelectedIndex(2);
    }

    public final void setFocusForAutotrace() {
        this.customTab.setSelectedIndex(3);
    }

    public final void scriptRunner(String string) {
        this.southScriptRunnerPanel.getScriptRunnerContext().setOutputComponenet((Object)this.getScriptOutputArea());
        DBConfig dBConfig = DBConfig.getInstance();
        this.southScriptRunnerPanel.getScriptRunnerContext().putProperty("DBConfig.GLOGIN", (Object)new Boolean(dBConfig.getBoolean("GLOGIN")));
        this.southScriptRunnerPanel.getScriptRunnerContext().putProperty("DBConfig.GLOGIN_FILE", (Object)dBConfig.getString(""));
        this.southScriptRunnerPanel.getScriptRunnerContext().setEditorComponenet(this.taSql);
        this.southScriptRunnerPanel.getScriptRunnerContext().putProperty("sqldev.editor.context", (Object)this._editor.getContext());
        this.southScriptRunnerPanel.setStatement(string);
        this.customTab.setSelectedIndex(1);
    }

    private void _tryContextMenu(MouseEvent mouseEvent) {
        Context context;
        Component component = mouseEvent.getComponent();
        component.requestFocus();
        if (mouseEvent.isPopupTrigger() && (context = this._editor.getContext(mouseEvent)) != null) {
            this._editor.getContextMenu().show(context);
        }
    }

    public String getConnectionName() {
        return this.dbSelector.getCurrentConnectionName();
    }

    public SqlEditor getEditor() {
        return this._editor;
    }

    public void setConnections(Connection connection) {
        this.southExplainPanel.setConnection(connection);
        this.southScriptRunnerPanel.setConnection(connection);
        this.southDbmsOutputPane.setConnection(connection);
        this.southOWAOutputPane.setConnection(connection);
        this.dbSelector.setCurrentConnection(Connections.getInstance().getConnectionName(this._editor.getDb()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveView(boolean bl) {
        SqlEditorNode sqlEditorNode;
        int n = 0;
        boolean bl2 = true;
        if (this._node instanceof SqlNode) {
            bl2 = false;
        } else if (this._node instanceof SqlEditorNode) {
            sqlEditorNode = (SqlEditorNode)this._node;
            boolean bl3 = bl2 = sqlEditorNode.getSqlNode() == null || sqlEditorNode.isTempFile();
        }
        if (bl || bl2) {
            if (this._lastUrl == null) {
                this.setLastUrl();
            }
            sqlEditorNode = DialogUtil.newURLChooser((Context)this._editor.getContext(), (URL)(bl2 ? this._lastUrl : this._node.getURL()));
            sqlEditorNode.clearChooseableURLFilters();
            sqlEditorNode.addChooseableURLFilter(PlsNode.PLS_FILTER);
            sqlEditorNode.addChooseableURLFilter(PlsNode.PLB_FILTER);
            sqlEditorNode.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            sqlEditorNode.setURLFilter(SqlNode.SQL_FILTER);
            n = sqlEditorNode.showSaveDialog(this);
            if (n == 0) {
                URL uRL = sqlEditorNode.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    if (sqlEditorNode.getSelectedFilter() == PlsNode.PLS_FILTER) {
                        uRL = URLFileSystem.convertSuffix((URL)uRL, (String)"", (String)".pls");
                    } else if (sqlEditorNode.getSelectedFilter() == PlsNode.PLB_FILTER) {
                        uRL = URLFileSystem.convertSuffix((URL)uRL, (String)"", (String)".plb");
                    } else if (sqlEditorNode.getSelectedFilter() == SqlNode.SQL_FILTER) {
                        uRL = URLFileSystem.convertSuffix((URL)uRL, (String)"", (String)".sql");
                    }
                }
                if (URLFileSystem.exists((URL)uRL)) {
                    switch (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)"File exists, overwrite? ", (String)URLFileSystem.getPlatformPathName((URL)uRL))) {
                        case 1: {
                            this.saveImpl(uRL);
                            this._editor.getContext().getNode().notifyObservers((Object)this._editor.getContext().getNode(), new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
                            break;
                        }
                    }
                } else {
                    this.saveImpl(uRL);
                    this._editor.getContext().getNode().notifyObservers((Object)this._editor.getContext().getNode(), new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
                }
                FileOpenHistory.getInstance().updateFileHistory(uRL);
                this._lastUrl = uRL;
                return;
            }
            if (n != 1) return;
        }
        try {
            this._node.save();
            this._editor.markDirty(false);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this._editor.setMD5(this.taSql.getText());
    }

    private void saveImpl(URL uRL) {
        SqlEditorMainPanel.writeFile(uRL, this.getSQLTextAsBuffer());
        if (this._node instanceof SqlNode) {
            SqlNode sqlNode = (SqlNode)this._node;
            sqlNode.setURL(uRL);
        } else {
            SqlEditorNode sqlEditorNode = (SqlEditorNode)this._node;
            SqlNode sqlNode = sqlEditorNode.getSqlNode();
            if (sqlNode == null) {
                sqlNode = new SqlNode(uRL);
                sqlEditorNode.setSqlNode(sqlNode);
            } else {
                sqlNode.setURL(uRL);
            }
            sqlEditorNode.setTempFile(false);
        }
        this._editor.markDirty(false);
        this._editor.setMD5(this.taSql.getText());
    }

    private void setLastUrl() {
        try {
            URL uRL;
            File file = DBConfig.getInstance().getString("DEFAULTPATH") == null ? new File(System.getProperty("user.home") + "/sql") : new File(DBConfig.getInstance().getString("DEFAULTPATH"));
            this._lastUrl = uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public URL getLastUrl() {
        if (this._lastUrl == null) {
            this.setLastUrl();
        }
        return this._lastUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFile(URL uRL, TextBuffer textBuffer) {
        OutputStream outputStream = null;
        Writer writer = null;
        try {
            outputStream = URLFileSystem.openOutputStream((URL)uRL);
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), IdeUtil.getIdeEncoding());
            textBuffer.write(writer, false);
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)URLFileSystem.getPlatformPathName((URL)uRL), null);
            System.err.println(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static boolean writeFile(File file, String string) {
        try {
            String string2 = IdeUtil.getIdeEncoding();
            FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)file.toString(), null);
            System.err.println(iOException);
            return false;
        }
        return true;
    }

    public void printView() {
        Utility.printText((String)SQLWorksheetArb.getString(42), (String)this.taSql.getText());
    }

    public void openWsFile() {
        int n = 0;
        if (this._lastUrl == null) {
            this.setLastUrl();
        }
        URLChooser uRLChooser = DialogUtil.newURLChooser((URL)this._lastUrl);
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.addChooseableURLFilter(PlsNode.PLS_FILTER);
        uRLChooser.addChooseableURLFilter(PlsNode.PLB_FILTER);
        uRLChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        uRLChooser.setURLFilter(SqlNode.SQL_FILTER);
        n = uRLChooser.showOpenDialog((Component)this);
        if (n == 0) {
            this.openFile(uRLChooser.getSelectedURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(URL uRL) {
        BasicDocument basicDocument = (BasicDocument)this.taSql.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.writeLock();
        this._lastUrl = uRL;
        Reader reader = null;
        try {
            String string = IdeUtil.getIdeEncoding();
            this.taSql.setText("");
            reader = URLFileSystem.createReader((URL)uRL, (String)string);
            textBuffer.read(reader);
            if (this._node instanceof SqlNode) {
                SqlNode sqlNode = (SqlNode)this._node;
                sqlNode.setURL(uRL);
            } else {
                SqlEditorNode sqlEditorNode = (SqlEditorNode)this._node;
                SqlNode sqlNode = sqlEditorNode.getSqlNode();
                if (sqlNode == null) {
                    sqlNode = new SqlNode(uRL);
                    sqlEditorNode.setSqlNode(sqlNode);
                } else {
                    sqlNode.setURL(uRL);
                }
                sqlEditorNode.setTempFile(false);
                sqlEditorNode.setTabName("");
            }
            this._editor.markDirty(false);
            this.taSql.setCaretPosition(this.taSql.getText().length());
            View.updateToolbarActions((Toolbar)this.toolBar);
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could not Read File", (String)uRL.getFile(), null);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            textBuffer.writeUnlock();
        }
        this._editor.updateVisibleActions();
    }

    public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
        this.gutterLineNo = n;
        this.columnListenerPanel = this;
        LineGutterPlugin lineGutterPlugin = (LineGutterPlugin)mouseEvent.getSource();
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) != 0 || (n2 & 4) != 0) {
            this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public DBConnectionComboBox getDbSelector() {
        return this.dbSelector;
    }

    private void createContextMenu() {
        if (this._gridCtxMenu == null) {
            this._gridCtxMenu = new JPopupMenu("Context Menu");
            JMenuItem jMenuItem = new JMenuItem("Toggle BookMarks");
            JMenuItem jMenuItem2 = new JMenuItem("Toggle Line Numbers");
            JPopupMenu jPopupMenu = new JPopupMenu("Gutter Menu");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GutterMark gutterMark;
                    SqlEditorMainPanel.this.logger.info("BookMark");
                    GutterColumn gutterColumn = SqlEditorMainPanel.this.sqlGutter.lookupGutterColumn("BookMarks");
                    if (gutterColumn == null) {
                        gutterColumn = SqlEditorMainPanel.this.sqlGutter.createGutterColumn("BookMarks", (GutterColumnListener)SqlEditorMainPanel.this.columnListenerPanel);
                    }
                    if (SqlEditorMainPanel.this.marksList == null) {
                        SqlEditorMainPanel.this.marksList = new ArrayList();
                        SqlEditorMainPanel.this.bookMark = SqlEditorMainPanel.this.getIcon(SQLWorksheetArb.getString(22));
                    }
                    if (SqlEditorMainPanel.this.marginMarkList == null) {
                        SqlEditorMainPanel.this.marginMarkList = new ArrayList();
                    }
                    boolean bl = false;
                    Iterator iterator = SqlEditorMainPanel.this.marksList.iterator();
                    int n = SqlEditorMainPanel.this.gutterLineNo;
                    while (iterator.hasNext()) {
                        gutterMark = (GutterMark)iterator.next();
                        if (gutterMark.getLine() != n) continue;
                        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
                        iterator.remove();
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        gutterMark = null;
                        EditorProperties editorProperties = EditorProperties.getProperties();
                        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
                        bookMarkHighlightStyle = highlightRegistry.createStyle("Bookmark", "BookMark", 20, Color.black, new Color(153, 255, 255));
                        FileOverviewMargin.setMarkColor((String)SqlEditorMainPanel.MARK_CATEGORY, (HighlightStyle)bookMarkHighlightStyle);
                        SqlEditorMainPanel.this.marksList.add(gutterColumn.addGutterMark(n, SqlEditorMainPanel.this.bookMark, bookMarkHighlightStyle, 1, 1));
                        SqlEditorMarginMark sqlEditorMarginMark = new SqlEditorMarginMark(n, n, "BookMark: Line " + n);
                        SqlEditorMainPanel.this.fileOverviewMargin.addMark(SqlEditorMainPanel.MARK_CATEGORY, n, (FileOverviewMark)sqlEditorMarginMark);
                        if (gutterMark != null) {
                            SqlEditorMainPanel.this.marksList.add(gutterMark);
                        }
                    }
                }
            });
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            this._gridCtxMenu.add(jPopupMenu);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        SqlEditorMainPanel.this._gridCtxMenu.show((Component)SqlEditorMainPanel.this.sqlGutter, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this._gridCtxMenu = jPopupMenu;
        }
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
    }

    public void markRemoved(GutterMark gutterMark, int n) {
        int n2 = this.marksList.indexOf(gutterMark);
        if (n2 != -1) {
            this.marksList.remove(n2);
        }
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
        this.marksList.remove(gutterMark);
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        return null;
    }

    void setNode(Node node) {
        if (node != this._node) {
            SqlNode sqlNode = this.getSqlNode(this._node);
            if (sqlNode != null) {
                sqlNode.releaseTextBuffer();
            }
            this._node = node;
            sqlNode = this.getSqlNode(this._node);
            if (this._node != null) {
                TextBuffer textBuffer = sqlNode.acquireTextBuffer();
                BasicDocument basicDocument = new BasicDocument("foo.sql", textBuffer);
                this.taSql.setDocument((Document)basicDocument);
            }
        }
    }

    private SqlNode getSqlNode(Node node) {
        if (node instanceof SqlNode) {
            return (SqlNode)node;
        }
        if (node instanceof SqlEditorNode) {
            return ((SqlEditorNode)node).getSqlNode();
        }
        return null;
    }

    public ResultSetTable getResultSetTable() {
        return this.tblResults;
    }

    public JComponent getActivePanel() {
        return (JComponent)this.customTab.getActivePanel();
    }

    public CustomTabbedPane getCustomTabbedPanel() {
        return this.customTab;
    }

    public void updateTimer(long l) {
        if (this.timerLabel != null) {
            float f = 0.0f;
            if (l > 0L) {
                f = Float.parseFloat(l + "") / 1.0E9f;
            }
            Object[] objectArray = new Object[]{new Float(f)};
            String string = MessageFormat.format("{0,number,#.########} seconds", objectArray);
            this.timerLabel.setText(" " + string);
            this.timerLabel.repaint();
            this.toggleProgress(false);
        }
    }

    public void toggleProgress(Boolean bl) {
        this.progressBar.setVisible(bl);
    }

    public boolean isProgressVisible() {
        return this.progressBar.isVisible();
    }

    public void refreshTimer() {
        if (this.timerLabel != null) {
            this.timerLabel.setBorder(null);
            this.timerLabel.setText("");
            this.timerLabel.repaint();
        }
    }

    public EditorStatusBar getStatusBar() {
        return this._statusBar;
    }

    public void setEditorHeaderLabelStr(String string) {
        this._lblSql.setText(string);
        this._lblSql.updateUI();
    }

    public void setEditorHeaderLabel(JLabel jLabel) {
        this._lblSql = jLabel;
        this._lblSql.updateUI();
    }

    public JPanel getEditorHeader() {
        return this.northPanel;
    }

    public Node getNode() {
        return this._node;
    }

    public String get_lastStatusbarMessage() {
        return this._lastStatusbarMessage;
    }

    public void set_lastStatusbarMessage(String string) {
        this._lastStatusbarMessage = string;
    }

    static {
        _lastDividerLocation = -123;
    }

    private class SqlEditorHandler
    implements PopupManager,
    KeyListener,
    MouseListener,
    UndoableEditListener {
        private int _lastHistoryItem = 0;

        private SqlEditorHandler() {
        }

        public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
            ContextMenu contextMenu;
            if (SqlEditorMainPanel.this._editor.getConnection() != null) {
                if (Connections.getInstance().lock(SqlEditorMainPanel.this._editor.getConnection())) {
                    Connections.getInstance().unlock(SqlEditorMainPanel.this._editor.getConnection());
                } else {
                    return;
                }
            }
            if ((contextMenu = SqlEditorMainPanel.this._editor.getContextMenu()) != null) {
                contextMenu.show(SqlEditorMainPanel.this._editor.getContext(mouseEvent));
            }
        }

        public void hidePopup(BasicEditorPane basicEditorPane) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.toolBar);
            if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
                IdeAction ideAction = IdeAction.find((int)SqlEditorController.EXECUTE_SQL_CMD_ID);
                if (ideAction != null) {
                    try {
                        ideAction.performAction();
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            } else if (keyEvent.isControlDown() && keyEvent.isShiftDown() && Character.isDigit(keyEvent.getKeyChar())) {
                String string = SqlEditorHistory.getInstance().getSqlAt(Integer.parseInt(Character.toString(keyEvent.getKeyChar())), false);
                SqlEditorMainPanel.this.taSql.setText(string);
                SqlEditorMainPanel.this.taSql.setCaretPositionCenter(0);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown()) {
                if (keyEvent.getKeyCode() == 38) {
                    if (this._lastHistoryItem + 1 < SqlEditorHistory.getHistorySize()) {
                        ++this._lastHistoryItem;
                    }
                    String string = SqlEditorHistory.getInstance().getSqlAt(this._lastHistoryItem, false);
                    SqlEditorMainPanel.this.taSql.setText(string);
                    SqlEditorMainPanel.this.taSql.setCaretPositionCenter(0);
                    return;
                }
            }
            if (!keyEvent.isControlDown()) return;
            if (keyEvent.getKeyCode() != 40) return;
            if (this._lastHistoryItem - 1 >= 0) {
                --this._lastHistoryItem;
            }
            String string = SqlEditorHistory.getInstance().getSqlAt(this._lastHistoryItem, false);
            SqlEditorMainPanel.this.taSql.setText(string);
            SqlEditorMainPanel.this.taSql.setCaretPositionCenter(0);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Context context = SqlEditorMainPanel.this._editor.getContext(mouseEvent);
            Object object = context.getEvent().getSource();
            if (!object.getClass().toString().equals("oracle.javatools.editor.gutter.LineGutterPlugin")) {
                SqlEditorMainPanel.this._tryContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SqlEditorMainPanel.this._tryContextMenu(mouseEvent);
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            SqlEditorUndoWrapper sqlEditorUndoWrapper = new SqlEditorUndoWrapper(undoableEdit);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            sqlEditorUndoWrapper.setContext(SqlEditorMainPanel.this._editor.getContext());
            try {
                commandProcessor.invoke((Command)sqlEditorUndoWrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class FocusHelper
    implements FocusListener {
        private FocusHelper(Document document) {
            this.addFocusListenerRecurse(SqlEditorMainPanel.this);
        }

        private void addFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.addFocusListenerRecurse(componentArray[i]);
                }
            }
            component.addFocusListener(this);
        }

        private void cleanup() {
            this.removeFocusListenerRecurse(SqlEditorMainPanel.this);
        }

        private void removeFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.removeFocusListenerRecurse(componentArray[i]);
                }
            }
            component.removeFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            SqlEditorMainPanel.this._editor.setFocusedComponent((Component)focusEvent.getSource());
            Component component = SqlEditorMainPanel.this._editor.getFocusedComponent();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

